/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.consts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RefundConstants {
    public static final String RELE_BILL_TYPE = "relebilltype";
    public static final String REFUND = "refund";
    public static final String RENOTE = "renote";
    public static final String PAYBILL_AUTO_RENOTE = "paybillAutoRenote";
    public static final String AGENTBILL_AUTO_RENOTE = "agentbillAutoRenote";
    public static final String ENTRY_RELA_BILL_ID = "id";
    public static final String ENTRY_RELA_ENTRY_ID = "entryid";
    public static final String ENTRY_RELA_BILL_NO = "relebillno";
    public static final Set<String> PAY_BILL_SELECT_FIELDS = new HashSet<String>(){
        {
            this.add(RefundConstants.ENTRY_RELA_BILL_ID);
            this.add("sourcebilltype");
            this.add("sourcebillid");
            this.add("entry");
            this.add(String.join((CharSequence)".", "entry", "e_sourcebillentryid"));
            this.add(String.join((CharSequence)".", "entry", "sourcebilltype"));
            this.add(String.join((CharSequence)".", "entry", RefundConstants.ENTRY_RELA_ENTRY_ID));
        }
    };
    public static final Set<String> PAY_APPLY_BILL_SELECT_FIELDS = new HashSet<String>(){
        {
            this.add(RefundConstants.ENTRY_RELA_BILL_ID);
            this.add("refundandrepay");
            this.add("cas_payinfo");
            this.add(String.join((CharSequence)".", "cas_payinfo", "entry_remainrfamount"));
            this.add(String.join((CharSequence)".", "cas_payinfo", RefundConstants.ENTRY_RELA_ENTRY_ID));
            this.add(String.join((CharSequence)".", "cas_payinfo", "entry_backbill"));
            this.add(String.join((CharSequence)".", "cas_payinfo", "entry_refund"));
            this.add(String.join((CharSequence)".", "cas_payinfo", "entry_relarecbillid"));
            this.add(String.join((CharSequence)".", "cas_payinfo", "entry_relaentryid"));
            this.add(String.join((CharSequence)".", "cas_payinfo", "entry_paystatus"));
        }
    };
    public static final Set<String> REFUND_PAGE_PAY_BILL_FIELDS = new HashSet<String>(){
        {
            this.add(RefundConstants.ENTRY_RELA_BILL_ID);
            this.add("billno");
            this.add("settletype");
            this.add("payeracctbank.bankaccountnumber");
            this.add("currency");
            this.add("actpayamt");
            this.add("dpcurrency");
            this.add("dpamt");
            this.add("isdiffcur");
            this.add("description");
            this.add("usage");
            this.add("payeetype");
            this.add("payeename");
            this.add("payeebanknum");
            this.add("totalremainrefundamt");
            this.add("entry.id");
            this.add("entry.e_payableamt");
            this.add("entry.e_discountamt");
            this.add("entry.e_actamt");
            this.add("entry.e_remainrefundamt");
        }
    };
    public static final Set<String> REFUND_PAGE_AGENT_BILL_FIELDS = new HashSet<String>(){
        {
            this.add(RefundConstants.ENTRY_RELA_BILL_ID);
            this.add("billno");
            this.add("settletype");
            this.add("payeracctbank.bankaccountnumber");
            this.add("currency");
            this.add("payamount");
            this.add("description");
            this.add("payeetype");
            this.add("isencryption");
            this.add("entry.id");
            this.add("entry.e_remark");
            this.add("entry.payeename");
            this.add("entry.payeeacctbank");
            this.add("entry.e_encryptamount");
            this.add("entry.e_remainrefundamt");
        }
    };
    public static final Map<String, String> IFM_BILL_FIELD_MAPPING = new HashMap<String, String>(){
        {
            this.put(RefundConstants.ENTRY_RELA_BILL_ID, RefundConstants.ENTRY_RELA_BILL_ID);
            this.put(RefundConstants.ENTRY_RELA_BILL_NO, "billno");
            this.put("relesettletype", "settletype");
            this.put("payeracctnum", "payeracctbank.bankaccountnumber");
            this.put("relecurrency", "currency");
            this.put("payamt", "actpayamt");
            this.put("description", "description");
            this.put("postscript", "usage");
            this.put("itempayeetype", "payeetype");
            this.put("payeename", "payeename");
            this.put("revaccountnum", "payeebanknum");
        }
    };
    public static final Set<String> TRADE_BILL_TYPE = Stream.of("fl_rentpaybill", "lc_arrival", "lc_buyerint", "cim_finsubscribe", "cim_deposit", "cim_noticedeposit", "cim_invest_loanbill", "cfm_repaymentbill", "cfm_interestbill", "gm_letterofguarantee", "fbd_suretybill", "fbd_suretyreleasebill", "fbd_surety_append", "scf_fincreditbill", "scf_finrepaybill", "tm_businessbill", "tm_structdeposit", "tm_rateswap", "tm_forex_options").collect(Collectors.toSet());
    public static final String OP_ADD_RELE_BILL = "addrelebill";
    public static final String OP_DELETE_ENTRY = "deleteentry";
}

