/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.fi.cas.enums.SourceBillTypeEnum;

public enum AutoMatchBillTypeEnum {
    TransDetail("0", "transdetail", "bei_transdetail_cas", "bei_transdetail_cas", ""),
    RECBILL("1", "rec", "bei_intelrec", "cas_recbill", "bizdate"),
    PAYBILL("2", "pay", "bei_intelpay", "cas_paybill", "bizdate"),
    AGENTPAYBILL("3", "agentpay", "bei_intelpay", "cas_agentpaybill", "bizdate"),
    TRANSUP("4", "transup", "bei_intelrec", "fca_transupbill", "transbilldate"),
    TRANSDOWN("5", "transdown", "bei_intelpay", "fca_transdownbill", "transbilldate"),
    TRANSHANDLEBILL("6", "transhandle", "bei_intelpay", SourceBillTypeEnum.TRANSHANDLEBILL.getValue(), "bizdate"),
    EXCHANGEBILL("7", "exchange", "bei_intelrec", "cas_exchangebill", "bizdate");

    private String value;
    private String bizType;
    private String sourceEntity;
    private String billEntity;
    private String defauleDateProp;

    private AutoMatchBillTypeEnum(String value, String bizType, String sourceEntity, String billEntity, String defauleDateProp) {
        this.value = value;
        this.bizType = bizType;
        this.sourceEntity = sourceEntity;
        this.billEntity = billEntity;
        this.defauleDateProp = defauleDateProp;
    }

    public String getValue() {
        return this.value;
    }

    public String getBizType() {
        return this.bizType;
    }

    public String getName() {
        return AutoMatchBillTypeEnum.getName(this.value);
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public String getBillEntity() {
        return this.billEntity;
    }

    public String getDefauleDateProp() {
        return this.defauleDateProp;
    }

    public static AutoMatchBillTypeEnum getByValue(String value) {
        AutoMatchBillTypeEnum result = null;
        for (AutoMatchBillTypeEnum billTypeEnum : AutoMatchBillTypeEnum.values()) {
            if (!billTypeEnum.getValue().equals(value)) continue;
            result = billTypeEnum;
            break;
        }
        return result;
    }

    public static AutoMatchBillTypeEnum getByType(String bizType) {
        AutoMatchBillTypeEnum result = null;
        for (AutoMatchBillTypeEnum billTypeEnum : AutoMatchBillTypeEnum.values()) {
            if (!billTypeEnum.getBizType().equals(bizType)) continue;
            result = billTypeEnum;
            break;
        }
        return result;
    }

    public static AutoMatchBillTypeEnum getByBillEntity(String billEntity) {
        AutoMatchBillTypeEnum result = null;
        for (AutoMatchBillTypeEnum billTypeEnum : AutoMatchBillTypeEnum.values()) {
            if (!billTypeEnum.getBillEntity().equals(billEntity)) continue;
            result = billTypeEnum;
            break;
        }
        return result;
    }

    public static String getName(String value) {
        switch (value) {
            case "0": {
                return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6", (String)"AutoMatchBillTypeEnum_2", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u5355", (String)"AutoMatchBillTypeEnum_0", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"AutoMatchBillTypeEnum_1", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"AutoMatchBillTypeEnum_3", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u4e0a\u5212\u5355", (String)"AutoMatchBillTypeEnum_4", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u4e0b\u62e8\u5355", (String)"AutoMatchBillTypeEnum_5", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355", (String)"AutoMatchBillTypeEnum_6", (String)"fi-cas-common", (Object[])new Object[0]);
            }
            case "7": {
                return ResManager.loadKDString((String)"\u5916\u5e01\u5151\u6362\u5355", (String)"AutoMatchBillTypeEnum_7", (String)"fi-cas-common", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

