/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayBillHelper {
    public static void save(DynamicObject agentPayBill) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentPayBill});
    }

    public static boolean execute(String sql, Object[] params) {
        DBRoute dbroute = new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_agentpaybill").getDBRouteKey());
        return DB.execute((DBRoute)dbroute, (String)sql, (Object[])params);
    }

    public static DynamicObject getById(long id) {
        if (!QueryServiceHelper.exists((String)"cas_agentpaybill", (Object)id)) {
            return null;
        }
        DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_agentpaybill");
        AgentPayBillHelper.decodeAmount(info);
        return info;
    }

    public static DynamicObject[] load(String selectors, QFilter[] filters) {
        boolean flag = false;
        String[] selectorArray = selectors.split(",");
        String localamtStr = "entry.e_localamt";
        String amountStr = "entry.e_amount";
        StringBuilder selectorsBuilder = new StringBuilder(selectors);
        for (int i = 0; i < selectorArray.length; ++i) {
            if (amountStr.equals(selectorArray[i].trim()) || "e_amount".equals(selectorArray[i].trim())) {
                flag = true;
                selectorsBuilder.append(',').append("e_encryptamount");
            }
            if (!localamtStr.equals(selectorArray[i].trim()) && !"e_localamt".equals(selectorArray[i].trim())) continue;
            flag = true;
            selectorsBuilder.append(',').append("e_encryptlocalamt");
        }
        selectors = selectorsBuilder.toString();
        DynamicObject[] agentBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)selectors, (QFilter[])filters);
        if (flag) {
            for (int i = 0; i < agentBills.length; ++i) {
                AgentPayBillHelper.decodeAmount(agentBills[i]);
            }
        }
        return agentBills;
    }

    public static DynamicObject loadSingle(Object pk, String selectors) {
        DynamicObject[] bills = AgentPayBillHelper.load(selectors, new QFilter[]{new QFilter("id", "=", pk)});
        return bills.length > 0 ? bills[0] : null;
    }

    public static void decodeAmountForWriteBack(DynamicObject agentBill) {
        AgentPayBillHelper.decodeAmount(agentBill);
    }

    public static void decodeAmount(DynamicObject agentBill) {
        DynamicObjectCollection entrys = agentBill.getDynamicObjectCollection("entry");
        HashMap<String, BigDecimal> decodeAmount = new HashMap<String, BigDecimal>(entrys.size());
        for (int i = 0; i < entrys.size(); ++i) {
            String encryptLocalAmtStr;
            String encryptAmounrStr;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (entry.getDataEntityType().getProperties().get((Object)"e_encryptamount") != null && (encryptAmounrStr = entry.getString("e_encryptamount")) != null && !encryptAmounrStr.trim().isEmpty()) {
                entry.set("e_amount", (Object)AgentPayBillHelper.getDecodeAmount(encryptAmounrStr, decodeAmount));
            }
            if (entry.getDataEntityType().getProperties().get((Object)"e_encryptlocalamt") == null || (encryptLocalAmtStr = entry.getString("e_encryptlocalamt")) == null || encryptLocalAmtStr.trim().isEmpty()) continue;
            entry.set("e_localamt", (Object)AgentPayBillHelper.getDecodeAmount(encryptLocalAmtStr, decodeAmount));
        }
    }

    private static BigDecimal getDecodeAmount(String encryptLocalAmtStr, Map<String, BigDecimal> decodeAmount) {
        BigDecimal amount = decodeAmount.get(encryptLocalAmtStr);
        if (amount == null) {
            decodeAmount.put(encryptLocalAmtStr, AgentPayBillHelper.decodeAmount(encryptLocalAmtStr));
        }
        return decodeAmount.get(encryptLocalAmtStr);
    }

    public static BigDecimal decodeAmountOld(String encryptAmount) {
        if (encryptAmount == null || encryptAmount.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        byte[] decode = Base64.getDecoder().decode(encryptAmount);
        return new BigDecimal(new String(decode));
    }

    public static String encodeAmountOld(BigDecimal amount) {
        BigDecimal amt = amount.setScale(6, RoundingMode.DOWN);
        byte[] toBytes = amt.toString().getBytes();
        return Base64.getEncoder().encodeToString(toBytes);
    }

    public static BigDecimal decodeAmount(String encryptAmount) {
        if (encryptAmount == null || encryptAmount.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        String decode = "";
        if (Encrypters.isEncrypted((String)encryptAmount)) {
            decode = Encrypters.decode((String)encryptAmount);
            return new BigDecimal(decode);
        }
        return AgentPayBillHelper.decodeAmountOld(encryptAmount);
    }

    public static String encodeAmount(BigDecimal amount) {
        BigDecimal amt = amount.setScale(6, RoundingMode.DOWN);
        return Encrypters.encode((String)amt.toString());
    }

    public static boolean isPaySalary(Long pk) {
        DynamicObject agentPayBill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"cas_agentpaybill", (String)"billtype");
        return AgentPayBillHelper.isPaySalary(agentPayBill);
    }

    public static boolean isPaySalary(DynamicObject agentPayBill) {
        DynamicObject billType = agentPayBill.getDynamicObject("billtype");
        if (billType == null) {
            return false;
        }
        long billTypeID = billType.getLong("id");
        return billTypeID == 343121063871251456L;
    }

    public static void wipeEntryAmount(DynamicObject agentPayBill) {
        boolean existEntryLocalAmountProp;
        EntityType dataEntityType = (EntityType)agentPayBill.getDataEntityType();
        EntryProp entryProp = (EntryProp)dataEntityType.getProperty("entry");
        if (entryProp == null) {
            return;
        }
        boolean existEntryAmountProp = entryProp._collectionItemPropertyType.getProperty("e_amount") != null;
        boolean bl = existEntryLocalAmountProp = entryProp._collectionItemPropertyType.getProperty("e_localamt") != null;
        if (!existEntryAmountProp && !existEntryLocalAmountProp) {
            return;
        }
        DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            if (existEntryAmountProp) {
                row.set("e_amount", null);
            }
            if (!existEntryLocalAmountProp) continue;
            row.set("e_localamt", null);
        }
    }

    public static boolean isDelegAgent(DynamicObject agentPayBill) {
        return agentPayBill.get("delegorg") != null;
    }

    public static boolean isDelegPush(DynamicObject agentPayBill) {
        String sourceBillType = agentPayBill.getString("sourcebilltype");
        return !CasHelper.isEmpty(sourceBillType) && "repay".equals(sourceBillType);
    }

    public static boolean isEntrustPush(DynamicObject agentPayBill) {
        String sourceBillType = agentPayBill.getString("sourcebilltype");
        return "repay".equals(sourceBillType) && EmptyUtil.isNoEmpty("applyorg");
    }

    public static void saveBankCheckFlags(DynamicObject[] agentPayBills) {
        ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>();
        for (DynamicObject agentPayBill : agentPayBills) {
            Object voucherId;
            QFilter filter1;
            DynamicObject[] journals;
            QFilter filter;
            DynamicObjectCollection vouchersDaps;
            DynamicObject org = agentPayBill.getDynamicObject("org");
            String bankcheckflagTag = agentPayBill.getString("bankcheckflag_tag");
            long orgId = (Long)org.getPkValue();
            boolean voucherBookJournal = SystemParameterHelper.isVoucherBookJournal(orgId);
            if (!voucherBookJournal || !CasHelper.isNotEmpty(vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid,billtype", (QFilter[])new QFilter[]{filter = new QFilter("sourcebillid", "=", (Object)agentPayBill.getLong("id"))})) || vouchersDaps.size() <= 0 || !CasHelper.isNotEmpty(journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"source,sourcebillid,sourcebilltype,bankcheckflag,bankcheckflag_tag,batchNo", (QFilter[])new QFilter[]{filter1 = new QFilter("sourcebillid", "=", voucherId = ((DynamicObject)vouchersDaps.get(0)).get("voucherid"))})) || journals.length <= 0) continue;
            DynamicObject journal = journals[0];
            journal.set("bankcheckflag", (Object)CasHelper.subFlag(bankcheckflagTag));
            journal.set("bankcheckflag_tag", (Object)bankcheckflagTag);
            journal.set("batchNo", (Object)bankcheckflagTag);
            journalList.add(journal);
        }
        if (journalList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])journalList.toArray(new DynamicObject[0]));
        }
    }

    public static void saveBankCheckFlag(DynamicObject agentPayBill) {
        Object voucherId;
        QFilter filter1;
        DynamicObject[] journals;
        QFilter filter;
        DynamicObjectCollection vouchersDaps;
        DynamicObject org = agentPayBill.getDynamicObject("org");
        String bankcheckflagTag = agentPayBill.getString("bankcheckflag_tag");
        long orgId = (Long)org.getPkValue();
        boolean voucherBookJournal = SystemParameterHelper.isVoucherBookJournal(orgId);
        if (voucherBookJournal && CasHelper.isNotEmpty(vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid,billtype", (QFilter[])new QFilter[]{filter = new QFilter("sourcebillid", "=", (Object)agentPayBill.getLong("id"))})) && vouchersDaps.size() > 0 && CasHelper.isNotEmpty(journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"source,sourcebillid,sourcebilltype,bankcheckflag,bankcheckflag_tag,batchNo", (QFilter[])new QFilter[]{filter1 = new QFilter("sourcebillid", "=", voucherId = ((DynamicObject)vouchersDaps.get(0)).get("voucherid"))})) && journals.length > 0) {
            DynamicObject journal = journals[0];
            journal.set("bankcheckflag", (Object)CasHelper.subFlag(bankcheckflagTag));
            journal.set("bankcheckflag_tag", (Object)bankcheckflagTag);
            journal.set("batchNo", (Object)bankcheckflagTag);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{journal});
        }
    }

    public static boolean isMatched(DynamicObject agentPayBillObj) {
        String result = agentPayBillObj.getString("matchflag");
        if (!AutoMatchFlagEnum.NONE.getValue().equals(result) && !AutoMatchFlagEnum.NONEED.getValue().equals(result)) {
            return true;
        }
        DynamicObjectCollection entryColl = agentPayBillObj.getDynamicObjectCollection("entry");
        for (DynamicObject dynamicObject : entryColl) {
            String eResult = dynamicObject.getString("entrymatchflag");
            if (AutoMatchFlagEnum.NONE.getValue().equals(eResult) || AutoMatchFlagEnum.NONEED.getValue().equals(eResult)) continue;
            return true;
        }
        return false;
    }
}

