/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.util.ViewUtils;

public class AgentPayBillPluginHelper {
    private static final String SAVE = "bar_save";
    private static final String SUBMIT = "bar_submit";
    private static final String SUBMITANDNEW = "bar_submitandnew";
    private static final String UNSUBMIT = "bar_unsubmit";
    private static final String AUDIT = "bar_audit";
    private static final String UNAUDIT = "bar_unaudit";
    private static final String PAY = "bar_pay";
    private static final String CANCELPAY = "bar_cancelpay";
    private static final String COMMITBE = "bar_commitbe";
    private static final String TRACKDOWN = "bar_trackdown";
    public static final String PAGE_CACHE_KEY_PERMISSION_ADD = "page_cache_key_permission_add";

    public static void setMenuVisibility(AbstractFormPlugin plugin, IDataModel model, IFormView view) {
        String billStatus = BillStatusEnum.SAVE.getValue();
        if (model.getDataEntity().getDataEntityState().getFromDatabase()) {
            DynamicObject agentBill = BusinessDataServiceHelper.loadSingleFromCache((Object)model.getDataEntity().getPkValue(), (String)"cas_agentpaybill", (String)"billstatus");
            if (CasHelper.isEmpty(agentBill)) {
                return;
            }
            billStatus = agentBill.getString("billstatus");
        }
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            AgentPayBillPluginHelper.showButtons(view, SAVE, SUBMIT, SUBMITANDNEW);
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            AgentPayBillPluginHelper.showButtons(view, UNSUBMIT, AUDIT);
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            AgentPayBillPluginHelper.showButtons(view, UNAUDIT, PAY, COMMITBE, "genvoucher", "deletevoucher");
        } else if (billStatus.equals(BillStatusEnum.PAY.getValue())) {
            AgentPayBillPluginHelper.showButtons(view, CANCELPAY, TRACKDOWN, "genvoucher", "deletevoucher");
        } else if (billStatus.equals(BillStatusEnum.BEING.getValue())) {
            AgentPayBillPluginHelper.showButtons(view, TRACKDOWN, "genvoucher", "deletevoucher");
        }
        view.setVisible(Boolean.FALSE, new String[]{"applyorg"});
        if (AgentPayBillPluginHelper.isDelegPush(model)) {
            model.setValue("delegorg", null);
            view.setVisible(Boolean.FALSE, new String[]{"delegorg"});
            view.setVisible(Boolean.TRUE, new String[]{"applyorg"});
            view.setEnable(Boolean.FALSE, new String[]{"org", "applyorg"});
        }
        AgentPayBillPluginHelper.setIsBotpFieldControl(plugin, model);
    }

    public static boolean isPersonPay(DynamicObject sourceBill) {
        String payeeType = sourceBill.getString("payeetype");
        if (StringUtils.isEmpty((CharSequence)payeeType)) {
            return true;
        }
        if ("bos_user".equals(payeeType)) {
            return true;
        }
        if ("bd_supplier".equals(payeeType) || "bd_customer".equals(payeeType)) {
            String formId = sourceBill.getDynamicObjectType().getName();
            if ("cas_agentpaybill".equals(formId)) {
                return false;
            }
            if (sourceBill.getLong("payee") == 0L) {
                return false;
            }
            DynamicObject payee = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceBill.getLong("payee"), (String)payeeType);
            if (payee != null) {
                String type = payee.getString("type");
                return "4".equals(type);
            }
        } else {
            if ("bos_org".equals(payeeType)) {
                return false;
            }
            if ("other".equals(payeeType)) {
                String formId = sourceBill.getDynamicObjectType().getName();
                return "cas_agentpaybill".equals(formId);
            }
        }
        return true;
    }

    private static void setIsBotpFieldControl(AbstractFormPlugin plugin, IDataModel model) {
        if (AgentPayBillPluginHelper.isBotpCreate(model)) {
            ViewUtils.setEnable(plugin, Boolean.FALSE, "payeetypelist");
            String sourceBillType = (String)model.getValue("sourcebilltype");
            Boolean isHeadPush = (Boolean)model.getValue("isheadpush");
            if (!isHeadPush.booleanValue() || "repay".equals(sourceBillType)) {
                ViewUtils.setEnable(plugin, Boolean.FALSE, "m_entryimport", "m_addrow", "payee", "payeename", "payeeacctbank", "encryptpayeeacctbank", "payeebank");
            }
            if ("repay".equals(sourceBillType)) {
                ViewUtils.setEnable(plugin, Boolean.FALSE, "m_deleterow", "e_amount");
            }
        }
    }

    private static void showButtons(IFormView view, String ... showKeys) {
        List<String> hiddenKeys = AgentPayBillPluginHelper.getAllButtonKeys();
        for (String key : showKeys) {
            hiddenKeys.remove(key);
        }
        if (!hiddenKeys.isEmpty()) {
            view.setVisible(Boolean.FALSE, hiddenKeys.toArray(new String[0]));
        }
        if (showKeys.length > 0) {
            view.setVisible(Boolean.TRUE, showKeys);
        }
    }

    private static List<String> getAllButtonKeys() {
        ArrayList<String> allButtonKeys = new ArrayList<String>();
        allButtonKeys.add(SAVE);
        allButtonKeys.add(SUBMIT);
        allButtonKeys.add(SUBMITANDNEW);
        allButtonKeys.add(UNSUBMIT);
        allButtonKeys.add(AUDIT);
        allButtonKeys.add(UNAUDIT);
        allButtonKeys.add(PAY);
        allButtonKeys.add(CANCELPAY);
        allButtonKeys.add(COMMITBE);
        allButtonKeys.add(TRACKDOWN);
        allButtonKeys.add("genvoucher");
        allButtonKeys.add("deletevoucher");
        return allButtonKeys;
    }

    private static boolean isBotpCreate(IDataModel model) {
        String sourceBillType = (String)model.getValue("sourcebilltype");
        return !CasHelper.isEmpty(sourceBillType);
    }

    public static boolean isDelegPush(IDataModel model) {
        String sourceBillType = (String)model.getValue("sourcebilltype");
        return !CasHelper.isEmpty(sourceBillType) && "repay".equals(sourceBillType);
    }

    public static boolean isEncodeAmount(IDataModel model, IFormView view) {
        boolean isEncode = false;
        if (((Boolean)model.getValue("isencryption")).booleanValue()) {
            String source = (String)model.getValue("source");
            if ("BOTP".equals(source)) {
                isEncode = true;
            } else if (view.getFormShowParameter().getStatus() == OperationStatus.VIEW || !"A".equals((String)model.getValue("billstatus"))) {
                isEncode = true;
            } else {
                DynamicObject org = (DynamicObject)model.getValue("org");
                long orgId = org == null ? 0L : (Long)org.getPkValue();
                IPageCache pageCache = view.getPageCache();
                String hasAddNewRightStr = pageCache.get(PAGE_CACHE_KEY_PERMISSION_ADD);
                boolean hasAddNewRight = false;
                if (StringUtils.isEmpty((CharSequence)hasAddNewRightStr)) {
                    hasAddNewRight = PermissionHelper.checkCurrentUserPermission(view.getFormShowParameter().getAppId(), orgId, "cas_agentpaybill", "47156aff000000ac");
                    pageCache.put(PAGE_CACHE_KEY_PERMISSION_ADD, String.valueOf(hasAddNewRight));
                } else {
                    hasAddNewRight = Boolean.parseBoolean(hasAddNewRightStr);
                }
                isEncode = !hasAddNewRight;
            }
        }
        return isEncode;
    }

    public static void setEncodeAmount(IDataModel model, Boolean isClear) {
        model.getEntryEntity("entry").forEach(action -> {
            BigDecimal loaclAmount;
            BigDecimal amount = action.getBigDecimal("e_amount");
            if (amount != null) {
                String encrptyAmountStr = AgentPayBillHelper.encodeAmount(amount);
                action.set("e_encryptamount", (Object)encrptyAmountStr);
                action.set("e_amount2", (Object)"****");
            }
            if ((loaclAmount = action.getBigDecimal("e_localamt")) != null) {
                String encrptyLocalAmountStr = AgentPayBillHelper.encodeAmount(loaclAmount);
                action.set("e_encryptlocalamt", (Object)encrptyLocalAmountStr);
                action.set("e_localamt2", (Object)"****");
            }
            if (isClear.booleanValue()) {
                action.set("e_amount", null);
                action.set("e_localamt", null);
            }
        });
    }

    public static BigDecimal getEntryAmount(IDataModel model, IFormView view, DynamicObject rowInfo) {
        if (AgentPayBillPluginHelper.isEncodeAmount(model, view)) {
            String encryptAmount = rowInfo.getString("e_encryptamount");
            return AgentPayBillHelper.decodeAmount(encryptAmount);
        }
        return rowInfo.getBigDecimal("e_amount");
    }

    public static BigDecimal getEntryAmount(IDataModel model, IFormView view, int rowIdx) {
        if (AgentPayBillPluginHelper.isEncodeAmount(model, view)) {
            String encryptAmount = (String)model.getValue("e_encryptamount");
            return AgentPayBillHelper.decodeAmount(encryptAmount);
        }
        return (BigDecimal)model.getValue("e_amount");
    }

    public static void setEncodeField(IDataModel model, IFormView view) {
        for (int i = 0; i < model.getEntryRowCount("entry"); ++i) {
            model.beginInit();
            String value = (String)model.getValue("payeeacctbank", i);
            model.setValue("encryptpayeeacctbank", (Object)AccountBankHelper.getBankNumberEncryptDisplay(value), i);
            model.setValue("e_amount2", (Object)"**.**", i);
            model.setValue("e_localamt2", (Object)"**.**", i);
            model.setValue("encryptunmatchamount", (Object)"**.**", i);
            model.setValue("encryptmatchamount", (Object)"**.**", i);
            model.setValue("e_remainrefundamt_s", (Object)"**.**", i);
            model.endInit();
            view.updateView("encryptpayeeacctbank", i);
            view.updateView("e_amount2", i);
            view.updateView("e_localamt2", i);
            view.updateView("encryptunmatchamount", i);
            view.updateView("encryptmatchamount", i);
        }
    }
}

