/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.ComboKey;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BalanceAdjustHelper {
    private static Log logger = LogFactory.getLog(BalanceAdjustHelper.class);

    public static List<String> getHasCheckedByDate(Long orgId, Long accountBankId, Long currencyId, Date endDate, String entityName) {
        QFilter singleLarge;
        DynamicObject[] SingleCheckedResults;
        ArrayList<String> ids = new ArrayList<String>(20);
        QFilter qfilter = new QFilter("accountbank", "=", (Object)accountBankId).and("currency", "=", (Object)currencyId);
        QFilter qfilterLess = new QFilter("entry.bizobject", "=", (Object)entityName).and("entry.bizdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
        QFilter qfilterlarge = new QFilter("entry.bizobject", "=", (Object)("cas_bankstatement".equals(entityName) ? "cas_bankjournal" : "cas_bankstatement")).and("entry.bizdate", ">", (Object)DateUtils.getDataFormat(endDate, false));
        DynamicObject[] checkedResults = BusinessDataServiceHelper.load((String)"cas_checkedresult", (String)"id,entry.bizobjectid", (QFilter[])new QFilter[]{qfilter, qfilterlarge});
        if (checkedResults != null && checkedResults.length > 0) {
            List<Long> tempIds = CasHelper.getIdList(checkedResults);
            ArrayList<Long> resultIds = new ArrayList<Long>(tempIds.size());
            resultIds.addAll(tempIds);
            DynamicObjectCollection results = QueryServiceHelper.query((String)"cas_checkedresult", (String)"id,entry.bizobjectid,entry.bizobject", (QFilter[])new QFilter[]{new QFilter("id", "in", resultIds), qfilterLess});
            if (results != null && results.size() > 0) {
                for (DynamicObject result : results) {
                    if (!entityName.equals(result.getString("entry.bizobject"))) continue;
                    ids.add(result.getString("entry.bizobjectid"));
                }
            }
        }
        if ((SingleCheckedResults = BusinessDataServiceHelper.load((String)"cas_checkedresult", (String)"id,entry.bizdate,entry.bizobjectid", (QFilter[])new QFilter[]{qfilter, singleLarge = new QFilter("entry.bizobject", "=", (Object)entityName).and("entry.bizdate", ">", (Object)DateUtils.getDataFormat(endDate, false)).and("checktype", "=", (Object)"byhand")})) != null && SingleCheckedResults.length > 0) {
            for (DynamicObject SingleCheckedResult : SingleCheckedResults) {
                DynamicObjectCollection results = SingleCheckedResult.getDynamicObjectCollection("entry");
                for (DynamicObject result : results) {
                    if (endDate.compareTo(result.getDate("bizdate")) < 0) continue;
                    ids.add(result.getString("bizobjectid"));
                }
            }
        }
        return ids;
    }

    public static void setDiffAndBankCg(DynamicObject balanceDy) {
        balanceDy.set("diffamount", (Object)balanceDy.getBigDecimal("adjustjournalamt").subtract(balanceDy.getBigDecimal("adjuststatementamt")));
        Long bankcgsetId = DynamicObjectHelper.getPk(balanceDy, "bankaccount");
        if (EmptyUtil.isNoEmpty(bankcgsetId)) {
            QFilter qFilter = new QFilter("id", "=", (Object)bankcgsetId);
            DynamicObject bankcgsetDy = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bank.bank_cate.id bankcgsetting", (QFilter[])new QFilter[]{qFilter});
            if (bankcgsetDy != null) {
                balanceDy.set("bankcgsetting", bankcgsetDy.get("bankcgsetting"));
            }
        }
    }

    public static DynamicObject adJustAmount(DynamicObject balAdjust, BigDecimal startbalamt, String sourceType, QFilter[] procFilters, boolean isAdd) {
        Map<Object, Object> reasonMap = new HashMap();
        Object balAdjustId = null;
        QFilter[] reasonFilters = null;
        String reasonSelProp = "";
        DynamicObjectCollection reasonColl = null;
        reasonSelProp = "id";
        reasonFilters = new QFilter[]{new QFilter("org", "=", (Object)DynamicObjectHelper.getPk(balAdjust, "org")), new QFilter("bankaccount", "=", (Object)DynamicObjectHelper.getPk(balAdjust, "bankaccount")), new QFilter("currency", "=", (Object)DynamicObjectHelper.getPk(balAdjust, "currency"))};
        reasonColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)reasonSelProp, (QFilter[])reasonFilters, (String)"bizdate desc");
        if (!reasonColl.isEmpty()) {
            balAdjustId = ((DynamicObject)reasonColl.get(0)).get("id");
        }
        if (!(reasonColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)(reasonSelProp = "enter_entry.billid, enter_entry.enter_reason"), (QFilter[])(reasonFilters = new QFilter[]{new QFilter("id", "=", balAdjustId), new QFilter("enter_entry.sourcetype", "=", (Object)sourceType)}), null)).isEmpty()) {
            reasonMap = reasonColl.stream().collect(Collectors.toMap(dyn -> dyn.get("enter_entry.billid"), dyn -> dyn.getString("enter_entry.enter_reason"), (e1, e2) -> e1));
        }
        BigDecimal adjustamt = new BigDecimal("0");
        BigDecimal creditSum = new BigDecimal("0");
        BigDecimal debitSum = new BigDecimal("0");
        if (isAdd) {
            if (sourceType.equals("cas_bankstatement")) {
                creditSum = balAdjust.getBigDecimal("bankgotamt");
                debitSum = balAdjust.getBigDecimal("bankpayedamt");
            } else {
                creditSum = balAdjust.getBigDecimal("entprpayedamt");
                debitSum = balAdjust.getBigDecimal("entprgotamt");
            }
        } else if (sourceType.equals("cas_bankstatement")) {
            balAdjust.set("enter_entry", null);
        } else {
            balAdjust.set("bank_entry", null);
        }
        String selectProperties = "";
        if (sourceType.equals("cas_bankstatement")) {
            selectProperties = "id,description,settlementtype.name,settlementnumber,bizdate,debitamount,creditamount,ratesdate,bankvouvherno,tradenumber,source,balanceamt,oppunit,oppbank,oppaccountnumber";
        } else {
            selectProperties = "id,sourcebilltype,sourcebillnumber,sourcebillid,,bookdate,bizdate,description,settlementtype.name,settlementnumber,debitamount,creditamount,pddate,avddate,preparationdate,createtime,source,cashier.name,feepayer,oppunit,oppbank,oppacctnumber";
            if (BalanceAdjustHelper.isHWProperty()) {
                selectProperties = selectProperties + ",hihn_paynum";
            }
        }
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)sourceType, (String)selectProperties, (QFilter[])procFilters, (String)"accountbank");
        logger.info("adJustAmount sourceType:{}, selectProperties:{} , procFilters:{}", new Object[]{sourceType, selectProperties, procFilters});
        if (sourceType.equals("cas_bankstatement")) {
            for (DynamicObject obj : colls) {
                DynamicObject balAdjustEntry = balAdjust.getDynamicObjectCollection("enter_entry").addNew();
                balAdjustEntry.set("sourcetype", (Object)sourceType);
                balAdjustEntry.set("billid", (Object)obj.getLong("id"));
                balAdjustEntry.set("enter_reason", reasonMap.get(obj.get("id")));
                balAdjustEntry.set("enter_description", EmptyUtil.isEmpty(obj.get("description")) ? " " : obj.get("description"));
                balAdjustEntry.set("enter_settletype", EmptyUtil.isEmpty(obj.get("settlementtype.name")) ? " " : obj.get("settlementtype.name"));
                balAdjustEntry.set("enter_settlenumber", EmptyUtil.isEmpty(obj.get("settlementnumber")) ? " " : obj.get("settlementnumber"));
                balAdjustEntry.set("enter_bizdate", obj.get("bizdate"));
                balAdjustEntry.set("enter_debitamount", EmptyUtil.isEmpty(obj.get("debitamount")) ? BigDecimal.ZERO : obj.get("debitamount"));
                balAdjustEntry.set("enter_creditamount", EmptyUtil.isEmpty(obj.get("creditamount")) ? BigDecimal.ZERO : obj.get("creditamount"));
                balAdjustEntry.set("ratesdate", obj.get("ratesdate"));
                balAdjustEntry.set("bankvouvherno", EmptyUtil.isEmpty(obj.get("bankvouvherno")) ? " " : obj.get("bankvouvherno"));
                balAdjustEntry.set("tradenumber", EmptyUtil.isEmpty(obj.get("tradenumber")) ? " " : obj.get("tradenumber"));
                balAdjustEntry.set("source", EmptyUtil.isEmpty(obj.get("source")) ? " " : obj.get("source"));
                balAdjustEntry.set("balanceamt", EmptyUtil.isEmpty(obj.get("balanceamt")) ? BigDecimal.ZERO : obj.get("balanceamt"));
                if (obj.containsProperty("oppunit")) {
                    balAdjustEntry.set("oppunit", (Object)obj.getString("oppunit"));
                }
                if (obj.containsProperty("oppbank")) {
                    balAdjustEntry.set("oppbank", (Object)obj.getString("oppbank"));
                }
                if (obj.containsProperty("oppaccountnumber")) {
                    balAdjustEntry.set("oppaccountnumber", (Object)obj.getString("oppaccountnumber"));
                }
                creditSum = creditSum.add(obj.getBigDecimal("creditamount"));
                debitSum = debitSum.add(obj.getBigDecimal("debitamount"));
            }
        } else {
            Map<Object, String[]> result = BalanceAdjustHelper.getBankJournalVoucher(colls);
            for (DynamicObject obj : colls) {
                DynamicObject balAdjustEntry = balAdjust.getDynamicObjectCollection("bank_entry").addNew();
                balAdjustEntry.set("banksourcetype", (Object)sourceType);
                balAdjustEntry.set("bankbillid", (Object)obj.getLong("id"));
                balAdjustEntry.set("bank_reason", reasonMap.get(obj.get("id")));
                balAdjustEntry.set("bank_bookdate", obj.get("bookdate"));
                balAdjustEntry.set("bank_bizdate", obj.get("bizdate"));
                balAdjustEntry.set("bank_description", EmptyUtil.isEmpty(obj.get("description")) ? " " : obj.get("description"));
                String[] voucherInfo = result.get(obj.getPkValue());
                if (voucherInfo != null) {
                    balAdjustEntry.set("bank_vouchertype", (Object)(EmptyUtil.isEmpty(voucherInfo[3]) ? " " : voucherInfo[3]));
                    balAdjustEntry.set("bank_vouchernumber", (Object)(EmptyUtil.isEmpty(voucherInfo[1]) ? " " : voucherInfo[1]));
                    balAdjustEntry.set("bank_billnumber", (Object)(EmptyUtil.isEmpty(voucherInfo[2]) ? " " : voucherInfo[2]));
                }
                balAdjustEntry.set("bank_billtype", (Object)SourceBillTypeEnum.getName(obj.getString("sourcebilltype")));
                balAdjustEntry.set("bank_settletype", EmptyUtil.isEmpty(obj.get("settlementtype.name")) ? " " : obj.get("settlementtype.name"));
                balAdjustEntry.set("bank_settlenumber", EmptyUtil.isEmpty(obj.get("settlementnumber")) ? " " : obj.get("settlementnumber"));
                balAdjustEntry.set("bank_debitamount", EmptyUtil.isEmpty(obj.get("debitamount")) ? BigDecimal.ZERO : obj.get("debitamount"));
                balAdjustEntry.set("bank_creditamount", EmptyUtil.isEmpty(obj.get("creditamount")) ? BigDecimal.ZERO : obj.get("creditamount"));
                balAdjustEntry.set("pddate", obj.get("pddate"));
                balAdjustEntry.set("avddate", obj.get("avddate"));
                balAdjustEntry.set("preparationdate", obj.get("preparationdate"));
                balAdjustEntry.set("sysdate", obj.get("createtime"));
                balAdjustEntry.set("banksource", EmptyUtil.isEmpty(obj.get("source")) ? " " : obj.get("source"));
                balAdjustEntry.set("cashier", EmptyUtil.isEmpty(obj.get("cashier.name")) ? " " : obj.get("cashier.name"));
                balAdjustEntry.set("feepayer", EmptyUtil.isEmpty(obj.get("feepayer")) ? " " : obj.get("feepayer"));
                if (obj.containsProperty("oppunit")) {
                    balAdjustEntry.set("bankoppunit", (Object)obj.getString("oppunit"));
                }
                if (obj.containsProperty("oppbank")) {
                    balAdjustEntry.set("bankoppbank", (Object)obj.getString("oppbank"));
                }
                if (obj.containsProperty("oppacctnumber")) {
                    balAdjustEntry.set("oppacctnumber", (Object)obj.getString("oppacctnumber"));
                }
                if (BalanceAdjustHelper.isHWProperty()) {
                    if (voucherInfo != null) {
                        balAdjustEntry.set("hihn_voucherbatchnum", (Object)(EmptyUtil.isEmpty(voucherInfo[4]) ? " " : voucherInfo[4]));
                    } else {
                        balAdjustEntry.set("hihn_voucherbatchnum", (Object)" ");
                    }
                    balAdjustEntry.set("hihn_paynum", EmptyUtil.isEmpty(obj.get("hihn_paynum")) ? " " : obj.get("hihn_paynum"));
                }
                creditSum = creditSum.add(obj.getBigDecimal("creditamount"));
                debitSum = debitSum.add(obj.getBigDecimal("debitamount"));
            }
        }
        if (sourceType.equals("cas_bankstatement")) {
            adjustamt = startbalamt.add(creditSum).subtract(debitSum);
            balAdjust.set("journalbalamt", (Object)startbalamt);
            balAdjust.set("bankgotamt", (Object)creditSum);
            balAdjust.set("bankpayedamt", (Object)debitSum);
            balAdjust.set("adjustjournalamt", (Object)adjustamt);
        } else {
            adjustamt = startbalamt.add(debitSum).subtract(creditSum);
            balAdjust.set("statmntbalamt", (Object)startbalamt);
            balAdjust.set("entprgotamt", (Object)debitSum);
            balAdjust.set("entprpayedamt", (Object)creditSum);
            balAdjust.set("adjuststatementamt", (Object)adjustamt);
        }
        return balAdjust;
    }

    public static Map<Object, String[]> getBankJournalVoucher(DynamicObject[] bankstatements) {
        Map<DynamicObject, Collection<Long>> voucherJournalMap = BalanceAdjustHelper.findRelatedVouchers(Arrays.asList(bankstatements), "cas_bankjournal");
        Map<Long, DynamicObject> voucherMap = BalanceAdjustHelper.queryVouchers(voucherJournalMap);
        HashMap resultMap = new HashMap();
        HashMap<Object, String[]> result = new HashMap<Object, String[]>();
        voucherJournalMap.forEach((journal, voucherPks) -> {
            HashSet voucherTypes = new HashSet();
            ArrayList voucherbatchnums = new ArrayList();
            ArrayList voucherTypeNos = new ArrayList();
            LinkedList voucherBillNos = new LinkedList();
            voucherPks.forEach(voucherPk -> {
                DynamicObject voucher = (DynamicObject)voucherMap.get(voucherPk);
                if (voucher != null) {
                    String voucherType = voucher.getString("vouchertype.name");
                    String voucherNumber = voucher.getString("billno");
                    String voucherTypeNumber = voucherType + " " + voucherNumber;
                    voucherTypes.add(voucherType);
                    voucherTypeNos.add(voucherTypeNumber);
                    voucherBillNos.add(voucherNumber);
                    if (BalanceAdjustHelper.isHWProperty()) {
                        String voucherbatchnum = voucher.getString("voucherbatchnum");
                        voucherbatchnums.add(voucherbatchnum);
                    }
                    resultMap.computeIfAbsent(journal.getString("id"), k -> new ArrayList());
                    resultMap.computeIfPresent(journal.getString("id"), (k, v) -> {
                        v.add(voucher);
                        return v;
                    });
                }
            });
            String sourceBillType = journal.getString("sourcebilltype");
            String[] sourceNumber = new String[]{sourceBillType, String.join((CharSequence)",", voucherTypeNos), "gl_voucher".equals(sourceBillType) ? String.join((CharSequence)",", voucherBillNos) : journal.getString("sourcebillnumber"), String.join((CharSequence)",", voucherTypes), String.join((CharSequence)",", voucherbatchnums)};
            result.put(journal.getPkValue(), sourceNumber);
        });
        return result;
    }

    public static Map<DynamicObject, Collection<Long>> findRelatedVouchers(Collection<DynamicObject> journals, String journalType) {
        HashMap<DynamicObject, Collection<Long>> journalVoucherMap = new HashMap<DynamicObject, Collection<Long>>(50);
        if (journals == null || journals.isEmpty()) {
            return journalVoucherMap;
        }
        for (DynamicObject dynamicObject : journals) {
            journalVoucherMap.put(dynamicObject, new ArrayList());
        }
        HashMap<ComboKey, Collection<DynamicObject>> sourceBillJournalMap = new HashMap<ComboKey, Collection<DynamicObject>>();
        for (DynamicObject journal : journals) {
            String sourceBillType = journal.getString("sourcebilltype");
            long sourceBillId = journal.getLong("sourcebillid");
            if ("gl_voucher".equals(sourceBillType)) {
                journalVoucherMap.computeIfPresent(journal, (k, v) -> {
                    v.add(sourceBillId);
                    return v;
                });
                continue;
            }
            if (sourceBillId == 0L && "cas_manualbankjournal".equals(sourceBillType)) continue;
            if (sourceBillId == 0L) {
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)journalType, (Long[])new Long[]{journal.getLong("id")});
                HashSet sourcePks2 = sourceBills.getOrDefault(sourceBillType, new HashSet());
                for (Long spk : sourcePks2) {
                    ComboKey key = new ComboKey(sourceBillType, spk);
                    sourceBillJournalMap.computeIfAbsent(key, k -> new ArrayList());
                    sourceBillJournalMap.computeIfPresent(key, (k, v) -> {
                        v.add(journal);
                        return v;
                    });
                }
                continue;
            }
            ComboKey key = new ComboKey(sourceBillType, sourceBillId);
            sourceBillJournalMap.computeIfAbsent(key, k -> new ArrayList());
            sourceBillJournalMap.computeIfPresent(key, (k, v) -> {
                v.add(journal);
                return v;
            });
        }
        Map<String, Collection<Long>> map = BalanceAdjustHelper.groupBySourceEntity(sourceBillJournalMap);
        map.forEach((sourceEntityKey, sourcePks) -> {
            DynamicObject[] dapTrackers;
            for (DynamicObject dapTracker : dapTrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourcePks)})) {
                long voucherPk = dapTracker.getLong("voucherid");
                ComboKey key = new ComboKey(sourceEntityKey, dapTracker.getLong("sourcebillid"));
                Collection relatedJournals = sourceBillJournalMap.getOrDefault(key, new ArrayList());
                for (DynamicObject journal : relatedJournals) {
                    journalVoucherMap.computeIfPresent(journal, (k, v) -> {
                        v.add(voucherPk);
                        return v;
                    });
                }
            }
        });
        return journalVoucherMap;
    }

    private static Map<String, Collection<Long>> groupBySourceEntity(Map<ComboKey, Collection<DynamicObject>> sourceBillJournalMap) {
        HashMap<String, Collection<Long>> sourceBillPksMap = new HashMap<String, Collection<Long>>();
        sourceBillJournalMap.keySet().forEach(sourceBillInfo -> {
            String sourceEntityKey = (String)sourceBillInfo.getKey(0);
            Long sourcePk = (Long)sourceBillInfo.getKey(1);
            sourceBillPksMap.computeIfAbsent(sourceEntityKey, k -> new ArrayList());
            sourceBillPksMap.computeIfPresent(sourceEntityKey, (k, v) -> {
                v.add(sourcePk);
                return v;
            });
        });
        return sourceBillPksMap;
    }

    public static Map<Long, DynamicObject> queryVouchers(Map<DynamicObject, Collection<Long>> voucherJournalMap) {
        DynamicObject[] vouchers;
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(50);
        LinkedList voucherPks = new LinkedList();
        voucherJournalMap.values().forEach(v -> voucherPks.addAll(v));
        if (voucherPks.isEmpty()) {
            return voucherMap;
        }
        Collection<Collection<Long>> values = voucherJournalMap.values();
        QFilter[] filters = null;
        if (null == values) {
            return voucherMap;
        }
        HashSet ids = new HashSet();
        values.stream().filter(t -> null != t && t.size() > 0).forEach(collection -> collection.forEach(t -> ids.add(t)));
        filters = new QFilter("id", "in", ids).toArray();
        String proStr = "vouchertype.name,billno";
        if (BalanceAdjustHelper.isHWProperty()) {
            proStr = "vouchertype.name,billno,voucherbatchnum";
        }
        for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)proStr, (QFilter[])filters)) {
            voucherMap.put((Long)voucher.getPkValue(), voucher);
        }
        return voucherMap;
    }

    public static boolean isHWProperty() {
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"cas_balanceadjust").findProperty("bank_entry");
        return prop.getDynamicCollectionItemPropertyType().getProperty("hihn_voucherbatchnum") != null;
    }

    public static DynamicObject getLastBalanceAdust(DynamicObject org, DynamicObject accountBank, DynamicObject currency) {
        if (org == null || accountBank == null || currency == null) {
            return null;
        }
        return BalanceAdjustHelper.getLastBalanceAdjust(org.getLong("id"), accountBank.getLong("id"), currency.getLong("id"));
    }

    public static DynamicObject getLastBalanceAdjust(Long org, Long accountBank, Long currency) {
        DynamicObjectCollection balances;
        QFilter filter = new QFilter("org", "=", (Object)org).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()).and("period", "!=", (Object)Long.valueOf("0"));
        if (!CasHelper.isEmpty(accountBank)) {
            filter.and(new QFilter("bankaccount", "=", (Object)accountBank));
        }
        if (!CasHelper.isEmpty(currency)) {
            filter.and(new QFilter("currency", "=", (Object)currency));
        }
        if ((balances = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"id,billstatus,bizdate,billno", (QFilter[])new QFilter[]{filter}, (String)"bizdate desc", (int)1)) != null && balances.size() > 0) {
            return (DynamicObject)balances.get(0);
        }
        return null;
    }

    public static Map<String, DynamicObject> getLastBalanceAdjustBatch(Collection<Long> orgIds, Collection<Long> accountBankIds, Collection<Long> currencyIds) {
        DynamicObjectCollection balances;
        QFilter filter = new QFilter("org", "in", orgIds).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()).and("period", "!=", (Object)Long.valueOf("0"));
        if (!CasHelper.isEmpty(accountBankIds)) {
            filter.and(new QFilter("bankaccount", "in", accountBankIds));
        }
        if (!CasHelper.isEmpty(currencyIds)) {
            filter.and(new QFilter("currency", "in", currencyIds));
        }
        if (EmptyUtil.isEmpty(balances = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"id, org, bankaccount, currency, billstatus, bizdate, billno", (QFilter[])new QFilter[]{filter}))) {
            return new HashMap<String, DynamicObject>(2);
        }
        return balances.stream().collect(Collectors.groupingBy(balance -> balance.getLong("org") + "_" + balance.getLong("bankaccount") + "_" + balance.getLong("currency"), Collectors.collectingAndThen(Collectors.reducing((t1, t2) -> t1.getDate("bizdate").getTime() > t2.getDate("bizdate").getTime() ? t1 : t2), Optional::get)));
    }

    public static BigDecimal getAmountByPeriod(Long periodId, Long acctId, Long orgId, Long currency) {
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,entrybank.bank_accountbank,entrybank.bank_journalbalance,entrybank.bank_currency", (QFilter[])new QFilter[]{new QFilter("startperiod", "=", (Object)periodId), new QFilter("entrybank.bank_accountbank", "=", (Object)acctId), new QFilter("entrybank.bank_currency", "=", (Object)currency), new QFilter("org", "!=", (Object)orgId)});
        if (CasHelper.isEmpty(inits)) {
            return amount;
        }
        for (DynamicObject init : inits) {
            DynamicObjectCollection entrybank = init.getDynamicObjectCollection("entrybank");
            for (DynamicObject bank : entrybank) {
                if (bank.getDynamicObject("bank_accountbank").getLong("id") != acctId.longValue() || bank.getDynamicObject("bank_currency").getLong("id") != currency.longValue()) continue;
                amount = amount.add(bank.getBigDecimal("bank_journalbalance"));
            }
        }
        return amount;
    }

    public static Map<String, DynamicObject> getLastBalanceAdjust(Set<Long> org, Set<Long> accountBank, Set<Long> currency) {
        if (org.size() == 0 || accountBank.size() == 0 || currency.size() == 0) {
            return new HashMap<String, DynamicObject>();
        }
        QFilter filter = new QFilter("org", "in", org).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()).and("period", "!=", (Object)Long.valueOf("0")).and("bizdate", "is not null", null).and("bankaccount", "in", accountBank).and("currency", "in", currency);
        HashMap<String, DynamicObject> balanceResultMap = new HashMap<String, DynamicObject>();
        DataSet balances = QueryServiceHelper.queryDataSet((String)"balanceadjust", (String)"cas_balanceadjust", (String)"id,org,billstatus,bizdate,billno,bankaccount,currency", (QFilter[])new QFilter[]{filter}, (String)"bizdate desc");
        DataSet groupDataSet = balances.copy().groupBy(new String[]{"org", "bankaccount", "currency"}).max("bizdate").finish();
        DataSet filter2 = balances.join(groupDataSet).on("org", "org").on("bizdate", "bizdate").on("bankaccount", "bankaccount").on("currency", "currency").select(new String[]{"org", "billstatus", "bizdate", "billno", "bankaccount", "currency"}).finish();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_balanceadjust");
        for (Row balanceObj : filter2.copy()) {
            DynamicObject dynamicObject = (DynamicObject)type.createInstance();
            dynamicObject.set("org", (Object)balanceObj.getLong("org"));
            dynamicObject.set("bankaccount", (Object)balanceObj.getLong("bankaccount"));
            dynamicObject.set("currency", (Object)balanceObj.getLong("currency"));
            dynamicObject.set("billstatus", (Object)balanceObj.getString("billstatus"));
            dynamicObject.set("bizdate", (Object)balanceObj.getDate("bizdate"));
            dynamicObject.set("billno", (Object)balanceObj.getString("billno"));
            String keyStr = BalanceAdjustHelper.getKeyStr(balanceObj.getLong("org"), balanceObj.getLong("bankaccount"), balanceObj.getLong("currency"));
            if (balanceResultMap.containsKey(keyStr)) continue;
            balanceResultMap.put(keyStr, dynamicObject);
        }
        return balanceResultMap;
    }

    public static String getKeyStr(Long org, Long account, Long currency) {
        return org + "_" + account + "_" + currency;
    }
}

