/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.util.EmptyUtil;

public class CasHelper {
    public static boolean isEmpty(Object obj) {
        return EmptyUtil.isEmpty(obj);
    }

    public static boolean isNotEmpty(Object o) {
        return !CasHelper.isEmpty(o);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(CasHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static String idListToInClause(List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append(idList.get(0));
        } else {
            Iterator<Long> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append(it.next()).append(", ");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String idsToInClause(List<String> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append('\'');
            sb.append(idList.get(0));
            sb.append('\'');
        } else {
            Iterator<String> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append('\'');
                sb.append(it.next());
                sb.append('\'');
                sb.append(", \n");
            }
            sb.append('\'');
            sb.append(it.next());
            sb.append('\'');
        }
        return sb.toString();
    }

    public static List<Long> getIdList(DynamicObject[] infos) {
        ArrayList<Long> idList = new ArrayList<Long>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.getPkValue() == null ? 0L : Long.parseLong(info.getPkValue().toString()));
        }
        return idList;
    }

    public static String getStackTraceMessage(Exception e) {
        return e.getMessage();
    }

    public static boolean isEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj2 == null && obj1 instanceof String) {
                return StringUtils.isBlank((Object)obj1);
            }
            if (obj1 == null && obj2 instanceof String) {
                return StringUtils.isBlank((Object)obj2);
            }
            return false;
        }
        if (obj1.getClass().equals(obj2.getClass())) {
            if (obj1 instanceof BigDecimal) {
                return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
            }
            if (obj1 instanceof DynamicObject) {
                return ((DynamicObject)obj1).getPkValue().equals(((DynamicObject)obj2).getPkValue());
            }
            return obj1.equals(obj2);
        }
        return false;
    }

    public static String removeFieldPrefix(String field) {
        int index = field.indexOf(46);
        index = index > 0 ? ++index : 0;
        return field.substring(index);
    }

    public static Long getCurrentUser() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static int getSelectedRowSize(ListSelectedRowCollection selectedRows) {
        HashSet pkIds = new HashSet();
        selectedRows.forEach(row -> pkIds.add((Long)row.getPrimaryKeyValue()));
        return pkIds.size();
    }

    public static boolean isEmpty(DynamicObject[] objs) {
        return objs == null || objs.length == 0;
    }

    public static OperateErrorInfo getOperateErrorInfo(Object pk, String meg, String title) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setTitle(title);
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    public static void showOperationResultMulti(OperationResult operationResult, String operateName, IFormView view) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        int errorCount = errorInfos.size();
        int successCount = operationResult.getBillCount() - errorCount;
        if (successCount < 0) {
            successCount = 0;
            errorCount = operationResult.getBillCount();
        }
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u5176\u4e2d\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"RecWorkbenchPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, errorCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        view.showForm(parameters);
    }

    public static boolean isNum(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Long getLong(Object obj) {
        return Long.parseLong(String.valueOf(obj));
    }

    public static String getLocalValue(DynamicObject obj, String prop) {
        if (obj == null || CasHelper.isEmpty(prop)) {
            return "";
        }
        String localeValue = obj.getLocaleString(prop).getLocaleValue();
        if (CasHelper.isEmpty(localeValue)) {
            String value = obj.getString(prop);
            return CasHelper.isEmpty(value) ? "" : value;
        }
        return localeValue;
    }

    public static List<String> getOverrideField(Object keyFields) {
        List<String> fieldList = new ArrayList<String>(10);
        String fields = String.valueOf(keyFields);
        if (CasHelper.isNotEmpty(fields)) {
            String[] field = fields.split(",");
            fieldList = Arrays.asList(field);
            fieldList = fieldList.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        return fieldList;
    }

    public static String subFlag(String bankCheckFlag) {
        if (bankCheckFlag != null && bankCheckFlag.length() > 255) {
            bankCheckFlag = bankCheckFlag.substring(0, 255);
        }
        return bankCheckFlag;
    }

    public static String getFailResultMsg(OperationResult result) {
        StringBuilder message = new StringBuilder(org.apache.commons.lang3.StringUtils.defaultString((String)result.getMessage(), (String)""));
        List operateInfoList = result.getAllErrorOrValidateInfo();
        if (CollectionUtils.isNotEmpty((Collection)operateInfoList)) {
            for (IOperateInfo info : operateInfoList) {
                message.append("\r\n").append(info.getMessage());
            }
        }
        return message.toString();
    }

    public static QFilter getFilterFromTag(String entryName, String filterTag) {
        if (StringUtils.isEmpty((CharSequence)filterTag)) {
            return null;
        }
        CRCondition condition = (CRCondition)JSON.parseObject((String)filterTag, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder fb = new FilterBuilder(dataType, filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    public static boolean isMatchCondition(CRCondition condition, DynamicObject row) {
        MainEntityType mainEntityType = (MainEntityType)row.getDataEntityType();
        FilterCondition filterCondition = condition.getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        String[] scripts = filterBuilder.buildFilterScript();
        String expression = scripts[0];
        RowDataModel rowDataModel = new RowDataModel(mainEntityType.getName(), mainEntityType);
        ExpressionParameter expressionParameter = new ExpressionParameter(expression, rowDataModel);
        Set vars = expressionParameter.getBOSExpression().getVars();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (String fieldName : vars) {
            Object value = row.get(fieldName);
            if (value instanceof OrmLocaleValue) {
                params.put(fieldName, ((OrmLocaleValue)value).getLocaleValue());
                continue;
            }
            params.put(fieldName, value);
        }
        return (Boolean)FormulaEngine.execExcelFormula((String)expression, params);
    }
}

