/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ViewInputHelper;

public class CoreBillSettingHelper {
    private static final Log LOGGER = LogFactory.getLog(CoreBillSettingHelper.class);

    public static List<DynamicObject> loadCoreBillSetting(String bizType, boolean isMultiReceivingType, boolean isPartReceivable) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("biztype", "=", (Object)bizType);
        if (!isMultiReceivingType) {
            if (isPartReceivable) {
                qFilter.and("settle", "=", (Object)"1");
            } else {
                qFilter.and("unsettle", "=", (Object)"1");
            }
        }
        Map coreSetting = BusinessDataServiceHelper.loadFromCache((String)"cas_corebill_setting", (QFilter[])qFilter.toArray());
        return new ArrayList<DynamicObject>(coreSetting.values());
    }

    public static Set<String> getNumberBySetting(List<DynamicObject> coreBillSettings) {
        if (coreBillSettings.size() > 0) {
            return coreBillSettings.stream().map(s -> s.getString("number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(10);
    }

    public static Map<String, String> loadCoreBillSettingNumberAndName(String bizType, boolean isMultiReceivingType, boolean isPartReceivable) {
        List<DynamicObject> coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting(bizType, isMultiReceivingType, isPartReceivable);
        if (coreBillSettings.size() > 0) {
            return coreBillSettings.stream().collect(Collectors.toMap(s -> s.getString("number"), s -> s.getString("name"), (p, q) -> p));
        }
        return new HashMap<String, String>(10);
    }

    public static void setCoreBillTypeComboItem(String bizType, boolean isMultiReceivingType, boolean isPartReceivable, List<ComboItem> coreComboItem) {
        List<DynamicObject> coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting(bizType, isMultiReceivingType, isPartReceivable);
        if (coreBillSettings.size() > 0) {
            for (DynamicObject coreBillSetting : coreBillSettings) {
                ComboItem comboItem = new ComboItem(new LocaleString(coreBillSetting.getString("name")), coreBillSetting.getString("number"));
                coreComboItem.add(comboItem);
            }
        }
    }

    public static DynamicObject filterCoreBillSetting(List<DynamicObject> coreBillSettings, String corebilltype) {
        if (coreBillSettings.size() > 0) {
            return coreBillSettings.stream().filter(s -> corebilltype.equals(s.getString("number"))).findFirst().orElse(null);
        }
        return null;
    }

    public static Map<String, Object> dealShowF7CustomParams(DynamicObject coreBillSetting, IDataModel model, boolean isBatch) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        DynamicObjectCollection showReqEntitys = coreBillSetting.getDynamicObjectCollection("showreqentity");
        try {
            for (DynamicObject showReqEntity : showReqEntitys) {
                String reqSource = showReqEntity.getString("reqsource");
                String reqBillProp = isBatch ? "reqbatchbillfieldprop" : "reqbillfieldprop";
                String reqFieldProp = showReqEntity.getString(reqBillProp);
                Object value = null;
                if ("head".equals(reqSource)) {
                    if (reqFieldProp.contains(".")) {
                        String[] split = reqFieldProp.split("\\.");
                        DynamicObject obj = (DynamicObject)model.getValue(split[0]);
                        if (CasHelper.isNotEmpty(obj)) {
                            value = obj.get(split[1]);
                        }
                    } else {
                        value = model.getValue(reqFieldProp);
                    }
                } else if ("entry".equals(reqSource)) {
                    int currrow = model.getEntryCurrentRowIndex("entryentity");
                    if (reqFieldProp.contains(".")) {
                        String[] split = reqFieldProp.split("\\.");
                        DynamicObject obj = (DynamicObject)model.getValue(split[0], currrow);
                        if (CasHelper.isNotEmpty(obj)) {
                            value = obj.get(split[1]);
                        }
                    } else {
                        value = model.getValue(reqFieldProp, currrow);
                    }
                }
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                customParam.put(showReqEntity.getString("reqparamtag"), value);
            }
            DynamicObjectCollection showRepEntry = coreBillSetting.getDynamicObjectCollection("showrepentry");
            String repBillProp = isBatch ? "repbatchtag" : "reptag";
            Map<String, String> queryMap = showRepEntry.stream().filter(s -> CasHelper.isNotEmpty(s.getString("repqueryfield"))).collect(Collectors.toMap(s -> s.getString("repqueryfield"), s -> s.getString(repBillProp)));
            if (queryMap.size() > 0) {
                customParam.put("EXT_QUERY_FIELD_MAP", queryMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("set showF7 params error", (Throwable)e);
        }
        return customParam;
    }

    public static void setClosedCallBackInfo(Map<String, Object> selectedRow, DynamicObject coreBillSetting, IFormView view, IDataModel model, int rowIndex) {
        try {
            String repTagProp = rowIndex == -1 ? "repbatchtag" : "reptag";
            DynamicObjectCollection showRepEntrys = coreBillSetting.getDynamicObjectCollection("showrepentry");
            for (DynamicObject showRepEntry : showRepEntrys) {
                String repTag = showRepEntry.getString(repTagProp);
                if (!CasHelper.isNotEmpty(repTag) || !selectedRow.containsKey(repTag)) continue;
                if (rowIndex == -1) {
                    ViewInputHelper.setValWithoutPropChgEvt(view, model, repTag, selectedRow.get(repTag));
                    continue;
                }
                ViewInputHelper.setValWithoutPropChgEvt(view, model, repTag, selectedRow.get(repTag), rowIndex);
            }
        }
        catch (Exception e) {
            LOGGER.error("setClosedCallBackInfo error", (Throwable)e);
        }
    }

    public static List<DynamicObject> loadRecWriteBackInfo(Set<String> coreBillTypeSet) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("number", "in", coreBillTypeSet);
        qFilter.and("writeback", "in", (Object)"1");
        Map coreSetting = BusinessDataServiceHelper.loadFromCache((String)"cas_corebill_setting", (QFilter[])qFilter.toArray());
        return new ArrayList<DynamicObject>(coreSetting.values());
    }

    public static void setRecWriteBackInfo(DynamicObject info, DynamicObject entry, Map<String, Object> detailMap, int entrySeq, DynamicObject setting) {
        try {
            DynamicObjectCollection recTreeEntrys = setting.getDynamicObjectCollection("rectreeentry");
            for (DynamicObject recTreeEntry : recTreeEntrys) {
                String[] split;
                String recLevel = recTreeEntry.getString("reclevel");
                String recParamType = recTreeEntry.getString("recparamtype");
                if ("Entries".equals(recParamType)) continue;
                String recObjPropName = recTreeEntry.getString("recobjpropname");
                Object value = null;
                if ("1".equals(recLevel)) {
                    if (recObjPropName.contains(".")) {
                        split = recObjPropName.split("\\.");
                        DynamicObject obj = info.getDynamicObject(split[0]);
                        value = obj.get(split[1]);
                    } else {
                        value = info.get(recObjPropName);
                    }
                } else if ("2".equals(recLevel)) {
                    split = recObjPropName.split("\\.");
                    int length = split.length;
                    if (length == 3) {
                        DynamicObject obj = entry.getDynamicObject(split[1]);
                        value = obj.get(split[2]);
                    } else {
                        value = "seq".equals(split[1]) ? Integer.valueOf(entrySeq) : entry.get(split[1]);
                    }
                }
                detailMap.put(recTreeEntry.getString("recparamtag"), value);
            }
        }
        catch (Exception e) {
            LOGGER.error("setRecWriteBackInfo error", (Throwable)e);
        }
    }

    public static void setCoreBillInfo(DynamicObject coreBillSetting, Map<String, Object> showParams, IFormView view, int entryIndex, boolean isBatch) {
        IDataModel model = view.getModel();
        String cloudId = coreBillSetting.getString("handcloud");
        DynamicObject appId = coreBillSetting.getDynamicObject("handappid");
        String serviceName = coreBillSetting.getString("handservicename");
        String methodName = coreBillSetting.getString("handmethodname");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId.getString("number"), (String)serviceName, (String)methodName, (Object[])new Object[]{showParams});
        if (result.size() > 0) {
            String isSuccess = (String)result.get("isSuccess");
            if (!"true".equals(isSuccess)) {
                if (isBatch) {
                    model.setValue("corebillno", null);
                } else {
                    model.setValue("e_corebillno", null, entryIndex);
                }
                String message = ResManager.loadKDString((String)"\u5bf9\u5e94\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u6b64\u6838\u5fc3\u5355\u636e\u53f7\u3002", (String)"ReceivingBillEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                view.showTipNotification(message);
            } else {
                DynamicObjectCollection showRepEntrys = coreBillSetting.getDynamicObjectCollection("showrepentry");
                for (DynamicObject showRepEntry : showRepEntrys) {
                    String repProp;
                    String repTag = showRepEntry.getString(repProp = isBatch ? "repbatchtag" : "reptag");
                    if (!CasHelper.isNotEmpty(repTag) || !result.containsKey(repTag)) continue;
                    if (isBatch) {
                        model.setValue(repTag, result.get(repTag));
                        continue;
                    }
                    model.setValue(repTag, result.get(repTag), entryIndex);
                }
            }
        }
    }

    public static QFilter getCoreBillFilter(Map<String, Object> customParams, String name) {
        QFilter qFilter = new QFilter("billstatus", "in", (Object)new Object[]{BillStatusEnum.PAY.getValue(), BillStatusEnum.REFUND.getValue(), BillStatusEnum.RENOTE.getValue()});
        Object ispartreceivable = customParams.get("ispartreceivable");
        Object payeracctbank = customParams.get("payeracctbank");
        if ("cas_recbill".equals(name)) {
            if (ispartreceivable != null && ((Boolean)ispartreceivable).booleanValue()) {
                CoreBillSettingHelper.setIsPartReceivableCommonFilter(qFilter, customParams);
            } else {
                boolean isNullAcc = true;
                String settlementtype = (String)customParams.get("settlementtype");
                if ("0".equals(settlementtype)) {
                    Object payeracctcash = customParams.get("payeracctcash");
                    if (payeracctcash != null) {
                        qFilter.and("payeracctcash", "=", payeracctcash);
                        isNullAcc = false;
                    }
                } else if (payeracctbank != null) {
                    QFilter accountOrOrgFilter = new QFilter("payeracctbank", "=", payeracctbank).or("org", "=", customParams.get("orgid"));
                    qFilter.and(accountOrOrgFilter);
                    isNullAcc = false;
                }
                if (isNullAcc) {
                    qFilter.and("payeracctcash", "=", null).and(new QFilter("payeracctbank", "=", null));
                }
                CoreBillSettingHelper.setUnPartReceivableCommonFilter(qFilter, customParams);
            }
        } else {
            String businessType = (String)customParams.get("businesstype");
            if (ispartreceivable != null && !((Boolean)ispartreceivable).booleanValue()) {
                QFilter accountOrOrgFilter = new QFilter("payeracctbank", "=", payeracctbank).or("org", "=", customParams.get("orgid"));
                qFilter.and(accountOrOrgFilter);
                CoreBillSettingHelper.setUnPartReceivableCommonFilter(qFilter, customParams);
            } else if (Arrays.asList("recticket", "rec").contains(businessType)) {
                CoreBillSettingHelper.setIsPartReceivableCommonFilter(qFilter, customParams);
            }
        }
        return qFilter;
    }

    private static void setIsPartReceivableCommonFilter(QFilter qFilter, Map<String, Object> customParams) {
        qFilter.and("paymenttype.ispartpayment", "=", (Object)"1");
        qFilter.and("dpcurrency", "=", customParams.get("currencyid"));
        qFilter.and("entry.settleorg", "=", customParams.get("settleorg"));
        QFilter accountOrOrgFilter = new QFilter("payeracctbank", "=", customParams.get("payeracctbank")).or("org", "=", customParams.get("orgid"));
        qFilter.and(accountOrOrgFilter);
        qFilter.and("totalremainrefundamt", "!=", (Object)BigDecimal.ZERO);
    }

    private static void setUnPartReceivableCommonFilter(QFilter qFilter, Map<String, Object> customParams) {
        String payerType = (String)customParams.get("paymenttype");
        if ("other".equals(payerType)) {
            qFilter.and("payeename", "=", customParams.get("payeename"));
        } else {
            qFilter.and("payee", "=", customParams.get("payee"));
        }
        qFilter.and("dpcurrency", "=", customParams.get("currencyid"));
        qFilter.and("totalremainrefundamt", "!=", (Object)BigDecimal.ZERO);
    }

    public static void setExtQueryFieldInfo(Map<String, Object> map, Map<String, String> extQueryFieldMap, DynamicObject info, boolean isHead) {
        try {
            if (extQueryFieldMap != null && extQueryFieldMap.size() > 0) {
                for (Map.Entry<String, String> entry : extQueryFieldMap.entrySet()) {
                    String entryKey = entry.getKey();
                    if (entryKey.contains(".")) {
                        String[] split = entryKey.split("\\.");
                        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_paybill");
                        DataEntityPropertyCollection propertyColl = type.getProperties();
                        IDataEntityProperty property = (IDataEntityProperty)propertyColl.get((Object)split[0]);
                        if ((isHead || !(property instanceof EntryProp)) && (!isHead || !(property instanceof BasedataProp))) continue;
                        map.put(entry.getValue(), info.get(entryKey));
                        continue;
                    }
                    map.put(entry.getValue(), info.get(entryKey));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("setExtQueryFieldInfo error", (Throwable)e);
        }
    }
}

