/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.ClosePeriodUtils;
import kd.fi.cas.util.StringUtils;

public class GLBusinessHelper {
    private static final Log logger = LogFactory.getLog(GLBusinessHelper.class);

    public static boolean isCheckWithGl(Long orgId) {
        return SystemParameterHelper.getParameterBoolean(orgId, "cs091");
    }

    public static boolean needCheckWithGL(long orgId) {
        List<CheckItemDetail> checkItems = ClosePeriodUtils.getCheckItemList(orgId, true);
        return !checkItems.isEmpty() && checkItems.stream().anyMatch(v -> "4.2-CheckWithGLChecker".equals(v.getNumber()));
    }

    public static void checkAndShowWithGL(IFormView view, Long orgId, Long periodId, Boolean isInit) {
        String openParam = null;
        try {
            openParam = GLBusinessHelper.invokeGLMethord(orgId, periodId, isInit);
        }
        catch (KDBizException e2) {
            if (e2.getErrorCode().getCode().equals("2")) {
                if (e2.getArgs().length > 0) {
                    openParam = e2.getArgs()[0].toString();
                }
            }
            throw e2;
        }
        logger.info("openParam:" + JSON.toJSONString((Object)openParam));
        if (StringUtils.isEmpty(openParam)) {
            throw new KDBizException(new ErrorCode("2", ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u627e\u4e0d\u5230\u5bf9\u8d26\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5bf9\u8d26\u76f8\u5173\u4fe1\u606f\u3002", (String)"GLBusinessHelper_1", (String)"fi-cas-common", (Object[])new Object[0])), new Object[0]);
        }
        FormShowParameter parame = new FormShowParameter();
        parame.setFormId("ai_reconciliation_rst_fst");
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parame.setCustomParam("model", (Object)openParam);
        view.showForm(parame);
    }

    public static String checkWithGL(Long orgId, Long periodId, Boolean isInit) {
        try {
            String invokeGLMethord = GLBusinessHelper.invokeGLMethord(orgId, periodId, isInit);
            logger.info("gl result:" + invokeGLMethord);
            return invokeGLMethord;
        }
        catch (KDBizException e) {
            if (e.getErrorCode().getCode().equals("2")) {
                String msg = ResManager.loadKDString((String)"\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u8bf7\u8c03\u6574\u51fa\u7eb3\u521d\u59cb\u6570\u636e\u3002", (String)"GLBusinessHelper_0", (String)"fi-cas-common", (Object[])new Object[0]);
                if (!isInit.booleanValue()) {
                    msg = ResManager.loadKDString((String)"\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8d26\u3002", (String)"GLBusinessHelper_2", (String)"fi-cas-common", (Object[])new Object[0]);
                }
                throw new KDBizException(new ErrorCode("2", msg), new Object[0]);
            }
            throw e;
        }
    }

    public static List<String> getCheckWithGL(Long orgId, Long periodId, Boolean isInit) {
        ArrayList<String> messages;
        block3: {
            messages = new ArrayList<String>(2);
            try {
                String invokeGLMethord = GLBusinessHelper.invokeGLMethord(orgId, periodId, isInit);
                logger.info("gl result:" + invokeGLMethord);
            }
            catch (KDBizException e) {
                if (!e.getErrorCode().getCode().equals("2")) break block3;
                String msg = ResManager.loadKDString((String)"\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u8bf7\u8c03\u6574\u51fa\u7eb3\u521d\u59cb\u6570\u636e\u3002", (String)"GLBusinessHelper_0", (String)"fi-cas-common", (Object[])new Object[0]);
                if (!isInit.booleanValue()) {
                    msg = ResManager.loadKDString((String)"\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8d26\u3002", (String)"GLBusinessHelper_2", (String)"fi-cas-common", (Object[])new Object[0]);
                }
                messages.add(msg);
                logger.info("\u4e0e\u603b\u8d26\u5bf9\u8d26\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)msg);
            }
        }
        return messages;
    }

    private static String invokeGLMethord(Long orgId, Long periodId, Boolean isInit) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("init", isInit);
        param.put("appNumber", "cas");
        param.put("orgId", orgId);
        param.put("periodId", periodId);
        logger.info("glparam:" + JSON.toJSONString(param));
        return (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{JSONObject.toJSONString(param)});
    }
}

