/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LoggerPrintHelper {
    private static Log logger = LogFactory.getLog(LoggerPrintHelper.class);

    public static <T> String printCollectionLogger(Collection<T> collection) {
        String loggerStr = "";
        try {
            loggerStr = Optional.ofNullable(collection).map(o -> JSON.toJSONString((Object)o, (SerializerFeature[])LoggerPrintHelper.getSerializeFeature())).orElseGet(() -> "");
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the collection: ", (Throwable)e);
        }
        return loggerStr;
    }

    public static <T> String printObjectLoggerByJSON(T ... objs) {
        String loggerStr = "";
        try {
            List objects = Arrays.stream(objs).filter(Objects::nonNull).collect(Collectors.toList());
            loggerStr = LoggerPrintHelper.printObjectLoggerByJSON(objects);
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the custom object: ", (Throwable)e);
        }
        return loggerStr;
    }

    public static <T> String printObjectLoggerByJSON(Collection<T> objects) {
        String loggerStr = "";
        try {
            objects = objects.stream().filter(Objects::nonNull).collect(Collectors.toList());
            loggerStr = JSON.toJSONString((Object)objects, (SerializerFeature[])LoggerPrintHelper.getSerializeFeature());
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the custom object: ", (Throwable)e);
        }
        return loggerStr;
    }

    private static SerializerFeature[] getSerializeFeature() {
        return new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName, SerializerFeature.WriteMapNullValue};
    }
}

