/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.StringUtils;

public class ManualJournalHelper {
    private static Log log = LogFactory.getLog(ManualJournalHelper.class);
    public static final String MANUAL_ENTRY = "manualentry";
    public static final String ORG_ID = "orgid";
    public static final String DEBIT = "debit";
    public static final String CREDIT = "credit";
    public static final String X_SUM = "sum";
    public static final String X_CURRENCY = "currency";
    public static final String X_CURRENCY_SUM = "currencysum";
    public static final String PERIOD_TYPE = "periodtype";
    public static final String DEBIT_SUM = "debitsum";
    public static final String DEBIT_CURRENCY = "debitcurrency";
    public static final String DEBIT_CURRENCY_SUM = "debitcurrencysum";
    public static final String CREDIT_SUM = "creditsum";
    public static final String CREDIT_CURRENCY = "creditcurrency";
    public static final String CREDIT_CURRENCY_SUM = "creditcurrencysum";
    public static final String BILL_ID = "billid";
    public static final String BILL_NO = "billno";
    public static final String FOUND_ENTRY = "entry";
    public static final String ISCHECK = "ischeck";
    public static final String MANUAL_ENTRY_FOUND = "fundflowitem";
    public static final String FOUNE_USE = "e_fundflowitem";
    public static final String FOUND_AMOUNT = "e_amount";
    public static final String FOUND_LOACLAMOUNT = "e_localamount";
    public static final String FOUND_OPPUNIT = "e_oppunit";
    public static final String FOUND_ORG = "e_org";
    public static final String FOUND_CURRENCY = "e_currency";
    public static final String FOUND_BANK = "e_accountbank";
    public static final String FOUND_CASH = "e_accountcash";
    public static final String SELECTROWKEY = "ManualJournalSelectRow";
    public static final String HEAD_BATCHNO = "batchno";
    public static final double MAX_VAL = 1.0E13;
    public static final String FILTERS_CAHE_ORGS_KEY = "filtersCacheOrgsKey";
    public static final String FILTERS_CAHE_CONTAIN_KEY = "filtersCacheCONTAINKey";
    public static final Integer MANUAL_SOURCE_ID = 1;

    public static DynamicObjectCollection getWholeBillBy(String entity, List<Map> rows) {
        HashSet<Date> createTimes = new HashSet<Date>();
        HashSet<String> batchNos = new HashSet<String>();
        ArrayList rowIds = new ArrayList(rows.size());
        for (Map row : rows) {
            rowIds.add(row.get("sourcebillnumber"));
        }
        QFilter filter = new QFilter("sourcebillnumber", "in", rowIds);
        DynamicObjectCollection dbRows = QueryServiceHelper.query((String)entity, (String)"id,createtime,batchno", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dbRow : dbRows) {
            if (dbRow.getDate("createtime") != null) {
                createTimes.add(dbRow.getDate("createtime"));
            }
            if (!StringUtils.isNotEmpty(dbRow.getString(HEAD_BATCHNO))) continue;
            batchNos.add(dbRow.getString(HEAD_BATCHNO));
        }
        QFilter timefilter = new QFilter("createtime", "in", createTimes);
        QFilter batchNoFilter = new QFilter(HEAD_BATCHNO, "in", batchNos);
        QFilter sourceFilter = new QFilter("source", "in", (Object)new String[]{"1", "3"});
        String fields = "id,billno,billstatus,sourcebillnumber";
        if ("cas_bankjournal".equals(entity)) {
            fields = "id,billno,billstatus,sourcebillnumber,ischeck";
        }
        return QueryServiceHelper.query((String)entity, (String)fields, (QFilter[])new QFilter[]{timefilter, sourceFilter, batchNoFilter});
    }

    public static void deleteManualJournalData(IPageCache pageCache, IReportView reportView, String entity) {
        List delRowList = null;
        String cache = pageCache.get(SELECTROWKEY);
        if (cache != null) {
            delRowList = (List)SerializationUtils.fromJsonString((String)cache, List.class);
        }
        if (delRowList == null) {
            return;
        }
        StringBuilder opSB = new StringBuilder();
        ArrayList<Long> delIdList = new ArrayList<Long>();
        DynamicObjectCollection wholeList = ManualJournalHelper.getWholeBillBy(entity, delRowList);
        if (wholeList == null || wholeList.isEmpty()) {
            reportView.showTipNotification(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u5f55\u5165\u5355\u636e\u4e0d\u80fd\u5220\u9664\u3002", (String)"ManualJournalHelper_1", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject bill : wholeList) {
            if (!"A".equals(bill.getString("billstatus"))) {
                opSB.append(bill.getString(BILL_NO)).append(' ');
                continue;
            }
            if ("cas_bankjournal".equals(entity) && bill.getBoolean(ISCHECK)) {
                reportView.showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5b58\u5728\u5df2\u52fe\u5bf9\u7684\u8bb0\u5f55\u3002", (String)"ManualJournalHelper_11", (String)"fi-cas-common", (Object[])new Object[0]));
                return;
            }
            delIdList.add(bill.getLong("id"));
        }
        if (!delIdList.isEmpty()) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
            if ("cas_bankjournal".equals(entity)) {
                CasBankJournalHelper.deleteBalance(BusinessDataServiceHelper.load((Object[])delIdList.toArray(new Object[0]), (DynamicObjectType)type));
            }
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])delIdList.toArray(new Object[0]));
        }
        ManualJournalHelper.showOpTipsBy(entity, reportView, ResManager.loadKDString((String)"\u5220\u9664", (String)"ManualJournalHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), opSB, ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u3002", (String)"ManualJournalHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), delRowList, delIdList);
        reportView.refresh();
    }

    private static void showOpTipsBy(String entity, IReportView reportView, String opName, StringBuilder opSB, String opFailMsg, List<Map> selectRowList, List<Long> delList) {
        if (selectRowList == null || selectRowList.isEmpty()) {
            return;
        }
        if (delList.isEmpty() && opSB.length() == 0) {
            reportView.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ManualJournalHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        StringBuilder successSB = new StringBuilder();
        StringBuilder unManualSB = new StringBuilder();
        for (Map select : selectRowList) {
            Long billId = select.get("id") instanceof Long ? (Long)select.get("id") : 0L;
            if (billId == 0L) continue;
            String billNo = (String)select.get("sourcebillnumber");
            if (ManualJournalHelper.isMaunalBillData(entity, billId)) {
                unManualSB.append(billNo).append(' ');
                continue;
            }
            if (!delList.isEmpty() && !delList.contains(billId)) {
                opSB.append(billNo).append(' ');
                continue;
            }
            successSB.append(billNo).append(' ');
        }
        if (unManualSB.length() > 0) {
            unManualSB.append(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u8bb0\u8d26\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"ManualJournalHelper_5", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        if (opSB.length() > 0) {
            String obstring = opSB.toString();
            unManualSB.append(obstring);
            unManualSB.append(opFailMsg);
        }
        if (successSB.length() < 1) {
            return;
        }
        if (unManualSB.length() == 0 && opSB.length() == 0) {
            reportView.showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"ManualJournalHelper_0", (String)"fi-cas-common", (Object[])new Object[0]), opName));
        } else {
            reportView.showTipNotification(unManualSB.toString());
        }
    }

    public static boolean isMaunalBillData(String entity, Object billId) {
        if (billId == null) {
            return false;
        }
        QFilter filter = new QFilter("id", "=", billId);
        QFilter sourceFilter = new QFilter("source", "=", (Object)MANUAL_SOURCE_ID);
        return QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{filter, sourceFilter});
    }

    public static boolean isManualJournalMode(RowClickEvent evt) {
        try {
            IDataModel model = ((ReportList)evt.getSource()).getModel();
            if (model != null && model.getValue("org") instanceof DynamicObjectCollection) {
                return ManualJournalHelper.isManualJournalMode((DynamicObjectCollection)model.getValue("org"));
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u624b\u5de5\u65e5\u8bb0\u8d26\u6a21\u5f0f\u6709\u8bef\uff01", (Throwable)e);
            return false;
        }
    }

    public static boolean isManualJournalMode(DynamicObjectCollection orgs) {
        if (orgs == null || orgs.isEmpty()) {
            return false;
        }
        try {
            for (DynamicObject org : orgs) {
                DynamicObject currOrg = (DynamicObject)org.get(1);
                if (currOrg == null) continue;
                long orgId = currOrg.getLong("id");
                if (SystemParameterHelper.isManualJournal(orgId)) {
                    return true;
                }
                if (!SystemParameterHelper.isVoucherMixBookJournal(orgId) && !SystemParameterHelper.isTradeMixHandJournal(orgId)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u624b\u5de5\u65e5\u8bb0\u8d26\u6a21\u5f0f\u6709\u8bef\uff01", (Throwable)e);
            return false;
        }
    }

    public static boolean isTradeManualJournalMode(DynamicObjectCollection orgs, IReportView view) {
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        String appId = view.getFormShowParameter().getAppId();
        log.info(String.format("ManualJournalHelper::isTradeManualJournalMode::to query with material, userId:%s, appId:%s", userID, appId));
        Set<Long> authorizedBankOrg = OrgHelper.getAuthBankOrgIds(userID, appId, "cas_bankjournalformrpt", "4730fc9f000007ae");
        if (authorizedBankOrg.size() == 0) {
            return false;
        }
        Boolean result = ManualJournalHelper.isTradeManualJournalMode(orgs);
        log.info(String.format("result the operating :%s", result));
        return result;
    }

    public static boolean isTradeManualJournalMode(DynamicObjectCollection orgs) {
        if (orgs == null || orgs.isEmpty()) {
            return false;
        }
        try {
            for (DynamicObject org : orgs) {
                long orgId;
                DynamicObject currOrg = (DynamicObject)org.get(1);
                if (currOrg == null || !SystemParameterHelper.isTradeMixHandJournal(orgId = currOrg.getLong("id"))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u4ea4\u6613\u660e\u7ec6+\u624b\u5de5\u65e5\u8bb0\u8d26\u6a21\u5f0f\u6709\u8bef\uff01", (Throwable)e);
            return false;
        }
    }

    public static List<Object> getAllInitOrgAcctId() {
        DynamicObjectCollection initOrgs = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org", null);
        if (initOrgs == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject initOrg : initOrgs) {
            Long org = initOrg.getLong("org");
            if (org == 0L) continue;
            list.add(org);
        }
        return list;
    }

    public static String checkDate(Date bizDate, Date bookDate) {
        if (bizDate == null) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ManualJournalHelper_7", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        if (bookDate == null) {
            return ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ManualJournalHelper_8", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        if (bizDate.compareTo(bookDate) > 0 || bookDate.compareTo(bizDate) < 0) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u8bb0\u8d26\u65e5\u671f\u3002", (String)"ManualJournalHelper_9", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static int checkAmount(BigDecimal debit, BigDecimal credit) {
        debit = debit == null ? BigDecimal.ZERO : debit;
        BigDecimal bigDecimal = credit = credit == null ? BigDecimal.ZERO : credit;
        if (debit.compareTo(BigDecimal.ZERO) == 0 && credit.compareTo(BigDecimal.ZERO) == 0) {
            return -1;
        }
        if (debit.compareTo(BigDecimal.ZERO) > 0 && credit.compareTo(BigDecimal.ZERO) > 0) {
            return -2;
        }
        return 0;
    }

    public static long getPeriodIdByDate(Date date, long ptId) {
        if (date == null) {
            date = TimeServiceHelper.now();
        }
        QFilter qfBeginDate = new QFilter("beginDate", "<=", (Object)date);
        QFilter qfEndDate = new QFilter("enddate", ">=", (Object)date);
        QFilter qfType = new QFilter(PERIOD_TYPE, "=", (Object)ptId);
        DynamicObject object = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{qfBeginDate, qfEndDate, qfType});
        return object != null ? object.getLong("id") : 0L;
    }

    public static DynamicObject getPeriodByDate(Date date, long ptId) {
        if (date == null) {
            date = TimeServiceHelper.now();
        }
        QFilter qfBeginDate = new QFilter("beginDate", "<=", (Object)date);
        QFilter qfEndDate = new QFilter("enddate", ">=", (Object)date);
        QFilter qfType = new QFilter(PERIOD_TYPE, "=", (Object)ptId);
        DynamicObject object = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, periodyear, periodnumber", (QFilter[])new QFilter[]{qfBeginDate, qfEndDate, qfType});
        return object;
    }
}

