/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OperateServiceHelper
extends OperationServiceHelper {
    private static Log log = LogFactory.getLog(OperateServiceHelper.class);

    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option, boolean RequireNew) {
        if (RequireNew) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = OperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option);
                return operationResult;
            }
        }
        return OperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option);
    }

    public static OperationResult execOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option, boolean RequireNew) {
        if (RequireNew) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = OperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
                return operationResult;
            }
        }
        return OperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
    }

    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }

    public static OperationResult execOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }

    public static OperationResult execOperateWithoutThrow(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        return operationResult;
    }

    public static OperationResult execOperateWithoutThrow(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = OperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        return operationResult;
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = OperateServiceHelper.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append('\n');
        }
        return buf.toString();
    }

    public static Map<Long, String> decodeErrorMessage(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        HashMap<Long, String> errMsg = new HashMap<Long, String>(size);
        if (size > 1) {
            errMsg.putAll(OperateServiceHelper.decodeMultiErrorMessage(operationResult));
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            String err = errorInfo.getMessage();
            errMsg.put((Long)errorInfo.getPkValue(), err);
        } else {
            String err = operationResult.getMessage();
            errMsg.put(-999L, err);
        }
        return errMsg;
    }

    public static Map<Long, String> decodeMultiErrorMessage(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int len = errorInfos.size();
        HashMap<Long, String> result = new HashMap<Long, String>(len);
        for (int i = 0; i < len; ++i) {
            IOperateInfo iOperateInfo = (IOperateInfo)errorInfos.get(i);
            String message = iOperateInfo.getMessage();
            Long pkValue = (Long)iOperateInfo.getPkValue();
            result.put(pkValue, message);
        }
        return result;
    }
}

