/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class OrgHelper {
    private static final Log logger = LogFactory.getLog(OrgHelper.class);
    public static final String ORGTYPE_ACCOUNTING = "fisaccounting";
    public static final String ORGTYPE_SETTLEMENT = "fissettlement";
    public static final String ORGTYPE_BANKROLL = "fisbankroll";
    public static final String NO_LEGAL_PERSON = "3";

    public static DynamicObject getAccountOrgByFundsOrg(DynamicObject fundsOrg) {
        if (null == fundsOrg) {
            return null;
        }
        DynamicObject accountOrg = null;
        boolean isAccount = fundsOrg.getBoolean(ORGTYPE_ACCOUNTING);
        if (isAccount) {
            DynamicObject tempSuperOrg;
            DynamicObject superOrg = fundsOrg;
            do {
                boolean isLegalPerson = false;
                DynamicObject orgpattern = superOrg.getDynamicObject("orgpattern");
                if (orgpattern != null) {
                    boolean bl = isLegalPerson = !NO_LEGAL_PERSON.equals((orgpattern = BusinessDataServiceHelper.loadSingle((Object)orgpattern.getPkValue(), (String)"bos_org_pattern", (String)"id, patterntype")).getString("patterntype"));
                }
                if (!isLegalPerson) continue;
                accountOrg = superOrg;
                break;
            } while (((tempSuperOrg = OrgHelper.getSuperiorBankOrg("10", superOrg.getLong("id"))) == null || tempSuperOrg.getLong("id") != fundsOrg.getLong("id")) && (superOrg = tempSuperOrg) != null);
        } else {
            try {
                Long orgid = OrgServiceHelper.getToOrg((String)ORGTYPE_BANKROLL, (String)ORGTYPE_ACCOUNTING, (Long)fundsOrg.getLong("id"), (Long)0L);
                accountOrg = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        }
        return accountOrg;
    }

    public static DynamicObject getSuperiorBankOrg(String attributes, long orgId) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)attributes, (long)orgId);
        if (superiorOrgs == null || superiorOrgs.size() < 1) {
            return null;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id, orgpattern", (QFilter[])new QFilter[]{new QFilter("id", "in", superiorOrgs.get(0))});
        return org;
    }

    public static Set<Long> getAuthBankOrgIds(Long userID, String appId, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg_Id(userID, appId, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static Set<Long> getAuthAcctOrgIds(Long userID, String appId, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg_Id(userID, appId, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    private static Set<Long> getAuthorizedOrg_Id(Long userID, String appId, String entityID, String permissionItem, String funType) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter functionFilter = new QFilter(funType, "=", (Object)"1");
        if (allPermOrgs.hasAllOrgPerm()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    orgIds.add(row.getLong("id"));
                }
            }
        }
        List orgIdList = allPermOrgs.getHasPermOrgs();
        QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                orgIds.add(row.getLong("id"));
            }
        }
        return orgIds;
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String appId, String entityID, String permissionItem, String funType) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter functionFilter = new QFilter(funType, "=", (Object)"1");
        Map orgs = new HashMap();
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedBankOrgId(userID, AppMetadataCache.getAppInfo((String)"cas").getId(), entityID, permissionItem);
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String appid, String entityID, String permissionItem) {
        return new ArrayList<Long>(OrgHelper.getAuthorizedOrg_Id(userID, appid, entityID, permissionItem, ORGTYPE_BANKROLL));
    }

    public static List<Long> getInitCasOrgIds(String entityId, List<Long> orgIds) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityId, (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("isfinishinit", "=", (Object)true)}, (String)"org");
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (DynamicObject org : coll) {
            Long orgId = org.getLong("id");
            idList.add(orgId);
        }
        return idList;
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static DynamicObject getOrgById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_org");
    }

    public static DynamicObject getBaseCurrency(long orgId) {
        try {
            return SystemStatusCtrolHelper.getStandardCurrency(orgId);
        }
        catch (KDBizException e) {
            return null;
        }
    }

    public static DynamicObject getCurrentPermOrg(String appId, String permissionEntity, String permissionItem) throws KDBizException {
        DynamicObject currentOrg;
        long userPK = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        if (PermissionHelper.checkCurrentUserPermission(appId, orgId, permissionEntity, permissionItem) && (currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org")).getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg;
        }
        Set<Long> orgIds = OrgHelper.getAuthBankOrgIds(userPK, appId, permissionEntity, permissionItem);
        if (orgIds.size() > 0) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)orgIds.toArray()[0], (String)"bos_org");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"TmcErrorCode_7", (String)"fi-cas-common", (Object[])new Object[0]));
    }
}

