/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayBillCrossHelper {
    public static boolean isIfmAcc(DynamicObject data) {
        DynamicObject payerBankObj = (DynamicObject)data.get("payeracctbank");
        if (EmptyUtil.isEmpty(payerBankObj)) {
            return false;
        }
        return PayBillCrossHelper.isIfmAccId(payerBankObj.getPkValue());
    }

    public static Map<Long, Boolean> batchIsIfmAcc(List<DynamicObject> data, String accStr) {
        HashMap<Long, Boolean> returnData = new HashMap<Long, Boolean>(2);
        HashMap<Long, Object> idToBankId = new HashMap<Long, Object>(2);
        HashMap<Long, Boolean> bankIdToIsInnerAcc = new HashMap<Long, Boolean>(2);
        HashSet<Object> bankIds = new HashSet<Object>(2);
        for (DynamicObject dynamicObject : data) {
            if ("payeracctbank".equals(accStr)) {
                DynamicObject payerBankObj = (DynamicObject)dynamicObject.get("payeracctbank");
                if (EmptyUtil.isEmpty(payerBankObj)) {
                    returnData.put(dynamicObject.getLong("id"), Boolean.FALSE);
                    continue;
                }
                bankIds.add(payerBankObj.getPkValue());
                idToBankId.put(dynamicObject.getLong("id"), payerBankObj.getPkValue());
                continue;
            }
            if (!"payeeacctbank".equals(accStr)) continue;
            Long payeeBankid = dynamicObject.getLong("payeeacctbank");
            if (payeeBankid == 0L) {
                returnData.put(dynamicObject.getLong("id"), Boolean.FALSE);
            }
            bankIds.add(payeeBankid);
            idToBankId.put(dynamicObject.getLong("id"), payeeBankid);
        }
        QFilter qFilterId = new QFilter("id", "in", bankIds);
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,inneracct", (QFilter[])new QFilter[]{qFilterId});
        for (DynamicObject accountBank : accountBanks) {
            DynamicObject innerAcct = accountBank.getDynamicObject("inneracct");
            if (!EmptyUtil.isEmpty(innerAcct)) {
                bankIdToIsInnerAcc.put(accountBank.getLong("id"), Boolean.TRUE);
                continue;
            }
            bankIdToIsInnerAcc.put(accountBank.getLong("id"), Boolean.FALSE);
        }
        for (Map.Entry entry : idToBankId.entrySet()) {
            if (bankIdToIsInnerAcc.get(entry.getValue()) != null) {
                returnData.put((Long)entry.getKey(), (Boolean)bankIdToIsInnerAcc.get(entry.getValue()));
                continue;
            }
            returnData.put((Long)entry.getKey(), Boolean.FALSE);
        }
        return returnData;
    }

    public static boolean isInnerAcct(Object acctId) {
        return PayBillCrossHelper.isIfmAccId(acctId);
    }

    public static boolean isIfmBankAcc(DynamicObject bankAcc) {
        if (EmptyUtil.isEmpty(bankAcc)) {
            return false;
        }
        return PayBillCrossHelper.isIfmAccId(bankAcc.getPkValue());
    }

    private static boolean isIfmAccId(Object acctId) {
        DynamicObject inneracct;
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", acctId)};
        DynamicObject accts = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"inneracct", (QFilter[])filters);
        return !EmptyUtil.isEmpty(accts) && !EmptyUtil.isEmpty(inneracct = accts.getDynamicObject("inneracct"));
    }

    public static Map<Long, Long> batchGetSettleCenterOrgIdByBankAcct(Collection<Long> accountIds) {
        HashMap<Long, Long> accIdToOrgId = new HashMap<Long, Long>(2);
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", accountIds)};
        DynamicObject[] accts = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id,inneracct,scorg", (QFilter[])filter);
        Map<Long, Object> idToInnerAccId = Arrays.stream(accts).filter(o -> o.getDynamicObject("inneracct") != null).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getDynamicObject("inneracct").getPkValue()));
        QFilter qFilterInnerAccIds = new QFilter("id", "in", idToInnerAccId.values());
        DynamicObject[] innerAccs = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id,org", (QFilter[])new QFilter[]{qFilterInnerAccIds});
        Map innerIdToInnerAcct = Arrays.stream(innerAccs).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (DynamicObject acct : accts) {
            Long orgId = 0L;
            if (!EmptyUtil.isEmpty(acct)) {
                DynamicObject innerAcct;
                DynamicObject org = acct.getDynamicObject("scorg");
                if (!EmptyUtil.isEmpty(org)) {
                    orgId = org.getLong("id");
                }
                if (orgId.compareTo(0L) == 0 && (innerAcct = acct.getDynamicObject("inneracct")) != null) {
                    DynamicObject innerDt = (DynamicObject)innerIdToInnerAcct.get(idToInnerAccId.get(acct.getLong("id")));
                    DynamicObject orgDt = (DynamicObject)innerDt.get("org");
                    orgId = (Long)orgDt.getPkValue();
                }
            }
            accIdToOrgId.put(acct.getLong("id"), orgId);
        }
        return accIdToOrgId;
    }

    public static Set<Long> getIfmAccIds(Set<Long> accIds) {
        if (EmptyUtil.isEmpty(accIds)) {
            return new HashSet<Long>(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", accIds), new QFilter("inneracct", "is not null", null), new QFilter("inneracct.id", "!=", (Object)0L)};
        DynamicObjectCollection ifmAccounts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])filters);
        if (EmptyUtil.isEmpty(ifmAccounts)) {
            return new HashSet<Long>(0);
        }
        return ifmAccounts.parallelStream().map(d -> d.getLong("id")).collect(Collectors.toSet());
    }
}

