/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SettleRecordQueryHelperForCas {
    public static boolean isExistsSettlesByMain(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        QFilter filter = new QFilter("mainbillid", "in", (Object)ids);
        filter.and(otherFilter);
        DynamicObject[] settleBills = SettleRecordQueryHelperForCas.getSettleRecords(settleRecordEntity, "id", entityKey, ids, filter);
        return settleBills.length > 0;
    }

    public static boolean isExistsSettlesByAsst(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        QFilter filter = new QFilter("entry.billid", "in", (Object)ids);
        filter.and(otherFilter);
        DynamicObject[] settleBills = SettleRecordQueryHelperForCas.getSettleRecords(settleRecordEntity, "id", entityKey, ids, filter);
        return settleBills.length > 0;
    }

    public static Set<Long> getSettleIdsByMain(String settleRecordEntity, String entityKey, Object[] ids) {
        return SettleRecordQueryHelperForCas.getSettleIdsByMain(settleRecordEntity, entityKey, ids, null);
    }

    public static Set<Long> getSettleIdsByAsst(String settleRecordEntity, String entityKey, Object[] ids) {
        return SettleRecordQueryHelperForCas.getSettleIdsByAsst(settleRecordEntity, entityKey, ids, null, "id");
    }

    public static Set<Long> getSettleIdsByMain(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        return SettleRecordQueryHelperForCas.getSettleIdsByMain(settleRecordEntity, entityKey, ids, otherFilter, "id");
    }

    public static Set<Long> getSettleIdsByMain(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter, String appointField) {
        QFilter filter = new QFilter("mainbillid", "in", (Object)ids);
        if (otherFilter != null) {
            filter.and(otherFilter);
        }
        DynamicObject[] settleBills = SettleRecordQueryHelperForCas.getSettleRecords(settleRecordEntity, appointField, entityKey, ids, filter);
        return Arrays.stream(settleBills).map(bill -> bill.getLong(appointField)).collect(Collectors.toSet());
    }

    public static Set<Long> getSettleIdsByAsst(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        return SettleRecordQueryHelperForCas.getSettleIdsByAsst(settleRecordEntity, entityKey, ids, otherFilter, "id");
    }

    public static Set<Long> getSettleIdsByAsst(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter, String appointField) {
        QFilter filter = new QFilter("entry.billid", "in", (Object)ids);
        if (otherFilter != null) {
            filter.and(otherFilter);
        }
        DynamicObject[] settleBills = SettleRecordQueryHelperForCas.getSettleRecords(settleRecordEntity, appointField, entityKey, ids, filter);
        return Arrays.stream(settleBills).map(bill -> bill.getLong(appointField)).collect(Collectors.toSet());
    }

    public static DynamicObject[] getSettleRecords(String settleRecordEntity, String selector, String entityKey, Object[] ids, QFilter filter) {
        boolean isSharding = ShardingHinter.isSharding((String)"t_ap_settlerecord");
        if (isSharding && !StringUtils.isEmpty((CharSequence)entityKey)) {
            String selectFields = null;
            selectFields = "cas_recbill".equals(entityKey) ? "entry.e_settleorg orgId" : ("cas_paybill".equals(entityKey) ? "entry.settleorg orgId" : "org orgId");
            DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"ArApXDBHelperGetSettlesOrg", (String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);
            HashSet<Long> orgIds = new HashSet<Long>(8);
            for (Row row : billDataSet) {
                orgIds.add(row.getLong("orgId"));
            }
            if (orgIds.size() > 0) {
                QFilter orgFilter = new QFilter("org", "in", orgIds);
                filter.and(orgFilter);
            }
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)settleRecordEntity, (String)selector, (QFilter[])filter.toArray());
        return bills;
    }

    public static List<Long> getBillIdsByMain(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        QFilter filter = new QFilter("mainbillid", "in", (Object)ids);
        filter.and(otherFilter);
        DynamicObject[] settleBills = SettleRecordQueryHelperForCas.getSettleRecords(settleRecordEntity, "mainbillid", entityKey, ids, filter);
        List<Long> mainBillIds = Arrays.stream(settleBills).map(bill -> bill.getLong("mainbillid")).collect(Collectors.toList());
        return mainBillIds;
    }

    public static List<Long> getBillIdsByAsst(String settleRecordEntity, String entityKey, Object[] ids, QFilter otherFilter) {
        QFilter filter = new QFilter("entry.billid", "in", (Object)ids);
        filter.and(otherFilter);
        DynamicObject[] settleBills = SettleRecordQueryHelperForCas.getSettleRecords(settleRecordEntity, "entry.billid", entityKey, ids, filter);
        ArrayList<Long> asstBillIds = new ArrayList<Long>(10);
        if (settleBills != null && settleBills.length > 0) {
            for (DynamicObject record : settleBills) {
                DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    asstBillIds.add(row.getLong("billid"));
                }
            }
        }
        return asstBillIds;
    }
}

