/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper.ebext;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasAttachmentHelper {
    public static List<DynamicObject> attachmentPanelToAttachmentField(List<Map<String, Object>> attachments) {
        if (EmptyUtil.isEmpty(attachments)) {
            return null;
        }
        ArrayList<DynamicObject> attachmentList = new ArrayList<DynamicObject>(10);
        for (Map<String, Object> attachment : attachments) {
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            attObj.set("name", attachment.get("name"));
            attObj.set("size", attachment.get("size"));
            attObj.set("uid", (Object)CasAttachmentHelper.getUid());
            String url = (String)attachment.getOrDefault("url", "");
            url = url.indexOf("&") > 0 ? url.substring(0, url.indexOf("&")) : url;
            url = url.indexOf("path=") > 0 ? url.substring(url.indexOf("path=") + 6) : url;
            attObj.set("url", (Object)url);
            attObj.set("type", attachment.get("type"));
            attObj.set("description", attachment.get("description"));
            attObj.set("tempfile", (Object)1);
            attObj.set("pageid", (Object)"");
            attObj.set("number", (Object)UUID.randomUUID().toString().replaceAll("-", ""));
            attObj.set("status", (Object)"B");
            long currTime = new Date().getTime();
            attObj.set("createtime", (Object)currTime);
            attObj.set("modifytime", (Object)currTime);
            attObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            attachmentList.add(attObj);
        }
        return attachmentList;
    }

    public static String getUid() {
        StringBuilder uid = new StringBuilder("rc-upload-");
        uid.append(new Date().getTime());
        uid.append("-");
        SecureRandom random = new SecureRandom();
        int index = (int)(random.nextDouble() * 10000.0);
        uid.append(index);
        return uid.toString();
    }
}

