/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.init;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.init.TransDetailsHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankJournalDataDealServiceImpl {
    private static final Log logger = LogFactory.getLog(BankJournalDataDealServiceImpl.class);

    public String ruleDataDeal(List<String> ids) {
        RpcResult recResult = new RpcResult();
        if (EmptyUtil.isNoEmpty(ids)) {
            String idStr = ids.get(0);
            Set idSet = (Set)JSON.parseObject((String)idStr, Set.class);
            try {
                logger.info("BankJournalDataDealServiceImpl: begin");
                Object[] transactionplanDys = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mon_transactionplan"));
                if (EmptyUtil.isNoEmpty(transactionplanDys)) {
                    for (Object transactionplanDy : transactionplanDys) {
                        DynamicObjectCollection coll = transactionplanDy.getDynamicObjectCollection("entryentity");
                        List<Long> Ids = coll.stream().map(v -> v.getLong("e_org.id")).collect(Collectors.toList());
                        ArrayList<QFilter> bankJournalQFilters = new ArrayList<QFilter>(3);
                        ArrayList<QFilter> transDetailQFilters = new ArrayList<QFilter>(3);
                        QFilter fOrg = new QFilter("org", "in", Ids);
                        QFilter fValidDate = new QFilter("bookdate", ">=", (Object)transactionplanDy.getDate("validdate"));
                        bankJournalQFilters.add(fOrg);
                        bankJournalQFilters.add(fValidDate);
                        boolean statsInnerAcct = transactionplanDy.getBoolean("statsinneracct");
                        if (!statsInnerAcct) {
                            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
                            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{acctFilter});
                            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                            QFilter innerAcctFilter = new QFilter("accountbank", "in", acctIds);
                            bankJournalQFilters.add(innerAcctFilter);
                            transDetailQFilters.add(innerAcctFilter);
                        }
                        String dataSource = transactionplanDy.getString("datasource");
                        logger.info("BankJournalDataDealServiceImpl:dataSource: {}", (Object)dataSource);
                        if ("bankjournal".equals(dataSource)) {
                            Object[] journals;
                            if (Ids.size() > 0) {
                                this.executeBankJournal(Ids);
                            }
                            if ((journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id", (QFilter[])bankJournalQFilters.toArray(new QFilter[0]))).length > 0) {
                                Object[] journalIdArr = Arrays.stream(journals).map(DataEntityBase::getPkValue).toArray();
                                journals = BusinessDataServiceHelper.load((Object[])journalIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_bankjournal"));
                            }
                            if (EmptyUtil.isNoEmpty(journals)) {
                                for (int i = 0; i < journals.length; ++i) {
                                    CasBankJournalHelper.getAllMetchResult(i, (DynamicObject[])journals, (DynamicObject)transactionplanDy);
                                }
                                SaveServiceHelper.save((DynamicObject[])journals);
                            }
                        }
                        logger.info("BankJournalDataDealServiceImpl: journals end");
                        if (!"bankbalance".equals(dataSource)) continue;
                        QFilter fCompany = new QFilter("company", "in", Ids);
                        QFilter fBizDate = new QFilter("bizdate", ">=", (Object)transactionplanDy.getDate("validdate"));
                        logger.info("BankJournalDataDealServiceImpl:dataSource: {}, bizdate:{}", (Object)dataSource, (Object)transactionplanDy.getDate("validdate"));
                        transDetailQFilters.add(fCompany);
                        transDetailQFilters.add(fBizDate);
                        Object[] transDetails = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id", (QFilter[])transDetailQFilters.toArray(new QFilter[0]));
                        Object[] transDetailIdArr = Arrays.stream(transDetails).map(DataEntityBase::getPkValue).toArray();
                        if (transDetails.length > 0) {
                            transDetails = BusinessDataServiceHelper.load((Object[])transDetailIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail"));
                        }
                        if (Ids.size() > 0) {
                            this.executeTransaction(Ids);
                        }
                        if (!EmptyUtil.isNoEmpty(transDetails)) continue;
                        ArrayList<DynamicObject> newDyList = new ArrayList<DynamicObject>(10);
                        DynamicObject[] transactionBei = BusinessDataServiceHelper.load((Object[])transDetailIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mon_transaction_bei"));
                        Map<Object, DynamicObject> transDetailMap = Arrays.stream(transactionBei).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
                        for (int i = 0; i < transDetails.length; ++i) {
                            DynamicObject newDy = TransDetailsHelper.getAllMatchResult(i, (DynamicObject[])transDetails, (DynamicObject)transactionplanDy, transDetailMap);
                            if (newDy != null) {
                                newDyList.add(newDy);
                            }
                            if (newDyList.size() <= 999) continue;
                            SaveServiceHelper.save((DynamicObject[])newDyList.toArray(new DynamicObject[0]));
                            newDyList.clear();
                        }
                        if (newDyList.size() <= 0) continue;
                        SaveServiceHelper.save((DynamicObject[])newDyList.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception e2) {
                String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e2);
                recResult.setStatusCode(RpcResultStatusCode.ERROR);
                recResult.setMessage(exception);
                logger.info(exception);
            }
        }
        return JSON.toJSONString((Object)recResult);
    }

    private void executeTransaction(List<Long> Ids) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from t_mon_transaction_bei where", new Object[0]);
        sql.appendIn("forgid", Ids.toArray());
        logger.info("BankJournalDataDealServiceImpl: sql : {}", (Object)sql);
        DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"mon_transaction_bei").getDBRouteKey()), (SqlBuilder)sql);
    }

    private void executeBankJournal(List<Long> Ids) {
        SqlBuilder journalSql = new SqlBuilder();
        journalSql.append("update t_cas_bankjournal_e set fislargeamount = '0',fissensitive='0',fisattention='0',fisdoubt='0' where fid in(", new Object[0]);
        journalSql.append("select fid from t_cas_bankjournal where ", new Object[0]);
        journalSql.appendIn("forgid", Ids.toArray());
        journalSql.append(")", new Object[0]);
        DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (SqlBuilder)journalSql);
    }

    /*
     * Exception decompiling
     */
    public String hisDataDeal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String hisBalanceDeal() {
        RpcResult recResult = new RpcResult();
        try {
            if (QueryServiceHelper.exists((String)"cas_balancetask", (QFilter[])new QFilter[]{new QFilter("taskstatus", "=", (Object)"1")})) {
                recResult.setStatusCode(RpcResultStatusCode.ERROR);
                recResult.setMessage(ResManager.loadKDString((String)"\u542b\u6709\u4f59\u989d\u4efb\u52a1\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BankJournalDataDealServiceImpl_5", (String)"fi-cas-common", (Object[])new Object[0]));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                String startDate = sdf.format(new Date());
                QFilter[] filters = new QFilter[]{new QFilter("id", "not in", (Object)0L)};
                DeleteServiceHelper.delete((String)"cas_balancetask", (QFilter[])filters);
                DeleteServiceHelper.delete((String)"cas_accountbalance", (QFilter[])filters);
                ArrayList<String> fieldKeys = new ArrayList<String>();
                fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys("cas_cashmgtinit", ""));
                Object[] load = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)String.join((CharSequence)",", fieldKeys), (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)});
                if (EmptyUtil.isNoEmpty(load)) {
                    for (Object cashMgtInit : load) {
                        CasBankJournalHelper.initBalanceAccount((DynamicObject)cashMgtInit);
                    }
                }
                recResult.setMessage(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u65e5\u8bb0\u8d26\u8d26\u6237\u4f59\u989d\u5347\u7ea7\u6210\u529f%1$s%2$s", (String)"BankJournalDataDealServiceImpl_6", (String)"fi-cas-common", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\n\u5f00\u59cb\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_3", (String)"fi-cas-common", (Object[])new Object[0]), startDate), String.format(ResManager.loadKDString((String)"\n\u7ed3\u675f\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_4", (String)"fi-cas-common", (Object[])new Object[0]), sdf.format(new Date()))));
            }
        }
        catch (Exception e) {
            String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(exception);
            logger.info(exception);
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String hisAdjustDeal() {
        RpcResult recResult = new RpcResult();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String startDate = sdf.format(new Date());
            QFilter[] filters = new QFilter[]{new QFilter("id", "not in", (Object)0L)};
            Object[] balanceDys = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys("cas_balanceadjust")), (QFilter[])filters);
            if (EmptyUtil.isNoEmpty(balanceDys)) {
                for (Object balanceDy : balanceDys) {
                    BalanceAdjustHelper.setDiffAndBankCg((DynamicObject)balanceDy);
                }
            }
            SaveServiceHelper.save((DynamicObject[])balanceDys);
            recResult.setMessage(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868\u5dee\u5f02\u548c\u94f6\u884c\u7c7b\u522b\u5b57\u6bb5\u5347\u7ea7\u6210\u529f%1$s%2$s", (String)"BankJournalDataDealServiceImpl_7", (String)"fi-cas-common", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\n\u5f00\u59cb\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_3", (String)"fi-cas-common", (Object[])new Object[0]), startDate), String.format(ResManager.loadKDString((String)"\n\u7ed3\u675f\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_4", (String)"fi-cas-common", (Object[])new Object[0]), sdf.format(new Date()))));
        }
        catch (Exception e) {
            String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(exception);
            logger.info(exception);
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String hisRecProductAndSalesMan() {
        RpcResult recResult = new RpcResult();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String startDate = sdf.format(new Date());
            QFilter[] filters = new QFilter[]{new QFilter("id", "not in", (Object)0L)};
            Object[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"hihn_productcode,hihn_salesman,entry.hihn_e_productcode,entry.hihn_e_salesman", (QFilter[])filters);
            if (EmptyUtil.isNoEmpty(recBills)) {
                for (Object recBill : recBills) {
                    DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        if (EmptyUtil.isNoEmpty(recBill.get("hihn_productcode")) && EmptyUtil.isEmpty(entry.get("hihn_e_productcode"))) {
                            entry.set("hihn_e_productcode", recBill.get("hihn_productcode"));
                        }
                        if (!EmptyUtil.isNoEmpty(recBill.get("hihn_salesman")) || !EmptyUtil.isEmpty(entry.get("hihn_e_salesman"))) continue;
                        entry.set("hihn_e_salesman", recBill.get("hihn_salesman"));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])recBills);
            recResult.setMessage(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u4ea7\u54c1\u548c\u533a\u57df\u5347\u7ea7\u5230\u5206\u5f55\u5b57\u6bb5\u6210\u529f%1$s%2$s", (String)"BankJournalDataDealServiceImpl_8", (String)"fi-cas-common", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\n\u5f00\u59cb\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_3", (String)"fi-cas-common", (Object[])new Object[0]), startDate), String.format(ResManager.loadKDString((String)"\n\u7ed3\u675f\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_4", (String)"fi-cas-common", (Object[])new Object[0]), sdf.format(new Date()))));
        }
        catch (Exception e) {
            String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(exception);
            logger.info(exception);
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String hisBalanceAdjustEntry() {
        RpcResult recResult = new RpcResult();
        try {
            Set companyIds;
            List haveCount;
            Set bankIds;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String startDate = sdf.format(new Date());
            List uncompanyIds = (List)DB.query((DBRoute)DBRouteConst.cas, (String)"select fid from t_cas_uncompanydetail", (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet resultSet) throws Exception {
                    ArrayList<String> uncompanyIds = new ArrayList<String>(10);
                    while (resultSet.next()) {
                        uncompanyIds.add(Long.toString(resultSet.getLong(1)));
                    }
                    return uncompanyIds;
                }
            });
            List unbankIds = (List)DB.query((DBRoute)DBRouteConst.cas, (String)"select fid from t_cas_unbankdetail", (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet resultSet) throws Exception {
                    ArrayList<String> unbankIds = new ArrayList<String>(10);
                    while (resultSet.next()) {
                        unbankIds.add(Long.toString(resultSet.getLong(1)));
                    }
                    return unbankIds;
                }
            });
            String whereStr = "0";
            if (!uncompanyIds.isEmpty() || !unbankIds.isEmpty()) {
                uncompanyIds.addAll(unbankIds);
                whereStr = String.join((CharSequence)",", uncompanyIds);
            }
            if (EmptyUtil.isNoEmpty(bankIds = (haveCount = (List)DB.query((DBRoute)DBRouteConst.cas, (String)("select fentryid,fid,fseq,fbillid,fsourcetype,freason from t_cas_unreachdetail where fid not in (" + whereStr + ")"), (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                public List<Object[]> handle(ResultSet resultSet) throws Exception {
                    ArrayList<Object[]> haveCount = new ArrayList<Object[]>(10);
                    while (resultSet.next()) {
                        Object[] result = new Object[]{resultSet.getLong(1), resultSet.getLong(2), resultSet.getLong(3), resultSet.getLong(4), resultSet.getObject(5), resultSet.getObject(6)};
                        haveCount.add(result);
                    }
                    return haveCount;
                }
            })).stream().filter(h -> "cas_bankstatement".equals(h[4])).map(h -> h[3]).collect(Collectors.toSet()))) {
                Object[] journals = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys("cas_bankstatement")), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bankIds.toArray())});
                Map<Object, DynamicObject> journalMap = Stream.of(journals).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy, (m1, m2) -> m1));
                int executeCount = 0;
                if (EmptyUtil.isNoEmpty(journals)) {
                    String insertSql = "insert into t_cas_uncompanydetail (fentryid,fid,fseq,fbillid,fsourcetype,freason,fdescription,fsettletype,fsettlenumber,fbizdate,fdebitamount,fcreditamount,fratesdate,fbankvouvherno,ftradenumber,fsource,fbalanceamt)  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
                    for (Object[] objects : haveCount) {
                        if (!"cas_bankstatement".equals(objects[4])) continue;
                        Object[] params = new Object[17];
                        params[0] = EmptyUtil.isEmpty(objects[0]) ? Long.valueOf(0L) : objects[0];
                        params[1] = EmptyUtil.isEmpty(objects[1]) ? Long.valueOf(0L) : objects[1];
                        params[2] = EmptyUtil.isEmpty(objects[2]) ? Long.valueOf(0L) : objects[2];
                        params[3] = EmptyUtil.isEmpty(objects[3]) ? Long.valueOf(0L) : objects[3];
                        params[4] = EmptyUtil.isEmpty(objects[4]) ? " " : objects[4];
                        Object object = params[5] = EmptyUtil.isEmpty(objects[5]) ? " " : objects[5];
                        DynamicObject journal = journalMap.get(objects[3]);
                        if (journal == null) continue;
                        params[6] = EmptyUtil.isEmpty(journal.get("description")) ? " " : journal.get("description");
                        params[7] = EmptyUtil.isEmpty(journal.getString("settlementtype.name")) ? " " : journal.getString("settlementtype.name");
                        params[8] = EmptyUtil.isEmpty(journal.get("settlementnumber")) ? " " : journal.get("settlementnumber");
                        params[9] = journal.get("bizdate");
                        params[10] = EmptyUtil.isEmpty(journal.get("debitamount")) ? BigDecimal.ZERO : journal.get("debitamount");
                        params[11] = EmptyUtil.isEmpty(journal.get("creditamount")) ? BigDecimal.ZERO : journal.get("creditamount");
                        params[12] = journal.get("ratesdate");
                        params[13] = EmptyUtil.isEmpty(journal.get("bankvouvherno")) ? " " : journal.get("bankvouvherno");
                        params[14] = EmptyUtil.isEmpty(journal.get("tradenumber")) ? " " : journal.get("tradenumber");
                        params[15] = EmptyUtil.isEmpty(journal.get("source")) ? " " : journal.get("source");
                        params[16] = EmptyUtil.isEmpty(journal.get("balanceamt")) ? BigDecimal.ZERO : journal.get("balanceamt");
                        paramsList.add(params);
                    }
                    int[] executeBatch = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)insertSql, paramsList);
                    executeCount = executeBatch.length;
                }
                recResult.setMessage(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u8fbe\u8d26\u660e\u7ec6\u8868t_cas_uncompanydetail\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f%s", (String)"BankJournalDataDealServiceImpl_9", (String)"fi-cas-common", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\n\u6b64\u6b21\u5347\u7ea7\u6761\u6570\uff1a%s", (String)"BankJournalDataDealServiceImpl_10", (String)"fi-cas-common", (Object[])new Object[0]), executeCount)));
            }
            if (EmptyUtil.isNoEmpty(companyIds = haveCount.stream().filter(h -> "cas_bankjournal".equals(h[4])).map(h -> h[3]).collect(Collectors.toSet()))) {
                Object[] bankstatements = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys("cas_bankjournal")), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyIds.toArray())});
                Map<Object, DynamicObject> bankstatementMap = Stream.of(bankstatements).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy, (m1, m2) -> m1));
                int executeCount = 0;
                if (EmptyUtil.isNoEmpty(bankstatements)) {
                    Map<Object, String[]> result = BalanceAdjustHelper.getBankJournalVoucher((DynamicObject[])bankstatements);
                    boolean isHW = BalanceAdjustHelper.isHWProperty();
                    String insertSql = "insert into t_cas_unbankdetail (fentryid,fid,fseq,fbankbillid,fbanksourcetype,freason,fdescription,fvouchertype,fvouchernumber,fbilltype,fbillnumber,fsettletype,fsettlenumber,fbookdate,fbizdate,fdebitamount,fcreditamount,fpddate,favddate,fpreparationdate,fsysdate,fbanksource,fcashier,ffeepayer)  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    if (isHW) {
                        insertSql = "insert into t_cas_unbankdetail (fentryid,fid,fseq,fbankbillid,fbanksourcetype,freason,fdescription,fvouchertype,fvouchernumber,fbilltype,fbillnumber,fsettletype,fsettlenumber,fbookdate,fbizdate,fdebitamount,fcreditamount,fpddate,favddate,fpreparationdate,fsysdate,fbanksource,fcashier,ffeepayer,fk_hihn_voucherbatchnum,fk_hihn_paynum)  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ?)";
                    }
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
                    for (Object[] objects : haveCount) {
                        if (!"cas_bankjournal".equals(objects[4])) continue;
                        Object[] params = new Object[isHW ? 26 : 24];
                        params[0] = EmptyUtil.isEmpty(objects[0]) ? Long.valueOf(0L) : objects[0];
                        params[1] = EmptyUtil.isEmpty(objects[1]) ? Long.valueOf(0L) : objects[1];
                        params[2] = EmptyUtil.isEmpty(objects[2]) ? Long.valueOf(0L) : objects[2];
                        params[3] = EmptyUtil.isEmpty(objects[3]) ? Long.valueOf(0L) : objects[3];
                        params[4] = EmptyUtil.isEmpty(objects[4]) ? " " : objects[4];
                        Object object = params[5] = EmptyUtil.isEmpty(objects[5]) ? " " : objects[5];
                        DynamicObject bankstatement = bankstatementMap.get(objects[3]);
                        if (bankstatement == null) continue;
                        params[6] = EmptyUtil.isEmpty(bankstatement.get("description")) ? " " : bankstatement.get("description");
                        String[] voucherInfo = result.get(bankstatement.getPkValue());
                        if (voucherInfo != null) {
                            params[7] = EmptyUtil.isEmpty(voucherInfo[3]) ? " " : voucherInfo[3];
                            params[8] = EmptyUtil.isEmpty(voucherInfo[1]) ? " " : voucherInfo[1];
                            params[9] = SourceBillTypeEnum.getName(bankstatement.getString("sourcebilltype"));
                            params[10] = EmptyUtil.isEmpty(voucherInfo[2]) ? " " : voucherInfo[2];
                        } else {
                            params[7] = " ";
                            params[8] = " ";
                            params[9] = SourceBillTypeEnum.getName(bankstatement.getString("sourcebilltype"));
                            params[10] = " ";
                        }
                        if (EmptyUtil.isEmpty(params[9])) {
                            params[9] = " ";
                        }
                        params[11] = EmptyUtil.isEmpty(bankstatement.getString("settlementtype.name")) ? " " : bankstatement.getString("settlementtype.name");
                        params[12] = EmptyUtil.isEmpty(bankstatement.get("settlementnumber")) ? " " : bankstatement.get("settlementnumber");
                        params[13] = bankstatement.get("bookdate");
                        params[14] = bankstatement.get("bizdate");
                        params[15] = EmptyUtil.isEmpty(bankstatement.get("debitamount")) ? BigDecimal.ZERO : bankstatement.get("debitamount");
                        params[16] = EmptyUtil.isEmpty(bankstatement.get("creditamount")) ? BigDecimal.ZERO : bankstatement.get("creditamount");
                        params[17] = bankstatement.get("pddate");
                        params[18] = bankstatement.get("avddate");
                        params[19] = bankstatement.get("preparationdate");
                        params[20] = bankstatement.get("createtime");
                        params[21] = EmptyUtil.isEmpty(bankstatement.get("source")) ? " " : bankstatement.get("source");
                        params[22] = EmptyUtil.isEmpty(bankstatement.getString("cashier.name")) ? " " : bankstatement.getString("cashier.name");
                        Object object2 = params[23] = EmptyUtil.isEmpty(bankstatement.get("feepayer")) ? " " : bankstatement.get("feepayer");
                        if (isHW) {
                            params[24] = voucherInfo != null ? (EmptyUtil.isEmpty(voucherInfo[4]) ? " " : voucherInfo[4]) : " ";
                            params[25] = EmptyUtil.isEmpty(bankstatement.get("hihn_paynum")) ? " " : bankstatement.get("hihn_paynum");
                        }
                        paramsList.add(params);
                    }
                    int[] executeBatch = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)insertSql, paramsList);
                    executeCount = executeBatch.length;
                }
                recResult.setMessage(String.format(ResManager.loadKDString((String)"%1$s\n\u94f6\u884c\u672a\u8fbe\u8d26\u660e\u7ec6\u8868t_cas_unbankdetail\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f%2$s%3$s%4$s", (String)"BankJournalDataDealServiceImpl_11", (String)"fi-cas-common", (Object[])new Object[0]), recResult.getMessage(), String.format(ResManager.loadKDString((String)"\n\u6b64\u6b21\u5347\u7ea7\u6761\u6570\uff1a%s", (String)"BankJournalDataDealServiceImpl_10", (String)"fi-cas-common", (Object[])new Object[0]), executeCount), String.format(ResManager.loadKDString((String)"\n\u5f00\u59cb\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_3", (String)"fi-cas-common", (Object[])new Object[0]), startDate), String.format(ResManager.loadKDString((String)"\n\u7ed3\u675f\u5347\u7ea7\u65f6\u95f4\u4e3a\uff1a%s", (String)"BankJournalDataDealServiceImpl_4", (String)"fi-cas-common", (Object[])new Object[0]), sdf.format(new Date()))));
            }
        }
        catch (Exception e) {
            String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(exception);
            logger.info(exception);
        }
        return JSON.toJSONString((Object)recResult);
    }
}

