/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class TransDetailsHelper {
    private static final Log logger = LogFactory.getLog(TransDetailsHelper.class);

    public static DynamicObject getAllMatchResult(int index, DynamicObject[] journals, DynamicObject tradeObject, Map<Object, DynamicObject> transDetailMap) {
        logger.info("TransDetailsHelper getAllMatchResult: begin");
        DynamicObject matchResult = null;
        DynamicObject info = journals[index];
        if (EmptyUtil.isNoEmpty(tradeObject)) {
            Date bookdate;
            DynamicObject dynamicObject = transDetailMap.get(info.getPkValue());
            if (EmptyUtil.isEmpty(dynamicObject)) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"mon_transaction_bei");
                dynamicObject.set("id", info.getPkValue());
            }
            if (EmptyUtil.isEmpty(bookdate = info.getDate("bizdate")) || bookdate.before(tradeObject.getDate("validdate"))) {
                return null;
            }
            String oppacctnumber = info.getString("oppbanknumber");
            dynamicObject.set("sourcebillnumber", (Object)info.getString("billno"));
            dynamicObject.set("org_id", info.getDynamicObject("company").getPkValue());
            dynamicObject.set("currency_id", info.getDynamicObject("currency").getPkValue());
            dynamicObject.set("oppacctnumber", (Object)info.getString("oppbanknumber"));
            dynamicObject.set("oppunit", (Object)info.getString("oppunit"));
            dynamicObject.set("bookdate", (Object)info.getDate("bizdate"));
            Map<String, DynamicProperty> fldProperties = TransDetailsHelper.getFilterProperties(info);
            logger.info("TransDetailsHelper getAllMatchResult: info : {}", (Object)info);
            boolean isMatch = TransDetailsHelper.isMatch(info, tradeObject.getString("amountconditon_real_Tag"), fldProperties);
            dynamicObject.set("islargeamount", (Object)isMatch);
            logger.info("TransDetailsHelper getAllMatchResult: islargeamount : {}", (Object)tradeObject.getString("amountconditon_real_Tag"));
            isMatch = TransDetailsHelper.isMatch(info, tradeObject.getString("sensitivecondition_real_Tag"), fldProperties);
            dynamicObject.set("issensitive", (Object)isMatch);
            isMatch = TransDetailsHelper.isMatch(info, tradeObject.getString("focusconditon_real_Tag"), fldProperties);
            dynamicObject.set("isattention", (Object)isMatch);
            int days = tradeObject.getInt("questionconditon");
            Long accountbank = info.getLong("accountbank.id");
            dynamicObject.set("accountbank_id", (Object)accountbank);
            BigDecimal creditamount = info.getBigDecimal("creditamount");
            BigDecimal debitamount = info.getBigDecimal("debitamount");
            dynamicObject.set("creditamount", (Object)info.getBigDecimal("debitamount"));
            dynamicObject.set("debitamount", (Object)info.getBigDecimal("creditamount"));
            if (oppacctnumber != null && !EmptyUtil.isEmpty(creditamount) && !EmptyUtil.isEmpty(debitamount)) {
                Date beginDate = DateUtils.getLastDay(bookdate, days);
                Date endDate = DateUtils.getNextDay(bookdate, days);
                for (int i = index + 1; i < journals.length; ++i) {
                    bookdate = journals[i].getDate("bizdate");
                    if (EmptyUtil.isEmpty(bookdate) || !bookdate.after(beginDate) || !bookdate.before(endDate) || accountbank.longValue() != journals[i].getLong("accountbank.id") || !oppacctnumber.equals(journals[i].getString("oppbanknumber")) || creditamount.compareTo(journals[i].getBigDecimal("creditamount")) != 0 || debitamount.compareTo(journals[i].getBigDecimal("debitamount")) != 0) continue;
                    dynamicObject.set("isdoubt", (Object)true);
                }
            }
            matchResult = dynamicObject;
        }
        return matchResult;
    }

    private static Map<String, DynamicProperty> getFilterProperties(DynamicObject info) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)info.getDataEntityType().getName());
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    private static boolean isMatch(DynamicObject object, String filterStr, Map<String, DynamicProperty> fldProperties) {
        boolean isMatch = false;
        if (EmptyUtil.isNotEmpty(filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)object.getDataEntityType().getName());
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (EmptyUtil.isNotEmpty(baseFilterStr)) {
                FormulaGetHandle<Boolean> basebillFilterHandle = new FormulaGetHandle<Boolean>(taskContext, baseFilterStr, Boolean.FALSE);
                isMatch = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, object, null);
            }
        }
        return isMatch;
    }
}

