/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.payment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.paybill.IPaymentPayHelper;
import org.apache.commons.lang3.StringUtils;

public class PaymentPayHelper {
    public static Date getPaymentPayDate(DynamicObject payBill) {
        PluginProxy pluginProxy = PluginProxy.create(IPaymentPayHelper.class, (String)"kd.sdk.fi.cas.extpoint.paybill.IPaymentPayHelper");
        List lists = pluginProxy.callReplace(o -> o.getPaymentPayDate(payBill));
        if (EmptyUtil.isNoEmpty(lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (Date)lists.get(0);
        }
        return new Date();
    }

    public static Date getAgentPayBillPayDate(DynamicObject agentPayBill) {
        PluginProxy pluginProxy = PluginProxy.create(IPaymentPayHelper.class, (String)"kd.sdk.fi.cas.extpoint.paybill.IPaymentPayHelper");
        List lists = pluginProxy.callReplace(o -> o.getAgentPayBillPayDate(agentPayBill));
        if (EmptyUtil.isNoEmpty(lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (Date)lists.get(0);
        }
        return new Date();
    }

    public static Date confirmPayDate(DynamicObject payBill, String casParam1046, Map<String, String> params, Map<String, Object> paydateMap) {
        Date payDate = null;
        if (casParam1046.contains(SysParamCs1046Enum.PAYDATE.getValue())) {
            String payDateObj = params.get("paydate");
            if (payDateObj != null && StringUtils.isNotBlank((CharSequence)payDateObj.toString())) {
                payDate = DateUtils.stringToDate(payDateObj.toString(), "yyyy-MM-dd HH:mm:ss");
            }
        } else {
            String paydateStr;
            String orgId = payBill.getDynamicObject("org").getString("id");
            String value = (String)paydateMap.get(orgId);
            switch (paydateStr = value == null ? "sysdate" : value.toString()) {
                case "expectdate": {
                    payDate = payBill.getDate("expectdate");
                    break;
                }
                case "bizdate": {
                    payDate = payBill.getDate("bizdate");
                    break;
                }
                case "sysdate": {
                    payDate = new Date();
                    break;
                }
                case "auditdate": {
                    payDate = payBill.getDate("auditdate");
                    break;
                }
                case "customize": {
                    payDate = PaymentPayHelper.getPaymentPayDate(payBill);
                    break;
                }
                default: {
                    payDate = new Date();
                }
            }
        }
        if (payDate == null && (payDate = payBill.getDate("expectdate")) == null && "fca_transupbill".equalsIgnoreCase(payBill.getString("sourcebilltype"))) {
            payDate = payBill.getDate("paydate");
        }
        if (params.containsKey("bizFinishDate") && CasHelper.isNotEmpty(params.get("bizFinishDate"))) {
            payDate = DateUtils.stringToDate(params.get("bizFinishDate"), "yyyy-MM-dd");
        }
        return payDate;
    }

    public static Date confirmPayDate(DynamicObject agentPayBill, String payDateStr) {
        Date payDate = null;
        switch (payDateStr) {
            case "expectdate": {
                payDate = agentPayBill.getDate("expectdealtime");
                break;
            }
            case "bizdate": {
                payDate = agentPayBill.getDate("bizdate");
                break;
            }
            case "auditdate": {
                payDate = agentPayBill.getDate("auditdate");
                break;
            }
            case "sysdate": {
                payDate = new Date();
                break;
            }
            case "customize": {
                payDate = PaymentPayHelper.getAgentPayBillPayDate(agentPayBill);
                break;
            }
            default: {
                payDate = null;
            }
        }
        return payDate;
    }

    public static void setPartPay(DynamicObject payApplyData, Set<String> status, boolean isPartPay, boolean existReject) {
        if (status.size() == 1 && status.contains(PayApplyPayStatusEnum.NOTPAYING.getValue())) {
            isPartPay = false;
        }
        if (status.size() == 1 && status.contains(PayApplyPayStatusEnum.SUCCESS.getValue())) {
            isPartPay = false;
        }
        if (existReject) {
            isPartPay = false;
        }
        payApplyData.set("partpay", (Object)isPartPay);
    }

    public static void setPaidStatus(DynamicObject payApplyData, Set<String> paidStatus) {
        if (paidStatus.size() == 1 && paidStatus.contains(PayApplyPayStatusEnum.SUCCESS.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.SUCCESS.getValue());
        } else if (paidStatus.size() == 1 && paidStatus.contains(PayApplyPayStatusEnum.NOTPAYING.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.NOTPAYING.getValue());
        } else if (paidStatus.size() == 1 && paidStatus.contains(PayApplyPayStatusEnum.PAYING.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.PAYING.getValue());
        } else if (paidStatus.contains(PayApplyPayStatusEnum.SUCCESS.getValue()) && paidStatus.contains(PayApplyPayStatusEnum.PAYING.getValue()) && paidStatus.contains(PayApplyPayStatusEnum.NOTPAYING.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.NOTPAYING.getValue());
        } else if (paidStatus.contains(PayApplyPayStatusEnum.SUCCESS.getValue()) && paidStatus.contains(PayApplyPayStatusEnum.PAYING.getValue()) && !paidStatus.contains(PayApplyPayStatusEnum.NOTPAYING.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.PAYING.getValue());
        }
    }

    public static void updateEntryDpAmt(DynamicObject payBill) {
        if (!payBill.getBoolean("isdiffcur")) {
            return;
        }
        DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
        if (CollectionUtils.isEmpty((Collection)entryList)) {
            return;
        }
        DynamicObject dpCurrency = payBill.getDynamicObject("dpcurrency");
        String agreedquotation = payBill.getString("agreedquotation");
        int round = 10;
        if (dpCurrency != null) {
            round = dpCurrency.getInt("amtprecision");
        }
        BigDecimal dpAmtSum = BigDecimal.ZERO;
        for (int i = 0; i < entryList.size() - 1; ++i) {
            DynamicObject entry = (DynamicObject)entryList.get(i);
            BigDecimal entryActAmt = entry.getBigDecimal("e_actamt");
            BigDecimal entryDpAmt = QuotationHelper.callToCurrency(entryActAmt, payBill.getBigDecimal("agreedrate"), agreedquotation, round);
            entry.set("e_dpamt", (Object)entryDpAmt);
            dpAmtSum = dpAmtSum.add(entryDpAmt);
        }
        BigDecimal headDpAmt = payBill.getBigDecimal("dpamt");
        ((DynamicObject)entryList.get(entryList.size() - 1)).set("e_dpamt", (Object)headDpAmt.subtract(dpAmtSum));
    }

    public static void updateAuditParam(DynamicObject payBill) {
        String auditParam = payBill.getString("auditparam");
        if (EmptyUtil.isEmpty(auditParam)) {
            DynamicObject org = payBill.getDynamicObject("org");
            String payeeBankNum = payBill.getString("payeebanknum");
            boolean isCrossPay = payBill.getBoolean("iscrosspay");
            long payee = payBill.getLong("payee");
            String liquidationParam = BaseDataHelper.getSupplierLiquidationParam(payee, isCrossPay, org, payeeBankNum);
            payBill.set("auditparam", (Object)liquidationParam);
        }
    }
}

