/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.payment;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.util.EmptyUtil;

public class PaymentPayScheduleSource {
    private static Log logger = LogFactory.getLog(PaymentPayScheduleSource.class);

    public static PaymentPayScheduleSource getInstance() {
        return Singleton.instance;
    }

    public Boolean isAddScheduleSource(DynamicObject info) {
        DynamicObject orgDO = info.getDynamicObject("org");
        String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
        Object sysParameter = SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)orgDO.getPkValue()), (String)"psd001");
        Boolean isOpenSchedule = (Boolean)sysParameter;
        if (!isOpenSchedule.booleanValue()) {
            return false;
        }
        String filterStr = this.getFilter(info);
        if (StringUtils.isEmpty((CharSequence)filterStr)) {
            logger.info("PaymentPayScheSaveOrSubmitOp::Application condition is null!");
            return false;
        }
        Set<String> filterProps = this.getFilterProps(filterStr);
        DynamicObjectCollection scheduleBills = this.getFldProperties(info, filterProps);
        if (scheduleBills == null) {
            return false;
        }
        DynamicObjectType dType = scheduleBills.getDynamicObjectType();
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(filterProps.size());
        DynamicObject dynamicObject = new DynamicObject(scheduleBills.getDynamicObjectType());
        for (String prop : filterProps) {
            fldProperties.put(prop, dType.getProperty(prop));
            dynamicObject.set(prop, info.get(prop));
        }
        Boolean isMatch = this.isMatchRule(filterStr, dynamicObject, fldProperties);
        logger.info(String.format("PaymentPayScheSaveOrSubmitOp::the result of match is %s", isMatch));
        return isMatch;
    }

    private String getFilter(DynamicObject info) {
        DynamicObject organization = (DynamicObject)info.get("org");
        Long orgId = organization.getLong("id");
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgFilter = new QFilter("entryentity.org", "=", (Object)orgId);
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((String)"psd_schedule_source", (String)"id, e_datafilterdesc_real_TAG", (QFilter[])new QFilter[]{statusFilter, orgFilter});
        String filterStr = "";
        if (EmptyUtil.isNoEmpty(orgObject)) {
            filterStr = orgObject.getString("e_datafilterdesc_real_TAG");
        } else {
            QFilter allOrgFilter = new QFilter("entryentity.org", "is null", null);
            DynamicObject allOrgObject = BusinessDataServiceHelper.loadSingle((String)"psd_schedule_source", (String)"id, e_datafilterdesc_real_TAG", (QFilter[])new QFilter[]{statusFilter, allOrgFilter});
            if (EmptyUtil.isNoEmpty(allOrgObject)) {
                filterStr = allOrgObject.getString("e_datafilterdesc_real_TAG");
            }
        }
        return filterStr;
    }

    private Set<String> getFilterProps(String filterStr) {
        MainEntityType mainEntityType;
        HashSet<String> filterProps = new HashSet<String>();
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        String baseFilterStr = filterObj.buildFullFormula(mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        if (EmptyUtil.isNotEmpty(baseFilterStr)) {
            String[] vars = FormulaEngine.extractVariables((String)baseFilterStr);
            filterProps.addAll(Arrays.asList(vars));
        }
        return filterProps;
    }

    private DynamicObjectCollection getFldProperties(DynamicObject info, Set<String> filterProps) {
        DynamicObjectCollection scheduleBills = null;
        QFilter pkFilter = new QFilter("id", "in", info.getPkValue());
        HashSet<String> selProps = new HashSet<String>(filterProps);
        selProps.add("id");
        String selectString = StringUtils.join((Object[])selProps.toArray(new String[selProps.size()]), (String)",");
        try (DataSet dsn = QueryServiceHelper.queryDataSet((String)PaymentPayScheduleSource.class.getName(), (String)"cas_paybill", (String)selectString, (QFilter[])new QFilter[]{pkFilter}, null);){
            scheduleBills = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
        logger.info(String.format("PaymentPayScheSaveOrSubmitOp::The object of scheduleBills is %s", scheduleBills));
        return scheduleBills;
    }

    private Boolean isMatchRule(String filterStr, DynamicObject schedulebill, Map<String, DynamicProperty> fldProperties) {
        MainEntityType mainEntityType;
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        String baseFilterStr = filterObj.buildFullFormula(mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        if (StringUtils.isEmpty((CharSequence)baseFilterStr)) {
            return Boolean.FALSE;
        }
        try {
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            FormulaGetHandle<Boolean> basebillFilterHandle = new FormulaGetHandle<Boolean>(taskContext, baseFilterStr, Boolean.FALSE);
            Boolean baseBoolean = basebillFilterHandle.GetVchFldValue(fldProperties, schedulebill, null);
            if (baseBoolean.booleanValue()) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return Boolean.FALSE;
    }

    static class Singleton {
        private static PaymentPayScheduleSource instance = new PaymentPayScheduleSource();

        Singleton() {
        }
    }
}

