/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.info.AccountAmount;

public class AccountBalanceUtils {
    public static Boolean accountBalance(long orgId, long period, long acctId, String formId) {
        QFilter[] periodFilters;
        DynamicObject periodObj;
        Boolean isZero = Boolean.TRUE;
        Date beginDate = null;
        if (period != 0L && (periodObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, periodyear, periodnumber, begindate", (QFilter[])(periodFilters = new QFilter[]{new QFilter("id", "=", (Object)period)}))) != null) {
            beginDate = periodObj.getDate("begindate");
        }
        List<AccountAmount> journalList = AccountBalanceUtils.getJournal(orgId, beginDate, acctId, formId);
        DynamicObjectCollection balanceList = AccountBalanceUtils.getBalance(orgId, period, acctId, formId);
        List<Long> currencyCol = AccountBalanceUtils.getCurrencyCol(acctId, formId);
        isZero = AccountBalanceUtils.isZearo(journalList, balanceList, currencyCol);
        return isZero;
    }

    private static List<AccountAmount> getJournal(long orgId, Date beginDate, long acctId, String formId) {
        String selector = "currency,debitamount,creditamount";
        QFilter accountFilter = null;
        String journalType = "cas_bankjournal";
        if ("bd_accountbanks".equals(formId)) {
            selector = selector + ",accountbank as account";
            accountFilter = new QFilter("accountbank", "=", (Object)acctId);
        } else {
            selector = selector + ",accountcash as account";
            accountFilter = new QFilter("accountcash", "=", (Object)acctId);
            journalType = "cas_cashjournal";
        }
        LinkedList<AccountAmount> journalData = new LinkedList<AccountAmount>();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("bookdate", ">=", (Object)beginDate);
        QFilter[] journalFilters = new QFilter[]{orgFilter, accountFilter, dateFilter};
        try (DataSet journalRawDataSet = QueryServiceHelper.queryDataSet((String)(AccountBalanceUtils.class.getName() + ".getJournal"), (String)journalType, (String)selector, (QFilter[])journalFilters, null);
             DataSet journalGroupByDataSet = journalRawDataSet.groupBy(new String[]{"account", "currency"}).sum("debitamount").sum("creditamount").finish();){
            journalGroupByDataSet.forEach(row -> {
                AccountAmount acctAmount = new AccountAmount();
                acctAmount.setAccount(row.getLong("account"));
                acctAmount.setCurrency(row.getLong("currency"));
                acctAmount.setCreditAmount(row.getBigDecimal("creditamount"));
                acctAmount.setDebitAmount(row.getBigDecimal("debitamount"));
                journalData.add(acctAmount);
            });
        }
        return journalData;
    }

    private static DynamicObjectCollection getBalance(long orgId, long period, long acctId, String formId) {
        String acctProperty = "";
        acctProperty = "bd_accountbanks".equals(formId) ? "accountbank" : "accountcash";
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", (Object)period), new QFilter(acctProperty, "=", (Object)acctId)};
        DynamicObjectCollection journalbalanceList = QueryServiceHelper.query((String)"cas_journalbalance", (String)"id, currency, monthstart", (QFilter[])filters);
        return journalbalanceList;
    }

    private static List<Long> getCurrencyCol(long acctId, String formId) {
        if ("bd_accountbanks".equals(formId)) {
            return new ArrayList<Long>(AccountBankHelper.getCurrencyPks(acctId));
        }
        return AccountCashHelper.getCurrencys(Collections.singletonList(acctId));
    }

    private static Boolean isZearo(List<AccountAmount> journalList, DynamicObjectCollection balanceList, List<Long> currencyCol) {
        Boolean isZero = Boolean.TRUE;
        if (currencyCol.size() > 0) {
            for (Long currency : currencyCol) {
                BigDecimal monthStart = new BigDecimal("0");
                BigDecimal creditamount = new BigDecimal("0");
                BigDecimal debitamount = new BigDecimal("0");
                for (DynamicObject balance : balanceList) {
                    long balanceCurrencyId = balance.getLong("currency");
                    if (balanceCurrencyId != currency) continue;
                    monthStart = balance.getBigDecimal("monthstart");
                }
                for (AccountAmount journal : journalList) {
                    long journalCurrencyId = journal.getCurrency();
                    if (journalCurrencyId != currency) continue;
                    creditamount = creditamount.add(journal.getCreditAmount());
                    debitamount = debitamount.add(journal.getDebitAmount());
                }
                if (monthStart.add(creditamount).subtract(debitamount).compareTo(new BigDecimal("0")) == 0) continue;
                isZero = Boolean.FALSE;
                break;
            }
        }
        return isZero;
    }
}

