/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.fcm.ExecuteStatus;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cas.util.DateUtils;

public class ClosePeriodUtils {
    private static final Log LOGGER = LogFactory.getLog(ClosePeriodUtils.class);
    private static final String APPID = BizAppServiceHelp.getAppIdByAppNumber((String)"cas");

    public static List<Long> getAccountOrg(Long bankRollOrgId) {
        DynamicObject banRollOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"fisaccounting", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankRollOrgId)});
        if (banRollOrg.getBoolean("fisaccounting")) {
            return Collections.singletonList(bankRollOrgId);
        }
        QFilter accountBookFilter = new QFilter("o_entry.o_app", "=", (Object)APPID);
        accountBookFilter.and("o_entry.o_relateorg.fbasedataid.id", "=", (Object)bankRollOrgId);
        DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org.id", (QFilter[])accountBookFilter.toArray());
        return accountBooks.stream().map(v -> v.getLong("org.id")).collect(Collectors.toList());
    }

    public static Set<Long> getCheckItemIds(Long bankRollOrgId) {
        List<CheckItemDetail> checkItems = ClosePeriodUtils.getCheckItemList(bankRollOrgId, true);
        return checkItems.stream().map(CheckItemDetail::getId).collect(Collectors.toSet());
    }

    public static List<CheckItemDetail> getCheckItemList(Long bankRollOrgId, Boolean isEffective) {
        List<Long> accountOrgIds = ClosePeriodUtils.getAccountOrg(bankRollOrgId);
        ArrayList<CheckItemDetail> result = new ArrayList<CheckItemDetail>();
        for (Long accountOrg : accountOrgIds) {
            List checkItemDetails = ClosePeriodCheckExecutor.queryCheckItemList((String)APPID, null, (Long)accountOrg, (Boolean)isEffective);
            result.addAll(checkItemDetails);
        }
        LOGGER.info("getCheckItemList size:{}", (Object)result.size());
        return result;
    }

    public static boolean closeCheck(DynamicObjectCollection entitys, long org, long curperiod) {
        ArrayList<Long> checkItems = new ArrayList<Long>(ClosePeriodUtils.getCheckItemIds(org));
        CheckItemExecutionParam checkItemExecutionParam = new CheckItemExecutionParam(APPID, "", Long.valueOf(org), Long.valueOf(curperiod), checkItems, "");
        CheckExecutionResult executeResult = ClosePeriodCheckExecutor.instance.execute(checkItemExecutionParam);
        List itemCheckResultList = executeResult.getItemCheckResultList();
        LOGGER.info("ClosePeriodOpLog-size" + itemCheckResultList.size());
        StringBuilder logSb = new StringBuilder();
        for (CheckExecutionResult.CheckResultWrapper checkResultWrapper : itemCheckResultList) {
            logSb.append(checkResultWrapper.getCheckItem().getName());
            logSb.append("-");
            logSb.append(checkResultWrapper.getExecuteStatus().getCode());
            logSb.append(";");
            ClosePeriodUtils.setCheckInfo(entitys, checkResultWrapper);
        }
        LOGGER.info("ClosePeriodOpLog-checkResult" + logSb);
        return executeResult.isFinalApproval();
    }

    public static boolean doReverseClosing(IFormView view) {
        int selectSize;
        int successSize;
        ReportList control = (ReportList)view.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        HashSet<Long> idList = new HashSet<Long>(rowIdxs.length);
        for (int i = 0; i < rowIdxs.length; ++i) {
            DynamicObject rowData = control.getReportModel().getRowData(rowIdxs[i]);
            long pid = rowData.getLong("pid");
            if (rowData.getInt("isgroupnode") == 0 && pid > 0L) continue;
            String checkoutId = rowData.getString("booktype");
            idList.add(Long.valueOf(checkoutId));
        }
        OperateOption opt = OperateOption.create();
        opt.setVariableValue("closeCacheKey", "CLOSE_PERIOD.");
        opt.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"anticheckout", (String)"cas_finalcheckout", (Object[])idList.toArray(), (OperateOption)opt);
        StringBuilder sb = new StringBuilder();
        if (!result.isSuccess()) {
            List errorInfos = result.getAllErrorInfo();
            for (OperateErrorInfo info : errorInfos) {
                sb.append(info.getMessage());
            }
            if (sb.length() == 0) {
                List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                for (IOperateInfo r : allErrorOrValidateInfo) {
                    OperateErrorInfo info = (OperateErrorInfo)r;
                    sb.append(info.getMessage()).append("\r\n");
                }
            }
        }
        if ((successSize = result.getSuccessPkIds().size()) - (selectSize = rowIdxs.length) == 0) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u6210\u529f\u3002", (String)"ClosePeriodUtils_0", (String)"fi-cas-common", (Object[])new Object[0]));
        } else {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u53cd\u7ed3\u8d26\u64cd\u4f5c\u5b8c\u6210\uff0c%d\u5bb6\u516c\u53f8\u53cd\u7ed3\u8d26\u6210\u529f\u3002", (String)"ClosePeriodUtils_1", (String)"fi-cas-common", (Object[])new Object[0]), result.getSuccessPkIds().size()), sb.toString(), MessageTypes.Default);
        }
        return true;
    }

    public static void createListOnCloseDetail(QFilter filter, String formNumber, String checkOutId, IFormView view) {
        DynamicObject finalCheckOut = BusinessDataServiceHelper.loadSingle((Object)checkOutId, (String)"cas_finalcheckout");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formNumber);
        parameter.setFormId("bos_list");
        if ("cas_bankstatement".equals(formNumber)) {
            parameter.setFormId("cas_templatetreelist");
        } else if ("cas_bankjournal".equals(formNumber)) {
            ReportShowParameter reportParameter = new ReportShowParameter();
            reportParameter.setFormId("cas_bankjournalformrpt");
            reportParameter.getCustomParams().put("isTrack", true);
            reportParameter.getCustomParams().put("trackOrg", finalCheckOut.getLong("org.id"));
            reportParameter.getCustomParams().put("trackPeriod", finalCheckOut.getLong("period.id"));
            reportParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)reportParameter);
            return;
        }
        parameter.getListFilterParameter().setFilter(filter);
        parameter.getCustomParams().put("isTrack", true);
        parameter.getCustomParams().put("trackOrg", finalCheckOut.getLong("org.id"));
        parameter.getCustomParams().put("trackPeriod", finalCheckOut.getLong("period.id"));
        DynamicObject curPeriod = finalCheckOut.getDynamicObject("period");
        parameter.getCustomParams().put("trackStartDate", DateUtils.formatString(curPeriod.getDate("begindate"), "yyyy-MM-dd"));
        parameter.getCustomParams().put("trackEndDate", DateUtils.formatString(curPeriod.getDate("enddate"), "yyyy-MM-dd"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)parameter);
    }

    public static void setCheckInfo(DynamicObjectCollection entitys, CheckExecutionResult.CheckResultWrapper checkResultWrapper) {
        CheckItemDetail checkItem = checkResultWrapper.getCheckItem();
        ExecuteStatus executeStatus = checkResultWrapper.getExecuteStatus();
        String errMsg = checkResultWrapper.getErrMsg();
        if (ExecuteStatus.PASS.equals((Object)executeStatus)) {
            ClosePeriodUtils.setSuccessInfo(entitys, checkItem.getName(), "1", checkItem.getCustomizeIcon());
        } else if (ExecuteStatus.FAIL.equals((Object)executeStatus)) {
            String onlineViewId;
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = checkItem.getName();
            }
            if (StringUtils.isNotBlank((CharSequence)(onlineViewId = checkItem.getOnlineViewId()))) {
                errMsg = null;
            }
            String filterStr = "";
            QFilter[] billFilters = checkResultWrapper.getBillFilters();
            if (!Objects.isNull(billFilters) && billFilters.length > 0) {
                QFilter filter = null;
                for (QFilter qFilter : billFilters) {
                    filter = null == filter ? qFilter : filter.and(qFilter);
                }
                if (null != filter) {
                    filterStr = filter.toSerializedString();
                }
            }
            ClosePeriodUtils.setCheckInfo(entitys, checkItem.getName(), "0", filterStr, onlineViewId, errMsg, checkItem.getCustomizeIcon());
        } else {
            ClosePeriodUtils.setCheckInfo(entitys, checkItem.getName(), "0", null, null, errMsg, checkItem.getCustomizeIcon());
        }
    }

    private static DynamicObject setCheckInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String formquery, String formnumber, String message, String menuid) {
        DynamicObject entity = ClosePeriodUtils.setSuccessInfo(entitys, checkitem, checkstate, menuid);
        entity.set("formquery", (Object)formquery);
        entity.set("formnumber", (Object)formnumber);
        entity.set("message", (Object)message);
        return entity;
    }

    private static DynamicObject setSuccessInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String menuid) {
        DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
        entity.set("checkitem", (Object)checkitem);
        entity.set("checkstate", (Object)checkstate);
        if (StringUtils.isBlank((CharSequence)menuid)) {
            menuid = "icons/pc/entrance/zz_qmjz_48_48.png";
        }
        entity.set("menuid", (Object)menuid);
        entitys.add((Object)entity);
        return entity;
    }
}

