/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.fi.cas.util.DateUtils;

public class DataSetUtil {
    public static List<String> getSelectedFields(DataSet dataSet, String ... ignoreFields) {
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<String> selectedFields = new ArrayList<String>();
        for (Field f : fields) {
            boolean ignore = false;
            if (ignoreFields.length > 0) {
                for (String ignoreField : ignoreFields) {
                    if (!f.getName().equalsIgnoreCase(ignoreField)) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            selectedFields.add(f.getName());
        }
        return selectedFields;
    }

    public static DataSet filterDataSet(DataSet ds, Function<Row, Boolean> filter) {
        List<String> selectedFields = DataSetUtil.getSelectedFields(ds, new String[0]);
        Field[] fields = ds.getRowMeta().getFields();
        DataSetBuilder dataSetBuilder = Algo.create((String)"cas.DataSetUtil.filterDataSet").createDataSetBuilder(new RowMeta(fields));
        ds.forEach(row -> {
            if (((Boolean)filter.apply((Row)row)).booleanValue()) {
                Object[] rowData = new Object[selectedFields.size()];
                for (int i = 0; i < selectedFields.size(); ++i) {
                    rowData[i] = row.get((String)selectedFields.get(i));
                }
                dataSetBuilder.append(rowData);
            }
        });
        return dataSetBuilder.build();
    }

    public static void setRowValue(AbstractRow row, String filed, Object value) {
        int index = row.getRowMeta().getFieldIndex(filed);
        row.values()[index] = value;
    }

    public static boolean containsKey(AbstractRow row, String filed) {
        Field[] fields;
        for (Field f : fields = row.getRowMeta().getFields()) {
            if (!f.getName().equals(filed)) continue;
            return true;
        }
        return false;
    }

    public static DataSet formatDataSetInDate(DataSet tDataSet, String ... tFormatDates) {
        List<String> tFormatDateLists = Arrays.asList(tFormatDates);
        if (tFormatDateLists.size() > 0) {
            List<String> selectedFields = DataSetUtil.getSelectedFields(tDataSet, new String[0]);
            Field[] fields = tDataSet.getRowMeta().getFields();
            DataSetBuilder dataSetBuilder = Algo.create((String)"cas.DataSetUtil.filterDataSet").createDataSetBuilder(new RowMeta(fields));
            for (Row row : tDataSet) {
                Object[] rowData = new Object[selectedFields.size()];
                for (int i = 0; i < selectedFields.size(); ++i) {
                    rowData[i] = row.get(selectedFields.get(i));
                    if (tFormatDateLists.indexOf(selectedFields.get(i)) <= 0) continue;
                    try {
                        Object obj = row.get(selectedFields.get(i));
                        if (!(obj instanceof Date)) continue;
                        rowData[i] = DateUtils.truncateDate((Date)obj);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dataSetBuilder.append(rowData);
            }
            tDataSet = dataSetBuilder.build();
        }
        return tDataSet;
    }
}

