/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EntityMetadataUtils;

public class FormUtils {
    public static void deleteEmptyRows(IDataModel model, String ... checkFields) {
        List<Integer> emptyRows = FormUtils.getEmptyRows(model, checkFields);
        if (emptyRows.size() > 0) {
            int[] indexs = new int[emptyRows.size()];
            for (int i = 0; i < indexs.length; ++i) {
                indexs[i] = emptyRows.get(i);
            }
            EntryProp pro = EntityMetadataUtils.getEntryProp((IDataEntityType)model.getDataEntityType());
            model.deleteEntryRows(pro.getName(), indexs);
        }
    }

    public static List<Integer> getEmptyRows(IDataModel model, String ... checkFields) {
        ArrayList<String> checkFieldList = new ArrayList<String>(checkFields.length);
        for (int i = 0; i < checkFields.length; ++i) {
            checkFieldList.add(checkFields[i]);
        }
        return FormUtils.getEmptyRows(model, checkFieldList);
    }

    public static List<Integer> getEmptyRows(IDataModel model, List<String> checkFields) {
        ArrayList<Integer> emptyRows = new ArrayList<Integer>();
        EntryProp entryProp = EntityMetadataUtils.getEntryProp((IDataEntityType)model.getDataEntityType());
        if (entryProp != null) {
            int count = model.getEntryRowCount(entryProp.getName());
            for (int i = 0; i < count; ++i) {
                if (!FormUtils.isRowEmpty(model, i, checkFields)) continue;
                emptyRows.add(i);
            }
            return emptyRows;
        }
        throw new KDException(new ErrorCode("FormUtilsException", ResManager.loadKDString((String)"\u5b9e\u4f53\u4e2d\u6ca1\u6709\u5206\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u7a7a\u884c\u3002", (String)"FormUtils_0", (String)"fi-cas-common", (Object[])new Object[0])), new Object[0]);
    }

    public static boolean isRowEmpty(IDataModel model, int i, List<String> checkFields) {
        if (checkFields == null || checkFields.size() < 1) {
            throw new KDException(new ErrorCode("FormUtilsException", ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u68c0\u9a8c\u7684\u5b57\u6bb5\u3002", (String)"FormUtils_1", (String)"fi-cas-common", (Object[])new Object[0])), new Object[0]);
        }
        for (String key : checkFields) {
            if (CasHelper.isEmpty(model.getValue(key, i))) continue;
            return false;
        }
        return true;
    }

    public static void deleteEmptyRows(DynamicObject info, String entry, String ... checkFields) {
        DynamicObjectCollection collection = info.getDynamicObjectCollection(entry);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DynamicObject object = (DynamicObject)iterator.next();
            for (String field : checkFields) {
                if (!CasHelper.isEmpty(object.get(field))) continue;
                iterator.remove();
            }
        }
    }
}

