/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ViewUtils {
    public static void setVisible(AbstractFormPlugin plugin, boolean visible, String ... ctrlId) {
        for (String s : ctrlId) {
            ViewUtils.innerSetVisible(plugin, visible, s);
        }
    }

    private static void innerSetVisible(AbstractFormPlugin plugin, boolean visible, String ctrlId) {
        Control ctrl = plugin.getView().getControl(ctrlId);
        if (ctrl == null || ctrl instanceof Button) {
            plugin.getView().setVisible(Boolean.valueOf(visible), new String[]{ctrlId});
        } else if (ctrl instanceof FieldEdit) {
            FieldEdit edit = (FieldEdit)ctrl;
            edit.setVisible("", visible);
        } else if (ctrl instanceof Container) {
            List<Control> subControls = ViewUtils.getSubControls((Container)ctrl);
            subControls.add(ctrl);
            String[] keys = new String[subControls.size()];
            for (int i = 0; i < subControls.size(); ++i) {
                keys[i] = subControls.get(i).getKey();
            }
            plugin.getView().setVisible(Boolean.valueOf(visible), keys);
        } else {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e%s\u7c7b\u578b\u63a7\u4ef6\u7684\u663e\u9690\u3002", (String)"ViewUtils_0", (String)"fi-cas-common", (Object[])new Object[0]), ctrl.getClass().getName()));
        }
    }

    private static List<Control> getSubControls(Container control) {
        ArrayList<Control> result = new ArrayList<Control>();
        List items = control.getItems();
        for (Control item : items) {
            if (item instanceof Container) {
                result.addAll(ViewUtils.getSubControls((Container)item));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public static void setEnable(AbstractFormPlugin plugin, boolean enable, String ... ctrlId) {
        for (int i = 0; i < ctrlId.length; ++i) {
            ViewUtils.innerSetEnable(plugin, enable, ctrlId[i]);
        }
    }

    private static void innerSetEnable(AbstractFormPlugin plugin, boolean enable, String ctrlId) {
        Control ctrl = plugin.getView().getControl(ctrlId);
        if (ctrl == null || ctrl instanceof Button) {
            plugin.getView().setEnable(Boolean.valueOf(enable), new String[]{ctrlId});
        } else if (ctrl instanceof FieldEdit) {
            FieldEdit edit = (FieldEdit)ctrl;
            if (edit.getProperty().getParent() instanceof EntryType) {
                int rowCount = plugin.getView().getModel().getEntryRowCount(edit.getEntryKey());
                for (int i = 0; i < rowCount; ++i) {
                    edit.setEnable("", enable, i);
                }
            } else {
                edit.setEnable("", enable, 0);
            }
        } else {
            throw new RuntimeException("");
        }
    }

    public static DynamicObject getCurrentUser() {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        return BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user");
    }

    public static String isRefrenced(DynamicObject billObj) {
        String error = null;
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        String enityName = billObj.getDataEntityType().getName();
        BaseDataCheckRefrenceResult refrenceResult = checker.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)enityName), billObj.getPkValue());
        if (refrenceResult.isRefence()) {
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (!(property instanceof IFieldHandle) || !StringUtils.equals((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) continue;
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            error = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"ViewUtils_1", (String)"fi-cas-common", (Object[])new Object[0]), billName, fieldName);
            return error;
        }
        return "";
    }
}

