/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.calculate.ICalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dao.PersistBalanceData;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.util.DateUtils;

public abstract class AbstractCalculateBalance
implements ICalculateBalance {
    private static final Log LOGGER = LogFactory.getLog(AbstractCalculateBalance.class);
    protected final PersistBalanceData persistBalanceData;
    private final Map<String, BalanceData> dataSourceBalances;
    private final Map<String, BalanceData> dealBalanceData;
    private Set<Long> undoBalanceLogIds;
    protected String operationType = "";

    public AbstractCalculateBalance(Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dealBalanceData) {
        this.dataSourceBalances = dataSourceBalances;
        this.dealBalanceData = dealBalanceData;
        this.persistBalanceData = new PersistBalanceData();
        this.undoBalanceLogIds = new HashSet<Long>(32);
    }

    @Override
    public void calculateData() throws Exception {
        if (this.dealBalanceData.size() == 0) {
            return;
        }
        HashSet<String> successLatKeys = new HashSet<String>(this.dealBalanceData.size());
        HashSet<String> failedLatKeys = new HashSet<String>(this.dealBalanceData.size());
        try {
            HashSet<String> latKeys = new HashSet<String>(this.dealBalanceData.keySet());
            this.batchLock(latKeys, successLatKeys, failedLatKeys);
            if (failedLatKeys.size() > 0) {
                for (String string : failedLatKeys) {
                    this.dealBalanceData.remove(string);
                }
            }
            for (Map.Entry entry : this.dealBalanceData.entrySet()) {
                String latKey = (String)entry.getKey();
                BalanceData balanceData = (BalanceData)entry.getValue();
                balanceData.orderBalancesDESC();
                List<Balance> balances = balanceData.getBalances();
                if (balances == null || balances.size() == 0) continue;
                BalanceData sourceBalanceData = this.dataSourceBalances.get(latKey);
                LOGGER.info("====AbstractCalculateBalance===latKey:{},sourceBalanceData:{}", (Object)latKey, (Object)sourceBalanceData);
                if (sourceBalanceData == null) {
                    for (Balance balance : balances) {
                        LOGGER.info("====AbstractCalculateBalance===latKey:{},sourceBalanceData:{}, table:{}", new Object[]{latKey, sourceBalanceData, balance.getBalanceTableName()});
                        this.saveNonLatBalance(balance, sourceBalanceData, balanceData);
                    }
                    continue;
                }
                for (Balance balance : balances) {
                    Date startDate = balance.getStartDate();
                    LOGGER.info("====AbstractCalculateBalance===latKey:{},startDate:{}, balance table:{}", new Object[]{latKey, startDate, balance.getBalanceTableName()});
                    Balance sourceBalance = sourceBalanceData.getBalance(startDate);
                    LOGGER.info("====AbstractCalculateBalance===latKey:{},sourceBalance:{}, balance table:{}", new Object[]{latKey, sourceBalance, balance.getBalanceTableName()});
                    if (sourceBalance == null) {
                        this.saveNewBalance(balance, sourceBalanceData, balanceData);
                        continue;
                    }
                    this.updateBalance(sourceBalanceData, balance);
                }
            }
            if (this.undoBalanceLogIds.size() > 0) {
                this.persistBalanceData.setBalanceLogIds(this.undoBalanceLogIds);
            }
            this.persistBalanceData.flush();
        }
        catch (Exception e) {
            LOGGER.error("error:", (Throwable)e);
            throw e;
        }
        finally {
            this.batchRelease(successLatKeys);
        }
    }

    @Override
    public void setUndoBalanceLogIds(Set<Long> undoBalanceLogIds) {
        this.undoBalanceLogIds.addAll(undoBalanceLogIds);
    }

    protected void updateBalance(BalanceData sourceBalanceData, Balance balance) throws Exception {
        BigDecimal difference = BigDecimal.ZERO;
        difference = difference.add(this.doUpdateBalance(sourceBalanceData, balance));
        sourceBalanceData.replaceBalance(balance);
        this.updateFollowBalance(sourceBalanceData, balance, difference);
    }

    protected void saveNewBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        BigDecimal difference = BigDecimal.ZERO;
        difference = difference.add(this.doSaveBalance(sourceBalanceData, balanceData, balance));
        if (sourceBalanceData != null) {
            sourceBalanceData.replaceBalance(balance);
            this.updateFollowBalance(sourceBalanceData, balance, difference);
        }
    }

    protected void updateFollowBalance(BalanceData sourceBalanceData, Balance balance, BigDecimal difference) throws Exception {
        Balance followBalance;
        Date followBalanceDate;
        Balance follow;
        boolean isReset;
        if (BigDecimal.ZERO.compareTo(difference) == 0) {
            return;
        }
        Date startDate = balance.getStartDate();
        List<Balance> balancesList = null;
        if (sourceBalanceData != null) {
            balancesList = sourceBalanceData.getBalances();
        }
        if (balancesList == null) {
            return;
        }
        List<Balance> followBalances = balancesList.stream().filter(e -> e.getStartDate().getTime() > startDate.getTime()).collect(Collectors.toList());
        if (followBalances.size() == 0) {
            return;
        }
        int year = balance.getYear();
        this.orderObjectDESC(followBalances);
        Iterator<Balance> iterator = followBalances.iterator();
        while (iterator.hasNext() && !(isReset = (follow = sourceBalanceData.getBalance(followBalanceDate = (followBalance = iterator.next()).getStartDate())).isReset().booleanValue())) {
            BigDecimal fMonthStart = follow.getMonthStart();
            BigDecimal fMonthBalance = follow.getMonthBalance();
            if (fMonthStart == null) {
                fMonthStart = BigDecimal.ZERO;
            }
            if (fMonthBalance == null) {
                fMonthBalance = BigDecimal.ZERO;
            }
            follow.setMonthStart(fMonthStart.add(difference));
            follow.setMonthBalance(fMonthBalance.add(difference));
            int fYear = follow.getYear();
            if (fYear == year) {
                this.dealFollow(balance, follow);
            } else if (year < fYear) {
                BigDecimal fYearStart = BalanceUtil.dealBigDecimal(follow.getYearStart());
                follow.setYearStart(fYearStart.add(difference));
            }
            follow.setYearBalance(follow.getMonthBalance());
            sourceBalanceData.replaceBalance(follow);
            this.persistBalanceData.updateBalance(follow);
        }
    }

    @Override
    public void dealFollow(Balance balance, Balance follow) {
        BigDecimal yearPayAmount = BalanceUtil.dealBigDecimal(balance.getYearPayAmount());
        BigDecimal yearRecAmount = BalanceUtil.dealBigDecimal(balance.getYearRecAmount());
        BigDecimal fPayAmount = BalanceUtil.dealBigDecimal(follow.getPayAmount());
        BigDecimal fRecAmount = BalanceUtil.dealBigDecimal(follow.getRevenueAmount());
        follow.setYearPayAmount(yearPayAmount.add(fPayAmount));
        follow.setYearRecAmount(yearRecAmount.add(fRecAmount));
    }

    protected BigDecimal doSaveBalance(BalanceData sourceBalanceData, BalanceData balanceData, Balance balance) throws Exception {
        Date startDate = balance.getStartDate();
        Set<Date> dates = null;
        if (sourceBalanceData != null) {
            sourceBalanceData.setStartDate(startDate);
            dates = sourceBalanceData.getStartDates();
        } else {
            dates = balanceData.getStartDates();
        }
        BigDecimal monthStart = balance.getMonthStart();
        if (monthStart == null) {
            monthStart = BigDecimal.ZERO;
        }
        BigDecimal yearPayAmount = BalanceUtil.dealBigDecimal(balance.getYearPayAmount());
        BigDecimal yearRecAmount = BalanceUtil.dealBigDecimal(balance.getYearRecAmount());
        BigDecimal monthBalance = balance.getMonthBalance();
        if (monthBalance == null) {
            monthBalance = BigDecimal.ZERO;
        }
        BigDecimal difference = BigDecimal.ZERO;
        Date preDate = DateUtils.preDate(dates, (Date)startDate);
        Balance preBalance = null;
        if (preDate.getTime() < startDate.getTime()) {
            if (balanceData != null) {
                preBalance = balanceData.getBalance(preDate);
            }
            if (sourceBalanceData != null && preBalance == null) {
                preBalance = sourceBalanceData.getBalance(preDate);
            }
        }
        if (preBalance != null) {
            BigDecimal preMonthBalance;
            monthStart = preMonthBalance = preBalance.getMonthBalance();
        }
        balance.setMonthStart(monthStart);
        BigDecimal newMonthBalance = monthStart.add(monthBalance);
        balance.setMonthBalance(newMonthBalance);
        difference = difference.add(newMonthBalance.subtract(monthStart));
        balance.setYearBalance(newMonthBalance);
        if (preBalance != null) {
            int preYear = preBalance.getYear();
            int year = balance.getYear();
            BigDecimal preYearPayAmount = BalanceUtil.dealBigDecimal(preBalance.getYearPayAmount());
            BigDecimal preYearRecAmount = BalanceUtil.dealBigDecimal(preBalance.getYearRecAmount());
            BigDecimal preYearStart = BalanceUtil.dealBigDecimal(preBalance.getYearStart());
            BigDecimal preYearBalance = BalanceUtil.dealBigDecimal(preBalance.getYearBalance());
            if (preYear < year) {
                balance.setYearStart(preYearBalance);
            } else {
                balance.setYearStart(preYearStart);
                balance.setYearPayAmount(preYearPayAmount.add(yearPayAmount));
                balance.setYearRecAmount(preYearRecAmount.add(yearRecAmount));
            }
        }
        this.persistBalanceData.saveBalance(balance);
        return difference;
    }

    private void orderObjectDESC(List<Balance> balances) {
        Collections.sort(balances, new Comparator<Balance>(){

            @Override
            public int compare(Balance b1, Balance b2) {
                try {
                    if (b1.getStartDate().getTime() < b2.getStartDate().getTime()) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    LOGGER.info("error:", (Object)e);
                    return 0;
                }
            }
        });
    }

    private void batchLock(Set<String> latKeys, Set<String> successLatKeys, Set<String> failedLatKeys) {
        try {
            ArrayList<String> latKeyList = new ArrayList<String>(latKeys.size());
            latKeyList.addAll(latKeys);
            Map lockResultMap = MutexServiceHelper.batchRequest(latKeyList, (String)"fi-cas-business", (String)"balanceCalculate");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (Boolean.TRUE.equals(next.getValue())) {
                    successLatKeys.add(key);
                    continue;
                }
                failedLatKeys.add(key);
            }
            if (failedLatKeys != null && failedLatKeys.size() > 0) {
                LOGGER.info(ResManager.loadKDString((String)String.format("\u52a0\u9501\uff1a\u4f59\u989d\u7ef4\u5ea6\u4fe1\u606f\uff08\u7ec4\u7ec7_\u8d26\u6237_\u5e01\u79cd\uff09\u201c %s\u201d \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", failedLatKeys), (String)"AbstractCalculateBalance_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e1) {
            LOGGER.error("to get lock Exception is:", (Throwable)e1);
            throw e1;
        }
    }

    private void batchRelease(Set<String> successLatKeys) {
        try {
            if (successLatKeys.size() == 0) {
                return;
            }
            ArrayList<String> keys = new ArrayList<String>(successLatKeys.size());
            keys.addAll(successLatKeys);
            LOGGER.info("\u91ca\u653e\u9501\uff1a\u4f59\u989d\u7ef4\u5ea6\u4fe1\u606f(\u7ec4\u7ec7_\u8d26\u6237_\u5e01\u79cd)\uff1a{}", successLatKeys);
            Map releaseResultMap = MutexServiceHelper.batchRelease(keys, (String)"fi-cas-business", (String)"balanceCalculate");
            LOGGER.info("\u91ca\u653e\u9501\uff1a\u4f59\u989d\u7ef4\u5ea6\u4fe1\u606f(\u7ec4\u7ec7_\u8d26\u6237_\u5e01\u79cd)\u7ed3\u679c\u96c6\u4fe1\u606f: {}", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            LOGGER.error((Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u91ca\u653e\u9501\uff1a\u4f59\u989d\u7ef4\u5ea6\u4fe1\u606f\uff08\u7ec4\u7ec7_\u8d26\u6237_\u5e01\u79cd\uff09\u7ed3\u679c\uff1a\u5931\u8d25\u3002", (String)"AbstractCalculateBalance_3", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    protected void addFieldValue(Balance balance) {
        if (FromType.RESET.getValue().equals(this.operationType)) {
            return;
        }
        BigDecimal iniBalance = balance.getMonthStart();
        BigDecimal yearDebit = balance.getYearDebit();
        BigDecimal yearCredit = balance.getYearCredit();
        boolean isSate = balance.isState();
        if (isSate) {
            BigDecimal yearStart = iniBalance.subtract(yearCredit).add(yearDebit);
            balance.setYearStart(yearStart);
            balance.setYearBalance(iniBalance);
            balance.setYearRecAmount(yearCredit);
            balance.setYearPayAmount(yearDebit);
        } else {
            BigDecimal yearStart = iniBalance.subtract(yearDebit).add(yearCredit);
            balance.setYearStart(yearStart);
            balance.setYearBalance(iniBalance);
            balance.setYearRecAmount(yearDebit);
            balance.setYearPayAmount(yearCredit);
        }
    }

    @Override
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    protected abstract BigDecimal doUpdateBalance(BalanceData var1, Balance var2) throws Exception;

    protected abstract void saveNonLatBalance(Balance var1, BalanceData var2, BalanceData var3) throws Exception;
}

