/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.fi.cas.business.balancemodel.calculate.AbstractCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.util.DateUtils;

public class InitCalculateBalance
extends AbstractCalculateBalance {
    public InitCalculateBalance(Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dealBalanceData) {
        super(dataSourceBalances, dealBalanceData);
    }

    @Override
    protected BigDecimal doUpdateBalance(BalanceData sourceBalanceData, Balance balance) throws Exception {
        Date startDate = balance.getStartDate();
        Balance sourceBalance = sourceBalanceData.getBalance(startDate);
        BigDecimal sourceMonthBalance = sourceBalance.getMonthBalance();
        BigDecimal sourceMonthStart = sourceBalance.getMonthStart();
        BigDecimal sourceYearStart = BalanceUtil.dealBigDecimal(sourceBalance.getYearStart());
        BigDecimal sourcePayAmount = BalanceUtil.dealBigDecimal(sourceBalance.getYearPayAmount());
        BigDecimal sourceRecAmount = BalanceUtil.dealBigDecimal(sourceBalance.getYearRecAmount());
        BigDecimal monthStart = balance.getMonthStart();
        BigDecimal difference = BigDecimal.ZERO;
        balance.setMonthStart(monthStart);
        difference = difference.add(monthStart.subtract(sourceMonthStart));
        BigDecimal initMonthBalance = sourceMonthBalance.add(difference);
        balance.setMonthBalance(initMonthBalance);
        Balance originBalance = sourceBalanceData.getBalance(balance.getStartDate());
        if (originBalance != null) {
            balance.setStroke(originBalance.getStroke());
            balance.setPayAmount(originBalance.getPayAmount());
            balance.setRevenueAmount(originBalance.getRevenueAmount());
        }
        if (FromType.RESET.getValue().equals(this.operationType)) {
            balance.setYearStart(sourceYearStart);
            balance.setYearBalance(initMonthBalance);
            balance.setYearRecAmount(sourceRecAmount);
            balance.setYearPayAmount(sourcePayAmount);
        }
        super.addFieldValue(balance);
        this.persistBalanceData.updateBalance(balance);
        return difference;
    }

    @Override
    protected void saveNonLatBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        super.addFieldValue(balance);
        this.persistBalanceData.saveBalance(balance);
    }

    @Override
    protected void saveNewBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        super.saveNewBalance(balance, sourceBalanceData, balanceData);
    }

    @Override
    protected BigDecimal doSaveBalance(BalanceData sourceBalanceData, BalanceData balanceData, Balance balance) throws Exception {
        BigDecimal monthBalance = balance.getMonthBalance();
        if (monthBalance == null) {
            monthBalance = BigDecimal.ZERO;
        }
        BigDecimal difference = BigDecimal.ZERO;
        Set<Date> dates = sourceBalanceData.getStartDates();
        Date startDate = balance.getStartDate();
        dates.add(startDate);
        Date preDate = DateUtils.preDate(dates, (Date)startDate);
        Balance preBalance = sourceBalanceData.getBalance(preDate);
        if (preBalance != null) {
            BigDecimal preMonthBalance = preBalance.getMonthBalance();
            difference = monthBalance.subtract(preMonthBalance);
        } else {
            difference = difference.add(monthBalance);
        }
        if (preBalance != null) {
            balance.setYearStart(BalanceUtil.dealBigDecimal(preBalance.getYearStart()));
            balance.setYearBalance(BalanceUtil.dealBigDecimal(preBalance.getYearBalance()).add(difference));
            balance.setYearPayAmount(BalanceUtil.dealBigDecimal(preBalance.getYearPayAmount()));
            balance.setYearRecAmount(BalanceUtil.dealBigDecimal(preBalance.getYearRecAmount()));
        }
        balance.setMonthStart(monthBalance);
        balance.setMonthBalance(monthBalance);
        super.addFieldValue(balance);
        this.persistBalanceData.saveBalance(balance);
        return difference;
    }
}

