/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.calculate.CalculateServiceFactory;
import kd.fi.cas.business.balancemodel.calculate.ICalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dao.CalculateBalanceDao;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceInitOrAnti;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.service.ICalculateBalanceService;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelBalanceHelper;
import kd.fi.cas.util.StringUtils;

public class CalculateBalanceServiceService
implements ICalculateBalanceService {
    private static Log logger = LogFactory.getLog(CalculateBalanceServiceService.class);

    private CalculateBalanceServiceService() {
    }

    public static CalculateBalanceServiceService getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public boolean doInitOrAntiInit() throws Exception {
        try {
            CalculateBalanceDao calculateBalanceDao = CalculateBalanceDao.getInstance();
            BalanceInitOrAnti balanceInitOrAnti = calculateBalanceDao.balance4InitORAnti();
            for (BalanceInitOrAnti.BalanceInitOrAntiInit bai : balanceInitOrAnti.getBalanceInitOrAntiInitList()) {
                HashSet<Long> orgIds = new HashSet<Long>(8);
                String type = bai.getBalanceType();
                String tableName = BalanceUtil.getTableName(type);
                Map<String, BalanceData> initBalances = this.balance4InitOrAnti(bai, orgIds);
                if (initBalances == null || initBalances.size() == 0) {
                    logger.warn("\u521d\u59cb\u5316\u65e5\u5fd7\u4e2d\u65e0\u6570\u636e\uff0c\u6216\u6570\u636e\u5f02\u5e38\u3002\u7ec4\u7ec7\uff1a{}", orgIds);
                    continue;
                }
                String operation = "";
                String formType = bai.getFormType();
                operation = FromType.INIT_CASH.getValue().equals(formType) || FromType.INIT_STATE.getValue().equals(formType) || FromType.RESET.getValue().equals(formType) || FromType.START_STATE.getValue().equals(formType) ? "BALANCE_INIT" : "BALANCE_ANTI_INIT";
                Map<String, BalanceData> dataSourceBalances = calculateBalanceDao.getDataSource(orgIds, tableName, BalanceUtil.getEntityName(type));
                ICalculateBalance calculateBalance = CalculateServiceFactory.getInstance().getBean(operation, dataSourceBalances, initBalances);
                calculateBalance.setOperationType(formType);
                calculateBalance.calculateData();
            }
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        return false;
    }

    @Override
    public boolean reCalculate(RequestBalanceParameter requestBalanceParameter) throws Exception {
        block20: {
            Set<Long> orgIds = requestBalanceParameter.getOrgIds();
            String type = requestBalanceParameter.getType();
            String tableName = BalanceUtil.getTableName(type);
            Date startDate = requestBalanceParameter.getStartDate();
            try (TXHandle tx = TX.required();){
                try {
                    if (BalanceType.STATE.getValue().equals(type)) {
                        Map<Long, DynamicObject> startInitState = BalanceModelBalanceHelper.resetStatement(orgIds);
                        requestBalanceParameter.setStartInitState(startInitState);
                    } else {
                        Map<String, Boolean> resetJournals = BalanceModelBalanceHelper.resetJournal(orgIds, type);
                        requestBalanceParameter.setResetJournals(resetJournals);
                    }
                    CalculateBalanceDao calculateBalanceDao = CalculateBalanceDao.getInstance();
                    Set<Long> undoBalanceLogIds = calculateBalanceDao.getUndoBalanceLogIds();
                    Map<String, BalanceData> dailyBalances = calculateBalanceDao.balanceData4Daily(requestBalanceParameter, type, tableName);
                    Map<String, BalanceData> dataSourceBalances = calculateBalanceDao.getDataSource(orgIds, tableName, BalanceUtil.getEntityName(type));
                    this.compareDailyAndSourceData(dataSourceBalances, dailyBalances, startDate);
                    ICalculateBalance calculateBalance = CalculateServiceFactory.getInstance().getBean("BALANCE_RECALCULATE", dataSourceBalances, dailyBalances);
                    if (undoBalanceLogIds != null) {
                        calculateBalance.setUndoBalanceLogIds(undoBalanceLogIds);
                    }
                    calculateBalance.calculateData();
                    if (requestBalanceParameter.getRecomputeCurrent().booleanValue()) {
                        BalanceModelBalanceHelper.reset(type, orgIds, requestBalanceParameter.getStartDate());
                        break block20;
                    }
                    BalanceModelBalanceHelper.reset(type, orgIds, null);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("error:", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("error:", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean calculateLog(String type) throws Exception {
        try {
            logger.info("======begin CalculateBalanceServiceService==calculateLog, traceId:{}", (Object)RequestContext.get().getTraceId());
            HashSet<Long> orgIds = new HashSet<Long>(16);
            String tableName = BalanceUtil.getTableName(type);
            CalculateBalanceDao calculateBalanceDao = CalculateBalanceDao.getInstance();
            Map<String, BalanceData> dealBalanceData = calculateBalanceDao.balanceData4Log(type, tableName, orgIds);
            Map<String, BalanceData> dataSourceBalances = calculateBalanceDao.getDataSource(orgIds, tableName, BalanceUtil.getEntityName(type));
            ICalculateBalance calculateBalance = CalculateServiceFactory.getInstance().getBean("BALANCE_LOG", dataSourceBalances, dealBalanceData);
            calculateBalance.calculateData();
            logger.info("======end CalculateBalanceServiceService==calculateLog, traceId:{}", (Object)RequestContext.get().getTraceId());
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        return false;
    }

    private Map<String, BalanceData> balance4InitOrAnti(BalanceInitOrAnti.BalanceInitOrAntiInit bai, Set<Long> orgIds) {
        Long currencyId;
        Long accId;
        String latKey;
        BalanceData balanceData;
        HashMap<String, BalanceData> initBalanceData = new HashMap<String, BalanceData>();
        Long orgId = bai.getOrg().getLong("id");
        orgIds.add(orgId);
        String balanceType = bai.getBalanceType();
        DynamicObject account = null;
        account = BalanceType.CASH.getValue().equals(balanceType) ? bai.getCashAcct() : bai.getBankAcct();
        if (account == null) {
            return new HashMap<String, BalanceData>(2);
        }
        boolean isReset = false;
        String formType = bai.getFormType();
        if (FromType.RESET.getValue().equals(formType) || FromType.INIT_STATE.getValue().equals(formType) || FromType.START_STATE.getValue().equals(formType)) {
            isReset = true;
        }
        if ((balanceData = (BalanceData)initBalanceData.get(latKey = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgId, accId = Long.valueOf(account.getLong("id")), currencyId = Long.valueOf(bai.getCurrency().getLong("id"))}))) == null) {
            balanceData = new BalanceData();
            initBalanceData.put(latKey, balanceData);
        }
        HashSet<Long> initLogIds = new HashSet<Long>(2);
        initLogIds.add(bai.getId());
        DynamicObject period = bai.getPeriod();
        Balance balance = new Balance();
        String type = bai.getBalanceType();
        String tableName = BalanceUtil.getTableName(type);
        balance.setBalanceTableName(tableName);
        balance.setOrgId(orgId);
        balance.setAccountId(accId);
        balance.setCurrencyId(currencyId);
        balance.setMonthStart(bai.getAmount());
        balance.setMonthBalance(bai.getAmount());
        balance.setPayAmount(BigDecimal.ZERO);
        balance.setRevenueAmount(BigDecimal.ZERO);
        balance.setStartDate(period.getDate("begindate"));
        balance.setEndDate(period.getDate("enddate"));
        balance.setYear(period.getInt("periodyear"));
        balance.setMonth(period.getInt("periodnumber"));
        balance.setReset(isReset);
        balance.setStroke(0);
        balance.setInitLogIds(initLogIds);
        balance.setYearCredit(bai.getYearCredit());
        balance.setYearDebit(bai.getYearDebit());
        balance.setState(BalanceType.STATE.getValue().equals(type));
        balanceData.setBalance(balance);
        balanceData.setStartDate(period.getDate("begindate"));
        return initBalanceData;
    }

    private void compareDailyAndSourceData(Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dailyBalances, Date startDate) {
        for (Map.Entry<String, BalanceData> dataSourceBalance : dataSourceBalances.entrySet()) {
            String lat = dataSourceBalance.getKey();
            BalanceData balanceData = dataSourceBalance.getValue();
            BalanceData dailyBalanceData = dailyBalances.get(lat);
            if (dailyBalanceData == null) {
                logger.info("\u4f59\u989d\u8868\u4e2d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u4e3a\uff1a{}\u7684\u6570\u636e", (Object)lat);
                continue;
            }
            Set<Date> balanceDataStartDate = balanceData.getStartDates();
            Set<Date> dailyBalanceDataStartDate = dailyBalanceData.getStartDates();
            if (dailyBalanceDataStartDate.size() > balanceDataStartDate.size() || dailyBalanceDataStartDate.size() >= balanceDataStartDate.size()) continue;
            this.computeInSourceData(balanceDataStartDate, dailyBalanceDataStartDate, balanceData, dailyBalanceData, startDate);
        }
    }

    private void computeInSourceData(Set<Date> balanceDataStartDate, Set<Date> dailyBalanceDataStartDate, BalanceData balanceData, BalanceData dailyBalanceData, Date startDate) {
        HashSet<Date> remainDate = new HashSet<Date>(balanceDataStartDate);
        remainDate.removeAll(dailyBalanceDataStartDate);
        HashSet<Date> moreThanDate = new HashSet<Date>(16);
        for (Date date : remainDate) {
            if (date.getTime() >= startDate.getTime()) continue;
            moreThanDate.add(date);
        }
        remainDate.removeAll(moreThanDate);
        for (Date sourceStartDate : remainDate) {
            Balance sourceBalance = balanceData.getBalance(sourceStartDate);
            if (sourceBalance == null) continue;
            Balance balance = new Balance();
            balance.setBalanceTableName(sourceBalance.getBalanceTableName());
            balance.setOrgId(sourceBalance.getOrgId());
            balance.setAccountId(sourceBalance.getAccountId());
            balance.setCurrencyId(sourceBalance.getCurrencyId());
            balance.setMonthBalance(BigDecimal.ZERO);
            balance.setPayAmount(BigDecimal.ZERO);
            balance.setRevenueAmount(BigDecimal.ZERO);
            balance.setStartDate(sourceBalance.getStartDate());
            balance.setEndDate(sourceBalance.getEndDate());
            balance.setYear(sourceBalance.getYear());
            balance.setMonth(sourceBalance.getMonth());
            balance.setStroke(sourceBalance.getStroke());
            balance.setReset(sourceBalance.getReset());
            balance.setYearRecAmount(BigDecimal.ZERO);
            balance.setYearPayAmount(BigDecimal.ZERO);
            dailyBalanceData.setBalance(balance);
        }
    }

    static class Singleton {
        private static final CalculateBalanceServiceService INSTANCE = new CalculateBalanceServiceService();

        Singleton() {
        }
    }
}

