/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.check;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.check.BalanceCheckResult;
import kd.fi.cas.business.balancemodel.log.bean.OccurDataInfo;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;
import kd.fi.cas.business.balancemodel.service.BalanceDataService;
import kd.fi.cas.business.balancemodel.service.BalanceOccurDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.util.DateUtils;

public class BalanceModelCheckHelper {
    private static final Log log = LogFactory.getLog(BalanceModelCheckHelper.class);

    public static BalanceCheckResult checkBalance(RequestBalanceParameter requestBalanceParameter) {
        BalanceCheckResult checkResult = new BalanceCheckResult();
        if (requestBalanceParameter == null) {
            return checkResult;
        }
        try {
            requestBalanceParameter.setQueryByPeriod(true);
            checkResult = BalanceModelCheckHelper.checkBalanceData(requestBalanceParameter);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u68c0\u67e5\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[traceId:%1$s]\u3002", (String)"BalanceModelCheckHelper_1", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
        return checkResult;
    }

    private static BalanceCheckResult checkBalanceData(RequestBalanceParameter requestBalanceParameter) throws Exception {
        Map<String, OccurDataInfo> balanceObjs = BalanceModelCheckHelper.getBalanceObjs(requestBalanceParameter);
        Map<String, OccurDataInfo> occurObjs = BalanceModelCheckHelper.sumOccurObj(requestBalanceParameter);
        BalanceCheckResult result = new BalanceCheckResult();
        result.setReCalObj(new RequestBalanceParameter());
        BalanceModelCheckHelper.simpleCopy(result.getReCalObj(), requestBalanceParameter);
        if (balanceObjs.size() == 0 && occurObjs.size() > 0) {
            result.getReCalObj().setAccountIds(requestBalanceParameter.getAccountIds());
            result.setCheckOk(false);
            return result;
        }
        result.getReCalObj().setAccountIds(new HashSet<Long>(16));
        for (Map.Entry<String, OccurDataInfo> entry : balanceObjs.entrySet()) {
            OccurDataInfo occurObj;
            String key = entry.getKey();
            OccurDataInfo balanceObj = entry.getValue();
            if (BalanceModelCheckHelper.isSame(balanceObj, occurObj = occurObjs.get(key) == null ? new OccurDataInfo() : occurObjs.get(key))) continue;
            result.getReCalObj().getAccountIds().add(balanceObj.getAcctid());
            result.setCheckOk(false);
        }
        return result;
    }

    private static void simpleCopy(RequestBalanceParameter a, RequestBalanceParameter b) {
        a.setOrgIds(b.getOrgIds());
        a.setCurrencyIds(b.getCurrencyIds());
        a.setAccountIds(b.getAccountIds());
        a.setStartDate(b.getStartDate());
        a.setEndDate(b.getEndDate());
        a.setType(b.getType());
        a.setReset(b.isReset());
        a.setRecomputeCurrent(b.getRecomputeCurrent());
    }

    private static Map<String, OccurDataInfo> sumOccurObj(RequestBalanceParameter requestBalanceParameter) {
        return BalanceOccurDataService.getInstance().sumOccurDatas(BalanceOccurDataService.getInstance().buildOccurDatas(Collections.singletonList(requestBalanceParameter)));
    }

    private static boolean isSame(OccurDataInfo balanceObj, OccurDataInfo occurObj) {
        return balanceObj.getCreditamount().compareTo(occurObj.getCreditamount()) == 0 && balanceObj.getDebitamount().compareTo(occurObj.getDebitamount()) == 0 && balanceObj.getCount() == occurObj.getCount();
    }

    private static Map<String, OccurDataInfo> getBalanceObjs(RequestBalanceParameter requestBalanceParameter) throws Exception {
        HashMap<String, OccurDataInfo> returns = new HashMap<String, OccurDataInfo>(16);
        List<ResponseBalances> balances = BalanceDataService.getInstance().getBalances(Collections.singletonList(requestBalanceParameter), BalanceQueryType.BEGINDATE);
        for (ResponseBalances row : balances) {
            OccurDataInfo occurInfo = BalanceModelCheckHelper.getInfoObj(row);
            returns.put(BalanceModelCheckHelper.getKey(occurInfo), occurInfo);
        }
        return returns;
    }

    public static String getKey(OccurDataInfo dataInfo) {
        return BalanceModelCheckHelper.getKey(dataInfo.getStartDate(), dataInfo.getOrgid(), dataInfo.getAcctid(), dataInfo.getCurrencyid());
    }

    public static String getKey(Date date, Long orgid, Long acctid, Long currencyid) {
        return StringUtils.join((Object[])new Serializable[]{DateUtils.getMonthDay((Date)date), "!", orgid, "!", acctid, "!", currencyid});
    }

    private static OccurDataInfo getInfoObj(ResponseBalances row) {
        return BalanceModelLogUtil.buildDataInfo(0L, "", row.getOrgId(), row.getAccountId(), row.getCurrencyId(), row.getBalance().getPayAmount(), row.getBalance().getRevenueAmount(), null, true, row.getStartDate(), row.getEndDate(), row.getBalance().getStroke());
    }
}

