/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class BalanceModelBalanceHelper {
    private static Log logger = LogFactory.getLog(BalanceModelBalanceHelper.class);
    private static final String TYPE_JOURNAL = "2";

    public static Map<Long, DynamicObject> resetStatement(Set<Long> orgIds) throws Exception {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(64);
        try {
            DynamicObject[] casRecInit;
            DynamicObject[] initStates;
            HashMap<Long, DynamicObject> orgPeriods = new HashMap<Long, DynamicObject>(64);
            for (DynamicObject initState : initStates = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"org, recperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)})) {
                DynamicObject org = initState.getDynamicObject("org");
                Long orgId = org.getLong("id");
                DynamicObject recPeriod = initState.getDynamicObject("recperiod");
                orgPeriods.put(orgId, recPeriod);
            }
            if (orgPeriods.size() == 0) {
                return result;
            }
            for (DynamicObject row : casRecInit = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id, org, billno,initperiod, currentperiod,isfinishinit, modifytime, entrybank, entrybank.bank_accountbank, entrybank.bank_currency, entrybank.bank_openorg, entrybank.bank_statementbalance", (QFilter[])new QFilter[]{new QFilter("org", "in", orgPeriods.keySet()), new QFilter("isfinishinit", "=", (Object)"1")})) {
                Long periodId;
                DynamicObject org = row.getDynamicObject("org");
                Long orgId = org.getLong("id");
                Long initPeriodId = row.getDynamicObject("initperiod").getLong("id");
                DynamicObject period = (DynamicObject)orgPeriods.get(orgId);
                if (period == null || EmptyUtil.isEmpty((DynamicObject)period) || (periodId = Long.valueOf(period.getLong("id"))).compareTo(initPeriodId) != 0) continue;
                result.put(orgId, period);
            }
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        return result;
    }

    public static Map<String, Boolean> resetJournal(Set<Long> orgIds, String type) throws Exception {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(64);
        try {
            DynamicObject[] resetInitBalance;
            QFilter qOrg = new QFilter("org", "in", orgIds);
            QFilter qStatus = new QFilter("billstatus", "=", (Object)"C");
            QFilter qType = new QFilter("entryentity.type", "=", (Object)"bank");
            if (BalanceType.STATE.getValue().equals(type)) {
                qType = new QFilter("entryentity.type", "=", (Object)"cash");
            }
            for (DynamicObject rib : resetInitBalance = BusinessDataServiceHelper.load((String)"cas_resetinitbalance", (String)"id, billno, org, resetinitbalperiod,modifytime, entryentity, entryentity.bank_accountbank, entryentity.initbalance, entryentity.cash_accountcash, entryentity.currency, entryentity.discarded", (QFilter[])new QFilter[]{qOrg, qStatus, qType})) {
                DynamicObject org = rib.getDynamicObject("org");
                Long orgId = org.getLong("id");
                DynamicObject resetPeriod = rib.getDynamicObject("resetinitbalperiod");
                Long resetPeriodId = resetPeriod.getLong("id");
                DynamicObjectCollection entryEntities = rib.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntities) {
                    DynamicObject currency;
                    Boolean discard = entry.getBoolean("discarded");
                    if (discard.booleanValue()) continue;
                    Long account = null;
                    if (TYPE_JOURNAL.equals(type)) {
                        DynamicObject bank = entry.getDynamicObject("bank_accountbank");
                        if (bank == null || EmptyUtil.isEmpty((DynamicObject)bank)) continue;
                        account = bank.getLong("id");
                    } else {
                        DynamicObject cash = entry.getDynamicObject("cash_accountcash");
                        if (cash == null || EmptyUtil.isEmpty((DynamicObject)cash)) continue;
                        account = cash.getLong("id");
                    }
                    if ((currency = entry.getDynamicObject("currency")) == null || EmptyUtil.isEmpty((DynamicObject)currency)) continue;
                    Long currencyId = currency.getLong("id");
                    String key = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{type, orgId, account, currencyId, resetPeriodId});
                    result.put(key, Boolean.TRUE);
                }
            }
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        return result;
    }

    public static void reset(String type, Set<Long> resetOrgIds, Date startDate) throws Exception {
        try {
            if (BalanceType.STATE.getValue().equals(type)) {
                BalanceModelBalanceHelper.resetStateLog(resetOrgIds, startDate);
            } else {
                BalanceModelBalanceHelper.resetJournalLog(type, resetOrgIds, startDate);
            }
        }
        catch (Exception e) {
            logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u6267\u884c\u91cd\u7f6e\u4fe1\u606f\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
        }
    }

    private static void resetStateLog(Set<Long> resetOrgIds, Date startDate) {
        QFilter qFilter = new QFilter("org", "in", resetOrgIds).and(new QFilter("isfinishinit", "=", (Object)"1"));
        if (startDate != null) {
            qFilter.and("initperiod.begindate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true));
            qFilter.and("initperiod.enddate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)false));
        }
        DynamicObject[] casRecInit = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id, org, billno,initperiod, currentperiod,isfinishinit, modifytime, entrybank, entrybank.bank_accountbank, entrybank.bank_currency, entrybank.bank_openorg, entrybank.bank_statementbalance", (QFilter[])new QFilter[]{qFilter}, (String)"id ASC");
        if (startDate != null) {
            ArrayList<DynamicObject> saveObject = new ArrayList<DynamicObject>(casRecInit.length);
            for (DynamicObject casRec : casRecInit) {
                DynamicObject initPeriod = casRec.getDynamicObject("initperiod");
                Date periodDate = DateUtils.getDataFormat((Date)initPeriod.getDate("begindate"), (boolean)true);
                Date delStartDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
                if (periodDate.getTime() != delStartDate.getTime()) continue;
                saveObject.add(casRec);
            }
            if (saveObject.size() > 0) {
                BalanceModelLogHelper.doBalanceModelLog(saveObject.toArray(new DynamicObject[0]), OperateType.ADD);
            }
        } else {
            BalanceModelLogHelper.doBalanceModelLog(casRecInit, OperateType.ADD);
        }
    }

    private static void resetJournalLog(String type, Set<Long> resetOrgIds, Date startDate) {
        QFilter qOrg = new QFilter("org", "in", resetOrgIds);
        QFilter qStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qDiscard = new QFilter("entryentity.discarded", "=", (Object)"0");
        String typeName = "";
        if (BalanceType.JOURNAL.getValue().equals(type)) {
            qDiscard.and(new QFilter("entryentity.type", "=", (Object)"bank"));
            typeName = "bank";
        } else {
            qDiscard.and(new QFilter("entryentity.type", "=", (Object)"cash"));
            typeName = "cash";
        }
        QFilter qFilter = qOrg.and(qStatus).and(qDiscard);
        DynamicObject[] resetInitBalance = BusinessDataServiceHelper.load((String)"cas_resetinitbalance", (String)"id, billno, org, resetinitbalperiod,modifytime,entryentity.bank_accountbank, entryentity.initbalance, entryentity.cash_accountcash, entryentity.currency, entryentity.discarded, entryentity.type", (QFilter[])new QFilter[]{qFilter}, (String)"id ASC");
        ArrayList<DynamicObject> addObjects = new ArrayList<DynamicObject>(resetInitBalance.length);
        for (DynamicObject dynamicObject : resetInitBalance) {
            if (startDate != null) {
                DynamicObject resetInitBalPeriod = dynamicObject.getDynamicObject("resetinitbalperiod");
                Date periodStart = DateUtils.getDataFormat((Date)resetInitBalPeriod.getDate("begindate"), (boolean)true);
                Date delStartDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
                if (periodStart.getTime() != delStartDate.getTime()) continue;
                addObjects.add(dynamicObject);
            }
            DynamicObjectCollection entity = dynamicObject.getDynamicObjectCollection("entryentity");
            String finalTypeName = typeName;
            List remove = entity.stream().filter(o -> !o.getString("type").equals(finalTypeName) || o.getBoolean("discarded")).collect(Collectors.toList());
            entity.removeAll(remove);
        }
        if (addObjects.size() > 0) {
            BalanceModelLogHelper.doBalanceModelLog(addObjects.toArray(new DynamicObject[0]), OperateType.ADD);
        } else {
            BalanceModelLogHelper.doBalanceModelLog(resetInitBalance, OperateType.ADD);
        }
    }
}

