/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.log.bean.BillDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.type.AbstractBalanceModelLog;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogConstant;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;
import kd.fi.cas.helper.PeriodHelper;

public class BalanceModelLogInit
extends AbstractBalanceModelLog {
    private static final List<String> LOGINSERTFIELDS = BalanceModelLogConstant.LOGINSERTFIELDS_RESET;

    public BalanceModelLogInit() {
        this.logTable = "t_cas_balancelog_init";
        this.insertFields = LOGINSERTFIELDS;
        this.isNeedOldData = false;
    }

    public static BalanceModelLogInit getInstance(String formid) {
        formId = formid;
        return Singleton.instance;
    }

    @Override
    protected Collection<BillDataInfo> buildBillInfos(DynamicObject[] bills) {
        ArrayList<BillDataInfo> returns = new ArrayList<BillDataInfo>(bills.length);
        Set<String> startInfos = this.getStartInfos(bills);
        for (DynamicObject bill : bills) {
            if (!this.isNeedDo(bill, startInfos)) continue;
            if (!"cas_rec_init".equalsIgnoreCase(formId)) {
                returns.addAll(this.buildSubBillInfos(bill, "entrycash", "cash_accountcash", "cash_currency", "cash_balance"));
            }
            returns.addAll(this.buildSubBillInfos(bill, "entrybank", "bank_accountbank", "bank_currency", this.getAmountField()));
        }
        return returns;
    }

    private Collection<BillDataInfo> buildSubBillInfos(DynamicObject bill, String entryName, String accountField, String currencyField, String amountField) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
        ArrayList<BillDataInfo> returns = new ArrayList<BillDataInfo>(entrys == null ? 1 : entrys.size());
        if (entrys == null || entrys.size() == 0) {
            return returns;
        }
        Long currentPeriod_id = this.getCurrentPeriod(bill);
        for (DynamicObject entry : entrys) {
            BillDataInfo dataInfo = BalanceModelLogUtil.buildDataInfo(bill.getLong("id"), bill.getString("billno"), bill.getDynamicObject("org") == null ? 0L : Long.parseLong(bill.getDynamicObject("org").getPkValue().toString()), entry.getDynamicObject(accountField) == null ? 0L : Long.parseLong(entry.getDynamicObject(accountField).getPkValue().toString()), entry.getDynamicObject(currencyField) == null ? 0L : Long.parseLong(entry.getDynamicObject(currencyField).getPkValue().toString()), entry.getBigDecimal(amountField), BigDecimal.ZERO, null, currentPeriod_id, false);
            dataInfo.setCashAcct("entrycash".equalsIgnoreCase(entryName));
            BigDecimal yearDebit = entry.getBigDecimal(this.getYearDebit(entryName));
            BigDecimal yearCredit = entry.getBigDecimal(this.getYearCredit(entryName));
            dataInfo.setYearCredit(yearCredit == null ? BigDecimal.ZERO : yearCredit);
            dataInfo.setYearDebit(yearDebit == null ? BigDecimal.ZERO : yearDebit);
            returns.add(dataInfo);
        }
        return returns;
    }

    private Long getCurrentPeriod(DynamicObject bill) {
        if (bill.get("currentperiod") instanceof DynamicObject) {
            return bill.getDynamicObject("currentperiod").getLong("id");
        }
        return PeriodHelper.getPeriodById((long)bill.getLong("currentperiod")).getLong("id");
    }

    private Set<String> getStartInfos(DynamicObject[] bills) {
        Set ids = Stream.of(bills).map(e -> e.getLong("org.id")).collect(Collectors.toSet());
        QFilter filters = new QFilter("org.id", "in", ids);
        HashSet<String> returns = new HashSet<String>(bills.length);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_rec_edc", (String)"org.id,recperiod.id", (QFilter[])filters.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                returns.add(this.getOrgPeriodKey(row.getLong("org.id"), row.getLong("recperiod.id")));
            }
        }
        return returns;
    }

    @Override
    protected void getExtendObjs(List<Object> valueLst, BillDataInfo row, boolean isDel) {
        valueLst.add(this.getBalanceType(row).getValue());
        valueLst.add(row.getPeriod());
        valueLst.add(this.getFromType().toString());
        valueLst.add(isDel ? row.getYearDebit().negate() : row.getYearDebit());
        valueLst.add(isDel ? row.getYearCredit().negate() : row.getYearCredit());
    }

    private boolean isNeedDo(DynamicObject bill, Set<String> startInfos) {
        if ("cas_cashmgtinit".equalsIgnoreCase(formId)) {
            return true;
        }
        return startInfos.contains(this.getOrgPeriodKey(bill.getLong("org.id"), bill.getLong("currentperiod.id")));
    }

    private String getOrgPeriodKey(Long orgId, Long periodId) {
        return StringUtils.join((Object[])new Serializable[]{orgId, "!", periodId});
    }

    @Override
    protected BigDecimal getAmount(BillDataInfo row) {
        BigDecimal debitAmount = row.getDebitamount();
        BigDecimal creditAmount = row.getCreditamount();
        return debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount : debitAmount;
    }

    private String getAmountField() {
        switch (formId) {
            case "cas_rec_init": {
                return "bank_statementbalance";
            }
            case "cas_cashmgtinit": {
                return "bank_journalbalance";
            }
        }
        return "";
    }

    private String getYearDebit(String entryName) {
        switch (formId) {
            case "cas_rec_init": {
                return "bank_statementdebit";
            }
            case "cas_cashmgtinit": {
                if ("entrycash".equalsIgnoreCase(entryName)) {
                    return "cash_yeardebit";
                }
                return "bank_journaldebit";
            }
        }
        return "";
    }

    private String getYearCredit(String entryName) {
        switch (formId) {
            case "cas_rec_init": {
                return "bank_statementcredit";
            }
            case "cas_cashmgtinit": {
                if ("entrycash".equalsIgnoreCase(entryName)) {
                    return "cash_yearcredit";
                }
                return "bank_journalcredit";
            }
        }
        return "";
    }

    private FromType getFromType() {
        switch (formId) {
            case "cas_rec_init": {
                return this.operate == OperateType.ADD ? FromType.INIT_STATE : FromType.RECINIT_STATE;
            }
            case "cas_cashmgtinit": {
                return this.operate == OperateType.ADD ? FromType.INIT_CASH : FromType.RECINIT_CASH;
            }
        }
        return FromType.INIT_STATE;
    }

    @Override
    protected BalanceType getBalanceType(BillDataInfo row) {
        switch (formId) {
            case "cas_rec_init": {
                return BalanceType.STATE;
            }
            case "cas_cashmgtinit": {
                return row.isCashAcct() ? BalanceType.CASH : BalanceType.JOURNAL;
            }
        }
        return BalanceType.CASH;
    }

    @Override
    protected boolean isDeleteBalance(OperateType operate) {
        switch (operate) {
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    static class Singleton {
        private static BalanceModelLogInit instance = new BalanceModelLogInit();

        Singleton() {
        }
    }
}

