/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.business.balancemodel.log.bean.BillDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.type.AbstractBalanceModelLog;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogConstant;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;

public class BalanceModelLogReset
extends AbstractBalanceModelLog {
    private static final List<String> LOGINSERTFIELDS = BalanceModelLogConstant.LOGINSERTFIELDS_RESET;

    public BalanceModelLogReset() {
        this.logTable = "t_cas_balancelog_init";
        this.insertFields = LOGINSERTFIELDS;
        this.isNeedOldData = false;
    }

    public static BalanceModelLogReset getInstance(String formid) {
        formId = formid;
        return Singleton.instance;
    }

    @Override
    protected Collection<BillDataInfo> buildBillInfos(DynamicObject[] bills) {
        ArrayList<BillDataInfo> returns = new ArrayList<BillDataInfo>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                BillDataInfo dataInfo = BalanceModelLogUtil.buildDataInfo(bill.getLong("id"), bill.getString("billno"), bill.getDynamicObject("org") == null ? 0L : Long.parseLong(bill.getDynamicObject("org").getPkValue().toString()), this.getAccountId(entry), entry.getDynamicObject("currency") == null ? 0L : Long.parseLong(entry.getDynamicObject("currency").getPkValue().toString()), entry.getBigDecimal("initbalance"), BigDecimal.ZERO, null, bill.getDynamicObject("resetinitbalperiod") == null ? 0L : Long.parseLong(bill.getDynamicObject("resetinitbalperiod").getPkValue().toString()), entry.getDataEntityState().getFromDatabase());
                dataInfo.setCashAcct(this.isCashAcct(entry));
                dataInfo.setYearCredit(BigDecimal.ZERO);
                dataInfo.setYearCredit(BigDecimal.ZERO);
                returns.add(dataInfo);
            }
        }
        return returns;
    }

    private long getAccountId(DynamicObject entry) {
        long bankAcct = entry.getDynamicObject("bank_accountbank") == null ? 0L : Long.parseLong(entry.getDynamicObject("bank_accountbank").getPkValue().toString());
        long cashAcct = entry.getDynamicObject("cash_accountcash") == null ? 0L : Long.parseLong(entry.getDynamicObject("cash_accountcash").getPkValue().toString());
        return bankAcct == 0L ? cashAcct : bankAcct;
    }

    private boolean isCashAcct(DynamicObject entry) {
        long bankAcct = entry.getDynamicObject("bank_accountbank") == null ? 0L : Long.parseLong(entry.getDynamicObject("bank_accountbank").getPkValue().toString());
        return bankAcct == 0L;
    }

    @Override
    protected void getExtendObjs(List<Object> valueLst, BillDataInfo row, boolean isDel) {
        valueLst.add(this.getBalanceType(row).getValue());
        valueLst.add(row.getPeriod());
        valueLst.add((Object)FromType.RESET);
        valueLst.add(BigDecimal.ZERO);
        valueLst.add(BigDecimal.ZERO);
    }

    @Override
    protected BigDecimal getAmount(BillDataInfo row) {
        BigDecimal debitAmount = row.getDebitamount();
        BigDecimal creditAmount = row.getCreditamount();
        return debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount : debitAmount;
    }

    @Override
    protected BalanceType getBalanceType(BillDataInfo row) {
        return row.isCashAcct() ? BalanceType.CASH : BalanceType.JOURNAL;
    }

    @Override
    protected boolean isDeleteBalance(OperateType operate) {
        switch (operate) {
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    static class Singleton {
        private static BalanceModelLogReset instance = new BalanceModelLogReset();

        Singleton() {
        }
    }
}

