/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.dto.DateRangeBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalance;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.business.balancemodel.log.bean.OccurDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.service.BalanceOccurDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceDataAbstract;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.StringUtils;

public class BalanceOldData
extends BalanceDataAbstract {
    private Map<String, DynamicObject> orgMgtInits;
    private static final String balanceProperties = "id, org,currency, monthstart, monthbalance, period.begindate as startdate, period.periodyear as year, period.periodnumber as month, period.enddate as enddate,monthcredit as payamount, monthdebit as revenueamount, 0 as stroke, 0 as isreset, 0 as isupgrade, yearstart, yearbalance, yearcredit as yearpayamount, yeardebit as yearrecamount";

    @Override
    protected Map<String, BalanceData> getDataSource(Set<Long> orgIds, Set<Long> accountIds, Set<Long> currencyIds, String type, Date minStartDate, Date maxEndDate, RequestBalanceParameter balParams) {
        log.info("BalanceOldData.getDataSource.begin.");
        String accountField = this.getAccountField(type);
        String tableName = this.getBalTableName(type);
        String entityName = this.getEntityName(type);
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (orgIds != null && orgIds.size() > 0) {
            qFilter.and(new QFilter("org", "in", orgIds));
        }
        if (accountIds != null && accountIds.size() > 0) {
            qFilter.and(accountField, "in", accountIds);
        }
        if (currencyIds != null && currencyIds.size() > 0) {
            qFilter.and("currency", "in", currencyIds);
        }
        qFilter.and("period.enddate", "<=", (Object)maxEndDate);
        qFilter.and("type", "=", (Object)type);
        log.info("BalanceOldData.getDataSource_filter_formId:{};filter:{}", (Object)entityName, (Object)qFilter.toString());
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)String.format("%1$s,%2$s as account ", balanceProperties, accountField), (QFilter[])qFilters, (String)"");
        return this.dealDateSource(dataSet, tableName);
    }

    @Override
    protected Map<String, ResponseBalance> getDealBalances(Map<String, BalanceData> dataSourceBalances, RequestBalanceParameter balParam) throws Exception {
        Map<String, ResponseBalance> balances = super.getDealBalances(dataSourceBalances, balParam);
        this.orgMgtInits = SystemStatusCtrolHelper.getSystemStatusCtrol(balParam.getOrgIds());
        List<OccurDataInfo> occurDatas = BalanceOccurDataService.getInstance().buildOccurDatas(this.sumParamOrg(this.getOccur2BalanceParams(balParam), balParam));
        this.convertOccurDate(occurDatas, balParam);
        this.addOccurDatas(occurDatas, balParam, balances);
        log.info("BalanceOldData.getDealBalances;");
        this.doLogBalance(balances.values());
        return balances;
    }

    private List<RequestBalanceParameter> sumParamOrg(List<RequestBalanceParameter> occurParams, RequestBalanceParameter balParam) {
        ArrayList<RequestBalanceParameter> returns = new ArrayList<RequestBalanceParameter>(occurParams.size());
        Map occurParamsMap = occurParams.stream().collect(Collectors.groupingBy(e -> this.getOccurKey(e.getStartDate(), e.getEndDate()), Collectors.mapping(o -> o, Collectors.toList())));
        for (Map.Entry balanceData : occurParamsMap.entrySet()) {
            List<RequestBalanceParameter> params = balanceData.getValue();
            RequestBalanceParameter anyParam = (RequestBalanceParameter)params.get(0);
            RequestBalanceParameter orgSum = new RequestBalanceParameter();
            orgSum.setOrgIds(this.getOccurQueryOrgIds(params, balParam, true));
            orgSum.setAccountIds(balParam.getAccountIds());
            orgSum.setCurrencyIds(balParam.getCurrencyIds());
            orgSum.setStartDate(anyParam.getStartDate());
            orgSum.setEndDate(anyParam.getEndDate());
            orgSum.setType(anyParam.getType());
            returns.add(orgSum);
        }
        log.info("BalanceOldData.sumParamOrg;");
        this.doLogParams(true, returns);
        return returns;
    }

    private void convertOccurDate(List<OccurDataInfo> occurDatas, RequestBalanceParameter balParam) {
        if (occurDatas == null || occurDatas.size() == 0) {
            return;
        }
        Date sDate = DateUtils.getPreMonth((Date)this.getMinPeriodSDate(occurDatas), (int)1);
        Date eDate = DateUtils.getPreMonth((Date)balParam.getEndDate(), (int)-1);
        Map<Long, List<DateRangeBalance>> periodDates = this.buildDateRangBalanceByOrgDate(balParam.getOrgIds(), sDate, eDate);
        block0: for (OccurDataInfo occurData : occurDatas) {
            Long orgId = occurData.getOrgid();
            List<DateRangeBalance> periods = periodDates.get(orgId);
            if (periods == null) continue;
            for (DateRangeBalance period : periods) {
                if (occurData.getBookdate().getTime() < period.getStartDate().getTime() || occurData.getBookdate().getTime() > period.getEndDate().getTime()) continue;
                occurData.setStartDate(period.getStartDate());
                occurData.setEndDate(period.getEndDate());
                continue block0;
            }
        }
    }

    private Date getMinPeriodSDate(List<OccurDataInfo> occurDatas) {
        Date minDate = null;
        for (OccurDataInfo occurData : occurDatas) {
            Date start = occurData.getBookdate();
            if (minDate != null && minDate.getTime() <= start.getTime()) continue;
            minDate = start;
        }
        return minDate;
    }

    private Date getMaxPeriodDate(boolean issDate, List<DateRangeBalance> periodRanges) {
        if (issDate) {
            return periodRanges.get(periodRanges.size() - 1).getStartDate();
        }
        return periodRanges.get(periodRanges.size() - 1).getEndDate();
    }

    private DynamicObject getClosePeriod(Long orgId) {
        DynamicObject dy = this.orgMgtInits.get(orgId + "");
        if (dy != null) {
            return dy.getDynamicObject("currentperiod");
        }
        return null;
    }

    protected List<RequestBalanceParameter> getOccur2BalanceParams(RequestBalanceParameter balParam) {
        Set<Long> orgIds = balParam.getOrgIds();
        ArrayList<RequestBalanceParameter> returns = new ArrayList<RequestBalanceParameter>(orgIds.size());
        for (Long orgId : orgIds) {
            DynamicObject closePeriod = this.getClosePeriod(orgId);
            if (closePeriod == null) continue;
            List periodRanges = (List)this.periodDates.get(orgId);
            if (closePeriod == null || periodRanges == null || periodRanges.size() <= 0) continue;
            Date closePeriod_sDate = closePeriod.getDate("begindate");
            Date maxPeriod_sDate = this.getMaxPeriodDate(true, periodRanges);
            Date maxPeriod_eDate = this.getMaxPeriodDate(false, periodRanges);
            if (maxPeriod_sDate.compareTo(closePeriod_sDate) < 0) continue;
            returns.add(this.buildOccurParam(closePeriod_sDate, maxPeriod_eDate, balParam, orgId));
        }
        return returns;
    }

    private RequestBalanceParameter buildOccurParam(Date begin, Date end, RequestBalanceParameter balParam, Long orgId) {
        RequestBalanceParameter param = new RequestBalanceParameter();
        param.setStartDate(begin);
        param.setEndDate(end);
        param.setType(balParam.getType());
        param.setOrgIds(Collections.singleton(orgId));
        param.setOldBalance(true);
        return param;
    }

    @Override
    protected String getOccurKey(Date begin, Date end) {
        return DateUtils.getMonthDay((Date)begin) + "!" + DateUtils.getMonthDay((Date)end);
    }

    @Override
    protected Set<Long> getOccurQueryOrgIds(List<RequestBalanceParameter> params, RequestBalanceParameter balParam, boolean isBalance) {
        return isBalance ? this.getQueryOrgids(params) : balParam.getOrgIds();
    }

    private Set<Long> getQueryOrgids(List<RequestBalanceParameter> params) {
        HashSet<Long> returns = new HashSet<Long>(params.size());
        params.forEach(o -> returns.addAll(o.getOrgIds()));
        return returns;
    }

    private void addOccurDatas(List<OccurDataInfo> occurDatas, RequestBalanceParameter balParam, Map<String, ResponseBalance> balances_out) {
        log.info("BalanceOldData.addOccurDatas.begin.");
        for (OccurDataInfo occurData : occurDatas) {
            List dateRangeBalances;
            Long orgId = occurData.getOrgid();
            Long accountId = occurData.getAcctid();
            Long currencyId = occurData.getCurrencyid();
            String tableName = this.getOccurTableName(balParam.getType());
            Long id = 0L;
            int month = balParam.getMonth();
            int stroke = 0;
            boolean isreset = false;
            String latKey = this.getFindKey(orgId, accountId, currencyId);
            ResponseBalance responseBalance = balances_out.get(latKey);
            if (responseBalance == null) {
                responseBalance = new ResponseBalance();
                balances_out.put(latKey, responseBalance);
            }
            if ((dateRangeBalances = (List)this.periodDates.get(orgId)) == null || dateRangeBalances.size() == 0) continue;
            for (DateRangeBalance dateRangeBalance : dateRangeBalances) {
                Date sDate = dateRangeBalance.getStartDate();
                Date eDate = dateRangeBalance.getEndDate();
                int year = dateRangeBalance.getYear();
                Balance balance = responseBalance.getBalance(sDate);
                if (balance == null) {
                    balance = this.buildBalanceObj(tableName, latKey, id, orgId, accountId, currencyId, BigDecimal.ZERO, BigDecimal.ZERO, sDate, eDate, year, month, BigDecimal.ZERO, BigDecimal.ZERO, stroke, isreset, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BalanceUtil.isState(tableName));
                    responseBalance.setBalances(balance);
                    responseBalance.setStartDates(sDate);
                    responseBalance.setEndDates(eDate);
                }
                this.addDatas(balance, occurData);
            }
        }
        log.info("BalanceOldData.addOccurDatas.end.");
    }

    protected void addDatas(Balance balance, OccurDataInfo occurData) {
        this.addMonthBalance(balance, occurData);
        this.addMonthOccur(balance, occurData);
        this.addYearBalance(balance, occurData);
        this.addYearOccur(balance, occurData);
    }

    private void addYearBalance(Balance balance, OccurDataInfo occurData) {
        Long orgId = occurData.getOrgid();
        DynamicObject closePeriod = this.getClosePeriod(orgId);
        if (closePeriod != null) {
            boolean isQueryBigOccur;
            Date closePeriod_sDate = closePeriod.getDate("begindate");
            Date queryPeriod_sDate = balance.getStartDate();
            Date occur_sDate = occurData.getStartDate();
            boolean isQueryBigClose = queryPeriod_sDate.compareTo(closePeriod_sDate) > 0;
            boolean bl = isQueryBigOccur = queryPeriod_sDate.compareTo(occur_sDate) > 0;
            if (isQueryBigClose && isQueryBigOccur) {
                boolean isCrossYear;
                boolean bl2 = isCrossYear = DateUtils.getYear((Date)queryPeriod_sDate) > DateUtils.getYear((Date)occur_sDate);
                if (isCrossYear) {
                    balance.setYearStart(balance.getYearStart().add(occurData.getDebitamount()).subtract(occurData.getCreditamount()));
                }
            }
        }
    }

    private void addYearOccur(Balance balance, OccurDataInfo occurData) {
        Long orgId = occurData.getOrgid();
        DynamicObject closePeriod = this.getClosePeriod(orgId);
        if (closePeriod != null) {
            boolean isQueryBigOccur;
            Date closePeriod_sDate = closePeriod.getDate("begindate");
            Date queryPeriod_sDate = balance.getStartDate();
            Date occur_sDate = occurData.getStartDate();
            boolean isQueryBigClose = queryPeriod_sDate.compareTo(closePeriod_sDate) >= 0;
            boolean bl = isQueryBigOccur = queryPeriod_sDate.compareTo(occur_sDate) >= 0;
            if (isQueryBigClose && isQueryBigOccur) {
                boolean isCrossYear;
                boolean bl2 = isCrossYear = DateUtils.getYear((Date)queryPeriod_sDate) > DateUtils.getYear((Date)occur_sDate);
                if (!isCrossYear) {
                    balance.setYearPayAmount(balance.getYearPayAmount().add(occurData.getCreditamount()));
                    balance.setYearRecAmount(balance.getYearRecAmount().add(occurData.getDebitamount()));
                }
            }
        }
    }

    private void addMonthBalance(Balance balance, OccurDataInfo occurData) {
        Long orgId = occurData.getOrgid();
        DynamicObject closePeriod = this.getClosePeriod(orgId);
        if (closePeriod != null) {
            boolean isQueryBigOccur;
            Date closePeriod_sDate = closePeriod.getDate("begindate");
            Date queryPeriod_sDate = balance.getStartDate();
            Date occur_sDate = occurData.getStartDate();
            boolean isQueryBigClose = queryPeriod_sDate.compareTo(closePeriod_sDate) > 0;
            boolean bl = isQueryBigOccur = queryPeriod_sDate.compareTo(occur_sDate) > 0;
            if (isQueryBigClose && isQueryBigOccur) {
                BigDecimal needAdd = occurData.getDebitamount().subtract(occurData.getCreditamount());
                balance.setMonthStart(balance.getMonthStart().add(needAdd));
                balance.setMonthBalance(balance.getMonthBalance().add(needAdd));
            }
        }
    }

    private void addMonthOccur(Balance balance, OccurDataInfo occurData) {
        Long orgId = occurData.getOrgid();
        DynamicObject closePeriod = this.getClosePeriod(orgId);
        if (closePeriod != null) {
            boolean isOccurBigQuery;
            Date closePeriod_sDate = closePeriod.getDate("begindate");
            Date queryPeriod_sDate = balance.getStartDate();
            Date occur_sDate = occurData.getStartDate();
            boolean isQueryBigClose = queryPeriod_sDate.compareTo(closePeriod_sDate) >= 0;
            boolean bl = isOccurBigQuery = occur_sDate.compareTo(queryPeriod_sDate) == 0;
            if (isQueryBigClose && isOccurBigQuery) {
                balance.setPayAmount(balance.getPayAmount().add(occurData.getCreditamount()));
                balance.setRevenueAmount(balance.getRevenueAmount().add(occurData.getDebitamount()));
                balance.setMonthBalance(balance.getMonthBalance().add(occurData.getDebitamount()).subtract(occurData.getCreditamount()));
            }
        }
    }

    private Balance buildBalanceObj(String tableName, String latKey, Long id, Long orgId, Long accountId, Long currencyId, BigDecimal monthStart, BigDecimal monthBalance, Date startDate, Date endDate, int year, int month, BigDecimal payamount, BigDecimal revenueamount, int stroke, boolean isReset, BigDecimal yearpayamount, BigDecimal yearrecamount, BigDecimal yearstart, BigDecimal yearbalance, boolean isState) {
        Balance balance = new Balance();
        balance.setBalanceTableName(tableName);
        balance.setBalanceKey(latKey);
        balance.setId(id);
        balance.setOrgId(orgId);
        balance.setAccountId(accountId);
        balance.setCurrencyId(currencyId);
        balance.setMonthStart(monthStart);
        balance.setMonthBalance(monthBalance);
        balance.setStartDate(startDate);
        balance.setEndDate(endDate);
        balance.setYear(year);
        balance.setMonth(month);
        balance.setPayAmount(payamount);
        balance.setRevenueAmount(revenueamount);
        balance.setStroke(stroke);
        balance.setReset(isReset);
        balance.setYearPayAmount(yearpayamount);
        balance.setYearRecAmount(yearrecamount);
        balance.setYearStart(yearstart);
        balance.setYearBalance(yearbalance);
        balance.setState(isState);
        return balance;
    }

    protected Map<String, BalanceData> dealDateSource(DynamicObjectCollection dataSet, String tableName) {
        HashMap<String, BalanceData> dataSourceBalances = new HashMap<String, BalanceData>(32);
        for (DynamicObject data : dataSet) {
            Long orgId = data.getLong("org");
            Long accountId = data.getLong("account");
            if (accountId == null) {
                log.error("BalanceOldData.dealDateSource:org:{},table name:{},accountId is null.", (Object)orgId, (Object)tableName);
                continue;
            }
            Long currencyId = data.getLong("currency");
            if (currencyId == null) {
                log.error("BalanceOldData.dealDateSource:org:{},table name:{},currencyId is null.", (Object)orgId, (Object)tableName);
                continue;
            }
            String latKey = this.getFindKey(orgId, accountId, currencyId);
            BalanceData balanceData = (BalanceData)dataSourceBalances.get(latKey);
            if (balanceData == null) {
                balanceData = new BalanceData();
                dataSourceBalances.put(latKey, balanceData);
            }
            Date startDate = data.getDate("startdate");
            balanceData.setStartDate(startDate);
            Balance balance = this.buildBalanceObj(tableName, latKey, data.getLong("id"), orgId, accountId, currencyId, data.getBigDecimal("monthstart"), data.getBigDecimal("monthbalance"), startDate, data.getDate("enddate"), data.getInt("year"), data.getInt("month"), data.getBigDecimal("payamount"), data.getBigDecimal("revenueamount"), data.getInt("stroke"), data.getBoolean("isreset"), data.getBigDecimal("yearpayamount"), data.getBigDecimal("yearrecamount"), BalanceUtil.dealBigDecimal(data.getBigDecimal("yearstart")), BalanceUtil.dealBigDecimal(data.getBigDecimal("yearbalance")), BalanceUtil.isState(tableName));
            balanceData.setBalance(balance);
            balanceData.setEndDate(data.getDate("enddate"));
            balanceData.setOrgId(orgId);
        }
        return dataSourceBalances;
    }

    protected String getFindKey(Long orgId, Long acctId, Long currencyId) {
        return StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgId, acctId, currencyId});
    }

    private String getAccountField(String type) {
        String accountField = "";
        if (BalanceType.CASH.getValue().equals(type)) {
            accountField = "accountcash";
        } else if (BalanceType.JOURNAL.getValue().equals(type)) {
            accountField = "accountbank";
        } else if (BalanceType.STATE.getValue().equals(type)) {
            accountField = "accountbank";
        }
        return accountField;
    }

    private String getOccurTableName(String type) {
        switch (type) {
            case "1": {
                return "t_cas_cashjournal";
            }
            case "2": {
                return "t_cas_bankjournal";
            }
            case "3": {
                return "t_cas_bankstatement";
            }
        }
        return "t_cas_cashjournal";
    }

    private String getBalTableName(String type) {
        return "t_cas_journalbalance";
    }

    private String getEntityName(String type) {
        return "cas_journalbalance";
    }
}

