/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.report;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.service.report.DealDsUtil;
import kd.fi.cas.business.balancemodel.service.report.pojo.CapitalDataPojo;

public class DealDsService {
    private static final int iniSize = 16;
    private static final String LOGTIP = "DealDsService:";
    private static final String[] fields_Account = new String[]{"facctname", "facctshortname", "facctnumber", "facctpurpose", "facctstyle", "faccttype", "fbankname", "frptbanktype"};
    private static final String[] fields_Currency = new String[]{"fcurrencyname", "famtdecimal", "fsign"};
    private static final Log log = LogFactory.getLog(DealDsService.class);

    public static DealDsService getInstance() {
        return Singleton.instance;
    }

    public DataSet dealDs(DataSet ds) {
        CapitalDataPojo dataPojo = this.recordDatas(ds);
        return this.dealOrgName(dataPojo, this.dealAccountName(dataPojo, this.dealCurrencyName(dataPojo, ds)));
    }

    private CapitalDataPojo recordDatas(DataSet ds) {
        CapitalDataPojo returns = new CapitalDataPojo();
        returns.setOrgIds(new HashSet<Long>(16));
        returns.setCashAcctIds(new HashSet<Long>(16));
        returns.setBankAcctIds(new HashSet<Long>(16));
        returns.setCurrencyIds(new HashSet<Long>(16));
        DataSet dsCopy = ds.copy();
        for (Row row : dsCopy) {
            returns.getOrgIds().add(row.getLong("forgid"));
            returns.getCurrencyIds().add(row.getLong("fcurrencyid"));
            if ("1".equals(row.getString("ftype"))) {
                returns.getCashAcctIds().add(row.getLong("facctid"));
                continue;
            }
            returns.getBankAcctIds().add(row.getLong("facctid"));
        }
        return returns;
    }

    private DataSet queryDatas(Set<Long> ids, String formId, String selFields) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        QFilter filters = new QFilter("id", "in", ids);
        return QueryServiceHelper.queryDataSet((String)"CapitalDataAbstract.queryDatas", (String)formId, (String)selFields, (QFilter[])filters.toArray(), null);
    }

    private DataSet dealAccountName(CapitalDataPojo dataPojo, DataSet ds) {
        log.info("{}dealAccountName.", (Object)LOGTIP);
        DataSet bankAcctDs = this.queryDatas(dataPojo.getBankAcctIds(), "bd_accountbanks", "id,acctname as facctname,name as facctshortname,number as facctnumber,acctproperty.name as facctpurpose,acctstyle as facctstyle,accttype as faccttype,bank.name as fbankname,bank.bank_cate.name as frptbanktype");
        DataSet cashAcctDs = this.queryDatas(dataPojo.getCashAcctIds(), "cas_accountcash", "id,name as facctname,name as facctshortname,number as facctnumber,'' as facctpurpose,'' as facctstyle,'' as faccttype,'' as fbankname,'' as frptbanktype");
        DataSet allAcctDs = bankAcctDs;
        if (cashAcctDs != null) {
            allAcctDs = allAcctDs == null ? cashAcctDs : allAcctDs.union(cashAcctDs);
        }
        log.info("{}dealAccountName_getLeftJoinDs.", (Object)LOGTIP);
        ds = DealDsUtil.getLeftJoinDs(ds, allAcctDs, "facctid", "id", fields_Account);
        DealDsUtil.closeDs(bankAcctDs, cashAcctDs, allAcctDs);
        return ds;
    }

    private DataSet dealOrgName(CapitalDataPojo dataPojo, DataSet ds) {
        log.info("{}dealOrgName.", (Object)LOGTIP);
        String[] fields = new String[]{"forgname"};
        DataSet orgDs = this.queryDatas(dataPojo.getOrgIds(), "bos_org", "id,name as forgname");
        log.info("{}dealOrgName_getLeftJoinDs.", (Object)LOGTIP);
        ds = DealDsUtil.getLeftJoinDs(ds, orgDs, "forgid", "id", fields);
        DealDsUtil.closeDs(orgDs);
        return ds;
    }

    private DataSet dealCurrencyName(CapitalDataPojo dataPojo, DataSet ds) {
        log.info("{}dealCurrencyName.", (Object)LOGTIP);
        DataSet currencyDs = this.queryDatas(dataPojo.getCurrencyIds(), "bd_currency", "id,name as fcurrencyname,amtprecision as famtdecimal,sign as fsign");
        log.info("{}dealCurrencyName_getLeftJoinDs.", (Object)LOGTIP);
        ds = DealDsUtil.getLeftJoinDs(ds, currencyDs, "fcurrencyid", "id", fields_Currency);
        DealDsUtil.closeDs(currencyDs);
        return ds;
    }

    static class Singleton {
        private static final DealDsService instance = new DealDsService();

        Singleton() {
        }
    }
}

