/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.report.reportbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BuildDataSet {
    protected static final int iniSize = 16;
    private static Log log = LogFactory.getLog(BuildDataSet.class);

    public static BuildDataSet getInstance() {
        return Singleton.instance;
    }

    public List<Object> buildRowData(Long orgid, String type, Long cashAcctId, Long currencyId, Date startDate, BigDecimal balance, BigDecimal debitAmt, BigDecimal creditAmt, Long period, String periodName, BigDecimal yearBalance, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt) {
        log.info("BuildDataSet.buildRowData.");
        ArrayList<Object> rowData = new ArrayList<Object>(16);
        rowData.add(orgid);
        rowData.add(type);
        rowData.add(cashAcctId);
        rowData.add(currencyId);
        rowData.add(startDate);
        rowData.add(balance);
        rowData.add(debitAmt);
        rowData.add(creditAmt);
        rowData.add(0);
        rowData.add(period);
        rowData.add(periodName);
        rowData.add(yearBalance);
        rowData.add(yearDebitAmt);
        rowData.add(yearCreditAmt);
        return rowData;
    }

    public DataSetBuilder createDsBuilder() {
        return Algo.create((String)"ReportBalanceService.createDataSetBuilder").createDataSetBuilder(new RowMeta(this.buildFields().toArray(new Field[0])));
    }

    public DataSet createNewDs() {
        return this.createDsBuilder().build();
    }

    private List<Field> buildFields() {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("forgid", (DataType)DataType.LongType));
        fields.add(new Field("ftype", (DataType)DataType.StringType));
        fields.add(new Field("facctid", (DataType)DataType.LongType));
        fields.add(new Field("fcurrencyid", (DataType)DataType.LongType));
        fields.add(new Field("fstartdate", (DataType)DataType.DateType));
        fields.add(new Field("fbalance", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fdebitamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fcreditamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("sumlevel", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fperiod", (DataType)DataType.LongType));
        fields.add(new Field("fperiodname", (DataType)DataType.StringType));
        fields.add(new Field("fyearbalance", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fyeardebitamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fyearcreditamount", (DataType)DataType.BigDecimalType));
        return fields;
    }

    static class Singleton {
        private static final BuildDataSet instance = new BuildDataSet();

        Singleton() {
        }
    }
}

