/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.convert;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.convert.AbstractPayBillConverter;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CodeRuleHelper;

public class OverseaAgentPayBillConverter
extends AbstractPayBillConverter {
    private static Map<String, String> fieldMapper = new HashMap<String, String>();

    public OverseaAgentPayBillConverter() {
        fieldMapper.put("org", "company");
        fieldMapper.put("payeracctbank", "accountbank");
        fieldMapper.put("currency", "currency");
        fieldMapper.put("exchangerate", "exchangerate");
        fieldMapper.put("payamount", "amount");
        fieldMapper.put("localamt", "locamt");
        fieldMapper.put("count", "count");
        fieldMapper.put("expectdealtime", "expectdealtime");
        fieldMapper.put("id", "sourcebillid");
        fieldMapper.put("payeename", "recname");
        fieldMapper.put("payeebankname", "recbank");
        fieldMapper.put("payeebanknumber", "recbanknumber");
        fieldMapper.put("payeeacctbank", "recaccountbank");
        fieldMapper.put("e_remark", "remark");
        fieldMapper.put("recprovince", "recprovince");
        fieldMapper.put("reccity", "reccity");
        fieldMapper.put("e_encryptamount", "enc_recamountfake");
        fieldMapper.put("entry.id", "sourceentryid");
        fieldMapper.put("ispersonpay", "ispersonpay");
        fieldMapper.put("isencryption", "isencryption");
        fieldMapper.put("iscrosspay", "istranspay");
        fieldMapper.put("recswiftcode", "incomeswiftcode");
        fieldMapper.put("feepayer", "payerfeetype");
        fieldMapper.put("feecurrency", "payerfeecurrency");
        fieldMapper.put("paymethod", "paymentmethod");
        fieldMapper.put("serlevel", "servicelevel");
        fieldMapper.put("agreedrate", "tolexchangerate");
        fieldMapper.put("contractno", "excontract");
        fieldMapper.put("sendway", "deliverymethod");
        fieldMapper.put("checktype", "chequetype");
        fieldMapper.put("checkuse", "chequeusage");
        fieldMapper.put("recbankaddress", "incomeradds");
        fieldMapper.put("recroutingnum", "incomebankcode");
    }

    @Override
    public DynamicObject convertToTargetBill(DynamicObject agentPayBill) {
        DynamicObject bankAgent = super.convertToTargetBill(agentPayBill);
        if (!this.isBizBillCommitBe() && this.isBankBillAudit()) {
            bankAgent.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        } else {
            bankAgent.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        DynamicObject company = bankAgent.getDynamicObject("company");
        bankAgent.set("billno", (Object)CodeRuleHelper.generateNumber((String)"bei_bankagentpay", (DynamicObject)bankAgent, (String)company.getPkValue().toString(), null));
        bankAgent.set("bizdate", (Object)new Date());
        bankAgent.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        bankAgent.set("createtime", (Object)new Date());
        bankAgent.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
        DynamicObjectCollection entry = bankAgent.getDynamicObjectCollection("entrys");
        for (DynamicObject row : entry) {
            row.set("status", (Object)BeBillStatusEnum.OP.getValue());
            row.set("isagencypersonpay", (Object)agentPayBill.getBoolean("isagencypersonpay"));
            row.set("recamount", (Object)AgentPayBillHelper.decodeAmount((String)((String)row.get("enc_recamountfake"))));
            DynamicObjectCollection agentEntryCol = agentPayBill.getDynamicObjectCollection("entry");
            for (DynamicObject agentEntry : agentEntryCol) {
                DynamicObject transType;
                if (!row.get("sourceentryid").equals(agentEntry.get("id")) || (transType = agentEntry.getDynamicObject("transtype")) == null) continue;
                row.set("transremarks", (Object)transType.getLocaleString("name").getLocaleValue());
            }
        }
        DynamicObject proxyBank = agentPayBill.getDynamicObject("payproxybank");
        if (proxyBank != null) {
            proxyBank = BusinessDataServiceHelper.loadSingle((Object)proxyBank.getPkValue(), (String)proxyBank.getDataEntityType().getName());
            String proxyAcctNumber = proxyBank.getString("proxyacct");
            bankAgent.set("proxyaccno", (Object)proxyAcctNumber);
            String proxyAcctName = null;
            DynamicObject proxyAcct = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"acctname", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)proxyAcctNumber)});
            if (proxyAcct != null) {
                proxyAcctName = proxyAcct.getString("acctname");
            } else {
                DynamicObject openOrg = agentPayBill.getDynamicObject("openorg");
                if (openOrg != null) {
                    proxyAcctName = openOrg.getString("name");
                }
            }
            bankAgent.set("proxyaccname", (Object)proxyAcctName);
            DynamicObject country = proxyBank.getDynamicObject("country");
            String countryName = null;
            if (country != null) {
                country = BusinessDataServiceHelper.loadSingle((Object)country.getPkValue(), (String)country.getDataEntityType().getName());
                countryName = country.getString("simplespell");
            }
            bankAgent.set("proxybankcountry", countryName);
            bankAgent.set("proxybankarea", countryName);
            bankAgent.set("proxyswiftcode", (Object)proxyBank.getString("swift_code"));
            bankAgent.set("proxybankname", (Object)proxyBank.getDynamicObject("bankname").getLocaleString("name").getLocaleValue());
            bankAgent.set("proxybankadds", (Object)proxyBank.getString("address"));
        }
        bankAgent.set("usecn", (Object)agentPayBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue());
        DynamicObject feeAcct = agentPayBill.getDynamicObject("feeactbank");
        if (feeAcct != null) {
            bankAgent.set("payerfeeaccno", (Object)feeAcct.getString("number"));
        }
        return bankAgent;
    }

    @Override
    public String getSourceEntityKey() {
        return "cas_agentpaybill";
    }

    @Override
    public String getTargetEntityKey() {
        return "bei_bankagentpay";
    }

    @Override
    public String getTargetField(String sourceField) {
        return fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return fieldMapper;
    }

    @Override
    public List<String> getGroupFields() {
        ArrayList<String> groupByFields = new ArrayList<String>();
        groupByFields.add("id");
        return groupByFields;
    }
}

