/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.function;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.function.result.AccountDateResult;
import kd.fi.cas.business.function.result.JournalDateResult;
import kd.fi.cas.util.StringUtils;
import org.apache.commons.io.IOUtils;

public class CslFunctionService {
    private static Log logger = LogFactory.getLog(CslFunctionService.class);
    private static final String FORMULA_CATALOG_LIST = "resources/csl_formula_catalog_list.json";
    private static final String FORMULA_DEF_LIST = "resources/csl_formula_list.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws IOException {
        String formula_def;
        String formula_catalog;
        InputStream formula_def_list = null;
        InputStream formula_catalog_list = null;
        try {
            formula_catalog_list = Thread.currentThread().getContextClassLoader().getResourceAsStream(FORMULA_CATALOG_LIST);
            formula_def_list = Thread.currentThread().getContextClassLoader().getResourceAsStream(FORMULA_DEF_LIST);
            formula_catalog = IOUtils.toString((InputStream)formula_catalog_list);
            formula_def = IOUtils.toString((InputStream)formula_def_list);
        }
        finally {
            try {
                if (formula_def_list != null) {
                    formula_def_list.close();
                }
                if (formula_catalog_list != null) {
                    formula_catalog_list.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)formula_def) && StringUtils.isNotEmpty((String)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        String configStr = SerializationUtils.toJsonString(configMap);
        return configStr;
    }

    public String dispatchCal(String formulaName, String paramJson) throws ParseException {
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
        Map<Object, Object> result = new HashMap();
        Map paramListMap = (Map)paramMap.get("param");
        logger.info("\u53c2\u6570\u4fe1\u606f{}\uff1a", (Object)SerializationUtils.toJsonString((Object)paramListMap));
        if ("journalformrptget".equalsIgnoreCase(formulaName.toLowerCase(Locale.ENGLISH))) {
            result = new JournalDateResult().query(paramListMap);
        }
        if ("accountget".equalsIgnoreCase(formulaName.toLowerCase(Locale.ENGLISH))) {
            result = new AccountDateResult().query(paramListMap);
        }
        logger.info("\u8fd4\u56de\u53c2\u6570{}", (Object)SerializationUtils.toJsonString(result));
        return SerializationUtils.toJsonString(result);
    }
}

