/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.compare.CompareEngine;
import kd.fi.cas.compare.concurrent.MultiThreadOperationExecutor;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.strategy.ICompareStrategy;
import kd.fi.cas.compare.strategy.MultiRuleOneToOneCompareStrategy;
import kd.fi.cas.dao.MatchData;
import kd.fi.cas.dao.SmartMatch;
import kd.fi.cas.enums.MatchBizTypeEnum;
import kd.fi.cas.enums.MatchPlanEnum;
import kd.fi.cas.helper.BatchQueryHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AutoMatchCalHelper {
    private static final Log logger = LogFactory.getLog(AutoMatchCalHelper.class);
    private static final String[] staticMatchField = new String[]{"id", "entryentity.seq", "entryentity.e_rulesname", "entryentity.e_matchplan_real_TAG"};

    public static List<Pair<Object, List<CompareResult>>> autoMatchCal(Set<Object> companyPKs, Map<Object, List<Object>> tdIdMap, MatchBizTypeEnum biztype) {
        List resultList = new MultiThreadOperationExecutor().doBatchOperation(new ArrayList<Object>(companyPKs), 4, dataList -> {
            ArrayList<Pair<Object, List<CompareResult>>> results = new ArrayList<Pair<Object, List<CompareResult>>>();
            for (Object companyPK : dataList) {
                Pair<Object, List<CompareResult>> result = AutoMatchCalHelper.calForThread(companyPK, (List)tdIdMap.get(companyPK), biztype);
                if (result == null) continue;
                results.add(result);
            }
            return results;
        });
        return resultList;
    }

    private static Pair<Object, List<CompareResult>> calForThread(Object comkey, List<Object> tdIdList, MatchBizTypeEnum biztype) {
        logger.info("------calForThread begin : " + Thread.currentThread().getName() + ": " + Thread.currentThread().getId() + "------");
        MatchData md = AutoMatchCalHelper.transMatchDate(comkey, tdIdList, biztype);
        if (md == null) {
            return null;
        }
        CompareEngine engine = new CompareEngine(md.getSrcDataList(), md.getTarDataList());
        MultiRuleOneToOneCompareStrategy strategy = new MultiRuleOneToOneCompareStrategy(md.getRules());
        List resultList = engine.compare((ICompareStrategy)strategy);
        logger.info("------calForThread end : " + Thread.currentThread().getName() + ": " + Thread.currentThread().getId() + "------");
        return Pair.of((Object)md.getRuleId(), (Object)resultList);
    }

    private static MatchData transMatchDate(Object companyPK, List<Object> tdIdList, MatchBizTypeEnum biztype) {
        DynamicObjectCollection smartmatchDCs = AutoMatchCalHelper.getSmartMatchDOC(companyPK, biztype);
        if (smartmatchDCs == null || smartmatchDCs.size() <= 0) {
            return null;
        }
        ArrayList ruleList = new ArrayList();
        Set<String> detailDateFields = AutoMatchCalHelper.getDateFields("bei_transdetail_cas");
        String bizName = MatchBizTypeEnum.PAY == biztype ? "cas_paybill" : "cas_recbill";
        Set<String> bizDateFields = AutoMatchCalHelper.getDateFields(bizName);
        HashSet detailFields = Sets.newHashSetWithExpectedSize((int)10);
        HashSet bizFields = Sets.newHashSetWithExpectedSize((int)10);
        for (DynamicObject smartmatchDC : smartmatchDCs) {
            String matchplan = smartmatchDC.getString("entryentity.e_matchplan_real_TAG");
            if (CasHelper.isEmpty((Object)matchplan)) continue;
            JSONArray matchplanArr = (JSONArray)JSONObject.parse((String)matchplan);
            List smartMatches = matchplanArr.toJavaList(SmartMatch.class);
            ArrayList<CompareRule> rules = new ArrayList<CompareRule>(smartMatches.size());
            Iterator iterator = smartMatches.iterator();
            while (iterator.hasNext()) {
                SmartMatch sm = (SmartMatch)iterator.next();
                detailFields.add(sm.getTransdetailfields());
                bizFields.add(sm.getBizfields());
                rules.add(AutoMatchCalHelper.transRule(sm));
            }
            ruleList.add(rules);
        }
        bizFields.add("id");
        detailFields.add("id");
        detailFields.add("bizdate");
        List transdetails = BatchQueryHelper.batchQuery(tdIdList, (String)"bei_transdetail_cas", (String)"id", (String)String.join((CharSequence)",", detailFields), null);
        ArrayList srcDataList = new ArrayList(transdetails.size());
        Date limitDate = DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)30);
        Date startDate = null;
        for (DynamicObject orgTransdetail : transdetails) {
            Date transDate = orgTransdetail.getDate("bizdate");
            if (transDate == null || transDate.compareTo(limitDate) < 0) continue;
            if (startDate == null || transDate.compareTo(startDate) < 0) {
                startDate = transDate;
            }
            HashMap<String, Object> srcDataMap = new HashMap<String, Object>();
            for (String detailField : detailFields) {
                if (detailDateFields.contains(detailField)) {
                    String dateStr = DateUtils.formatString((Date)orgTransdetail.getDate(detailField), (String)"yyyy-MM-dd");
                    srcDataMap.put(detailField, dateStr);
                    continue;
                }
                srcDataMap.put(detailField, orgTransdetail.get(detailField));
            }
            srcDataList.add(srcDataMap);
        }
        if (startDate == null) {
            return null;
        }
        startDate = DateUtils.getLastDay((Date)DateUtils.getDataFormat(startDate, (boolean)true), (int)90);
        Date endDate = DateUtils.getCurrentDate();
        ArrayList<Date> queryDates = new ArrayList<Date>();
        while (startDate.compareTo(endDate) <= 0) {
            queryDates.add(startDate);
            startDate = DateUtils.getNextDay((Date)startDate, (int)1);
        }
        List bizBillDCs = new MultiThreadOperationExecutor().doBatchOperation(queryDates, 5, dataList -> {
            QFilter orgFilter = new QFilter("org", "=", companyPK);
            Date sdate = (Date)dataList.get(0);
            Date eDate = (Date)dataList.get(dataList.size() - 1);
            QFilter sDateFilter = new QFilter("bizdate", ">=", (Object)sdate);
            QFilter eDateFilter = null;
            if (eDate.compareTo(DateUtils.getCurrentDate()) < 0) {
                eDateFilter = new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)eDate, (int)1));
            }
            String bizEntityName = MatchBizTypeEnum.PAY == biztype ? "cas_paybill" : "cas_recbill";
            QFilter entrustorgFilter = new QFilter("entrustorg", "=", (Object)0);
            bizFields.add("bankcheckflag_tag");
            DynamicObjectCollection queryCol = QueryServiceHelper.query((String)bizEntityName, (String)String.join((CharSequence)",", bizFields), (QFilter[])new QFilter[]{orgFilter, sDateFilter, eDateFilter, MatchBizTypeEnum.PAY == biztype ? entrustorgFilter : null});
            for (int i = 0; i < queryCol.size(); ++i) {
                if (!EmptyUtil.isNoEmpty((String)((DynamicObject)queryCol.get(i)).getString("bankcheckflag_tag"))) continue;
                queryCol.remove(i);
            }
            return queryCol;
        });
        if (bizBillDCs == null || bizBillDCs.size() <= 0) {
            return null;
        }
        ArrayList<HashMap> tarDataList = new ArrayList<HashMap>(bizBillDCs.size());
        for (DynamicObject bizBillDy : bizBillDCs) {
            HashMap recBillMap = Maps.newHashMapWithExpectedSize((int)bizFields.size());
            for (String bizField : bizFields) {
                if (bizDateFields.contains(bizField)) {
                    String dateStr = "";
                    if (!CasHelper.isEmpty((Object)bizBillDy.get(bizField))) {
                        dateStr = DateUtils.formatString((Date)bizBillDy.getDate(bizField), (String)"yyyy-MM-dd");
                    }
                    recBillMap.put(bizField, dateStr);
                    continue;
                }
                recBillMap.put(bizField, bizBillDy.get(bizField));
            }
            tarDataList.add(recBillMap);
        }
        MatchData md = new MatchData();
        md.setRuleId((Object)((DynamicObject)smartmatchDCs.get(0)).getLong("id"));
        md.setRules(ruleList);
        md.setSrcDataList(srcDataList);
        md.setTarDataList(tarDataList);
        return md;
    }

    private static DynamicObjectCollection getSmartMatchDOC(Object companyPK, MatchBizTypeEnum biztype) {
        QFilter rulCommonFilter = AutoMatchCalHelper.getRulCommonFilter(companyPK, biztype.getValue(), false);
        DynamicObjectCollection smartmatchDCs = QueryServiceHelper.query((String)"cas_smartmatch", (String)String.join((CharSequence)",", staticMatchField), (QFilter[])new QFilter[]{rulCommonFilter}, (String)"entryentity.seq asc");
        if (smartmatchDCs == null || smartmatchDCs.size() <= 0) {
            rulCommonFilter = AutoMatchCalHelper.getRulCommonFilter(companyPK, biztype.getValue(), true);
            smartmatchDCs = QueryServiceHelper.query((String)"cas_smartmatch", (String)String.join((CharSequence)",", staticMatchField), (QFilter[])new QFilter[]{rulCommonFilter}, (String)"entryentity.seq asc");
        }
        return smartmatchDCs;
    }

    private static QFilter getRulCommonFilter(Object companyPK, String type, Boolean isFaceAllOrg) {
        QFilter filter = new QFilter("biztype", "=", (Object)type).and(new QFilter("enable", "=", (Object)"1"));
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", companyPK));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org"));
        }
        return filter;
    }

    private static Set<String> getDateFields(String entryName) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            IDataEntityProperty fieldProp = transField.getFieldProp();
            if (!(fieldProp instanceof DateProp) && !(fieldProp instanceof TimeProp) && !(fieldProp instanceof DateTimeProp) && !(fieldProp instanceof ModifyDateProp) && !(fieldProp instanceof CreateDateProp)) continue;
            dateFields.add(transField.getFullFieldName());
        }
        return dateFields;
    }

    private static CompareRule transRule(SmartMatch sm) {
        CompareRule r = new CompareRule();
        r.setSymbol(AutoMatchCalHelper.transSymbol(sm.getRelation()));
        if (!StringUtils.isEmpty((CharSequence)sm.getNum())) {
            try {
                r.setExtraVal((Object)Integer.valueOf(sm.getNum()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        r.setPropNameSrc(sm.getTransdetailfields());
        r.setPropNameTgt(sm.getBizfields());
        if (StringUtils.isNotBlank((CharSequence)sm.getIsnullmatch())) {
            r.setNullMatch((sm.getIsnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)sm.getIsallnullmatch())) {
            r.setAllNullMatch((sm.getIsallnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        } else if (sm.getIsnullmatch().equals("true")) {
            r.setAllNullMatch(true);
        }
        return r;
    }

    private static CompareRule.Symbol transSymbol(String relation) {
        if (MatchPlanEnum.DIFF.getValue().equals(relation)) {
            return CompareRule.Symbol.DATE_DIFF;
        }
        if (MatchPlanEnum.LIKE.getValue().equals(relation)) {
            return CompareRule.Symbol.STR_MATCH;
        }
        return CompareRule.Symbol.EQUALS;
    }
}

