/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.helper.AutoMatchCalHelper;
import kd.fi.cas.business.helper.MatchAmountDealHelper;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.enums.AutoMatchBillEnum;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.MatchBizTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AutoMatchHelper {
    private static Date doOpDate = DateUtils.getCurrentDate();
    private static final Log logger = LogFactory.getLog(AutoMatchHelper.class);
    private static final String MATCH_AMT = "matchAmount";
    private static final String UN_MATCH_AMT = "unMatchAmount";
    private static final String MATCH_FLAG = "matchFlag";
    private static final String MATCH_FLAG_MSG = "matchFlagMsg";

    public static boolean autoMatch(ListSelectedRowCollection selectRows, MatchBizTypeEnum biztype, String thisOpnumber) {
        if (DateUtils.getCurrentDate().compareTo(doOpDate) >= 0) {
            ThreadPools.executeOnceIncludeRequestContext((String)"deleteHistoryData", () -> {
                QFilter datefilter = new QFilter("createtime", "<", (Object)DateUtils.getCurrentDate());
                DeleteServiceHelper.delete((String)"cas_autocalresult", (QFilter[])new QFilter[]{datefilter});
                doOpDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)1);
            });
        }
        if (selectRows == null || selectRows.size() <= 0) {
            return false;
        }
        if (selectRows.size() > 10000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u5339\u914d\u7684\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e07\u6761\u3002", (String)"AutoMatchHelper_01", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        HashSet<Object> companyPKs = new HashSet<Object>();
        HashMap<Object, List<Object>> tdIdMap = new HashMap<Object, List<Object>>();
        for (ListSelectedRow row : selectRows) {
            Long companyId = row.getMainOrgId();
            companyPKs.add(companyId);
            ArrayList<Object> tdIdList = (ArrayList<Object>)tdIdMap.get(companyId);
            if (tdIdList == null) {
                tdIdList = new ArrayList<Object>();
            }
            tdIdList.add(row.getPrimaryKeyValue());
            tdIdMap.put(companyId, tdIdList);
        }
        List<Pair<Object, List<CompareResult>>> results = AutoMatchCalHelper.autoMatchCal(companyPKs, tdIdMap, biztype);
        return AutoMatchHelper.dealMatchResult(results, biztype, thisOpnumber);
    }

    private static boolean dealMatchResult(List<Pair<Object, List<CompareResult>>> results, MatchBizTypeEnum biztype, String thisOpnumber) {
        if (results != null && results.size() > 0) {
            String resultEntityName = "cas_autocalresult";
            ArrayList<DynamicObject> autoSaveList = new ArrayList<DynamicObject>();
            for (Pair<Object, List<CompareResult>> result : results) {
                List rs = (List)result.getRight();
                if (rs == null || rs.size() <= 0) continue;
                for (CompareResult cs : rs) {
                    DynamicObject autoSaveObj = BusinessDataServiceHelper.newDynamicObject((String)resultEntityName);
                    Long pk = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)resultEntityName).getAlias());
                    autoSaveObj.set("id", (Object)pk);
                    autoSaveObj.set("number", (Object)thisOpnumber);
                    autoSaveObj.set("name", (Object)String.valueOf(pk));
                    autoSaveObj.set("matchstatus", (Object)"0");
                    autoSaveObj.set("smartmatch", result.getLeft());
                    autoSaveObj.set("createtime", (Object)new Date());
                    DynamicObjectCollection entry = autoSaveObj.getDynamicObjectCollection("entryentity");
                    DynamicObject r1 = entry.addNew();
                    r1.set("seq", (Object)1);
                    r1.set("record", (Object)"0");
                    r1.set("billid", cs.getSrcIdSet().iterator().next());
                    DynamicObject r2 = entry.addNew();
                    r2.set("seq", (Object)2);
                    r2.set("record", (Object)(MatchBizTypeEnum.PAY == biztype ? "2" : "1"));
                    r2.set("billid", cs.getTarIdSet().iterator().next());
                    autoSaveList.add(autoSaveObj);
                }
            }
            if (autoSaveList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])autoSaveList.toArray(new DynamicObject[autoSaveList.size()]));
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> getMatchAmount(BigDecimal amount, BigDecimal matchAmount, BigDecimal unMatchAmount) {
        HashMap<String, Object> tMatchResult = new HashMap<String, Object>(4);
        for (BigDecimal initAmount : Arrays.asList(amount, matchAmount, unMatchAmount)) {
            if (initAmount != null) continue;
            initAmount = BigDecimal.ZERO;
        }
        BigDecimal allAmount = matchAmount.add(unMatchAmount);
        BigDecimal tAmount = matchAmount.add(amount);
        tMatchResult.put(MATCH_AMT, tAmount);
        tMatchResult.put(MATCH_FLAG_MSG, "");
        String matchFlag = null;
        if (allAmount.compareTo(tAmount) == 0 && BigDecimal.ZERO.compareTo(allAmount) != 0) {
            matchFlag = AutoMatchFlagEnum.ALL.getValue();
        } else if (BigDecimal.ZERO.compareTo(tAmount) == 0) {
            matchFlag = AutoMatchFlagEnum.NONE.getValue();
        } else {
            logger.error("\u5339\u914d\u5f02\u5e38\u7684\u573a\u666f\uff0d\uff0damount\uff1a{},matchAmount:{},unMatchAmount:{}", new Object[]{amount, matchAmount, unMatchAmount});
            if (allAmount.abs().compareTo(tAmount.abs()) < 0 && (BigDecimal.ZERO.compareTo(allAmount) > 0 && BigDecimal.ZERO.compareTo(tAmount) > 0 || BigDecimal.ZERO.compareTo(allAmount) < 0 && BigDecimal.ZERO.compareTo(tAmount) < 0)) {
                logger.error("\u603b\u91d1\u989d\u548c\u5df2\u5339\u914d\u91d1\u989d\u540c\u53f7\uff0c\u540c\u4e3a\u6b63\u6216\u540c\u4e3a\u8d1f\uff0c\u8d85\u989d\u5339\u914d");
            } else {
                logger.error("\u5339\u914d\u5f02\u5e38");
            }
            tMatchResult.put(UN_MATCH_AMT, unMatchAmount);
            tMatchResult.put(MATCH_AMT, matchAmount);
            tMatchResult.put(MATCH_FLAG_MSG, "");
            if (BigDecimal.ZERO.compareTo(unMatchAmount) == 0) {
                tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.ALL.getValue());
            } else if (BigDecimal.ZERO.compareTo(matchAmount) == 0) {
                tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.NONE.getValue());
            } else {
                tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.SOME.getValue());
            }
            return tMatchResult;
        }
        tMatchResult.put(UN_MATCH_AMT, unMatchAmount.subtract(amount));
        tMatchResult.put(MATCH_FLAG, matchFlag);
        return tMatchResult;
    }

    public static Map<String, Object> getMatchAmount(BigDecimal amount, BigDecimal matchAmount, BigDecimal unMatchAmount, Boolean isRelateOtherFlow, BigDecimal oMatchAmount, BigDecimal oUnMatchAmount) {
        Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(amount, matchAmount, unMatchAmount);
        if (tMatchResult != null) {
            if (isRelateOtherFlow.booleanValue()) {
                if (AutoMatchFlagEnum.ALL.getValue().equals(tMatchResult.get(MATCH_FLAG))) {
                    if (matchAmount.add(unMatchAmount).compareTo(oMatchAmount) != 0 || BigDecimal.ZERO.compareTo(oUnMatchAmount) != 0) {
                        tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.SOME.getValue());
                    }
                } else if (AutoMatchFlagEnum.NONE.getValue().equals(tMatchResult.get(MATCH_FLAG)) && (BigDecimal.ZERO.compareTo(oMatchAmount) != 0 && oUnMatchAmount.compareTo(oMatchAmount) != 0 || BigDecimal.ZERO.compareTo(matchAmount) != 0 && unMatchAmount.compareTo(matchAmount) != 0)) {
                    tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.SOME.getValue());
                }
            } else if (BigDecimal.ZERO.compareTo(oMatchAmount) != 0) {
                tMatchResult.put(MATCH_FLAG, AutoMatchFlagEnum.ERROR.getValue());
                if (matchAmount.add(unMatchAmount).abs().compareTo(oMatchAmount.abs()) < 0 && BigDecimal.ZERO.compareTo(matchAmount.add(unMatchAmount).multiply(oMatchAmount)) < 0) {
                    tMatchResult.put(MATCH_FLAG_MSG, ResManager.loadKDString((String)"\u8d85\u989d\u5339\u914d", (String)"AutoMatchHelper_02", (String)"fi-cas-business", (Object[])new Object[0]));
                } else {
                    tMatchResult.put(MATCH_FLAG_MSG, ResManager.loadKDString((String)"\u672c\u5355\u65e0\u9700\u5173\u8054\u5bf9\u65b9\u6d41\u6c34\uff0c\u4f46\u5df2\u5b58\u5728\u5bf9\u65b9\u6d41\u6c34\u5173\u8054\u8bb0\u5f55\u3002", (String)"AutoMatchHelper_04", (String)"fi-cas-business", (Object[])new Object[0]));
                }
            }
        }
        return tMatchResult;
    }

    public static void setRecedBillEntry(DynamicObject transdetail, String recedbilltype, String recedbillnumber, Long recedbillid, Long recedbillentryid, String amttype, BigDecimal amount, String direction, String opNumber) {
        if (!transdetail.getDataEntityType().getProperties().stream().anyMatch(o -> "recedbillentry".equals(o.getName()))) {
            DynamicObjectCollection entry = new DynamicObjectCollection(transdetail.getDynamicObjectType(), (Object)"recedbillentry");
            transdetail.set("recedbillentry", (Object)entry);
        }
        DynamicObjectCollection tRecedBillEntry = transdetail.getDynamicObjectCollection("recedbillentry");
        DynamicObject entry = tRecedBillEntry.addNew();
        entry.set("e_opnumber", (Object)opNumber);
        entry.set("e_recedbilltype", (Object)recedbilltype);
        entry.set("e_recedbillnumber", (Object)recedbillnumber);
        entry.set("e_recedbillid", (Object)recedbillid);
        entry.set("e_amount", (Object)amount);
        entry.set("e_direction", (Object)direction);
        if (recedbillentryid != null && Long.compare(recedbillentryid, 0L) != 0) {
            entry.set("e_recedbillentryid", (Object)recedbillentryid);
        }
        if (amttype != null && amttype.trim().length() > 0) {
            entry.set("e_amttype", (Object)amttype);
        }
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail) {
        transdetail.getDynamicObjectCollection("recedbillentry").clear();
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, Long recedbillid) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0);
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, String recedbillnumber) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> recedbillnumber != null && recedbillnumber.equals(o.getString("e_recedbillnumber")));
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, Long recedbillid, Long recedbillentryid) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && Long.compare(o.getLong("e_recedbillentryid"), recedbillid) == 0);
    }

    public static void deleteRecedBillEntry(DynamicObject transdetail, Long recedbillid, String amttype) {
        transdetail.getDynamicObjectCollection("recedbillentry").removeIf(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && amttype != null && amttype.equals(o.getString("e_amttype")));
    }

    public static List<DynamicObject> getRecedBillEntry(DynamicObject transdetail, Long recedbillid) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0).collect(Collectors.toList());
    }

    public static List<DynamicObject> getRecedBillEntry(DynamicObject transdetail, String recedbillnumber) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> recedbillnumber != null && recedbillnumber.equals(o.getString("e_recedbillnumber"))).collect(Collectors.toList());
    }

    public static DynamicObject getRecedBillEntry(DynamicObject transdetail, Long recedbillid, Long recedbillentryid) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && Long.compare(o.getLong("e_recedbillentryid"), recedbillid) == 0).findFirst().get();
    }

    public static DynamicObject getRecedBillEntry(DynamicObject transdetail, Long recedbillid, String amttype) {
        return transdetail.getDynamicObjectCollection("recedbillentry").stream().filter(o -> Long.compare(o.getLong("e_recedbillid"), recedbillid) == 0 && amttype != null && amttype.equals(o.getString("e_amttype"))).findFirst().get();
    }

    public static void initMatchAmount(DynamicObject businessBill, BigDecimal amount, String matchAmountProp, String unMatchAmountProp, String matchFlagProp, String matchFlagMsgProp) {
        if (businessBill != null && amount != null) {
            Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(businessBill.getBigDecimal(matchAmountProp), BigDecimal.ZERO, amount);
            AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, matchAmountProp, unMatchAmountProp, matchFlagProp, matchFlagMsgProp);
        }
    }

    public static void initMatchAmount(DynamicObject businessBill, Map<String, Object> tMatchResult, String matchAmountProp, String unMatchAmountProp, String matchFlagProp, String matchFlagMsgProp) {
        if (tMatchResult != null) {
            businessBill.set(matchAmountProp, tMatchResult.get(MATCH_AMT));
            businessBill.set(unMatchAmountProp, tMatchResult.get(UN_MATCH_AMT));
            String entityName = businessBill.getDataEntityType().getName();
            if ("cas_paybill".equals(entityName)) {
                boolean isCashOut;
                boolean isCashIn;
                if (businessBill.getDynamicObject("entrustorg") != null || BaseDataHelper.isSettleTypeMatch((DynamicObject)businessBill.getDynamicObject("settletype"))) {
                    businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONEED.getValue());
                } else {
                    businessBill.set(matchFlagProp, tMatchResult.get(MATCH_FLAG));
                }
                DynamicObject billType = businessBill.getDynamicObject("billtype");
                String businessType = businessBill.getString("businesstype");
                boolean relateOtherFlow = businessBill.getBoolean("relateotherflow");
                boolean bl = isCashIn = "cas_paybill_cash_BT_S".equals(billType.getString("number")) && PayBusinessTypeEnum.CASHIN.getValue().equals(businessType);
                if (isCashIn) {
                    if (relateOtherFlow) {
                        if (EmptyUtil.isEmpty((BigDecimal)businessBill.getBigDecimal("unmatchamountrec")) && EmptyUtil.isNoEmpty((BigDecimal)businessBill.getBigDecimal("matchamountrec"))) {
                            businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.ALL.getValue());
                        } else {
                            businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONE.getValue());
                        }
                    } else {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONEED.getValue());
                    }
                }
                boolean bl2 = isCashOut = "cas_paybill_cash_BT_S".equals(billType.getString("number")) && PayBusinessTypeEnum.CASHOUT.getValue().equals(businessType);
                if (isCashOut) {
                    if (EmptyUtil.isEmpty((BigDecimal)businessBill.getBigDecimal("unmatchamountpay")) && EmptyUtil.isNoEmpty((BigDecimal)businessBill.getBigDecimal("matchamountpay"))) {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.ALL.getValue());
                    } else {
                        businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONE.getValue());
                    }
                }
            } else if ("cas_recbill".equals(entityName) && BaseDataHelper.isSettleTypeMatch((DynamicObject)businessBill.getDynamicObject("settletype"))) {
                businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONEED.getValue());
            } else if ("cas_exchangebill".equals(entityName)) {
                String accountType = businessBill.getString("accounttype");
                if ("cas_accountcash".equals(accountType)) {
                    businessBill.set(matchFlagProp, (Object)AutoMatchFlagEnum.NONEED.getValue());
                    businessBill.set("matchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
                    businessBill.set("buymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
                    businessBill.set("sellmatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
                }
            } else {
                businessBill.set(matchFlagProp, tMatchResult.get(MATCH_FLAG));
            }
            if (tMatchResult.containsKey(MATCH_FLAG_MSG) && matchFlagMsgProp != null && matchFlagMsgProp.trim().length() > 0) {
                businessBill.set(matchFlagMsgProp, tMatchResult.get(MATCH_FLAG_MSG));
            }
        }
    }

    public static List<String> getRecedBillNumber(DynamicObjectCollection infos) {
        return AutoMatchHelper.getRecedBillNumber(infos.stream());
    }

    public static List<String> getRecedBillNumber(DynamicObject[] infos) {
        return AutoMatchHelper.getRecedBillNumber(Arrays.stream(infos));
    }

    private static List<String> getRecedBillNumber(Stream<DynamicObject> infos) {
        return infos.map(o -> o.getDynamicObjectCollection("recedbillentry")).flatMap(o -> o.stream().map(p -> p.getString("e_recedbillnumber"))).filter(o -> CasHelper.isNotEmpty((Object)o)).distinct().collect(Collectors.toList());
    }

    public static List<String> getMatchFieldKeys() {
        return Arrays.asList("recedbillentry", "recedbillentry.e_opnumber", "recedbillentry.e_recedbilltype", "recedbillentry.e_recedbillnumber", "recedbillentry.e_recedbillid", "recedbillentry.e_recedbillentryid", "recedbillentry.e_amttype", "recedbillentry.e_amount", "recedbillentry.e_direction");
    }

    public static void dealMatchBillInfo(DynamicObject[] businessBill, Map<Long, DynamicObject> autoSaveEntryMap, HashMap<Long, BigDecimal> map, String kind) {
        HashMap<String, ArrayList<Long>> dataMap = new HashMap<String, ArrayList<Long>>(10);
        ArrayList<DynamicObject> autoSaveEntrys = new ArrayList<DynamicObject>(10);
        HashMap<String, BigDecimal> mapA = new HashMap<String, BigDecimal>(4);
        for (Map.Entry<Long, DynamicObject> entry : autoSaveEntryMap.entrySet()) {
            DynamicObject entry2 = entry.getValue();
            String billType = entry2.getString("record");
            Long billId = entry2.getLong("billid");
            Long billEntryId = entry2.getLong("billentryid");
            String bizType = AutoMatchBillEnum.getByValue((String)billType).getName();
            ArrayList<Long> bizBillIds = (ArrayList<Long>)dataMap.get(bizType);
            if (bizBillIds == null) {
                bizBillIds = new ArrayList<Long>();
            }
            bizBillIds.add(billId);
            dataMap.put(bizType, bizBillIds);
            autoSaveEntrys.add(entry2);
            mapA.put(billId.toString().concat(billEntryId.toString()), map.get(entry.getKey()));
        }
        for (Map.Entry<Long, Object> entry : dataMap.entrySet()) {
            String entryName = "entrys";
            if ("cas_agentpaybill".equals(entry.getKey())) {
                entryName = "entry";
            }
            for (DynamicObject bill : businessBill) {
                Long id = Long.parseLong(bill.getPkValue().toString());
                List results = autoSaveEntrys.stream().filter(y -> y.getLong("billid") == id.longValue()).collect(Collectors.toList());
                for (DynamicObject result : results) {
                    Long entryId = result.getLong("billentryid");
                    BigDecimal amount = (BigDecimal)mapA.get(id.toString().concat(entryId.toString()));
                    if (entryId > 0L) {
                        DynamicObjectCollection entry1 = bill.getDynamicObjectCollection(entryName);
                        DynamicObject first = entry1.stream().filter(y -> y.getPkValue().equals(entryId)).findFirst().get();
                        MatchAmountDealHelper.dealWithMatchProperty(first, bill, amount, "entry");
                        continue;
                    }
                    if (MatchAmountDealHelper.A_BUSINESS_TYPE.contains(entry.getKey())) {
                        MatchAmountDealHelper.dealWithMatchProperty(bill, bill, amount, "");
                    }
                    MatchAmountDealHelper.matchManyToOne(bill, kind, amount, (String)((Object)entry.getKey()));
                }
            }
        }
    }

    private static boolean releaseOrLockBills(boolean isLock, String billType, List<String> idList) {
        Map request = isLock ? MutexServiceHelper.batchRequest(idList, (String)billType, (String)"releaseOrLockBills") : MutexServiceHelper.batchRelease(idList, (String)billType, (String)"releaseOrLockBills");
        if (request.containsValue(Boolean.FALSE)) {
            logger.info("=================\u6570\u636e" + (isLock ? "\u9501\u5b9a" : "\u89e3\u9501") + "\u5f02\u5e38");
            request.entrySet().stream().filter(o -> (Boolean)o.getValue() == false).forEach(o -> logger.info("=================\u6570\u636e\u7c7b\u578b" + billType + "\uff0cID\uff1a" + (String)o.getKey()));
        }
        return !request.containsValue(Boolean.FALSE);
    }

    public static boolean releaseOrLockBills(boolean isLock, Map<String, List<String>> billMap) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(billMap.size());
        for (Map.Entry<String, List<String>> billEntry : billMap.entrySet()) {
            if (billEntry.getValue() == null || billEntry.getValue().size() <= 0) continue;
            result.put(billEntry.getKey(), AutoMatchHelper.releaseOrLockBills(isLock, billEntry.getKey(), billEntry.getValue()));
        }
        return !result.values().contains(Boolean.FALSE);
    }

    public static boolean releaseOrLockBills(boolean isLock, DynamicObject[] details, DynamicObject[] ... busnessBillArrays) {
        HashMap<String, List<String>> billMap = new HashMap<String, List<String>>(2);
        if (details != null && details.length > 0) {
            billMap.put(details[0].getDataEntityType().getName(), Arrays.stream(details).map(o -> o.getString("id")).collect(Collectors.toList()));
        }
        if (busnessBillArrays != null && busnessBillArrays.length > 0) {
            for (DynamicObject[] busnessBills : busnessBillArrays) {
                if (busnessBills == null || busnessBills.length < 1) continue;
                String tBillType = busnessBills[0].getDataEntityType().getName();
                if (billMap.containsKey(tBillType)) {
                    List tBillIdList = (List)billMap.get(tBillType);
                    tBillIdList.addAll(Arrays.stream(busnessBills).map(o -> o.getString("id")).collect(Collectors.toList()));
                    billMap.put(tBillType, tBillIdList);
                    continue;
                }
                billMap.put(tBillType, Arrays.stream(busnessBills).map(o -> o.getString("id")).collect(Collectors.toList()));
            }
        }
        if (billMap.size() > 0) {
            return AutoMatchHelper.releaseOrLockBills(isLock, billMap);
        }
        return true;
    }

    private static boolean checkCancelMatchToInit(Long transDetailId, String recedBillType, Long recedBillId) {
        QFilter tQFilter = new QFilter("recedbillentry.e_recedbillid", "=", (Object)recedBillId);
        tQFilter.and("recedbillentry.e_recedbilltype", "=", (Object)recedBillType);
        tQFilter.and("id", "!=", (Object)transDetailId);
        tQFilter.and("receredtype", "=", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
        return !QueryServiceHelper.exists((String)"bei_transdetail_cas", (QFilter[])tQFilter.toArray());
    }

    public static void initMatchAmountInCancelMatch(Long transDetailId, DynamicObject businessBill) {
        String recedBillType = businessBill.getDataEntityType().getName();
        Long recedBillId = businessBill.getLong("id");
        Map<String, Map<String, String>> tBillFieldMap = AutoMatchHelper.getBillFieldMap(recedBillType);
        if (AutoMatchHelper.checkCancelMatchToInit(transDetailId, recedBillType, recedBillId) && tBillFieldMap != null && !tBillFieldMap.isEmpty()) {
            if (Arrays.asList("cas_paybill", "cas_recbill").contains(recedBillType)) {
                if (AutoMatchFlagEnum.ALL.getValue().equals(businessBill.getString("matchflag"))) {
                    tBillFieldMap.entrySet().forEach(o -> {
                        Map tFieldMap = (Map)o.getValue();
                        Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, businessBill.getBigDecimal((String)tFieldMap.get(MATCH_AMT)).add(businessBill.getBigDecimal((String)tFieldMap.get(UN_MATCH_AMT))));
                        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, (String)tFieldMap.get(MATCH_AMT), (String)tFieldMap.get(UN_MATCH_AMT), (String)tFieldMap.get(MATCH_FLAG), (String)tFieldMap.get(MATCH_FLAG_MSG));
                    });
                }
            } else if ("cas_agentpaybill".equals(recedBillType)) {
                Map<String, String> tFieldMap = tBillFieldMap.get("head");
                if (AutoMatchFlagEnum.ALL.getValue().equals(businessBill.getString(tFieldMap.get(MATCH_FLAG)))) {
                    Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, businessBill.getBigDecimal(tFieldMap.get(MATCH_AMT)).add(businessBill.getBigDecimal(tFieldMap.get(UN_MATCH_AMT))));
                    AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, tFieldMap.get(MATCH_AMT), tFieldMap.get(UN_MATCH_AMT), tFieldMap.get(MATCH_FLAG), tFieldMap.get(MATCH_FLAG_MSG));
                    Map<String, String> tentryFieldMap = tBillFieldMap.get("entry");
                    businessBill.getDynamicObjectCollection("entry").forEach(o -> {
                        Map<String, Object> tMatchEntryResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, o.getBigDecimal((String)tentryFieldMap.get(MATCH_AMT)).add(o.getBigDecimal((String)tentryFieldMap.get(UN_MATCH_AMT))));
                        AutoMatchHelper.initMatchAmount(o, tMatchEntryResult, (String)tentryFieldMap.get(MATCH_AMT), (String)tentryFieldMap.get(UN_MATCH_AMT), (String)tentryFieldMap.get(MATCH_FLAG), (String)tentryFieldMap.get(MATCH_FLAG_MSG));
                    });
                }
            } else if ("cas_exchangebill".equals(recedBillType)) {
                tBillFieldMap.entrySet().forEach(o -> {
                    Map tFieldMap = (Map)o.getValue();
                    if (AutoMatchFlagEnum.ALL.getValue().equals(businessBill.getString((String)tFieldMap.get(MATCH_FLAG)))) {
                        Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(BigDecimal.ZERO, BigDecimal.ZERO, businessBill.getBigDecimal((String)tFieldMap.get(MATCH_AMT)).add(businessBill.getBigDecimal((String)tFieldMap.get(UN_MATCH_AMT))));
                        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, (String)tFieldMap.get(MATCH_AMT), (String)tFieldMap.get(UN_MATCH_AMT), (String)tFieldMap.get(MATCH_FLAG), (String)tFieldMap.get(MATCH_FLAG_MSG));
                    }
                });
                MatchAmountDealHelper.updataExchangeBill(businessBill);
            }
        }
    }

    private static Map<String, Map<String, String>> getBillFieldMap(String billtype) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(1);
        switch (billtype) {
            case "cas_paybill": {
                result.putAll(AutoMatchHelper.getFieldMap("pay", "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("rec", "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg"));
                break;
            }
            case "cas_recbill": {
                result.putAll(AutoMatchHelper.getFieldMap("rec", "matchamountrec", "unmatchamountrec", "matchflag", "matchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("pay", "matchamountpay", "unmatchamountpay", "matchflag", "matchflagmsg"));
                break;
            }
            case "cas_agentpaybill": {
                result.putAll(AutoMatchHelper.getFieldMap("entry", "entrymatchamount", "entryunmatchamount", "entrymatchflag", "entrymatcherrmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("head", "matchamount", "unmatchamount", "matchflag", "matcherrmsg"));
                break;
            }
            case "cas_exchangebill": {
                result.putAll(AutoMatchHelper.getFieldMap("buy", "buymatchamount", "buyunmatchamount", "buymatchflag", "buymatchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("sell", "sellmatchamount", "sellunmatchamount", "sellmatchflag", "sellmatchflagmsg"));
                result.putAll(AutoMatchHelper.getFieldMap("fee", "feematchamount", "feeunmatchamount", "feematchflag", "feematchflagmsg"));
            }
        }
        return result;
    }

    private static Map<String, Map<String, String>> getFieldMap(String headProp, String matchAmountProp, String unMatchAmountProp, String matchFlagProp, String matchFlagMsgProp) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(4);
        if (matchAmountProp != null && matchAmountProp.trim().length() > 0) {
            fieldMap.put(MATCH_AMT, matchAmountProp);
        }
        if (unMatchAmountProp != null && unMatchAmountProp.trim().length() > 0) {
            fieldMap.put(UN_MATCH_AMT, unMatchAmountProp);
        }
        if (matchFlagProp != null && matchFlagProp.trim().length() > 0) {
            fieldMap.put(MATCH_FLAG, matchFlagProp);
        }
        if (matchFlagMsgProp != null && matchFlagMsgProp.trim().length() > 0) {
            fieldMap.put(MATCH_FLAG_MSG, matchFlagMsgProp);
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(1);
        resultMap.put(headProp != null ? headProp.trim() : "", fieldMap);
        return resultMap;
    }
}

