/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.MatchRelEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class CasFlowConfirmLogHelper {
    private static final Log logger = LogFactory.getLog(CasFlowConfirmLogHelper.class);

    public static void saveEnterLog(HashMap<Long, HashMap<String, Object>> enterInfo) {
        try {
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(enterInfo.size());
            DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", enterInfo.keySet()).toArray());
            Set ruleWaySet = enterInfo.values().stream().map(e -> (String)e.get("ruleWay")).collect(Collectors.toSet());
            if (ruleWaySet.contains(ReceredWayEnum.HANDMERGE.getValue())) {
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)"cas_flowconfirmlog");
                DynamicObject firstDetail = (DynamicObject)transDetails.get(0);
                HashMap<String, Object> enterInfoMap = enterInfo.get(firstDetail.getLong("id"));
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, firstDetail);
                confirmLog.set("billno", enterInfoMap.get("opnumber"));
                confirmLog.set("optype", (Object)ReceredWayEnum.HANDMERGE.getValue());
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                for (DynamicObject transDetail : transDetails) {
                    DynamicObject detailEntry = entryEntity.addNew();
                    CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                }
                DynamicObject bizBillEntry = entryEntity.addNew();
                CasFlowConfirmLogHelper.fillBizEnterInfo(bizBillEntry, firstDetail, enterInfoMap);
                bizBillEntry.set("recamount", (Object)transDetails.stream().map(e -> e.getBigDecimal("creditamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                bizBillEntry.set("payamount", (Object)transDetails.stream().map(e -> e.getBigDecimal("debitamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                confirmLogs.add(confirmLog);
            } else {
                for (Map.Entry<Long, HashMap<String, Object>> entryInfo : enterInfo.entrySet()) {
                    DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)"cas_flowconfirmlog");
                    Long detailId = entryInfo.getKey();
                    HashMap<String, Object> enterInfoMap = entryInfo.getValue();
                    DynamicObject transDetail = transDetails.stream().filter(e -> e.getLong("id") == detailId.longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0));
                    CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, transDetail);
                    confirmLog.set("billno", enterInfoMap.get("opnumber"));
                    confirmLog.set("optype", enterInfoMap.get("ruleWay"));
                    confirmLog.set("matchrule", enterInfoMap.get("ruleName"));
                    DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                    DynamicObject detailEntry = entryEntity.addNew();
                    CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                    DynamicObject bizBillEntry = entryEntity.addNew();
                    CasFlowConfirmLogHelper.fillBizEnterInfo(bizBillEntry, transDetail, enterInfoMap);
                    confirmLogs.add(confirmLog);
                }
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e2) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e2);
        }
    }

    public static void saveMatchLog(List<AutoMatchInfoParam> autoMatchParams, String opType) {
        if (autoMatchParams.size() == 0) {
            return;
        }
        try {
            DynamicObject transDetail;
            DynamicObject detailEntry;
            ArrayList<DynamicObject> confirmLogs = new ArrayList<DynamicObject>(autoMatchParams.size());
            Set detailIds = autoMatchParams.stream().map(AutoMatchInfoParam::getTransDetailId).collect(Collectors.toSet());
            DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            Map<Long, List<DynamicObject>> idToDetailMap = transDetails.stream().collect(Collectors.groupingBy(c -> c.getLong("id")));
            Map<Long, List<AutoMatchInfoParam>> manyToOneInfoMap = autoMatchParams.stream().filter(param -> MatchRelEnum.MANY_TO_ONE.getValue().equals(param.getMatchRelation())).collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillId));
            for (Map.Entry<Long, List<AutoMatchInfoParam>> entry : manyToOneInfoMap.entrySet()) {
                List<AutoMatchInfoParam> matchInfoList = entry.getValue();
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)"cas_flowconfirmlog");
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                DynamicObject firstDetail = null;
                AutoMatchInfoParam firstParam = matchInfoList.get(0);
                if (!transDetails.isEmpty()) {
                    firstDetail = transDetails.stream().filter(detail -> detail.getLong("id") == firstParam.getTransDetailId().longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0));
                }
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, firstDetail);
                confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
                confirmLog.set("optype", (Object)opType);
                confirmLog.set("matchrule", (Object)firstParam.getMatchRule());
                for (AutoMatchInfoParam matchParam : matchInfoList) {
                    detailEntry = entryEntity.addNew();
                    transDetail = transDetails.stream().filter(detail -> detail.getLong("id") == matchParam.getTransDetailId().longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0));
                    CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                }
                DynamicObject bizBillEntry = entryEntity.addNew();
                DynamicObject detail2 = idToDetailMap.get(firstParam.getTransDetailId()).get(0);
                CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, detail2, firstParam);
                BigDecimal totalAmt = matchInfoList.stream().map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if ("rec".equals(firstParam.getDirection())) {
                    bizBillEntry.set("recamount", (Object)totalAmt);
                } else {
                    bizBillEntry.set("payamount", (Object)totalAmt);
                }
                confirmLogs.add(confirmLog);
            }
            Map<Long, List<AutoMatchInfoParam>> detailIdToInfoMap = autoMatchParams.stream().filter(param -> MatchRelEnum.ONE_TO_MANY.getValue().equals(param.getMatchRelation()) || EmptyUtil.isEmpty((String)param.getMatchRelation())).collect(Collectors.groupingBy(AutoMatchInfoParam::getTransDetailId));
            for (Map.Entry<Long, List<AutoMatchInfoParam>> entry : detailIdToInfoMap.entrySet()) {
                Long detailId = entry.getKey();
                List<AutoMatchInfoParam> matchInfoList = entry.getValue();
                DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)"cas_flowconfirmlog");
                DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
                DynamicObject firstDetail = null;
                if (!transDetails.isEmpty()) {
                    firstDetail = idToDetailMap.get(detailId).get(0);
                }
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, firstDetail);
                AutoMatchInfoParam firstParam = matchInfoList.get(0);
                confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
                confirmLog.set("optype", (Object)opType);
                confirmLog.set("matchrule", (Object)firstParam.getMatchRule());
                detailEntry = entryEntity.addNew();
                transDetail = transDetails.stream().filter(detail -> detail.getLong("id") == detailId.longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0));
                CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                for (AutoMatchInfoParam matchParam : matchInfoList) {
                    DynamicObject bizBillEntry = entryEntity.addNew();
                    DynamicObject detail3 = idToDetailMap.get(detailId).get(0);
                    CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, detail3, matchParam);
                    if ("rec".equals(matchParam.getDirection())) {
                        bizBillEntry.set("recamount", (Object)matchParam.getAmount());
                        continue;
                    }
                    bizBillEntry.set("payamount", (Object)matchParam.getAmount());
                }
                confirmLogs.add(confirmLog);
            }
            SaveServiceHelper.save((DynamicObject[])confirmLogs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    public static void saveSingleMatchLog(List<AutoMatchInfoParam> autoMatchParams) {
        if (autoMatchParams.size() == 0) {
            return;
        }
        try {
            Set billTypeSet = autoMatchParams.stream().map(AutoMatchInfoParam::getRecedBillType).collect(Collectors.toSet());
            DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)"cas_flowconfirmlog");
            DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
            if (billTypeSet.size() == 1 && billTypeSet.contains("bei_transdetail")) {
                Set detailIds = autoMatchParams.stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet());
                DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", detailIds).toArray());
                AutoMatchInfoParam firstParam = autoMatchParams.get(0);
                confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
                confirmLog.set("optype", (Object)ReceredWayEnum.SINGLEMATCH.getValue());
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, (DynamicObject)transDetails.get(0));
                int i = 1;
                for (Long detailId : detailIds) {
                    DynamicObject detailEntry = entryEntity.addNew();
                    detailEntry.set("seq", (Object)i++);
                    DynamicObject transDetail = transDetails.stream().filter(detail -> detailId.longValue() == detail.getLong("id")).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0));
                    CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
                }
            } else {
                AutoMatchInfoParam firstParam = autoMatchParams.get(0);
                confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
                confirmLog.set("optype", (Object)ReceredWayEnum.SINGLEMATCH.getValue());
                CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, null);
                DynamicObject bizBill = QueryServiceHelper.queryOne((String)firstParam.getRecedBillType(), (String)CasFlowConfirmLogHelper.getSelectFieldStr(firstParam), (QFilter[])new QFilter("id", "=", (Object)firstParam.getRecedBillId()).toArray());
                if (bizBill != null) {
                    if ("cas_exchangebill".equals(firstParam.getRecedBillType())) {
                        String traceType = firstParam.getTraceType();
                        String currField = "buy".equals(traceType) ? "buyingcurrency" : "sellingcurrency";
                        String accountField = "buy".equals(traceType) ? "buyingaccount" : "sellingaccount";
                        confirmLog.set("currency", (Object)bizBill.getLong(currField));
                        confirmLog.set("accountbank", (Object)bizBill.getLong(accountField));
                    } else {
                        confirmLog.set("accountbank", (Object)bizBill.getLong("accountbank"));
                        confirmLog.set("currency", (Object)bizBill.getLong("currency"));
                    }
                }
                int i = 1;
                for (AutoMatchInfoParam autoMatchParam : autoMatchParams) {
                    DynamicObject bizBillEntry = entryEntity.addNew();
                    bizBillEntry.set("seq", (Object)i++);
                    CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, null, autoMatchParam);
                    String sourceEntity = autoMatchParam.getSourceEntity();
                    BigDecimal amount = autoMatchParam.getAmount();
                    if ("bei_intelrec".equals(sourceEntity)) {
                        bizBillEntry.set("recamount", (Object)amount);
                    } else {
                        bizBillEntry.set("payamount", (Object)amount);
                    }
                    if (bizBill != null) {
                        bizBillEntry.set("org", (Object)bizBill.getLong("org"));
                    }
                    bizBillEntry.set("bizdate", (Object)autoMatchParam.getBizDate());
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{confirmLog});
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    public static void saveDifferMatchLog(List<AutoMatchInfoParam> autoMatchInfoParams) {
        if (autoMatchInfoParams.size() == 0) {
            return;
        }
        try {
            DynamicObject confirmLog = BusinessDataServiceHelper.newDynamicObject((String)"cas_flowconfirmlog");
            DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
            AutoMatchInfoParam firstParam = autoMatchInfoParams.get(0);
            confirmLog.set("billno", (Object)firstParam.getThisOpnumber());
            confirmLog.set("optype", (Object)ReceredWayEnum.DIFFERMATCH.getValue());
            Set detailIds = autoMatchInfoParams.stream().map(AutoMatchInfoParam::getTransDetailId).collect(Collectors.toSet());
            DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,currency,accountbank,bizdate,billno,creditamount,debitamount", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            CasFlowConfirmLogHelper.fillCommonInfo(confirmLog, (DynamicObject)transDetails.get(0));
            int i = 1;
            for (Long detailId : detailIds) {
                DynamicObject detailEntry = entryEntity.addNew();
                detailEntry.set("seq", (Object)i++);
                DynamicObject transDetail = transDetails.stream().filter(detail -> detail.getLong("id") == detailId.longValue()).findFirst().orElseGet(() -> (DynamicObject)transDetails.get(0));
                CasFlowConfirmLogHelper.fillDetailInfo(detailEntry, transDetail);
            }
            Set bizBillIds = autoMatchInfoParams.stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet());
            for (Long bizBillId : bizBillIds) {
                DynamicObject bizBillEntry = entryEntity.addNew();
                bizBillEntry.set("seq", (Object)i++);
                AutoMatchInfoParam autoMatchInfoParam = autoMatchInfoParams.stream().filter(param -> param.getRecedBillId().equals(bizBillId)).findFirst().orElseGet(() -> (AutoMatchInfoParam)autoMatchInfoParams.get(0));
                CasFlowConfirmLogHelper.fillBizAutoMatchInfo(bizBillEntry, (DynamicObject)transDetails.get(0), autoMatchInfoParam);
                bizBillEntry.set("bizdate", (Object)autoMatchInfoParam.getBizDate());
                String recedBillType = autoMatchInfoParam.getRecedBillType();
                boolean isPay = StringUtils.equalsAny((CharSequence)recedBillType, (CharSequence[])new CharSequence[]{"cas_paybill", "cas_agentpaybill", "ifm_transhandlebill"});
                if ("cas_exchangebill".equals(recedBillType)) {
                    String traceType = autoMatchInfoParam.getTraceType();
                    isPay = "sell".equals(traceType);
                }
                if (isPay) {
                    bizBillEntry.set("payamount", (Object)autoMatchInfoParam.getAmount());
                    continue;
                }
                bizBillEntry.set("recamount", (Object)autoMatchInfoParam.getAmount());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{confirmLog});
        }
        catch (Exception e) {
            logger.error("generate flow confirm log error\uff1a", (Throwable)e);
        }
    }

    public static void updateSameTransMatchLog(String opNumber, DynamicObject transDetail) {
        DynamicObject confirmLog = BusinessDataServiceHelper.loadSingle((String)"cas_flowconfirmlog", (String)"id,entryentity,entryentity.bizobject,entryentity.billtype,entryentity.org,entryentity.bizdate,entryentity.bizbillno,entryentity.bizbillid,entryentity.detailnum,entryentity.detailid,entryentity.recamount,entryentity.payamount", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)opNumber)});
        if (EmptyUtil.isNoEmpty((DynamicObject)confirmLog)) {
            DynamicObjectCollection entryEntity = confirmLog.getDynamicObjectCollection("entryentity");
            DynamicObject newEntry = entryEntity.addNew();
            CasFlowConfirmLogHelper.fillDetailInfo(newEntry, transDetail);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{confirmLog});
    }

    private static void fillCommonInfo(DynamicObject confirmLog, DynamicObject transDetail) {
        confirmLog.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        confirmLog.set("optime", (Object)Calendar.getInstance().getTime());
        confirmLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        confirmLog.set("traceid", (Object)RequestContext.get().getRequestId());
        if (transDetail != null) {
            confirmLog.set("accountbank", (Object)transDetail.getLong("accountbank"));
            confirmLog.set("currency", (Object)transDetail.getLong("currency"));
        }
    }

    private static void fillDetailInfo(DynamicObject detailEntry, DynamicObject transDetail) {
        detailEntry.set("bizobject", (Object)"bei_transdetail");
        detailEntry.set("org", transDetail.get("company"));
        detailEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
        detailEntry.set("bizbillid", (Object)transDetail.getLong("id"));
        detailEntry.set("bizbillno", (Object)transDetail.getString("billno"));
        detailEntry.set("recamount", (Object)transDetail.getBigDecimal("creditamount"));
        detailEntry.set("payamount", (Object)transDetail.getBigDecimal("debitamount"));
    }

    private static void fillBizEnterInfo(DynamicObject bizBillEntry, DynamicObject transDetail, HashMap<String, Object> enterInfoMap) {
        bizBillEntry.set("bizobject", enterInfoMap.get("recedbilltype"));
        bizBillEntry.set("bizbillno", enterInfoMap.get("recedbillnumber"));
        bizBillEntry.set("bizbillid", enterInfoMap.get("recedbillid"));
        bizBillEntry.set("org", transDetail.get("company"));
        bizBillEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
        bizBillEntry.set("recamount", (Object)transDetail.getBigDecimal("creditamount"));
        bizBillEntry.set("payamount", (Object)transDetail.getBigDecimal("debitamount"));
    }

    private static void fillBizAutoMatchInfo(DynamicObject bizBillEntry, DynamicObject transDetail, AutoMatchInfoParam autoMatchParam) {
        if (autoMatchParam.getRecedBillType().startsWith("cas_paybill")) {
            bizBillEntry.set("bizobject", (Object)SourceBillTypeEnum.PAYBILL.getValue());
            if ("cas_paybill".equals(autoMatchParam.getRecedBillType())) {
                DynamicObjectCollection payBill = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)autoMatchParam.getRecedBillId())});
                long billTypeId = ((DynamicObject)payBill.get(0)).getLong("billtype");
                String payBillType = CasFlowConfirmLogHelper.getPayBillType(billTypeId);
                bizBillEntry.set("billtype", (Object)payBillType);
            } else {
                bizBillEntry.set("billtype", (Object)autoMatchParam.getRecedBillType());
            }
        } else {
            bizBillEntry.set("bizobject", (Object)autoMatchParam.getRecedBillType());
            if (AutoMatchBillTypeEnum.EXCHANGEBILL.getBillEntity().equals(autoMatchParam.getRecedBillType())) {
                String direction = autoMatchParam.getDirection();
                if (StringUtils.isEmpty((CharSequence)direction)) {
                    String traceType = autoMatchParam.getTraceType();
                    direction = "buy".equals(traceType) ? "rec" : "pay";
                }
                bizBillEntry.set("billtype", (Object)(autoMatchParam.getRecedBillType() + "_" + direction));
            }
        }
        bizBillEntry.set("bizbillno", (Object)autoMatchParam.getRecedBillNumber());
        bizBillEntry.set("bizbillid", (Object)autoMatchParam.getRecedBillId());
        bizBillEntry.set("detailid", (Object)autoMatchParam.getRecedBillEntryId());
        String recedBillType = autoMatchParam.getRecedBillType();
        if (autoMatchParam.getRecedBillEntryId() != null && StringUtils.equalsAny((CharSequence)recedBillType, (CharSequence[])new CharSequence[]{"cas_agentpaybill", "fca_transupbill", "fca_transdownbill"})) {
            String entityName = "";
            String selectField = "";
            String entryField = "";
            if ("cas_agentpaybill".equals(recedBillType)) {
                entityName = "cas_agentpaybill";
                selectField = "entry, entry.seq seq";
                entryField = "entry";
            } else if ("fca_transupbill".equals(recedBillType)) {
                entityName = "fca_transupbill";
                selectField = "entrys, entrys.seq seq";
                entryField = "entrys";
            } else if ("fca_transdownbill".equals(recedBillType)) {
                entityName = "fca_transdownbill";
                selectField = "entrys, entrys.seq seq";
                entryField = "entrys";
            }
            DynamicObject entry = QueryServiceHelper.queryOne((String)entityName, (String)selectField, (QFilter[])new QFilter(entryField, "=", (Object)autoMatchParam.getRecedBillEntryId()).toArray());
            if (entry != null) {
                bizBillEntry.set("detailnum", entry.get("seq"));
            }
        }
        if (transDetail != null) {
            bizBillEntry.set("org", transDetail.get("company"));
            bizBillEntry.set("bizdate", (Object)transDetail.getDate("bizdate"));
        }
    }

    public static String getPayBillType(Long billTypeId) {
        if (BillTypeConstants.PAYBILL_SYN.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYBILL_SYNONYM.getValue();
        }
        if (BillTypeConstants.PAYBILL_CASH.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYCASHBILL.getValue();
        }
        if (BillTypeConstants.PAYBILL_SPAN.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYBILL_SPAN.getValue();
        }
        if (BillTypeConstants.PAYBILL_DCEP.equals(billTypeId)) {
            return SourceBillTypeEnum.PAYBILL_DCEP.getValue();
        }
        if (BillTypeConstants.PAYBILL_PUR.equals(billTypeId)) {
            return "cas_paybill_pur";
        }
        return "cas_paybill_otr";
    }

    private static String getSelectFieldStr(AutoMatchInfoParam autoMatchInfoParam) {
        String recedBillType = autoMatchInfoParam.getRecedBillType();
        String selectFieldStr = "";
        switch (recedBillType) {
            case "cas_paybill": 
            case "cas_agentpaybill": 
            case "ifm_transhandlebill": {
                selectFieldStr = "payeracctbank accountbank,currency,org";
                break;
            }
            case "fca_transupbill": 
            case "fca_transdownbill": {
                selectFieldStr = "accountbank,currency,company org";
                break;
            }
            case "cas_recbill": {
                selectFieldStr = "accountbank,currency,org";
                break;
            }
            case "cas_exchangebill": {
                selectFieldStr = "buyingcurrency,buyingaccount,sellingcurrency,sellingaccount,org";
            }
        }
        return selectFieldStr;
    }
}

