/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cas.helper.CasHelper;
import org.apache.commons.lang.StringUtils;

public class JournalSyncHepler {
    public static Map<String, String> getConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cas_paybill", "bankcheckflag_tag");
        map.put("cas_recbill", "bankcheckflag_tag");
        map.put("cas_agentpaybill", "bankcheckflag_tag");
        return map;
    }

    public static Map<String, String> getEntryMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fca_transupbill", "entrys.bankcheckflag");
        map.put("fca_transdownbill", "entrys.bankcheckflag");
        return map;
    }

    public static Map<String, String> getFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cas_paybill", ",payeename,payeebanknum,payeebank,payeebankname,iscommitbe,feepayer");
        map.put("cas_recbill", ",payername,payeracctbanknum,f7_payerbank,payerbankname");
        map.put("cas_agentpaybill", ",iscommitbe");
        return map;
    }

    public static Boolean setOppBySourceBill(DynamicObject info, DynamicObject journal, String billType) {
        if (JournalSyncHepler.getFields().containsKey(billType) && CasHelper.isEmpty((Object)journal.getString("oppunit")) && !StringUtils.equals((String)billType, (String)"cas_agentpaybill")) {
            switch (billType) {
                case "cas_paybill": {
                    journal.set("oppunit", (Object)info.getString("payeename"));
                    journal.set("oppacctnumber", (Object)info.getString("payeebanknum"));
                    DynamicObject payeeBank = info.getDynamicObject("payeebank");
                    if (payeeBank != null) {
                        journal.set("oppbank", (Object)payeeBank.getLocaleString("name").getLocaleValue());
                        break;
                    }
                    journal.set("oppbank", (Object)info.getString("payeebankname"));
                    break;
                }
                case "cas_recbill": {
                    journal.set("oppunit", (Object)info.getString("payername"));
                    journal.set("oppacctnumber", (Object)info.getString("payeracctbanknum"));
                    DynamicObject payerBank = info.getDynamicObject("f7_payerbank");
                    if (payerBank != null) {
                        journal.set("oppbank", (Object)payerBank.getString("name"));
                        break;
                    }
                    journal.set("oppbank", (Object)info.getString("payerbankname"));
                }
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isCommitbe(DynamicObject info, String billType) {
        Boolean isCommitbe;
        if ((StringUtils.equals((String)billType, (String)"cas_paybill") || StringUtils.equals((String)billType, (String)"cas_agentpaybill")) && (isCommitbe = Boolean.valueOf(info.getBoolean("iscommitbe"))).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isCheckVoucherMixBook(String sourceType) {
        return "0".equals(sourceType) || "3".equals(sourceType) || "7".equals(sourceType) || "8".equals(sourceType);
    }
}

