/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPayeeOrPayerHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class PaymentFillPropHelper {
    private static Log logger = LogFactory.getLog(PaymentFillPropHelper.class);

    public static void fillProp(DynamicObject paymentBill) {
        PaymentFillPropHelper.supplePayeeInfo(paymentBill);
        DynamicObject org = paymentBill.getDynamicObject("org");
        if (org != null) {
            DynamicObject payerAcctBank;
            DynamicObject settletype;
            DynamicObject dpCurrency;
            DynamicObject currency;
            long orgId = org.getLong("id");
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (baseCurrency != null) {
                paymentBill.set("basecurrency", (Object)baseCurrency);
            }
            if ((currency = paymentBill.getDynamicObject("currency")) != null && CasHelper.isNotEmpty((Object)(currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency")))) {
                paymentBill.set("currency", (Object)currency);
            }
            if ((dpCurrency = paymentBill.getDynamicObject("dpcurrency")) != null && CasHelper.isNotEmpty((Object)(dpCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)dpCurrency.getPkValue(), (String)"bd_currency")))) {
                paymentBill.set("dpcurrency", (Object)dpCurrency);
            }
            if ((settletype = paymentBill.getDynamicObject("settletype")) != null && CasHelper.isNotEmpty((Object)(settletype = BusinessDataServiceHelper.loadSingleFromCache((Object)settletype.getPkValue(), (String)"bd_settlementtype")))) {
                paymentBill.set("settletype", (Object)settletype);
            }
            if ((payerAcctBank = paymentBill.getDynamicObject("payeracctbank")) != null) {
                payerAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAcctBank.getPkValue(), (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultpay,openorg,isopenbank,issetbankinterface,isvirtual,iselecpayment");
                if (BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype) && !VisibleVirtualAcctHelper.checkVirtualAcct(payerAcctBank).booleanValue()) {
                    payerAcctBank = null;
                    paymentBill.set("payeracctbank", (Object)payerAcctBank);
                    paymentBill.set("payerbank", (Object)payerAcctBank);
                }
            } else if (settletype == null || !SettleMentTypeEnum.MONEY.getValue().equals(settletype.getString("settlementtype"))) {
                DynamicObject[] accountBanks;
                QFilter filter = new QFilter("company", "=", org.getPkValue());
                QFilter recFilter = new QFilter("isdefaultpay", "=", (Object)"1");
                QFilter statusFilter = new QFilter("acctstatus", "=", (Object)"normal");
                QFilter currFilter = null;
                if (CasHelper.isNotEmpty((Object)currency)) {
                    currFilter = new QFilter("currency.fbasedataid.id", "=", currency.getPkValue());
                }
                if ((accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultpay,openorg,isopenbank,issetbankinterface,isvirtual,iselecpayment", (QFilter[])new QFilter[]{filter, recFilter, statusFilter, currFilter})) != null && accountBanks.length > 0 && (BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype) && VisibleVirtualAcctHelper.checkVirtualAcct(accountBanks[0]).booleanValue() || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype) && !VisibleVirtualAcctHelper.checkVirtualAcct(accountBanks[0]).booleanValue())) {
                    payerAcctBank = accountBanks[0];
                }
            }
            if (payerAcctBank != null) {
                paymentBill.set("payeracctbank", (Object)payerAcctBank);
                PaymentFillPropHelper.setValueIfAbsent(paymentBill, "payerbank", payerAcctBank.getDynamicObject("bank"));
                PaymentFillPropHelper.setValueIfAbsent(paymentBill, "openorg", payerAcctBank.getDynamicObject("openorg"));
                PaymentFillPropHelper.setSettleorg(paymentBill);
            }
            PaymentFillPropHelper.setPayCountryValue(paymentBill);
            if (CasHelper.isEmpty((Object)paymentBill.getDynamicObject("exratetable"))) {
                PaymentFillPropHelper.setDefaultExratetable(paymentBill, orgId);
            }
            PaymentFillPropHelper.setValueIfAbsent(paymentBill, "exratedate", DateUtils.getCurrentDate());
            BigDecimal exchangeRate = paymentBill.getBigDecimal("exchangerate");
            if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                exchangeRate = BigDecimal.ONE;
                if (currency != null && baseCurrency != null) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = paymentBill.getDate("exratedate");
                        DynamicObject exrateTable = paymentBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                if (CasHelper.isNotEmpty((Object)exchangeRate)) {
                    paymentBill.set("exchangerate", (Object)exchangeRate);
                }
            }
            if (CasHelper.isEmpty((Object)paymentBill.getString("paymentchannel"))) {
                PaymentFillPropHelper.setPaymentChannelValue(paymentBill, payerAcctBank);
            }
            PaymentFillPropHelper.setDiffPayInfo(paymentBill, orgId);
            PaymentFillPropHelper.calculateAmt(paymentBill, true);
            DynamicObject paymentType = paymentBill.getDynamicObject("paymenttype");
            if (paymentType != null) {
                paymentType = BusinessDataServiceHelper.loadSingleFromCache((Object)paymentType.getPkValue(), (String)"cas_paymentbilltype", (String)"id,fundflowitem");
                PaymentFillPropHelper.fillFundflowItem(paymentBill, paymentType.getDynamicObject("fundflowitem"));
            }
        }
    }

    public static void setPaymentChannelValue(DynamicObject targetBill, DynamicObject payerAcctBank) {
        String defChannel = "";
        DynamicObject settletype = targetBill.getDynamicObject("settletype");
        defChannel = payerAcctBank == null || settletype != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settletype.getString("settlementtype")) ? PaymentChannelEnum.COUNTER.getValue() : (payerAcctBank.getBoolean("isopenbank") ? PaymentChannelEnum.ONLINEBANK.getValue() : (payerAcctBank.getBoolean("issetbankinterface") ? PaymentChannelEnum.BEI.getValue() : PaymentChannelEnum.COUNTER.getValue()));
        targetBill.set("paymentchannel", (Object)defChannel);
    }

    public static void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }

    public static void setDiffPayInfo(DynamicObject targetBill, Long orgId) {
        targetBill.set("dpexratetable", targetBill.get("exratetable"));
        targetBill.set("dpexratedate", targetBill.get("exratedate"));
        DynamicObject dpCurrency = targetBill.getDynamicObject("dpcurrency");
        if (targetBill.getBoolean("isdiffcur") && CasHelper.isNotEmpty((Object)dpCurrency)) {
            BigDecimal agreedRate;
            BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
            if (CasHelper.isEmpty((Object)dpExchangeRate) || dpExchangeRate.compareTo(BigDecimal.ONE) == 0) {
                dpExchangeRate = BigDecimal.ONE;
                DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
                if (CasHelper.isNotEmpty((Object)baseCurrency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = dpCurrency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("dpexratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("dpexratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            dpExchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                if (CasHelper.isNotEmpty((Object)dpExchangeRate)) {
                    targetBill.set("dpexchangerate", (Object)dpExchangeRate);
                }
            }
            if (CasHelper.isEmpty((Object)(agreedRate = targetBill.getBigDecimal("agreedrate"))) || agreedRate.compareTo(BigDecimal.ONE) == 0) {
                agreedRate = BigDecimal.ONE;
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (CasHelper.isNotEmpty((Object)currency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = dpCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            agreedRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                if (CasHelper.isNotEmpty((Object)agreedRate)) {
                    targetBill.set("agreedrate", (Object)agreedRate);
                }
            }
        } else {
            targetBill.set("dpcurrency", targetBill.get("currency"));
            targetBill.set("dpexchangerate", targetBill.get("exchangerate"));
            targetBill.set("agreedrate", (Object)BigDecimal.ONE);
        }
    }

    public static void calculateAmt(DynamicObject targetBill) {
        PaymentFillPropHelper.calculateAmt(targetBill, true);
    }

    public static void calculateAmt(DynamicObject targetBill, boolean isSave) {
        PaymentFillPropHelper.calculateAmt(targetBill, isSave, false);
    }

    public static void calculateAmt(DynamicObject targetBill, boolean isSave, boolean isFromSche) {
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        String quotation = targetBill.getString("payquotation");
        if (null == quotation) {
            quotation = PaymentFillPropHelper.quoteType(targetBill);
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (DynamicObject rowInfo : entry) {
            BigDecimal payAmount = rowInfo.getBigDecimal("e_payableamt");
            BigDecimal payableLocamt = rowInfo.getBigDecimal("e_payablelocamt");
            if (payAmount != null && CasHelper.isEmpty((Object)payableLocamt) || !isSave) {
                BigDecimal payablelocamt = QuotationHelper.callToCurrency((BigDecimal)payAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                rowInfo.set("e_payablelocamt", (Object)payablelocamt);
            }
            BigDecimal discountAmt = rowInfo.getBigDecimal("e_discountamt");
            BigDecimal discountAmtLocam = rowInfo.getBigDecimal("e_discountlocamt");
            if (discountAmt != null && CasHelper.isEmpty((Object)discountAmtLocam) || !isSave) {
                BigDecimal discountlocamt = QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                rowInfo.set("e_discountlocamt", (Object)discountlocamt);
            }
            BigDecimal localAmt = rowInfo.getBigDecimal("e_localamt");
            if (payAmount != null && discountAmt != null) {
                BigDecimal actAmt = payAmount.subtract(discountAmt);
                sumAmt = sumAmt.add(actAmt);
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                sumLocalAmt = sumLocalAmt.add(actLocalAmt);
                rowInfo.set("e_actamt", (Object)actAmt);
                if (CasHelper.isEmpty((Object)localAmt) || !isSave) {
                    rowInfo.set("e_localamt", (Object)actLocalAmt);
                }
            }
            if (isSave) {
                rowInfo.set("e_unsettledamt", (Object)payAmount);
                rowInfo.set("e_unlockamt", (Object)payAmount);
            }
            BigDecimal unsettledamt = rowInfo.getBigDecimal("e_unsettledamt");
            BigDecimal unsettledlocalamt = QuotationHelper.callToCurrency((BigDecimal)unsettledamt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
            rowInfo.set("e_unsettledlocalamt", (Object)unsettledlocalamt);
        }
        targetBill.set("actpayamt", (Object)sumAmt);
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        if (CasHelper.isEmpty((Object)localAmt) || !isSave) {
            targetBill.set("localamt", (Object)sumLocalAmt);
        }
        PaymentFillPropHelper.calculateDpAmt(targetBill, isSave, isFromSche);
    }

    private static void calculateDpAmt(DynamicObject targetBill, boolean isSave, boolean isFromSche) {
        BigDecimal oldLossAmt;
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        String dppayquotation = targetBill.getString("dppayquotation");
        if (null == dppayquotation) {
            dppayquotation = PaymentFillPropHelper.quoteType(targetBill);
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        BigDecimal dpAmt = targetBill.getBigDecimal("dpamt");
        if (isSave) {
            if (CasHelper.isEmpty((Object)dpAmt) || isFromSche) {
                BigDecimal agreedRate;
                DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
                String agreedquotation = targetBill.getString("agreedquotation");
                int dppayround = 10;
                if (dpcurrency != null) {
                    dppayround = dpcurrency.getInt("amtprecision");
                }
                if ((agreedRate = targetBill.getBigDecimal("agreedrate")).compareTo(new BigDecimal(0)) == 0) {
                    return;
                }
                BigDecimal actPayAmt = targetBill.getBigDecimal("actpayamt");
                if (currency != null) {
                    actPayAmt = actPayAmt.setScale(currency.getInt("amtprecision"), 4);
                }
                dpAmt = QuotationHelper.calAmtByRate((BigDecimal)actPayAmt, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
                targetBill.set("dpamt", (Object)dpAmt);
            }
        } else {
            dpAmt = targetBill.getBigDecimal("dpamt");
        }
        BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        BigDecimal dplocalAmt = targetBill.getBigDecimal("dplocalamt");
        if (CasHelper.isEmpty((Object)dplocalAmt)) {
            targetBill.set("dplocalamt", (Object)dpLocalAmt);
        }
        if (CasHelper.isEmpty((Object)(oldLossAmt = targetBill.getBigDecimal("lossamt"))) || isFromSche) {
            targetBill.set("lossamt", (Object)localAmt.subtract(dpLocalAmt));
        }
    }

    private static String quoteType(DynamicObject targetBill) {
        Map exchangeRateByRules;
        DynamicObject currency = targetBill.getDynamicObject("currency");
        DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject exRateTable = targetBill.getDynamicObject("exratetable");
        Date exRateDate = (Date)targetBill.get("exratedate");
        String quoteType = "0";
        if (currency != null && baseCurrency != null && exRateTable != null && exRateDate != null && (exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exRateDate)).get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
            quoteType = "1";
        }
        return quoteType;
    }

    public static void setPayCountryValue(DynamicObject targetBill) {
        DynamicObject payerBank = targetBill.getDynamicObject("payerbank");
        if (payerBank != null && CasHelper.isEmpty((Object)targetBill.getDynamicObject("paycountry")) && CasHelper.isNotEmpty((Object)(payerBank = BusinessDataServiceHelper.loadSingle((Object)payerBank.getPkValue(), (String)"bd_finorginfo", (String)"id,country")))) {
            targetBill.set("paycountry", (Object)payerBank.getDynamicObject("country"));
        }
    }

    public static void supplePayeeInfo(DynamicObject targetBill) {
        String billName;
        Object payeeType;
        Object payee = targetBill.get("payee");
        Map resultMap = CasPayeeOrPayerHelper.getPayeeOrPayerInfo((Object)payee, (Object)(payeeType = targetBill.get("payeetype")), (String)(billName = targetBill.getDataEntityType().getName()));
        if (resultMap.size() > 0) {
            Object bankaccount = resultMap.get("payeebanknum");
            Object accountname = resultMap.get("accountname");
            DynamicObject payeebank = (DynamicObject)resultMap.get("payeebank");
            PaymentFillPropHelper.setValueIfAbsent(targetBill, "payeebanknum", bankaccount);
            PaymentFillPropHelper.setValueIfAbsent(targetBill, "recaccbankname", accountname);
            PaymentFillPropHelper.setValueIfAbsent(targetBill, "recemail", resultMap.get("payeeemail"));
            PaymentFillPropHelper.setValueIfAbsent(targetBill, "recaddress", resultMap.get("payeeaddress"));
            if (targetBill.get("payeebank") != null) {
                payeebank = targetBill.getDynamicObject("payeebank");
            }
            if (payeebank != null) {
                PaymentFillPropHelper.setValueIfAbsent(targetBill, "payeebank", payeebank);
                if (EmptyUtil.isEmpty((Object)targetBill.get("payeebankname"))) {
                    targetBill.set("payeebankname", (Object)payeebank.getLocaleString("name").getLocaleValue());
                }
                if (CasHelper.isNotEmpty((Object)(payeebank = BusinessDataServiceHelper.loadSingleFromCache((Object)payeebank.getPkValue(), (String)"bd_bebank", (String)"union_number,swift_code,routingnum,other_code,address_eng,country,provincetxt,citytxt")))) {
                    if (targetBill.get("recbanknumber") == null) {
                        targetBill.set("recbanknumber", (Object)payeebank.getString("union_number"));
                    }
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "recswiftcode", payeebank.getString("swift_code"));
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "recroutingnum", payeebank.getString("routingnum"));
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "recothercode", payeebank.getString("other_code"));
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "recbankaddress", payeebank.getString("address_eng"));
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "reccountry", payeebank.getDynamicObject("country"));
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "recprovince", payeebank.getString("provincetxt"));
                    PaymentFillPropHelper.setValueIfAbsent(targetBill, "reccity", payeebank.getString("citytxt"));
                }
            }
        }
    }

    public static void setSettleorg(DynamicObject targetBill) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        DynamicObject openorg = targetBill.getDynamicObject("openorg");
        for (DynamicObject rowInfo : entry) {
            PaymentFillPropHelper.setValueIfAbsent(rowInfo, "settleorg", openorg);
        }
    }

    public static void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    public static void fillPayeeAcctInfo(DynamicObject payBill) {
        DynamicObject internal_company;
        long payee = payBill.getLong("payee");
        if (payee == 0L) {
            return;
        }
        String payeeacctbank = payBill.getString("payeeacctbank");
        String payeebanknum = payBill.getString("payeebanknum");
        if (CasHelper.isNotEmpty((Object)payeeacctbank) && !"0".equals(payeeacctbank) || CasHelper.isEmpty((Object)payeebanknum)) {
            return;
        }
        String payeetype = payBill.getString("payeetype");
        Object companyId = null;
        if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeetype)) {
            DynamicObject supplierDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payee, (String)AsstActTypeEnum.SUPPLIER.getValue());
            internal_company = supplierDO.getDynamicObject("internal_company");
            if (CasHelper.isEmpty((Object)internal_company)) {
                return;
            }
            companyId = internal_company.getPkValue();
        } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeetype)) {
            DynamicObject customerDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payee, (String)AsstActTypeEnum.CUSTOMER.getValue());
            internal_company = customerDO.getDynamicObject("internal_company");
            if (CasHelper.isEmpty((Object)internal_company)) {
                return;
            }
            companyId = internal_company.getPkValue();
        } else if (AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) {
            companyId = payee;
        } else {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)payeebanknum), new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED)};
        DynamicObject payeeAccount = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,company,bank", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((DynamicObject)payeeAccount)) {
            if (EmptyUtil.isNoEmpty((Long)payeeAccount.getLong("company")) && companyId.equals(payeeAccount.getLong("company"))) {
                payBill.set("payeeacctbank", (Object)payeeAccount.getLong("id"));
            } else {
                PaymentFillPropHelper.setPayeeAcctBank(payBill, companyId, payeeAccount.getLong("id"));
            }
        }
    }

    public static void calSettlAmt(DynamicObject targetBill) {
        String sourceBillType = targetBill.getString("sourcebilltype");
        if ("ar_finarbill".equals(sourceBillType) || "ap_finapbill".equals(sourceBillType) || PaymentServiceHelper.isNeedLockAmt(sourceBillType, targetBill.getLong("sourcebillid"))) {
            DynamicObjectCollection entryColl = targetBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entry.set("e_lockAmt", (Object)entry.getBigDecimal("e_payableAmt"));
                entry.set("e_unlockAmt", (Object)BigDecimal.ZERO);
                entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableAmt").subtract(entry.getBigDecimal("e_settledamt")));
            }
        }
    }

    public static void setDefaultProvinceAndCity(DynamicObject[] payBills) {
        for (DynamicObject payBill : payBills) {
            QFilter filter;
            DynamicObject bank;
            DynamicObject payeeBank;
            if (payBill.getBoolean("iscrosspay") || StringUtils.isNotEmpty((String)payBill.getString("recprovince")) || StringUtils.isNotEmpty((String)payBill.getString("reccity")) || (payeeBank = payBill.getDynamicObject("payeebank")) == null || (bank = QueryServiceHelper.queryOne((String)"bd_bebank", (String)"id,provincetxt,citytxt", (QFilter[])(filter = new QFilter("id", "=", (Object)payeeBank.getLong("id"))).toArray())) == null) continue;
            payBill.set("recprovince", bank.get("provincetxt"));
            payBill.set("reccity", bank.get("citytxt"));
        }
    }

    private static void fillFundflowItem(DynamicObject targetBill, DynamicObject defaultFundsItem) {
        if (defaultFundsItem == null) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject row : entry) {
            PaymentFillPropHelper.setValueIfAbsent(row, "e_fundflowitem", defaultFundsItem);
        }
    }

    private static void setPayeeAcctBank(DynamicObject payBill, Object useOrgId, long accountBankId) {
        String selectSql = "select fdataid from t_bd_accountbanksUseReg where fuseorgid = ? and fdataid = ?";
        Object[] params = new Object[]{useOrgId, accountBankId};
        DataSet accountBankAssigns = DB.queryDataSet((String)"PaymentFillPropHelper-setPayeeAcctBank", (DBRoute)new DBRoute("sys"), (String)selectSql, (Object[])params);
        for (Row next : accountBankAssigns) {
            if (!EmptyUtil.isNoEmpty((Object)next) || !EmptyUtil.isNoEmpty((Long)next.getLong("fdataid"))) continue;
            payBill.set("payeeacctbank", (Object)next.getLong("fdataid"));
            break;
        }
    }
}

