/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.writeback.RecClaimWriteBackConsumer;
import kd.fi.cas.business.writeback.RecWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.CasHelper;

public class RecBillOverAmountHelper {
    private static final Log logger = LogFactory.getLog(RecBillOverAmountHelper.class);

    public static OperationResult getWriteBackVad(DynamicObject info, WriteBackOperateEnum writeEnum, boolean isValidate) {
        if (info == null) {
            return null;
        }
        String entryName = "entryentity";
        if ("cas_recbill".equals(info.getDataEntityType().getName()) || "cas_recbill_change".equals(info.getDataEntityType().getName())) {
            entryName = "entry";
        }
        DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
        boolean validateFr = false;
        boolean validateSm = false;
        for (DynamicObject entry : entrys) {
            String billType = entry.getString("e_corebilltype");
            String corebillNo = entry.getString("e_corebillno");
            if (CasHelper.isEmpty((Object)corebillNo)) continue;
            if ("fr_glreim_paybill".equals(billType) || "fr_glreim_recbill".equals(billType)) {
                validateFr = true;
            }
            if (!"sm_salorder".equals(billType)) continue;
            validateSm = true;
        }
        if (validateFr) {
            logger.info("\u603b\u8d26\u62a5\u8d26\u5355validate");
            RecBillOverAmountHelper.validateRequest(info, "fr_glreim_bill", entryName, isValidate, writeEnum);
        }
        if (validateSm && (WriteBackOperateEnum.RECEIVE == writeEnum || WriteBackOperateEnum.CANCELRECEIVE == writeEnum)) {
            RecBillOverAmountHelper.validateRequest(info, "sm_salorder", entryName, isValidate, writeEnum);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validateRequest(DynamicObject info, String billType, String entryName, boolean isValidate, WriteBackOperateEnum writeEnum) {
        DynamicObjectCollection entrys;
        Throwable throwable;
        TXHandle tx;
        block23: {
            block24: {
                tx = TX.requiresNew();
                throwable = null;
                entrys = info.getDynamicObjectCollection(entryName);
                if ("fr_glreim_bill".equals(billType)) {
                    entrys = entrys.stream().filter(entry -> CasHelper.isNotEmpty((Object)entry.getString("e_corebillno")) && ("fr_glreim_paybill".equals(entry.getString("e_corebilltype")) || "fr_glreim_recbill".equals(entry.getString("e_corebilltype")))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                } else if ("ar_finarbill".equals(billType)) {
                    entrys = entrys.stream().filter(entry -> CasHelper.isNotEmpty((Object)entry.getString("e_corebillno")) && "ar_finarbill".equals(entry.getString("e_corebilltype"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                } else if ("sm_salorder".equals(billType)) {
                    entrys = entrys.stream().filter(entry -> CasHelper.isNotEmpty((Object)entry.getString("e_corebillno")) && "sm_salorder".equals(entry.getString("e_corebilltype"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                }
                if (entrys.size() != 0) break block23;
                if (tx == null) return;
                if (throwable == null) break block24;
                try {
                    tx.close();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                return;
            }
            tx.close();
            return;
        }
        try {
            try {
                List payEntryPks = entrys.stream().map(row -> row.getPkValue()).collect(Collectors.toList());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("entryPks", payEntryPks);
                params.put("info", info);
                Object result = null;
                logger.info("writeback helper");
                result = "entry".equals(entryName) ? WriteBackTaskHelper.addRealtimeTaskEntry(info, entrys, billType, entryName, writeEnum, RecWriteBackConsumer.class, params) : WriteBackTaskHelper.addRealtimeTaskEntry(info, entrys, billType, entryName, writeEnum, RecClaimWriteBackConsumer.class, params);
                if (!isValidate || !CasHelper.isNotEmpty((Object)result)) return;
                WriteBackValidateHelper.WriteBackResultDeal(info, result, billType, writeEnum);
                return;
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u63d0\u4ea4\u6821\u9a8c\u5f02\u5e38\uff1a" + e);
                if (!isValidate || !"fr_glreim_bill".equals(billType)) return;
                throw e;
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

