/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.writeback.task.ClaimWriteDetailParam;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecClaimBillHelper {
    public static void writeBackByClaimBatch(DynamicObject[] recBills, Boolean isRec) {
        if (CasHelper.isEmpty((DynamicObject[])recBills)) {
            return;
        }
        List<DynamicObject> bills = Arrays.stream(recBills).filter(e -> "cas_claimcenterbill".equals(e.getString("sourcebilltype"))).collect(Collectors.toList());
        if (bills == null || bills.size() == 0) {
            return;
        }
        String type = ((DynamicObject)bills.get(0)).getString("sourcebilltype");
        List sourceIds = bills.stream().map(e -> e.get("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] claimBills = BusinessDataServiceHelper.load((Object[])sourceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)type));
        HashMap longDynamicObjectMap = new HashMap(bills.size());
        bills.forEach(e -> longDynamicObjectMap.put(e.getLong("sourcebillid"), e));
        HashMap<Long, HashMap<String, Object>> map = new HashMap<Long, HashMap<String, Object>>(claimBills.length);
        if (!CasHelper.isEmpty((DynamicObject[])claimBills)) {
            for (DynamicObject claimBill : claimBills) {
                if (!StringUtils.equals((CharSequence)claimBill.getString("businesstype"), (CharSequence)"rec") && !StringUtils.equals((CharSequence)claimBill.getString("businesstype"), (CharSequence)"pay")) continue;
                DynamicObject businessBill = (DynamicObject)longDynamicObjectMap.get(claimBill.getLong("id"));
                HashMap<String, Object> transFerInfo = new HashMap<String, Object>(8);
                transFerInfo.put("recedbilltype", businessBill.getDataEntityType().getName());
                transFerInfo.put("recedbillnumber", businessBill.getString("billno"));
                transFerInfo.put("billId", businessBill.getLong("id"));
                List<Long> allDetailIds = RecClaimHelper.getAllChildNoticeBill((Object)claimBill.getPkValue()).stream().map(dy -> dy.getLong("sourceid")).collect(Collectors.toList());
                allDetailIds.forEach(e -> map.put((Long)e, transFerInfo));
            }
            if (map == null || map.size() == 0) {
                return;
            }
            RecClaimBillHelper.writeBeiSyncBatch(map, isRec);
        }
    }

    public static void writeBeiSyncBatch(HashMap<Long, HashMap<String, Object>> map, Boolean isRec) {
        ClaimWriteDetailParam param = new ClaimWriteDetailParam();
        param.setWriteOrCancel(isRec);
        if (isRec.booleanValue()) {
            param.setRecInfo(map);
        } else {
            param.setIds(map.keySet().toArray());
        }
        ECGlobalSession.begin((String)"CLAIM_WRITE_DETAIL", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"claimWrite");
        ECGlobalSession.setBusinessInfo(map.keySet().stream().map(e -> e.toString()).collect(Collectors.toList()));
        ECGlobalSession.setAsync((boolean)true);
        ECGlobalSession.register((String)"fi", (String)"cas", (String)"ClaimWriteDetailService", (Param)param, null, (String)"");
    }

    public static void claimCancelAccount(String[] sourceBillIds, String sourceBillType, String ... reason) {
        if (sourceBillIds == null || sourceBillIds.length == 0) {
            return;
        }
        List<String> ids = Arrays.asList(sourceBillIds);
        if (!"cas_claimcenterbill".equals(sourceBillType)) {
            return;
        }
        DynamicObject[] claimBill = BusinessDataServiceHelper.load((Object[])ids.stream().map(Long::valueOf).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceBillType));
        if (!CasHelper.isEmpty((DynamicObject[])claimBill)) {
            DynamicObject bill = claimBill[0];
            bill.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
            bill.set("confirmuser", null);
            bill.set("confirmdate", null);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entry.set("e_handlestatus", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue());
            }
            if (reason != null) {
                bill.set("chargereason", (Object)reason);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            QFilter qFilter = new QFilter("claimno", "=", (Object)bill.getString("billno"));
            Object[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimstatus,handlestatus", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])colls)) {
                for (Object coll : colls) {
                    coll.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                    coll.set("handlestatus", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])colls);
            }
        }
    }

    public static void unClaimAccount(Object[] pkIds) {
        DynamicObject[] claimNoticeBill = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimcenterbill"));
        if (claimNoticeBill != null && claimNoticeBill.length > 0) {
            for (DynamicObject dynamicObject : claimNoticeBill) {
                dynamicObject.set("isunclaim", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])claimNoticeBill);
        }
    }

    public static DynamicObjectCollection claimEntryOrder(DynamicObjectCollection entrys) {
        Boolean billstatus;
        int num = 0;
        for (DynamicObject entry : entrys) {
            billstatus = entry.getBoolean("e_billstatus");
            int seq = entry.getInt("seq");
            if (billstatus.booleanValue()) continue;
            num = seq > num ? seq : num;
        }
        for (DynamicObject entry : entrys) {
            billstatus = entry.getBoolean("e_billstatus");
            if (!billstatus.booleanValue()) continue;
            entry.set("seq", (Object)(++num));
        }
        return entrys;
    }
}

