/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.RecAmtTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class RecFillPropHelper {
    private static Log logger = LogFactory.getLog(RecFillPropHelper.class);

    public static void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    public static void fillProp(DynamicObject recBill) {
        if (recBill != null) {
            RecFillPropHelper.calculateAmt(recBill);
        }
    }

    private static void calculateAmt(DynamicObject recBill) {
        DynamicObject org = recBill.getDynamicObject("org");
        if (org != null) {
            int cs = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs117");
            if (RecAmtTypeEnum.RECEIVABLEAMT.getValue().equals(String.valueOf(cs))) {
                RecFillPropHelper.calculateAmtByRecamt(recBill);
            } else {
                RecFillPropHelper.calculateAmtByActamt(recBill);
            }
        }
    }

    public static void calculateAmtByRecamt(DynamicObject recBill) {
        String quotation = recBill.getString("quotation");
        BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
        BigDecimal fee = recBill.getBigDecimal("fee");
        DynamicObject currency = recBill.getDynamicObject("currency");
        if (currency == null) {
            return;
        }
        DynamicObject basecurrency = recBill.getDynamicObject("basecurrency");
        if (basecurrency == null) {
            return;
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            BigDecimal subtract = row.getBigDecimal("e_receivableamt").subtract(row.getBigDecimal("e_discountamt"));
            amount = amount.add(subtract);
        }
        BigDecimal countFee = BigDecimal.ZERO;
        boolean feeTemp = false;
        for (DynamicObject rowInfo : entry) {
            BigDecimal e_fee = rowInfo.getBigDecimal("e_fee");
            if (!CasHelper.isNotEmpty((Object)e_fee)) continue;
            feeTemp = true;
            break;
        }
        BigDecimal sumFee = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal actAmt;
            BigDecimal recAmount = ((DynamicObject)entry.get(i)).getBigDecimal("e_receivableamt");
            BigDecimal recAmountLocamt = ((DynamicObject)entry.get(i)).getBigDecimal("e_receivablelocamt");
            if (recAmount != null && CasHelper.isEmpty((Object)recAmountLocamt)) {
                ((DynamicObject)entry.get(i)).set("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")));
            }
            BigDecimal discountAmt = ((DynamicObject)entry.get(i)).getBigDecimal("e_discountamt");
            BigDecimal discountAmtLocamt = ((DynamicObject)entry.get(i)).getBigDecimal("e_discountlocamt");
            if (discountAmt != null && CasHelper.isEmpty((Object)discountAmtLocamt)) {
                ((DynamicObject)entry.get(i)).set("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")));
            }
            BigDecimal elocalAmt = ((DynamicObject)entry.get(i)).getBigDecimal("e_localamt");
            if (recAmount != null && !feeTemp) {
                actAmt = recAmount.subtract(discountAmt);
                ((DynamicObject)entry.get(i)).set("e_fee", (Object)BigDecimal.ZERO);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmt.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (RecFillPropHelper.getLastRow(i, entry.getRowCount()).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    ((DynamicObject)entry.get(i)).set("e_fee", (Object)efee);
                    actAmt = actAmt.subtract(efee);
                }
                sumAmt = sumAmt.add(actAmt);
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                sumLocalAmt = sumLocalAmt.add(actLocalAmt);
                ((DynamicObject)entry.get(i)).set("e_actamt", (Object)actAmt);
                if (CasHelper.isEmpty((Object)elocalAmt)) {
                    ((DynamicObject)entry.get(i)).set("e_localamt", (Object)actLocalAmt);
                }
            }
            if (recAmount != null && feeTemp) {
                actAmt = recAmount.subtract(discountAmt);
                BigDecimal e_fee = ((DynamicObject)entry.get(i)).getBigDecimal("e_fee");
                if (e_fee != null) {
                    sumFee = e_fee.add(sumFee);
                    actAmt = actAmt.subtract(e_fee);
                }
                sumAmt = sumAmt.add(actAmt);
                ((DynamicObject)entry.get(i)).set("e_actamt", (Object)actAmt);
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                if (CasHelper.isEmpty((Object)elocalAmt)) {
                    ((DynamicObject)entry.get(i)).set("e_localamt", (Object)localAmt);
                }
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            ((DynamicObject)entry.get(i)).set("e_unsettledamt", (Object)recAmount);
            if (recAmount != null) {
                ((DynamicObject)entry.get(i)).set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)recAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round));
            }
            ((DynamicObject)entry.get(i)).set("e_unlockamt", (Object)recAmount);
        }
        recBill.set("actrecamt", (Object)sumAmt);
        BigDecimal localAmt = recBill.getBigDecimal("localamt");
        if (CasHelper.isEmpty((Object)localAmt)) {
            recBill.set("localamt", (Object)sumLocalAmt);
        }
        if (feeTemp) {
            recBill.set("fee", (Object)sumFee);
        }
    }

    public static void calculateAmtByActamt(DynamicObject recBill) {
        DynamicObject currency;
        String quotation = recBill.getString("quotation");
        BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
        BigDecimal fee = recBill.getBigDecimal("fee");
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        if (fee == null) {
            fee = BigDecimal.ZERO;
        }
        if ((currency = recBill.getDynamicObject("currency")) == null) {
            return;
        }
        DynamicObject basecurrency = recBill.getDynamicObject("basecurrency");
        if (basecurrency == null) {
            return;
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        BigDecimal sumFee = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
        boolean feeTemp = false;
        for (DynamicObject rowInfo : entry) {
            BigDecimal e_fee = rowInfo.getBigDecimal("e_fee");
            if (!CasHelper.isNotEmpty((Object)e_fee)) continue;
            feeTemp = true;
            break;
        }
        for (DynamicObject row : entry) {
            BigDecimal actAndDisc = row.getBigDecimal("e_actamt").add(row.getBigDecimal("e_discountamt"));
            amount = amount.add(actAndDisc);
        }
        BigDecimal countFee = BigDecimal.ZERO;
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal actAmtAndDisc;
            BigDecimal actAmount = ((DynamicObject)entry.get(i)).getBigDecimal("e_actamt");
            BigDecimal actAmountLocamt = ((DynamicObject)entry.get(i)).getBigDecimal("e_localamt");
            if (actAmount != null) {
                BigDecimal localAmt = QuotationHelper.callToCurrency((BigDecimal)actAmount, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                if (CasHelper.isEmpty((Object)actAmountLocamt)) {
                    ((DynamicObject)entry.get(i)).set("e_localamt", (Object)localAmt);
                }
                sumLocalAmt = sumLocalAmt.add(localAmt);
            }
            BigDecimal discountAmt = ((DynamicObject)entry.get(i)).getBigDecimal("e_discountamt");
            BigDecimal discountAmtLocamt = ((DynamicObject)entry.get(i)).getBigDecimal("e_discountlocamt");
            BigDecimal recAmountLocamt = ((DynamicObject)entry.get(i)).getBigDecimal("e_receivablelocamt");
            if (discountAmt != null && CasHelper.isEmpty((Object)discountAmtLocamt)) {
                ((DynamicObject)entry.get(i)).set("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision")));
            }
            ((DynamicObject)entry.get(i)).set("e_unsettledamt", (Object)actAmount);
            ((DynamicObject)entry.get(i)).set("e_unlockamt", (Object)actAmount);
            if (actAmount != null && !feeTemp) {
                actAmtAndDisc = actAmount.add(discountAmt);
                ((DynamicObject)entry.get(i)).set("e_fee", (Object)BigDecimal.ZERO);
                if (amount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal efee = actAmtAndDisc.multiply(fee).divide(amount, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (RecFillPropHelper.getLastRow(i, entry.getRowCount()).booleanValue()) {
                        efee = fee.subtract(countFee);
                    }
                    countFee = countFee.add(efee);
                    ((DynamicObject)entry.get(i)).set("e_fee", (Object)efee);
                    actAmtAndDisc = actAmtAndDisc.add(efee);
                }
                BigDecimal actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)basecurrency.getInt("amtprecision"));
                ((DynamicObject)entry.get(i)).set("e_receivableamt", (Object)actAmtAndDisc);
                if (CasHelper.isEmpty((Object)recAmountLocamt)) {
                    ((DynamicObject)entry.get(i)).set("e_receivablelocamt", (Object)actLocalAmt);
                }
                ((DynamicObject)entry.get(i)).set("e_unsettledamt", (Object)actAmtAndDisc);
                ((DynamicObject)entry.get(i)).set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                ((DynamicObject)entry.get(i)).set("e_unlockamt", (Object)actAmtAndDisc);
            }
            if (actAmount != null && feeTemp) {
                actAmtAndDisc = actAmount.add(discountAmt);
                BigDecimal e_fee = ((DynamicObject)entry.get(i)).getBigDecimal("e_fee");
                if (e_fee != null) {
                    sumFee = e_fee.add(sumFee);
                    actAmtAndDisc = actAmtAndDisc.add(e_fee);
                }
                ((DynamicObject)entry.get(i)).set("e_receivableamt", (Object)actAmtAndDisc);
                if (CasHelper.isEmpty((Object)recAmountLocamt)) {
                    ((DynamicObject)entry.get(i)).set("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                }
                ((DynamicObject)entry.get(i)).set("e_unsettledamt", (Object)actAmtAndDisc);
                ((DynamicObject)entry.get(i)).set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)actAmtAndDisc, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                ((DynamicObject)entry.get(i)).set("e_unlockamt", (Object)actAmtAndDisc);
            }
            if (actAmount == null) continue;
            sumAmt = sumAmt.add(actAmount);
        }
        recBill.set("actrecamt", (Object)sumAmt);
        BigDecimal localAmt = recBill.getBigDecimal("localamt");
        if (CasHelper.isEmpty((Object)localAmt)) {
            recBill.set("localamt", (Object)sumLocalAmt);
        }
        if (feeTemp) {
            recBill.set("fee", (Object)sumFee);
        }
    }

    public static Boolean getLastRow(int row, int entryRowCount) {
        if (row < entryRowCount - 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

