/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.BalanceCountHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.util.NumberUtils;

public class RecInitHepler {
    public static void reloadData(DynamicObject info) {
        DynamicObject org = info.getDynamicObject("org");
        Long orgId = org.getLong("id");
        DynamicObject initperiod = info.getDynamicObject("initperiod");
        Map<String, BigDecimal> cashBalance = BalanceCountHelper.getCashBalance(orgId, initperiod);
        DynamicObjectCollection entrycash = info.getDynamicObjectCollection("entrycash");
        for (DynamicObject row : entrycash) {
            DynamicObject accountCash = row.getDynamicObject("cash_accountcash");
            DynamicObject currency = row.getDynamicObject("cash_currency");
            String key = BalanceCountHelper.getMapKey(org, accountCash, currency);
            row.set("cash_balance", (Object)cashBalance.get(key));
        }
        Map<String, BigDecimal> journalBalance = BalanceCountHelper.getJournalBalance(orgId, initperiod);
        Map<String, Map<String, BigDecimal>> statementMap = RecInitHepler.getBankJournalOrStatement(orgId, initperiod, "cas_bankstatement");
        Map<String, Map<String, BigDecimal>> journalMap = RecInitHepler.getBankJournalOrStatement(orgId, initperiod, "cas_bankjournal");
        DynamicObjectCollection entrybank = info.getDynamicObjectCollection("entrybank");
        for (DynamicObject row : entrybank) {
            DynamicObject accountCash = row.getDynamicObject("bank_accountbank");
            DynamicObject currency = row.getDynamicObject("bank_currency");
            String key = BalanceCountHelper.getMapKey(org, accountCash, currency);
            row.set("bank_journalbalance", (Object)journalBalance.get(key));
            RecInitHepler.calcJournalBalanceAdj(orgId, initperiod, row, statementMap);
            RecInitHepler.calcStatementBalanceAdj(row, journalMap);
        }
    }

    private static void calcStatementBalanceAdj(DynamicObject row, Map<String, Map<String, BigDecimal>> journalMap) {
        Long rowAcctbankId = (Long)row.getDynamicObject("bank_accountbank").getPkValue();
        Long rowCurrencyId = (Long)row.getDynamicObject("bank_currency").getPkValue();
        BigDecimal statementBalance = row.getBigDecimal("bank_statementbalance");
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (journalMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal statementBalanceAdj = statementBalance.add(debitAmount).subtract(creditAmount);
        BigDecimal journalBalanceAdj = row.getBigDecimal("bank_journalsumbalanceadj");
        row.set("bank_statementbalanceadj", (Object)statementBalanceAdj);
        row.set("bank_equal", (Object)(NumberUtils.equals((BigDecimal)journalBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0"));
    }

    private static void calcJournalBalanceAdj(Long orgId, DynamicObject initperiod, DynamicObject row, Map<String, Map<String, BigDecimal>> statementMap) {
        Long rowAcctbankId = (Long)row.getDynamicObject("bank_accountbank").getPkValue();
        Long rowCurrencyId = (Long)row.getDynamicObject("bank_currency").getPkValue();
        BigDecimal journalBalance = row.getBigDecimal("bank_journalbalance");
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (statementMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal journalBalanceAdj = journalBalance.add(creditAmount).subtract(debitAmount);
        row.set("bank_journalbalanceadj", (Object)journalBalanceAdj);
        BigDecimal sumBalanceAdj = RecInitHepler.getUseOrgJournalAmount(orgId, initperiod, row);
        BigDecimal statementBalanceAdj = row.getBigDecimal("bank_statementbalanceadj");
        row.set("bank_journalsumbalanceadj", (Object)sumBalanceAdj);
        row.set("bank_equal", (Object)(NumberUtils.equals((BigDecimal)sumBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0"));
    }

    private static BigDecimal getUseOrgJournalAmount(Long orgId, DynamicObject initperiod, DynamicObject row) {
        BigDecimal totalAmount = new BigDecimal(0);
        Long accountbankId = (Long)row.getDynamicObject("bank_accountbank").getPkValue();
        Long currencyId = (Long)row.getDynamicObject("bank_currency").getPkValue();
        DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,startperiod,currentperiod,isfinishinit,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_journalbalance,entrybank.bank_journalbalanceadj", (QFilter[])new QFilter[]{new QFilter("entrybank.bank_accountbank", "=", (Object)accountbankId)});
        boolean isSave = false;
        for (DynamicObject dyObj : cashmgtInitDy) {
            if (dyObj.getDynamicObject("org").getLong("id") == orgId.longValue()) {
                isSave = true;
                totalAmount = totalAmount.add(row.getBigDecimal("bank_journalbalanceadj"));
                continue;
            }
            if (!dyObj.getBoolean("isfinishinit")) continue;
            DynamicObjectCollection bankCollection = dyObj.getDynamicObjectCollection("entrybank");
            for (DynamicObject dyObj1 : bankCollection) {
                Date createOrgBeginDate;
                long accountBankId1 = dyObj1.getDynamicObject("bank_accountbank").getLong("id");
                long currencyId1 = dyObj1.getDynamicObject("bank_currency").getLong("id");
                if (accountBankId1 != accountbankId || currencyId1 != currencyId) continue;
                DynamicObject useorgStartPeriod = dyObj.getDynamicObject("startperiod");
                Date useOrgBeginDate = useorgStartPeriod.getDate("begindate");
                if (useOrgBeginDate.compareTo(createOrgBeginDate = initperiod.getDate("begindate")) < 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(createOrgBeginDate);
                    calendar.add(5, -1);
                    Date endDate = calendar.getTime();
                    BalanceCountService balanceCountService = new BalanceCountService();
                    BigDecimal accountBalance = balanceCountService.getJournalBalance(dyObj, dyObj.getDynamicObject("org").getLong("id"), accountBankId1, currencyId1, endDate);
                    totalAmount = totalAmount.add(accountBalance);
                    continue;
                }
                BigDecimal journalbalance1 = dyObj1.getBigDecimal("bank_journalbalance");
                totalAmount = totalAmount.add(journalbalance1);
            }
        }
        if (!isSave) {
            totalAmount = totalAmount.add(row.getBigDecimal("bank_journalbalanceadj"));
        }
        return totalAmount;
    }

    private static Map<String, Map<String, BigDecimal>> getBankJournalOrStatement(long orgId, DynamicObject initperiod, String entity) {
        String selectors = "accountbank as faccountbankid,currency as fcurrencyid,debitamount,creditamount";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)0L);
        QFilter recperiodFilter = new QFilter("recinitperiod", "=", initperiod.getPkValue());
        HashMap<String, Map<String, BigDecimal>> dataMap = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"cas.recinit", (String)entity, (String)selectors, (QFilter[])new QFilter[]{orgFilter, periodFilter, recperiodFilter}, null);
             DataSet groupByDataSet = dataSet.groupBy(new String[]{"faccountbankid", "fcurrencyid"}).sum("debitamount").sum("creditamount").finish();){
            groupByDataSet.forEach(row -> {
                Long rowAcctbankId = (Long)row.get("faccountbankid");
                Long rowCurrencyId = (Long)row.get("fcurrencyid");
                BigDecimal debitamount = (BigDecimal)row.get("debitamount");
                BigDecimal creditamount = (BigDecimal)row.get("creditamount");
                HashMap<String, BigDecimal> rowData = new HashMap<String, BigDecimal>();
                rowData.put("debitamount", debitamount);
                rowData.put("creditamount", creditamount);
                dataMap.put(rowAcctbankId + "-" + rowCurrencyId, rowData);
            });
        }
        return dataMap;
    }
}

