/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.errorcode.JournalErrorCode;
import kd.fi.cas.business.journal.BookJournalLogger;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;

public abstract class AbstractBookJournalBuilder
implements IBookJournalBuilder {
    private static final Log logger = LogFactory.getLog(AbstractBookJournalBuilder.class);
    private static final String four = "14";
    private Boolean isValidata = Boolean.FALSE;
    protected boolean isConsistency = false;

    @Override
    public List<DynamicObject> getJournalList(DynamicObject billObject) {
        ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>();
        List<JournalInfo> journalInfoList = this.getJournalInfoList(billObject);
        this.process(journalList, journalInfoList);
        return journalList;
    }

    @Override
    public Map<Long, List<DynamicObject>> getJournalList(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
        Map<Long, List<JournalInfo>> journalInfoList = this.getJournalInfoLists(billColl, errorResult);
        Map<Long, List<DynamicObject>> journalInfoLast = this.process(journalInfoList, errorResult);
        return journalInfoLast;
    }

    @Override
    public List<DynamicObject> getJournalList(DynamicObjectCollection billColl) {
        ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>();
        List<JournalInfo> journalInfoList = this.getJournalInfoList(billColl);
        this.process(journalList, journalInfoList);
        return journalList;
    }

    private void process(List<DynamicObject> journalList, List<JournalInfo> journalInfoList) {
        for (int i = 0; i < journalInfoList.size(); ++i) {
            DynamicObject orgInit;
            DynamicObject accountBank;
            DynamicObject journal = null;
            JournalInfo journalInfo = journalInfoList.get(i);
            DynamicObject settlementType = journalInfo.getSettlementType();
            if (settlementType != null && four.equals(settlementType.getString("settlementtype"))) {
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u865a\u62df\u652f\u4ed8\u4e0d\u767b\u65e5\u8bb0\u8d26%s", (String)"AbstractBookJournalBuilder_2", (String)"fi-cas-business", (Object[])new Object[0]), settlementType.getString("number")));
                continue;
            }
            DynamicObject org = journalInfo.getOrg();
            long orgId = (Long)org.getPkValue();
            boolean voucherBookJournal = SystemParameterHelper.isVoucherBookJournal((long)orgId);
            boolean isVoucherMixBookJournal = SystemParameterHelper.isVoucherMixBookJournal((long)orgId);
            String sourceBillType = journalInfo.getSourceBillType();
            BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u767b\u8d26\u53c2\u6570\uff0csourceBillType\u4e3a%1$s\uff0cCS105\u4e3a%2$s\u3002", (String)"AbstractBookJournalBuilder_0", (String)"fi-cas-business", (Object[])new Object[0]), sourceBillType, voucherBookJournal));
            if ("gl_voucher".equals(sourceBillType)) {
                boolean fromCashCount = "cas_cash_verification".equals(journalInfo.getSourceBillTypeOfSourceBill());
                if (!(voucherBookJournal || fromCashCount || isVoucherMixBookJournal)) {
                    BookJournalLogger.log("!voucherBookJournal && !fromCashCount && !isVoucherMixBookJournal.");
                    continue;
                }
            } else if (!SystemParameterHelper.isBillBookJournal((long)orgId) && !isVoucherMixBookJournal) {
                BookJournalLogger.log(String.format("!isBillBookJournal(org:%s) && !isVoucherMixBookJournal.", orgId));
                continue;
            }
            if ((accountBank = journalInfo.getAccountBank()) != null) {
                journal = this.newBankJournalObject();
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"accountbank", (Object)accountBank);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"openorg", (Object)accountBank.getDynamicObject("openorg"));
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"ischeck", (Object)false);
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bankCheckFlag", (Object)CasHelper.subFlag((String)journalInfo.getBankCheckFlag()));
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bankcheckflag_tag", (Object)journalInfo.getBankCheckFlag());
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"synccheck", (Object)journalInfo.getSynccheck());
            } else if (journalInfo.getAccountCash() != null) {
                journal = this.newCashJournalObject();
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"accountcash", (Object)journalInfo.getAccountCash());
            } else {
                BookJournalLogger.log(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u3001\u73b0\u91d1\u8d26\u6237\u4e3a\u7a7a", (String)"AbstractBookJournalBuilder_8", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal creditAmount = journalInfo.getCreditAmount();
            BigDecimal debitAmount = journalInfo.getDebitAmount();
            int direction = journalInfo.getDirection();
            boolean isAllowNega = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"cs1043");
            if (!isAllowNega) {
                if (creditAmount.compareTo(BigDecimal.ZERO) < 0) {
                    debitAmount = creditAmount.abs();
                    creditAmount = BigDecimal.ZERO;
                    direction = 2;
                }
                if (debitAmount.compareTo(BigDecimal.ZERO) < 0) {
                    creditAmount = debitAmount.abs();
                    debitAmount = BigDecimal.ZERO;
                    direction = 1;
                }
                if (journalInfo.getLocalAmount() != null) {
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"localamount", (Object)journalInfo.getLocalAmount().abs());
                }
            } else {
                DynamicObjectHelper.setValue((DynamicObject)journal, (String)"localamount", (Object)journalInfo.getLocalAmount());
            }
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"org", (Object)org);
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"currency", (Object)journalInfo.getCurrency());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"cashier", (Object)journalInfo.getCashier());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"settlementType", (Object)journalInfo.getSettlementType());
            Date bookDate = journalInfo.getBizDate();
            if (isVoucherMixBookJournal) {
                if ("gl_voucher".equals(sourceBillType)) {
                    int CS1042 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs1042");
                    if (CS1042 == 2) {
                        bookDate = new Date();
                    } else if (CS1042 == 3) {
                        bookDate = journalInfo.getBookDate();
                    }
                } else {
                    int CS1041 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs1041");
                    if (CS1041 == 2) {
                        bookDate = new Date();
                    }
                }
            } else {
                int CS104 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs104");
                if (CS104 == 2) {
                    bookDate = new Date();
                } else if (CS104 == 3) {
                    bookDate = journalInfo.getBookDate();
                }
            }
            Set cs109 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs109");
            logger.info("cs109:" + SerializationUtils.toJsonString((Object)cs109));
            logger.info("id:" + orgId);
            if (("cas_paybill_synonym".equals(sourceBillType) || "cas_paybill_cash".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) || "cas_agentpaybill".equals(sourceBillType) || "fca_transupbill".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType)) && cs109.contains(journalInfo.getPaychannel()) && journalInfo.getPayDate() != null) {
                bookDate = journalInfo.getPayDate();
            }
            if ((orgInit = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId)) == null) {
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u521d\u59cb\u5316%s", (String)"AbstractBookJournalBuilder_3", (String)"fi-cas-business", (Object[])new Object[0]), orgId));
                continue;
            }
            DynamicObject startPeriod = orgInit.getDynamicObject("startperiod");
            if (null == startPeriod) {
                BookJournalLogger.log(ResManager.loadKDString((String)"\u51fa\u7eb3\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"VoucherBookJournalBuilder_7", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject currectPeriod = orgInit.getDynamicObject("currentperiod");
            if (null == currectPeriod && ExtendConfigHelper.isInitOnlySet()) {
                currectPeriod = startPeriod;
            }
            if (null == currectPeriod) {
                BookJournalLogger.log(ResManager.loadKDString((String)"\u51fa\u7eb3\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff01", (String)"VoucherBookJournalBuilder_7_4", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            Date periodStartDate = startPeriod.getDate("begindate");
            if (startPeriod != null && bookDate.before(periodStartDate)) {
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u5bf9\u5e94\u671f\u95f4\u672a\u542f\u7528\uff0c\u767b\u8bb0\u65e5\u8bb0\u8d26\u5931\u8d25\uff0c\u5982\u9700\u7ee7\u7eed\u590d\u6838\uff0c\u8bf7\u5148\u8c03\u6574\u8d44\u91d1\u7ec4\u7ec7\u767b\u8d26\u53c2\u6570\u4e3a\u975e\u51ed\u8bc1\u767b\u8d26\u3002", (String)"CasErrorCode_15", (String)"fi-cas-business", (Object[])new Object[0]), journalInfo.getSourceBillId()));
                continue;
            }
            if (currectPeriod != null && bookDate != null && bookDate.before(currectPeriod.getDate("begindate"))) {
                boolean isAllowChgDate = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs1044");
                try {
                    String paymentChannel;
                    DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)journalInfo.getSourceBillId(), (String)sourceBillType);
                    logger.info("sourceBillType:" + sourceBillType + "_sourceBillId:" + journalInfo.getSourceBillId());
                    if ("fca_transupbill".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType)) {
                        DynamicObjectCollection entrys = sourceBill.getDynamicObjectCollection("entrys");
                        paymentChannel = ((DynamicObject)entrys.get(0)).getString("paychanel");
                    } else {
                        paymentChannel = sourceBill.getString("paymentchannel");
                    }
                    if (PaymentChannelEnum.BEI.getValue().equals(paymentChannel)) {
                        isAllowChgDate = true;
                    }
                }
                catch (Exception e) {
                    logger.info(sourceBillType + "\uff0c" + journalInfo.getSourceBillId() + "\uff1a\u65e0\u652f\u4ed8\u6e20\u9053\u5b57\u6bb5\uff0c\u4e0d\u8fdb\u884c\u5339\u914d\u5224\u65ad");
                }
                if (!isAllowChgDate) {
                    throw new KDBizException(new JournalErrorCode().JOURNAL_CHG_DATE(), new Object[0]);
                }
                bookDate = currectPeriod.getDate("begindate");
            }
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bookDate", (Object)DateUtils.truncateDate((Date)bookDate));
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"period", (Object)PeriodHelper.getPeriodByDate((long)orgId, (Date)journal.getDate("bookDate")));
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bizDate", (Object)journalInfo.getBizDate());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"description", (Object)journalInfo.getDescription());
            DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)journal, (String)"description");
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillType", (Object)sourceBillType);
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillNumber", (Object)journalInfo.getSourceBillNumber());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"billno", (Object)journalInfo.getBillno());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"settlementNumber", (Object)journalInfo.getSettlementNumber());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillId", (Object)journalInfo.getSourceBillId());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourcebillentryid", (Object)journalInfo.getSourceBillEntryId());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"direction", (Object)direction);
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"source", (Object)journalInfo.getSource());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"relatedBizDate", (Object)journalInfo.getRelatedBizDate());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"ticketNumber", (Object)journalInfo.getTicketNumber());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"lineno", (Object)journalInfo.getLineno());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppUnit", (Object)journalInfo.getOppUnit());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppAcctNumber", (Object)journalInfo.getOppAcctNumber());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppBank", (Object)journalInfo.getOppBank());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"creditAmount", (Object)creditAmount);
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"debitAmount", (Object)debitAmount);
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"exchangeRate", (Object)journalInfo.getExchangeRate());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"batchNo", (Object)CasHelper.subFlag((String)journalInfo.getBatchNo()));
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"basecurrency", (Object)OrgHelper.getBaseCurrency((long)org.getLong("id")));
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"billstatus", (Object)EnumBillStatus.C);
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"createtime", (Object)new Date());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"tracedate", (Object)journalInfo.getTraceDate());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"avddate", (Object)journalInfo.getAvd());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"pddate", (Object)journalInfo.getPd());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"preparationdate", (Object)journalInfo.getPreparationdate());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"feepayer", (Object)journalInfo.getFeepayer());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"isencryption", (Object)journalInfo.getIsencryption());
            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"fee", (Object)journalInfo.getFee());
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)journal.getDataEntityType().getName()).findProperty("entry");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            List<JournalEntryInfo> entryList = journalInfo.getEntry();
            for (int j = 0; j < entryList.size(); ++j) {
                JournalEntryInfo entryInfo = entryList.get(j);
                DynamicObject entryObject = new DynamicObject(dt);
                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"seq", (Object)(j + 1));
                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_fundflowitem", (Object)entryInfo.getFundFlowItem());
                if (!isAllowNega) {
                    if (entryInfo.getAmount() != null) {
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_amount", (Object)entryInfo.getAmount().abs());
                    }
                    if (entryInfo.getLocalAmount() != null) {
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_localamount", (Object)entryInfo.getLocalAmount().abs());
                    }
                } else {
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_amount", (Object)entryInfo.getAmount());
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_localamount", (Object)entryInfo.getLocalAmount());
                }
                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_org", (Object)org);
                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_currency", (Object)journalInfo.getCurrency());
                if (journalInfo.getAccountBank() != null) {
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_accountbank", (Object)journalInfo.getAccountBank());
                } else {
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_accountcash", (Object)journalInfo.getAccountCash());
                }
                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_oppunit", (Object)(entryInfo.getOppUnit() != null ? entryInfo.getOppUnit() : journalInfo.getOppUnit()));
                journal.getDynamicObjectCollection("entry").add((Object)entryObject);
            }
            EntryProp bankCheckEntityProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)journal.getDataEntityType().getName()).findProperty("bankcheckentity");
            DynamicObjectType bankCheckEntityDt = bankCheckEntityProp.getDynamicCollectionItemPropertyType();
            if (journal.containsProperty("bankcheckflag_tag")) {
                String eBankCheckStr = journal.getString("bankcheckflag_tag");
                String[] bankCheckEntity = eBankCheckStr.split(",");
                for (int j = 0; j < bankCheckEntity.length; ++j) {
                    String entryInfo = bankCheckEntity[j];
                    DynamicObject entryObject = new DynamicObject(bankCheckEntityDt);
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"seq", (Object)(j + 1));
                    DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"ebankcheckflag", (Object)entryInfo);
                    journal.getDynamicObjectCollection("bankcheckentity").add((Object)entryObject);
                }
            }
            journalList.add(journal);
        }
    }

    public abstract List<JournalInfo> getJournalInfoList(DynamicObject var1);

    public abstract List<JournalInfo> getJournalInfoList(DynamicObjectCollection var1);

    public abstract Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection var1, Map<Long, Exception> var2);

    protected void setBookDate(Date bookDate, DynamicObject journal) {
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"org");
        DynamicObject period = SystemStatusCtrolHelper.getCurrentPeriod((long)orgId);
        if (period == null) {
            BookJournalLogger.log(ResManager.loadKDString((String)"\u51fa\u7eb3\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff01", (String)"VoucherBookJournalBuilder_7_4", (String)"fi-cas-business", (Object[])new Object[0]));
            return;
        }
        if ((period = PeriodHelper.getPeriodById((long)period.getLong("id"))) != null && bookDate != null && bookDate.before(period.getDate("begindate"))) {
            bookDate = period.getDate("begindate");
        }
        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bookDate", (Object)DateUtils.truncateDate((Date)bookDate));
    }

    private DynamicObject newCashJournalObject() {
        return BusinessDataServiceHelper.newDynamicObject((String)"cas_cashjournal");
    }

    private DynamicObject newBankJournalObject() {
        return BusinessDataServiceHelper.newDynamicObject((String)"cas_bankjournal");
    }

    public Boolean getIsValidata() {
        return this.isValidata;
    }

    public void setIsValidata(Boolean isValidata) {
        this.isValidata = isValidata;
    }

    private Map<Long, List<DynamicObject>> process(Map<Long, List<JournalInfo>> journalInfoListMap, Map<Long, Exception> errorResult) {
        long startTime = System.currentTimeMillis();
        logger.info("getJournalInfoLists process perform data is start" + startTime);
        HashMap<Long, List<DynamicObject>> journalInfoLiast = new HashMap<Long, List<DynamicObject>>();
        HashSet orgids = new HashSet();
        for (Map.Entry<Long, List<JournalInfo>> voucherId : journalInfoListMap.entrySet()) {
            orgids.addAll(voucherId.getValue().stream().map(e -> e.getOrg().getLong("id")).collect(Collectors.toSet()));
        }
        if (null != orgids) {
            logger.info("orgids size\uff1a" + orgids.size());
        }
        Long startTime1 = System.currentTimeMillis();
        logger.info("getSystemStatusCtrol start:" + startTime1);
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgids);
        logger.info("getSystemStatusCtrol end:" + (System.currentTimeMillis() - startTime1));
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgids));
        Map<Long, List<DynamicObject>> periodtypeMap = this.getPeriodtypeMap(orgInitMap);
        long startTime2 = System.currentTimeMillis();
        logger.info("getJournalInfoLists process perform data end" + (startTime2 - startTime));
        for (Map.Entry<Long, List<JournalInfo>> voucherId : journalInfoListMap.entrySet()) {
            try {
                List<JournalInfo> journalInfoList = voucherId.getValue();
                ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>(10);
                for (JournalInfo journalInfo : journalInfoList) {
                    DynamicObject orgInit;
                    HashSet cs109;
                    Object dataInt;
                    DynamicObject accountBank;
                    String error;
                    DynamicObject journal = null;
                    DynamicObject settlementType = journalInfo.getSettlementType();
                    if (settlementType != null && four.equals(settlementType.getString("settlementtype"))) {
                        String error2 = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s", (String)"VoucherBookJournalBuilder_11", (String)"fi-cas-business", (Object[])new Object[0]), voucherId.getKey(), String.format(ResManager.loadKDString((String)"\u865a\u62df\u652f\u4ed8\u4e0d\u767b\u65e5\u8bb0\u8d26%s", (String)"VoucherBookJournalBuilder_12", (String)"fi-cas-business", (Object[])new Object[0]), settlementType.getString("number")));
                        BookJournalLogger.log(error2);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error2)));
                        continue;
                    }
                    DynamicObject org = journalInfo.getOrg();
                    long orgId = (Long)org.getPkValue();
                    String orgIdStr = org.getPkValue().toString();
                    boolean voucherBookJournal = "1".equals(((Map)systemParamsMap.get(orgIdStr)).get("cs105"));
                    boolean isVoucherMixBookJournal = "3".equals(((Map)systemParamsMap.get(orgIdStr)).get("cs105"));
                    String sourceBillType = journalInfo.getSourceBillType();
                    BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u767b\u8d26\u53c2\u6570\uff0csourceBillType\u4e3a%1$s\uff0cCS105\u4e3a%2$s\u3002", (String)"AbstractBookJournalBuilder_0", (String)"fi-cas-business", (Object[])new Object[0]), sourceBillType, voucherBookJournal));
                    if ("gl_voucher".equals(sourceBillType)) {
                        boolean fromCashCount = "cas_cash_verification".equals(journalInfo.getSourceBillTypeOfSourceBill());
                        if (!voucherBookJournal && !isVoucherMixBookJournal) {
                            error = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s", (String)"VoucherBookJournalBuilder_11", (String)"fi-cas-business", (Object[])new Object[0]), voucherId.getKey(), ResManager.loadKDString((String)"\u65e2\u4e0d\u662f\u51ed\u8bc1\u767b\u8d26\u4e5f\u4e0d\u662f\u6df7\u5408\u767b\u8d26\uff08\u5355\u636e+\u51ed\u8bc1+\u624b\u5de5\uff09\u7684\u65e5\u8bb0\u8d26\u4e0d\u767b\u8d26", (String)"VoucherBookJournalBuilder_13", (String)"fi-cas-business", (Object[])new Object[0]));
                            BookJournalLogger.log(error);
                            if (!this.isConsistency) continue;
                            errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error)));
                            continue;
                        }
                    } else {
                        boolean isVoucherMixBookJournal3;
                        boolean bl = isVoucherMixBookJournal3 = !"0".equals(((Map)systemParamsMap.get(orgIdStr)).get("cs105"));
                        if (isVoucherMixBookJournal3 && !isVoucherMixBookJournal) {
                            error = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s", (String)"VoucherBookJournalBuilder_11", (String)"fi-cas-business", (Object[])new Object[0]), voucherId.getKey(), ResManager.loadKDString((String)"\u65e2\u4e0d\u662f\u5355\u636e\u767b\u8d26\u4e5f\u4e0d\u662f\u6df7\u5408\u767b\u8d26\uff08\u5355\u636e+\u51ed\u8bc1+\u624b\u5de5\uff09\u7684\u65e5\u8bb0\u8d26\u4e0d\u767b\u8d26", (String)"VoucherBookJournalBuilder_14", (String)"fi-cas-business", (Object[])new Object[0]));
                            BookJournalLogger.log(error);
                            if (!this.isConsistency) continue;
                            errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error)));
                            continue;
                        }
                    }
                    if ((accountBank = journalInfo.getAccountBank()) != null) {
                        journal = this.newBankJournalObject();
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"accountbank", (Object)accountBank);
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"openorg", (Object)accountBank.getDynamicObject("openorg"));
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"ischeck", (Object)false);
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bankCheckFlag", (Object)CasHelper.subFlag((String)journalInfo.getBankCheckFlag()));
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bankcheckflag_tag", (Object)journalInfo.getBankCheckFlag());
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"synccheck", (Object)journalInfo.getSynccheck());
                    } else if (journalInfo.getAccountCash() != null) {
                        journal = this.newCashJournalObject();
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"accountcash", (Object)journalInfo.getAccountCash());
                    } else {
                        error = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1ID%1$s%2$s", (String)"VoucherBookJournalBuilder_11", (String)"fi-cas-business", (Object[])new Object[0]), voucherId.getKey(), ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u3001\u73b0\u91d1\u8d26\u6237\u4e3a\u7a7a", (String)"AbstractBookJournalBuilder_8", (String)"fi-cas-business", (Object[])new Object[0]));
                        BookJournalLogger.log(error);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error)));
                        continue;
                    }
                    BigDecimal creditAmount = journalInfo.getCreditAmount();
                    BigDecimal debitAmount = journalInfo.getDebitAmount();
                    int direction = journalInfo.getDirection();
                    boolean isAllowNega = this.getAllowNega(((Map)systemParamsMap.get(orgIdStr)).get("cs1043"));
                    if (!isAllowNega) {
                        if (creditAmount.compareTo(BigDecimal.ZERO) < 0) {
                            debitAmount = creditAmount.abs();
                            creditAmount = BigDecimal.ZERO;
                            direction = 2;
                        }
                        if (debitAmount.compareTo(BigDecimal.ZERO) < 0) {
                            creditAmount = debitAmount.abs();
                            debitAmount = BigDecimal.ZERO;
                            direction = 1;
                        }
                        if (journalInfo.getLocalAmount() != null) {
                            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"localamount", (Object)journalInfo.getLocalAmount().abs());
                        }
                    } else {
                        DynamicObjectHelper.setValue((DynamicObject)journal, (String)"localamount", (Object)journalInfo.getLocalAmount());
                    }
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"org", (Object)org);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"currency", (Object)journalInfo.getCurrency());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"cashier", (Object)journalInfo.getCashier());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"settlementType", (Object)journalInfo.getSettlementType());
                    Date bookDate = journalInfo.getBizDate();
                    if (isVoucherMixBookJournal) {
                        if ("gl_voucher".equals(sourceBillType)) {
                            int CS1042;
                            dataInt = ((Map)systemParamsMap.get(orgIdStr)).get("cs1042");
                            int n = CS1042 = null == dataInt ? 0 : Integer.parseInt(dataInt.toString());
                            if (CS1042 == 2) {
                                bookDate = new Date();
                            } else if (CS1042 == 3) {
                                bookDate = journalInfo.getBookDate();
                            }
                        } else {
                            int CS1041;
                            dataInt = ((Map)systemParamsMap.get(orgIdStr)).get("cs1041");
                            int n = CS1041 = null == dataInt ? 0 : Integer.parseInt(dataInt.toString());
                            if (CS1041 == 2) {
                                bookDate = new Date();
                            }
                        }
                    } else {
                        int CS104;
                        dataInt = ((Map)systemParamsMap.get(orgIdStr)).get("cs104");
                        int n = CS104 = null == dataInt ? 0 : Integer.parseInt(dataInt.toString());
                        if (CS104 == 2) {
                            bookDate = new Date();
                        } else if (CS104 == 3) {
                            bookDate = journalInfo.getBookDate();
                        }
                    }
                    dataInt = ((Map)systemParamsMap.get(orgIdStr)).get("cs109");
                    Set<Object> set = cs109 = null == dataInt ? new HashSet() : Arrays.stream(String.valueOf(dataInt).split(",")).filter(CasHelper::isNotEmpty).collect(Collectors.toSet());
                    if (("cas_paybill_synonym".equals(sourceBillType) || "cas_paybill_cash".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) || "cas_agentpaybill".equals(sourceBillType)) && cs109.contains(journalInfo.getPaychannel()) && journalInfo.getPayDate() != null) {
                        bookDate = journalInfo.getPayDate();
                    }
                    if ((orgInit = (DynamicObject)orgInitMap.get(orgIdStr)) == null) {
                        String error3 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u521d\u59cb\u5316%s", (String)"AbstractBookJournalBuilder_3", (String)"fi-cas-business", (Object[])new Object[0]), orgId);
                        BookJournalLogger.log(error3);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error3)));
                        continue;
                    }
                    DynamicObject startPeriod = orgInit.getDynamicObject("startperiod");
                    if (null == startPeriod) {
                        BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002%s", (String)"AbstractBookJournalBuilder_5", (String)"fi-cas-business", (Object[])new Object[0]), journalInfo.getSourceBillId()));
                        continue;
                    }
                    DynamicObject currectPeriod = orgInit.getDynamicObject("currentperiod");
                    if (null == currectPeriod) {
                        currectPeriod = orgInit.getDynamicObject("startperiod");
                    }
                    if (null == currectPeriod) {
                        String error4 = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff01%s", (String)"AbstractBookJournalBuilder_4", (String)"fi-cas-business", (Object[])new Object[0]), journalInfo.getSourceBillId());
                        BookJournalLogger.log(error4);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error4)));
                        continue;
                    }
                    Date periodStartDate = startPeriod.getDate("begindate");
                    logger.info("bookDate is:" + bookDate + ",periodStartDate is:" + periodStartDate);
                    if (startPeriod != null && bookDate.before(periodStartDate)) {
                        String error5 = String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u5bf9\u5e94\u671f\u95f4\u672a\u542f\u7528\uff0c\u767b\u8bb0\u65e5\u8bb0\u8d26\u5931\u8d25\uff0c\u5982\u9700\u7ee7\u7eed\u590d\u6838\uff0c\u8bf7\u5148\u8c03\u6574\u8d44\u91d1\u7ec4\u7ec7\u767b\u8d26\u53c2\u6570\u4e3a\u975e\u51ed\u8bc1\u767b\u8d26\u3002", (String)"CasErrorCode_15", (String)"fi-cas-business", (Object[])new Object[0]), journalInfo.getSourceBillId());
                        BookJournalLogger.log(error5);
                        if (!this.isConsistency || !"gl_voucher".equals(sourceBillType)) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error5)));
                        continue;
                    }
                    if (currectPeriod != null && bookDate != null && bookDate.before(currectPeriod.getDate("begindate"))) {
                        boolean isAllowChgDate = (Boolean)((Map)systemParamsMap.get(orgIdStr)).get("cs1044");
                        try {
                            String paymentChannel;
                            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)journalInfo.getSourceBillId(), (String)sourceBillType);
                            logger.info("sourceBillType:" + sourceBillType + "_sourceBillId:" + journalInfo.getSourceBillId());
                            if ("fca_transupbill".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType)) {
                                DynamicObjectCollection entrys = sourceBill.getDynamicObjectCollection("entrys");
                                paymentChannel = ((DynamicObject)entrys.get(0)).getString("paychanel");
                            } else {
                                paymentChannel = sourceBill.getString("paymentchannel");
                            }
                            if (PaymentChannelEnum.BEI.getValue().equals(paymentChannel)) {
                                isAllowChgDate = true;
                            }
                        }
                        catch (Exception e2) {
                            logger.info(sourceBillType + "\uff0c" + journalInfo.getSourceBillId() + "\uff1a\u65e0\u652f\u4ed8\u6e20\u9053\u5b57\u6bb5\uff0c\u4e0d\u8fdb\u884c\u5339\u914d\u5224\u65ad");
                        }
                        if (!isAllowChgDate) {
                            throw new KDBizException(new JournalErrorCode().JOURNAL_CHG_DATE(), new Object[0]);
                        }
                        bookDate = currectPeriod.getDate("begindate");
                    }
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bookDate", (Object)DateUtils.truncateDate((Date)bookDate));
                    DynamicObject systemDym = (DynamicObject)orgInitMap.get(orgIdStr);
                    if (null != systemDym && null != systemDym.getDynamicObject("periodtype")) {
                        Long id = systemDym.getDynamicObject("periodtype").getLong("id");
                        List<DynamicObject> list = periodtypeMap.get(id);
                        Date bookDateTime = journal.getDate("bookDate");
                        for (DynamicObject period : list) {
                            Date beiginDate = period.getDate("begindate");
                            Date enddate = period.getDate("enddate");
                            if (beiginDate.compareTo(bookDateTime) > 0 || enddate.compareTo(bookDateTime) < 0) continue;
                            DynamicObjectHelper.setValue((DynamicObject)journal, (String)"period", (Object)period);
                            break;
                        }
                    }
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"bizDate", (Object)journalInfo.getBizDate());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"description", (Object)journalInfo.getDescription());
                    DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)journal, (String)"description");
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillType", (Object)sourceBillType);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillNumber", (Object)journalInfo.getSourceBillNumber());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"billno", (Object)journalInfo.getBillno());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"settlementNumber", (Object)journalInfo.getSettlementNumber());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourceBillId", (Object)journalInfo.getSourceBillId());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"sourcebillentryid", (Object)journalInfo.getSourceBillEntryId());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"direction", (Object)direction);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"source", (Object)journalInfo.getSource());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"relatedBizDate", (Object)journalInfo.getRelatedBizDate());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"ticketNumber", (Object)journalInfo.getTicketNumber());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"lineno", (Object)journalInfo.getLineno());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppUnit", (Object)journalInfo.getOppUnit());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppAcctNumber", (Object)journalInfo.getOppAcctNumber());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"oppBank", (Object)journalInfo.getOppBank());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"creditAmount", (Object)creditAmount);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"debitAmount", (Object)debitAmount);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"exchangeRate", (Object)journalInfo.getExchangeRate());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"batchNo", (Object)CasHelper.subFlag((String)journalInfo.getBatchNo()));
                    DynamicObject baseCurrency = (DynamicObject)orgInitMap.get(orgIdStr);
                    DynamicObject baseCurrencyObj = null;
                    if (null != baseCurrency && null != baseCurrency.getDynamicObject("standardcurrency")) {
                        baseCurrencyObj = baseCurrency.getDynamicObject("standardcurrency");
                    }
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"basecurrency", baseCurrencyObj);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"billstatus", (Object)EnumBillStatus.C);
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"creator", (Object)RequestContext.get().getCurrUserId());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"createtime", (Object)new Date());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"tracedate", (Object)journalInfo.getTraceDate());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"avddate", (Object)journalInfo.getAvd());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"pddate", (Object)journalInfo.getPd());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"preparationdate", (Object)journalInfo.getPreparationdate());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"feepayer", (Object)journalInfo.getFeepayer());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"isencryption", (Object)journalInfo.getIsencryption());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"fee", (Object)journalInfo.getFee());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"rpbasetype", (Object)journalInfo.getRpBaseType());
                    DynamicObjectHelper.setValue((DynamicObject)journal, (String)"rptype", (Object)journalInfo.getRpType());
                    EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)journal.getDataEntityType().getName()).findProperty("entry");
                    DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
                    List<JournalEntryInfo> entryList = journalInfo.getEntry();
                    for (int j = 0; j < entryList.size(); ++j) {
                        JournalEntryInfo entryInfo = entryList.get(j);
                        DynamicObject entryObject = new DynamicObject(dt);
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"seq", (Object)(j + 1));
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_fundflowitem", (Object)entryInfo.getFundFlowItem());
                        if (!isAllowNega) {
                            if (entryInfo.getAmount() != null) {
                                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_amount", (Object)entryInfo.getAmount().abs());
                            }
                            if (entryInfo.getLocalAmount() != null) {
                                DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_localamount", (Object)entryInfo.getLocalAmount().abs());
                            }
                        } else {
                            DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_amount", (Object)entryInfo.getAmount());
                            DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_localamount", (Object)entryInfo.getLocalAmount());
                        }
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_org", (Object)org);
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_currency", (Object)journalInfo.getCurrency());
                        if (journalInfo.getAccountBank() != null) {
                            DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_accountbank", (Object)journalInfo.getAccountBank());
                        } else {
                            DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_accountcash", (Object)journalInfo.getAccountCash());
                        }
                        DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"e_oppunit", (Object)(entryInfo.getOppUnit() != null ? entryInfo.getOppUnit() : journalInfo.getOppUnit()));
                        journal.getDynamicObjectCollection("entry").add((Object)entryObject);
                    }
                    EntryProp bankCheckEntityProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)journal.getDataEntityType().getName()).findProperty("bankcheckentity");
                    DynamicObjectType bankCheckEntityDt = bankCheckEntityProp.getDynamicCollectionItemPropertyType();
                    if (journal.containsProperty("bankcheckflag_tag")) {
                        String eBankCheckStr = journal.getString("bankcheckflag_tag");
                        String[] bankCheckEntity = eBankCheckStr.split(",");
                        for (int j = 0; j < bankCheckEntity.length; ++j) {
                            String entryInfo = bankCheckEntity[j];
                            DynamicObject entryObject = new DynamicObject(bankCheckEntityDt);
                            DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"seq", (Object)(j + 1));
                            DynamicObjectHelper.setValue((DynamicObject)entryObject, (String)"ebankcheckflag", (Object)entryInfo);
                            journal.getDynamicObjectCollection("bankcheckentity").add((Object)entryObject);
                        }
                    }
                    journalList.add(journal);
                }
                journalInfoLiast.put(voucherId.getKey(), journalList);
            }
            catch (Exception e3) {
                logger.error("getJournalInfoLists process data Exception:", (Throwable)e3);
                errorResult.put(voucherId.getKey(), e3);
            }
        }
        logger.info("getJournalInfoLists process data end" + (System.currentTimeMillis() - startTime2));
        return journalInfoLiast;
    }

    private Map<Long, List<DynamicObject>> getPeriodtypeMap(Map<String, DynamicObject> orgInitMap) {
        HashSet<Long> periodTypeIdSet = new HashSet<Long>();
        for (Map.Entry<String, DynamicObject> keyStr : orgInitMap.entrySet()) {
            DynamicObject periodTypeDyn = keyStr.getValue().getDynamicObject("periodtype");
            if (null == periodTypeDyn) {
                periodTypeIdSet.add(0L);
                continue;
            }
            periodTypeIdSet.add(periodTypeDyn.getLong("id"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "in", periodTypeIdSet), new QFilter("enddate", "is not null", null), new QFilter("begindate", "is not null", null)};
        long startTime1 = System.currentTimeMillis();
        logger.info("getPeriodtypeMap start:" + startTime1);
        Map periodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (QFilter[])filters);
        logger.info("getPeriodtypeMap end:" + (System.currentTimeMillis() - startTime1));
        return periodMap.values().stream().collect(Collectors.groupingBy(e -> e.getDynamicObject("periodtype").getLong("id")));
    }

    private boolean getAllowNega(Object isAllowNega2) {
        if (isAllowNega2 == null) {
            return false;
        }
        if (isAllowNega2 instanceof Boolean) {
            return (Boolean)isAllowNega2;
        }
        return "true".equals(isAllowNega2);
    }
}

