/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.fi.cas.business.journal.AbstractBankJournalDownload;
import kd.fi.cas.business.journal.buffer.BankJournalBuffer;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.pojo.BankJournalDownload;
import kd.fi.cas.pojo.BankJournalParameter;

public class BankJournalDownNorService
extends AbstractBankJournalDownload {
    public static BankJournalDownNorService getInstance() {
        return Singleton.instance;
    }

    @Override
    public void doDownloadData(BankJournalParameter bankJournalParameter) throws Exception {
        MainEntityType entityType = bankJournalParameter.getEntityType();
        BankJournalDownload bjd = bankJournalParameter.getBjd();
        String batchNoTime = bankJournalParameter.getBatchNoTime();
        List resultIds = bankJournalParameter.getResultIds();
        Map casInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(new HashSet(bjd.getOrgIds()));
        DataSet dataSet = bankJournalParameter.getDataSet();
        BankJournalBuffer bankJournalBuffer = new BankJournalBuffer();
        for (Row data : dataSet) {
            DynamicObject bankStatement = super.convert2BankJournal(data, entityType, casInitMap, bjd.getBeginDate(), batchNoTime);
            if (null != bankStatement) {
                bankJournalBuffer.write(bankStatement);
            }
            if (!bankJournalBuffer.isSynToDatabase().booleanValue()) continue;
            bankJournalBuffer.flushCurrentToDatabase(resultIds, this);
        }
        if (bankJournalBuffer.getCurrentBufferSize() > 0) {
            bankJournalBuffer.flushCurrentToDatabase(resultIds, this);
        }
    }

    @Override
    public void saveWriteBack(DynamicObject[] bankJournals, List<Object> resultIds) throws Exception {
        super.saveAndWriteBack(bankJournals, resultIds);
    }

    static class Singleton {
        private static BankJournalDownNorService instance = new BankJournalDownNorService();

        Singleton() {
        }
    }
}

