/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.Date;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.RecDecInitHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankJournalDownloadBuilder {
    private DynamicObject bankJournal;
    private Row data;

    public BankJournalDownloadBuilder(MainEntityType entityType, Row data) {
        this.data = data;
        this.bankJournal = new DynamicObject((DynamicObjectType)entityType);
    }

    public BankJournalDownloadBuilder setOrganizationInfo() {
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"org", (Object)this.data.getLong("company"));
        DynamicObject payeeAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,openorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.data.getLong("accountbank"))});
        Long openId = 0L;
        if (payeeAccount != null) {
            DynamicObject doc = (DynamicObject)payeeAccount.get("openorg");
            openId = doc.getLong("id");
        }
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"openorg", (Object)openId);
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"accountbank", (Object)this.data.get("accountbank"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"currency", (Object)this.data.get("currency"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"isvalid", (Object)RecDecInitHelper.getValid((Long)openId, (Date)this.data.getDate("bizdate")));
        return this;
    }

    public BankJournalDownloadBuilder setAmount() {
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"debitamount", (Object)this.data.get("creditamount"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"creditamount", (Object)this.data.get("debitamount"));
        return this;
    }

    public BankJournalDownloadBuilder setDate() {
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"bizdate", (Object)this.data.getDate("bizdate"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"bookdate", (Object)this.data.getDate("bizdate"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"tracedate", (Object)this.data.getDate("bizdate"));
        return this;
    }

    public BankJournalDownloadBuilder setPeriod(DynamicObject period) {
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"period", (Object)period);
        return this;
    }

    public BankJournalDownloadBuilder setAccount() {
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"oppunit", (Object)this.data.get("oppunit"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"oppacctnumber", (Object)this.data.get("oppbanknumber"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"oppbank", (Object)this.data.get("oppbank"));
        return this;
    }

    public BankJournalDownloadBuilder setBillInfo() {
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"sourcebilltype", (Object)"bei_transdetail");
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"sourcebillnumber", (Object)this.data.get("billno"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"source", (Object)"5");
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"datasource", (Object)this.data.get("datasource"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"billstatus", (Object)"C");
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"sourcebillid", (Object)this.data.get("id"));
        Object flag = this.data.get("bankcheckflag");
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"bankcheckflag", (Object)flag);
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"bankcheckflag_tag", (Object)flag);
        if (this.bankJournal != null && this.bankJournal.containsProperty("bankcheckentity") && !EmptyUtil.isEmpty((Object)flag)) {
            String[] split;
            DynamicObjectCollection bankCheckEntity = this.bankJournal.getDynamicObjectCollection("bankcheckentity");
            for (String item : split = flag.toString().split(",")) {
                if (EmptyUtil.isEmpty((String)item) || bankCheckEntity.stream().anyMatch(o -> item.equalsIgnoreCase(o.getString("ebankcheckflag")))) continue;
                DynamicObject entry = bankCheckEntity.addNew();
                entry.set("ebankcheckflag", (Object)item);
            }
        }
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"creator", (Object)RequestContext.get().getCurrUserId());
        return this;
    }

    public BankJournalDownloadBuilder setBasicInfo(String batchNoTime) {
        Long accountBank = (Long)this.data.get("accountbank");
        Long currency = (Long)this.data.get("currency");
        String account = String.valueOf(accountBank);
        String current = String.valueOf(currency);
        String batchNo = account + current + batchNoTime;
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"batchno", (Object)batchNo);
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)this.data.getLong("company"));
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"basecurrency", (Object)baseCurrency);
        String description = this.data.getString("description");
        if (description != null) {
            description = description.substring(0, Math.min(255, description.length()));
        }
        DynamicObjectHelper.setValue((DynamicObject)this.bankJournal, (String)"description", (Object)description);
        return this;
    }

    public DynamicObject build() {
        return this.bankJournal;
    }
}

