/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.JournalErrorCode;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.errorcode.KDBatchDealDBException;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class JournalAntiBookImpl
extends AbstractOpService {
    private static Log logger = LogFactory.getLog(JournalAntiBookImpl.class);

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("id");
        lst.add("org.id");
        lst.add("accountbank");
        lst.add("accountcash");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("sourcebillentryid");
        lst.add("ischeck");
        lst.add("bookdate");
        lst.add("billstatus");
        lst.add("entry");
        lst.add("currency");
        lst.add("debitamount");
        lst.add("creditamount");
        lst.add("billno");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        DynamicObject period = SystemStatusCtrolHelper.getCurrentPeriod((long)info.getLong("org.id"));
        if (period == null) {
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
        }
        period = PeriodHelper.getPeriodById((long)period.getLong("id"));
        Date bookDate = info.getDate("bookdate");
        if (period.getDate("begindate").after(bookDate)) {
            throw new KDBizException(new JournalErrorCode().CHECKED_CANNOT_OPERTION(), new Object[0]);
        }
        String entityName = info.getDynamicObjectType().getName();
        if ("cas_bankjournal".equals(entityName)) {
            boolean isCheck = info.getBoolean("ischeck");
            if (isCheck) {
                throw new KDBizException(new JournalErrorCode().CHECKED_CANNOT_OPERTION(), new Object[0]);
            }
            DynamicObject accountBank = info.getDynamicObject("accountbank");
            if (!CasHelper.isEmpty((Object)accountBank) && !AccountBankHelper.isEntrustCanUseAccount((long)info.getDynamicObject("org").getLong("id"), (long)accountBank.getLong("id"))) {
                throw new KDBizException(new CasErrorCode().ORG_NOT_ACCTAUTH(), new Object[0]);
            }
            String errorMsg = AccountBankHelper.checkBalanceAdjust((DynamicObject)info, (boolean)false);
            if (!CasHelper.isEmpty((Object)errorMsg)) {
                throw new KDBizException(errorMsg);
            }
        } else {
            DynamicObject accountCash = info.getDynamicObject("accountcash");
            if (accountCash != null && (accountCash = QueryServiceHelper.queryOne((String)"cas_accountcash", (String)"id,closestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountCash.getLong("id"))})) != null && 0 != accountCash.getInt("closestatus")) {
                throw new KDBizException(new CasErrorCode().ACCT_IS_CLOSE(), new Object[0]);
            }
        }
    }

    public void validates(Map<Object, DynamicObject> periodsMap, Map<String, DynamicObject> orgInitMap, DynamicObject info, Map<String, Boolean> bankResultMap, Map<String, Map<String, Object>> systemParamsMap, Map<String, DynamicObject> balanceResultMap, Set<Long> cashResultMap, boolean needCheck) throws KDException {
        long orgId = DynamicObjectHelper.getPk((DynamicObject)info, (String)"org");
        String orgIdStr = String.valueOf(orgId);
        DynamicObject orgInit = orgInitMap.get(orgIdStr);
        DynamicObject currentperiod = orgInit.getDynamicObject("currentperiod");
        if (currentperiod == null && ExtendConfigHelper.isInitOnlySet()) {
            currentperiod = orgInit.getDynamicObject("startperiod");
        }
        if (currentperiod == null) {
            return;
        }
        Long periodId = currentperiod.getLong("id");
        DynamicObject period = periodsMap.get(periodId);
        Date bookDate = info.getDate("bookdate");
        if (period.getDate("begindate").after(bookDate)) {
            throw new KDBizException(new JournalErrorCode().CHECKED_CANNOT_OPERTION(), new Object[0]);
        }
        String entityName = info.getDynamicObjectType().getName();
        if ("cas_bankjournal".equals(entityName)) {
            String keyStr;
            Boolean isEntrustCanUse;
            boolean isCheck = info.getBoolean("ischeck");
            if (needCheck && isCheck) {
                throw new KDBizException(new JournalErrorCode().CHECKED_CANNOT_OPERTION2(), new Object[0]);
            }
            DynamicObject accountBank = info.getDynamicObject("accountbank");
            if (!CasHelper.isEmpty((Object)accountBank) && !(isEntrustCanUse = Boolean.valueOf(bankResultMap.containsKey(keyStr = accountBank.getLong("id") + "_" + orgIdStr))).booleanValue()) {
                throw new KDBizException(new CasErrorCode().ORG_NOT_ACCTAUTH(), new Object[0]);
            }
            Object value = systemParamsMap.get(orgIdStr).get("cs095");
            Boolean parameterBooleans = this.getBooleanOfSysPara(value);
            String errorMsg = AccountBankHelper.checkBalanceAdjust((DynamicObject)info, (boolean)false, (boolean)parameterBooleans, balanceResultMap);
            if (!CasHelper.isEmpty((Object)errorMsg)) {
                throw new KDBizException(errorMsg);
            }
        } else {
            Long accountCashId;
            Boolean closestatus;
            DynamicObject accountCash = info.getDynamicObject("accountcash");
            if (accountCash != null && (closestatus = Boolean.valueOf(cashResultMap.contains(accountCashId = Long.valueOf(accountCash.getLong("id"))))).booleanValue()) {
                throw new KDBizException(new CasErrorCode().ACCT_IS_CLOSE(), new Object[0]);
            }
        }
    }

    private Boolean getBooleanOfSysPara(Object value) {
        Boolean parameterBooleans = false;
        if (null != value) {
            parameterBooleans = value instanceof Boolean ? (Boolean)value : Boolean.valueOf("true".equals(value));
        }
        return parameterBooleans;
    }

    public void processes(DynamicObject[] infos, String dataTypeName) throws KDException {
        try (TXHandle tx = TX.required();){
            try {
                super.process(infos);
                long startTimeTobook2 = System.currentTimeMillis();
                logger.info("delete journalDelete start:" + startTimeTobook2);
                Set<Object> pkIdSet = Arrays.stream(infos).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                this.journalDeletes(pkIdSet, dataTypeName);
                long startTimeTobook3 = System.currentTimeMillis();
                logger.info("delete journalDelete cost:" + (startTimeTobook3 - startTimeTobook2));
                try {
                    CasBankJournalHelper.deleteBalance((DynamicObject[])infos);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    throw new KDBatchDealDBException(ResManager.loadKDString((String)"\u4f59\u989d\u6570\u636e\u66f4\u65b0\u5931\u8d25\u3002", (String)"CasErrorCode_11", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                logger.info("delete deleteBalance cost:" + (System.currentTimeMillis() - startTimeTobook3));
            }
            catch (KDBatchDealDBException e) {
                logger.error((Throwable)e);
                tx.markRollback();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
            }
        }
    }

    private void journalDeletes(Set<Object> pkIdSet, String dataTypeName) {
        try {
            OperateOption create = OperateOption.create();
            create.setVariableValue("delByOp", "op");
            OperationResult op = OperateServiceHelper.execOperate((String)"delete", (String)dataTypeName, (Object[])pkIdSet.toArray(), (OperateOption)create);
            if (null != op.getAllErrorInfo() && op.getAllErrorInfo().size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5220\u9664\u5931\u8d25\u3002", (String)"CasErrorCode_10", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("journalType:" + dataTypeName + "has error:" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5220\u9664\u5931\u8d25\u3002", (String)"CasErrorCode_10", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        this.journalDelete(info);
    }

    @Override
    public void process(DynamicObject[] infos) throws KDException {
        super.process(infos);
        for (DynamicObject journal : infos) {
            this.journalDelete(journal);
        }
        CasBankJournalHelper.deleteBalance((DynamicObject[])infos);
    }

    private void journalDelete(DynamicObject journal) {
        OperateOption create = OperateOption.create();
        create.setVariableValue("delByOp", "op");
        OperateServiceHelper.execOperate((String)"delete", (String)journal.getDataEntityType().getName(), (Object[])new Object[]{journal.getPkValue()}, (OperateOption)create);
    }
}

