/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.JournalAntiBookImpl;
import kd.fi.cas.business.journal.JournalBookImpl;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.helper.LocalDynamicObjectCache;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TmcBookService {
    private static final Log LOGGER = LogFactory.getLog(TmcBookService.class);
    private static final Map<String, String> rpTypeMap = new HashMap<String, String>(16);

    public List<Pair<Long, String>> book(String serializedJournalInfos) {
        final List journalInfos = SerializationUtils.fromJsonStringToList((String)serializedJournalInfos, JournalInfo.class);
        LocalDynamicObjectCache dataCache = new LocalDynamicObjectCache();
        for (JournalInfo journalInfo : journalInfos) {
            journalInfo.setOrg(dataCache.getCachedData(journalInfo.getOrgId(), "bos_org"));
            journalInfo.setAccountBank(dataCache.getCachedData(journalInfo.getAccountBankId(), "bd_accountbanks"));
            journalInfo.setCurrency(dataCache.getCachedData(journalInfo.getCurrencyId(), "bd_currency"));
            journalInfo.setAccountCash(dataCache.getCachedData(journalInfo.getAccountCashId(), "cas_accountcash"));
            journalInfo.setCashier(dataCache.getCachedData(journalInfo.getCashierId(), "bos_user"));
            journalInfo.setSettlementType(dataCache.getCachedData(journalInfo.getSettlementTypeId(), "bd_settlementtype"));
            String rpBaseType = journalInfo.getRpBaseType();
            if (EmptyUtil.isNoEmpty((String)rpBaseType) && EmptyUtil.isNoEmpty((String)rpTypeMap.get(rpBaseType))) {
                String entity = rpTypeMap.get(rpBaseType);
                if (EmptyUtil.isNoEmpty((Long)journalInfo.getRpTypeId())) {
                    journalInfo.setRpType(dataCache.getCachedData(journalInfo.getRpTypeId(), entity));
                }
            } else {
                journalInfo.setRpBaseType(null);
            }
            for (JournalEntryInfo entry : journalInfo.getEntry()) {
                entry.setFundFlowItem(dataCache.getCachedData(entry.getFundFlowItemId(), "cas_fundflowitem"));
            }
        }
        AbstractBookJournalBuilder journalBuilder = new AbstractBookJournalBuilder(){

            @Override
            public List<JournalInfo> getJournalInfoList(DynamicObject billObject) {
                return journalInfos;
            }

            @Override
            public List<JournalInfo> getJournalInfoList(DynamicObjectCollection billColl) {
                return journalInfos;
            }

            @Override
            public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
                return new HashMap<Long, List<JournalInfo>>();
            }
        };
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        List<DynamicObject> journalList = journalBuilder.getJournalList((DynamicObject)null);
        if (journalList == null || journalList.isEmpty()) {
            return result;
        }
        String sourceBillType = journalList.get(0).getString("sourcebilltype");
        List<Long> sourceIdList = journalList.stream().map(j -> j.getLong("sourcebillid")).distinct().collect(Collectors.toList());
        List<Long> sourceEntryIdList = journalList.stream().map(j -> j.getLong("sourcebillentryid")).distinct().collect(Collectors.toList());
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            this.cancelEntryBook(sourceBillType, sourceIdList, sourceEntryIdList);
            JournalBookImpl journalBookImpl = new JournalBookImpl();
            LinkedList<DynamicObject> validJournals = new LinkedList<DynamicObject>();
            for (DynamicObject journal : journalList) {
                try {
                    journalBookImpl.validate(journal);
                    validJournals.add(journal);
                }
                catch (KDBizException bizExc) {
                    result.add((Pair<Long, String>)new MutablePair((Object)journal.getLong("sourcebillid"), (Object)bizExc.getMessage()));
                    LOGGER.info("book error:{}, error message:{}", (Object)bizExc, (Object)bizExc.getMessage());
                }
            }
            journalBookImpl.process(validJournals.toArray(new DynamicObject[0]));
            LinkedList<Pair<Long, String>> linkedList = result;
            return linkedList;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public List<Pair<Long, String>> cancelBook(String sourceEntity, Collection<Long> sourcePks) {
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)sourceEntity, (Long[])sourcePks.toArray(new Long[0]));
        String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
        String[] journalEntityKeys = new String[]{"cas_bankjournal", "cas_cashjournal"};
        LinkedList<DynamicObject> validatedJournals = new LinkedList<DynamicObject>();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
            for (String journalEntity : journalEntityKeys) {
                DynamicObject[] journals;
                HashSet journalPks = (HashSet)targetBills.get(journalEntity);
                if (journalPks == null) continue;
                for (DynamicObject journal : journals = BusinessDataServiceHelper.load((String)journalEntity, (String)journalSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)journalPks)})) {
                    long sourcebillid = journal.getLong("sourcebillid");
                    if (!sourcePks.contains(sourcebillid)) continue;
                    try {
                        journalAntiBookImpl.validate(journal);
                        validatedJournals.add(journal);
                    }
                    catch (KDBizException bizExc) {
                        result.add((Pair<Long, String>)new MutablePair((Object)sourcebillid, (Object)bizExc.getMessage()));
                    }
                }
            }
            journalAntiBookImpl.process(validatedJournals.toArray(new DynamicObject[0]));
            LinkedList<Pair<Long, String>> linkedList = result;
            return linkedList;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public List<Pair<Long, String>> cancelEntryBook(String sourceBillType, List<Long> sourceIdList, List<Long> sourceEntryIdList) {
        LOGGER.info("TmcBookService cancelEntryBook :sourceBillType{},sourceIdList:{},sourceEntryIdList:{}", new Object[]{sourceBillType, sourceIdList, sourceEntryIdList});
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        if (sourceIdList == null || sourceIdList.isEmpty()) {
            return result;
        }
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
        String[] journalEntityKeys = new String[]{"cas_bankjournal", "cas_cashjournal"};
        LinkedList<DynamicObject> validatedJournals = new LinkedList<DynamicObject>();
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)sourceBillType);
        filter.and("sourcebillid", "in", sourceIdList);
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            for (String journalEntity : journalEntityKeys) {
                DynamicObject[] journals;
                for (DynamicObject journal : journals = BusinessDataServiceHelper.load((String)journalEntity, (String)journalSelectors, (QFilter[])filter.toArray())) {
                    Long sourceBillEntryId = journal.getLong("sourcebillentryid");
                    Long sourceBillId = journal.getLong("sourcebillid");
                    if (!EmptyUtil.isEmpty((Long)sourceBillEntryId) && !sourceEntryIdList.contains(sourceBillEntryId)) continue;
                    try {
                        journalAntiBookImpl.validate(journal);
                        validatedJournals.add(journal);
                    }
                    catch (KDBizException bizExc) {
                        LOGGER.error("journalAntiBookImpl validate error", (Throwable)bizExc);
                        result.add((Pair<Long, String>)new MutablePair((Object)sourceBillId, (Object)bizExc.getMessage()));
                    }
                }
            }
            journalAntiBookImpl.process(validatedJournals.toArray(new DynamicObject[0]));
            LinkedList<Pair<Long, String>> linkedList = result;
            return linkedList;
        }
        catch (Exception throwable2) {
            try {
                LOGGER.error("TmcBookService cancelEntryBook error", (Throwable)throwable2);
                tx.markRollback();
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    public List<Pair<Long, String>> validateBeforeCancelBook(String sourceEntity, Collection<Long> sourcePks) {
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)sourceEntity, (Long[])sourcePks.toArray(new Long[0]));
        String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
        String[] journalEntityKeys = new String[]{"cas_bankjournal", "cas_cashjournal"};
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        for (String journalEntity : journalEntityKeys) {
            DynamicObject[] journals;
            HashSet journalPks = (HashSet)targetBills.get(journalEntity);
            if (journalPks == null) continue;
            for (DynamicObject journal : journals = BusinessDataServiceHelper.load((String)journalEntity, (String)journalSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)journalPks)})) {
                try {
                    journalAntiBookImpl.validate(journal);
                }
                catch (KDBizException bizExc) {
                    result.add((Pair<Long, String>)new MutablePair((Object)journal.getLong("sourcebillid"), (Object)bizExc.getMessage()));
                }
            }
        }
        return result;
    }

    public List<Pair<Long, String>> validateBeforeCancel(HashMap<String, Collection<Long>> map) {
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        if (map.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, Collection<Long>> entry : map.entrySet()) {
            String[] journalEntityKeys;
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entry.getKey(), (Long[])entry.getValue().toArray(new Long[0]));
            String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
            for (String journalEntity : journalEntityKeys = new String[]{"cas_bankjournal", "cas_cashjournal"}) {
                DynamicObject[] journals;
                HashSet journalPks = (HashSet)targetBills.get(journalEntity);
                if (journalPks == null) continue;
                for (DynamicObject journal : journals = BusinessDataServiceHelper.load((String)journalEntity, (String)journalSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)journalPks)})) {
                    try {
                        journalAntiBookImpl.validate(journal);
                    }
                    catch (KDBizException bizExc) {
                        result.add((Pair<Long, String>)new MutablePair((Object)journal.getLong("sourcebillid"), (Object)bizExc.getMessage()));
                        return result;
                    }
                }
            }
        }
        return result;
    }

    public List<Pair<Long, String>> validateDeleteEntryJournal(String sourceBillType, List<Long> sourceIdList, List<Long> sourceEntryIdList) {
        if (sourceEntryIdList == null || sourceEntryIdList.isEmpty()) {
            return new LinkedList<Pair<Long, String>>();
        }
        return this.validateCancelBook(sourceBillType, sourceIdList, sourceEntryIdList);
    }

    public List<Pair<Long, String>> validateDeleteJournal(String sourceBillType, List<Long> sourceIdList) {
        if (sourceIdList == null || sourceIdList.isEmpty()) {
            return new LinkedList<Pair<Long, String>>();
        }
        return this.validateCancelBook(sourceBillType, sourceIdList, null);
    }

    private List<Pair<Long, String>> validateCancelBook(String sourceBillType, List<Long> sourceIdList, List<Long> sourceEntryIdList) {
        LOGGER.info("TmcBookService validateCancelBook :sourceBillType{}, sourceIdList:{}, sourceEntryIdList:{}", new Object[]{sourceBillType, sourceIdList, sourceEntryIdList});
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)sourceBillType);
        if (sourceIdList != null && !sourceIdList.isEmpty()) {
            filter.and("sourcebillid", "in", sourceIdList);
        }
        if (sourceEntryIdList != null && !sourceEntryIdList.isEmpty()) {
            filter.and("sourcebillentryid", "in", sourceEntryIdList);
        }
        String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
        DynamicObject[] bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)journalSelectors, (QFilter[])filter.toArray());
        DynamicObject[] cashJournals = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)journalSelectors, (QFilter[])filter.toArray());
        ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>(10);
        journalList.addAll(Arrays.asList(bankJournals));
        journalList.addAll(Arrays.asList(cashJournals));
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        for (DynamicObject journal : journalList) {
            try {
                journalAntiBookImpl.validate(journal);
            }
            catch (KDBizException bizExc) {
                result.add((Pair<Long, String>)new MutablePair((Object)journal.getLong("sourcebillid"), (Object)bizExc.getMessage()));
            }
        }
        return result;
    }

    public List<Pair<Long, String>> validateBook(String serializedJournalInfos) {
        final List journalInfos = SerializationUtils.fromJsonStringToList((String)serializedJournalInfos, JournalInfo.class);
        LocalDynamicObjectCache dataCache = new LocalDynamicObjectCache();
        for (JournalInfo journalInfo : journalInfos) {
            journalInfo.setOrg(dataCache.getCachedData(journalInfo.getOrgId(), "bos_org"));
            journalInfo.setAccountBank(dataCache.getCachedData(journalInfo.getAccountBankId(), "bd_accountbanks"));
            journalInfo.setCurrency(dataCache.getCachedData(journalInfo.getCurrencyId(), "bd_currency"));
            journalInfo.setAccountCash(dataCache.getCachedData(journalInfo.getAccountCashId(), "cas_accountcash"));
            journalInfo.setCashier(dataCache.getCachedData(journalInfo.getCashierId(), "bos_user"));
            journalInfo.setSettlementType(dataCache.getCachedData(journalInfo.getSettlementTypeId(), "bd_settlementtype"));
            String rpBaseType = journalInfo.getRpBaseType();
            if (EmptyUtil.isNoEmpty((String)rpBaseType) && EmptyUtil.isNoEmpty((String)rpTypeMap.get(rpBaseType))) {
                String entity = rpTypeMap.get(rpBaseType);
                if (EmptyUtil.isNoEmpty((Long)journalInfo.getRpTypeId())) {
                    journalInfo.setRpType(dataCache.getCachedData(journalInfo.getRpTypeId(), entity));
                }
            } else {
                journalInfo.setRpBaseType(null);
            }
            for (JournalEntryInfo entry : journalInfo.getEntry()) {
                entry.setFundFlowItem(dataCache.getCachedData(entry.getFundFlowItemId(), "cas_fundflowitem"));
            }
        }
        AbstractBookJournalBuilder journalBuilder = new AbstractBookJournalBuilder(){

            @Override
            public List<JournalInfo> getJournalInfoList(DynamicObject billObject) {
                return journalInfos;
            }

            @Override
            public List<JournalInfo> getJournalInfoList(DynamicObjectCollection billColl) {
                return journalInfos;
            }

            @Override
            public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
                return new HashMap<Long, List<JournalInfo>>();
            }
        };
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        List<DynamicObject> journalList = journalBuilder.getJournalList((DynamicObject)null);
        if (journalList == null || journalList.isEmpty()) {
            return result;
        }
        JournalBookImpl journalBookImpl = new JournalBookImpl();
        for (DynamicObject journal : journalList) {
            try {
                journalBookImpl.validate(journal);
            }
            catch (KDBizException bizExc) {
                result.add((Pair<Long, String>)new MutablePair((Object)journal.getLong("sourcebillid"), (Object)bizExc.getMessage()));
                LOGGER.info("book error:{}, error message:{}", (Object)bizExc, (Object)bizExc.getMessage());
            }
        }
        return result;
    }

    static {
        rpTypeMap.put("pay", "cas_paymentbilltype");
        rpTypeMap.put("receive", "cas_receivingbilltype");
    }
}

